/**************************************************************************************
 * @file        : SXMDataCollectorInterface.cpp
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM data collector Interface to get collector data.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#include "hmi_trace_if.h"
#include "CgiExtensions/CourierMessageMapper.h"
//#include "hall_std_if.h"  //when other headers also needed, include hall_std_if and remove above two
#include "SXMDataCollectorInterface.h"
#include "SXMDataCollector.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS       TR_CLASS_APPHMI_SXM_HALL
#define ETG_I_TRACE_CHANNEL           TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX        "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX             App::Core::SXMDataCollectorInterface::
#include "trcGenProj/Header/SXMDataCollectorInterface.cpp.trc.h"
#endif

namespace App {
namespace Core {
/**
 * Helper function to set the sxm data for the status line.
 */
void SXMDataCollectorInterface::vSetSXMDynamicData(const std::string strHeaderTextData)
{
   SXMDataCollector::instance()->vSetHeaderTextData(strHeaderTextData);
}


/**
* Helper function to get HardwareVersion.
*/
std::string SXMDataCollectorInterface::vGetHardwareVersion()
{
   return SXMDataCollector::instance()->vGetHWVersion();
}


}  // namespace Core
}  // namespace App
