/**************************************************************************************
 * @file        : SXMDataCollector.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM Datacollector utility class required to interact with StatusBar Service.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef SXMDATACOLLECTOR_H
#define SXMDATACOLLECTOR_H

#include "AppBase/ServiceAvailableIF.h"
#include "App/Core/SxmUtils/SxmUtilsSingleton.h"
#include "AppHmi_SxmStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "SXMDataCollectorInterface.h"

namespace App {
namespace Core {

class SXMDataCollector :
   public SxmUtilsSingleton<SXMDataCollector>,
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF
{
   public:
      /**
       * SXMDataCollector Class constructor
       */
      SXMDataCollector();
      /**
       * SXMDataCollector Class destructor
       */
      virtual ~SXMDataCollector();
      /**
       * Utility function that registers for notifications updates from NavigationService.
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      /**
       * Utility function that deregisters for notifications updates from NavigationService.
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      /**
       * Helper function to set the header text of sxm.
       */
      void vSetHeaderTextData(const std::string strHeaderTextData);
      /**
      * Helper function to get HardwareVersion.
      */
      std::string vGetHWVersion();
      /**
       *  Error handling function for HardwareVersion.
       */

   private:
      friend class  SxmUtilsSingleton<SXMDataCollector>;

      /**
       * Helper function to intialize the default data for status line.
       */
      void vInitializeStatusLineDataDefault();
      /**
      * Callback to handle Courier Message GuiStartupFinishedUpdMsg Request
      */
      bool onCourierMessage(const GuiStartupFinishedUpdMsg& /*msg*/);
      /**
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()
      /**
       * DataBinding
       */
      DataBindingItem<HeaderTextDataBindingSource> _headerText;
};


} // namespace Core
} // namespace App


#endif
