/**************************************************************************************
 * @file        : SXMDataCollector.cpp
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM Datacollector utility class required to interact with StatusBar Service.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#include "hmi_trace_if.h"
#include "CgiExtensions/CourierMessageMapper.h"
//#include "hall_std_if.h"  //when other headers also needed, include hall_std_if and remove above two
#include "datacollector_main_fi_types.h"
#include "SXMDataCollector.h"
#include "App/Core/SxmUtils/SxmUtils.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SXM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX                 App::Core::SXMDataCollector::
#include "trcGenProj/Header/SXMDataCollector.cpp.trc.h"
#endif

namespace App {
namespace Core {
/**
 * SXMDataCollector Class constructor
 */
SXMDataCollector::SXMDataCollector()
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("SXMDataCollector() Constructor"));
}


/**
 * SXMDataCollector Class destructor
 */
SXMDataCollector::~SXMDataCollector()
{
   ETG_TRACE_USR4(("~SXMDataCollector() Destructor"));
   ETG_I_UNREGISTER_FILE();
}


/**
 * Utility function that registers for notifications updates from Datacollector Main.
 * @param [in] : proxy - Datacollector class instance
 * @param [in] : stateChange - Current ASF state
 */
void SXMDataCollector::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/,
      const asf::core::ServiceStateChange& /*stateChange*/)
{
}


/**
 * Utility function that deregisters for notifications updates from Datacollector Main.
 * @param [in] : proxy - Datacollector class instance
 * @param [in] : stateChange - Current ASF state
 */
void SXMDataCollector::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/,
      const asf::core::ServiceStateChange& /*stateChange*/)
{
}


/**
 * setHeaderTextData : Update the Header Icon data to status line.
 * @param[in]      : strHeaderTextData - Header Text Data
 */
void SXMDataCollector::vSetHeaderTextData(const std::string strHeaderTextData)
{
   ETG_TRACE_USR4(("DataCollector: setHeaderIconData:%s", strHeaderTextData.c_str()));
   //Update Header Text
   (*_headerText).mVisible = true;
   (*_headerText).mHeaderText = strHeaderTextData.c_str();
   _headerText.SendUpdate(true);
}


/**
* Helper function to get HardwareVersion.
*/
std::string SXMDataCollector::vGetHWVersion()
{
   std::string meterHWVersionInfo = " ";
   meterHWVersionInfo.append(SxmUtils::conCatData("i", 1, (datacollector_main_fi_types::T_datacollector_VersionInfo::kU8Upper)));
   meterHWVersionInfo.append(".");
   meterHWVersionInfo.append(SxmUtils::conCatData("i", 1, (datacollector_main_fi_types::T_datacollector_VersionInfo::kU8Mid)));
   meterHWVersionInfo.append(".");
   meterHWVersionInfo.append(SxmUtils::conCatData("i", 1, (datacollector_main_fi_types::T_datacollector_VersionInfo::kU8Lower)));
   ETG_TRACE_USR4(("onProperty_HardwareVersionStatus Upper = %d \t Mid = %d \t Lower = %d", datacollector_main_fi_types::T_datacollector_VersionInfo::kU8Upper,
                   datacollector_main_fi_types::T_datacollector_VersionInfo::kU8Mid,
                   datacollector_main_fi_types::T_datacollector_VersionInfo::kU8Lower));
   return meterHWVersionInfo;
}


/**
 *  vInitializeStatusLineDataDefault : It initializes the default data required for the status line.
 */
void SXMDataCollector::vInitializeStatusLineDataDefault()
{
   ETG_TRACE_USR4(("DataCollector: vInitializeStatusLineDataDefault"));
   //Update Header Text
   (*_headerText).mVisible = false;
   _headerText.MarkItemModified(ItemKey::HeaderText::VisibleItem);
   _headerText.SendUpdate(false);
}


/**
 * This funtion is used to get the get the startup trigger and initializes default value for header line.
 * based on the statup of the GUI default data collector function needs to be called.
 * @param[in] - msg       - GuiStartupFinishedUpdMsg,
 * @param[out] -returns true when message is consumed else vice versa
 */
bool SXMDataCollector::onCourierMessage(const GuiStartupFinishedUpdMsg& /*msg*/)
{
   ETG_TRACE_USR4(("SXMDataCollector: GuiStartupFinishedUpdMsg received "));
   vInitializeStatusLineDataDefault();
   return false;
}


} // namespace Core
} // namespace App
