/**************************************************************************************
 * @file        : SXMClockServiceInterface.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM clock Interface to get clock data.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMCLOCKSERVICEINTERFACE_H_
#define _SXMCLOCKSERVICEINTERFACE_H_
#include "clock_main_fi_typesConst.h"
#include "App/Core/SxmUtils/SxmCommonTypes.h"
#include "ISxmClockService.h"
#include "AppHmi_SxmTypes.h"

namespace App {
namespace Core {
/**
 *
 * @class : SXMClockServiceInterface
 */
class SXMClockServiceInterface
{
   public:
      /**
       * Helper function to get Time format from  MIDW Clock fi.
       */
      static ::clock_main_fi_types::VDCLK_TEN_TimeFormat GetCurrentTimeFormat();
      /**
       * Helper function to get date format from  MIDW Clock fi.
       */
      static ::clock_main_fi_types::VDCLK_TEN_NewDateFormat GetCurrentDateFormat();
      /**
       * Helper function to get LocalTimedate from  MIDW Clock fi.
       */
      static LocalDateTimeType GetLocalTimeDate();
      /**
       * Helper function to get current Time Zone.
       */
      static std::string GetTimeZone();

      static void registerTimeStatusNotification(ISxmClockService* _obsptr, enSXMServiceType enServiceType);
      /**
       * De-Register call back function to stop receiving updates.
       */
      static void deregisterTimeStatusNotification(ISxmClockService* _obsptr, enSXMServiceType enServiceType);
};


}  // namespace Core
}  // namespace App

#endif
