/* ***************************************************************************************
* FILE:          CGIAppViewController_Sds.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewController_Sds.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined (_CGIAPPVIEWCONTROLLER_SDS_H)
#define _CGIAPPVIEWCONTROLLER_SDS_H

#include "CgiExtensions/ViewControllerBase.h"
//#include "AppHmi_Sds_SimpleViewController.h"

#define SIMPLE_CONTROLLER(tController)\
		class tController : public ViewControllerBase\
								{\
		private:\
				courier_messages:\
		COURIER_MSG_MAP_BEGIN(0)\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()\
      COURIER_MSG_MAP_ENDS()\
		public:\
		tController() {}\
		virtual ~tController() {}\
		static const char* _name;\
		static Courier::ViewController* createInstance()\
								{\
			return COURIER_NEW(tController)();\
								}\
								};

SIMPLE_CONTROLLER(CGIAppViewController_SR_DummyScene)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SDSMessage)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_GLO)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_NAV_T4)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_E_PHO)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_NAV_T2)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_PHO)
/* SIMPLE_CONTROLLER(CGIAppViewController_SR_PHO_Calling) */
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_S_PHO)
/* SIMPLE_CONTROLLER(CGIAppViewController_SR_PHO_SelectNumber)
SIMPLE_CONTROLLER(CGIAppViewController_SR_PHO_SelectContact)
SIMPLE_CONTROLLER(CGIAppViewController_SR_PHO_NbestList)
SIMPLE_CONTROLLER(CGIAppViewController_SR_AUD_EnterAlbum)
SIMPLE_CONTROLLER(CGIAppViewController_SR_AUD_EnterArtist)
SIMPLE_CONTROLLER(CGIAppViewController_SR_AUD_EnterAudiobook)
SIMPLE_CONTROLLER(CGIAppViewController_SR_AUD_EnterGenre)
SIMPLE_CONTROLLER(CGIAppViewController_SR_AUD_EnterPlaylist)
SIMPLE_CONTROLLER(CGIAppViewController_SR_AUD_EnterPodcast) */
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_AUD_T1)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_PHO_T1)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_AUD)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_S_AUD)
/* SIMPLE_CONTROLLER(CGIAppViewController_SR_AUD_Playing)*/
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_TUNER)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_AUD_CONF)
/*SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_Main)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_EnterAddress)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_EnterCountry)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_EnterHouseNumber)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_EnterPoi)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_EnterState)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_EnterStreet)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_ChangeStreet)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_ChangeCity)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_StartingGuidance)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_StoppingGuidance) */
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_NAV_T5)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_NAV_T1)
/* SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_Address_Nbest)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_ConfirmStop)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_Country_Nbest)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_PoiCity)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_PoiCity_Nbest)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_PoiLocation)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_Poi_Nbest)*/
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_S_NAV)
SIMPLE_CONTROLLER(CGIAppViewController_SDS_LAYOUT_CV_NAV_CONF)
/*SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_ReplaceWaypDest)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_SelectAddress)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_SelectPoi)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_SettingWaypoint)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_SetWaypDest)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_State_Nbest)
SIMPLE_CONTROLLER(CGIAppViewController_SR_NAV_SelectHousenumber) */
#endif // _CGIAPPVIEWCONTROLLER_SDS_H
