/* ***************************************************************************************
* FILE:          CGIAppController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "AppHmi_SdsStateMachine.h"
#include "CGIAppController.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SDS_HALL
#include "trcGenProj/Header/CGIAppController.cpp.trc.h"
#endif

bool CGIAppController::onCourierMessage(const HKStatusChangedUpdMsg& msg)
{
   ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg HKCode: %d %d", msg.GetHKCode(), msg.GetHKState()));
   switch (msg.GetHKCode())
   {
      case HARDKEYCODE_HK_NAV:
      case HARDKEYCODE_HK_CAMERA:
      case HARDKEYCODE_HK_SETTINGS:
      case HARDKEYCODE_HK_SRC_COCKPIT:
      case HARDKEYCODE_HK_HOME:
         if (msg.GetHKState() == hmibase::HARDKEYSTATE_UP)
         {
            POST_MSG((COURIER_MESSAGE_NEW(HKStatusChangedNotifyMsg)()));
         }
         break;
      default:
         break;
   }

   return CGIAppControllerProject::onCourierMessage(msg);
}
