/* ***************************************************************************************
* FILE:          HMIModelComponent.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIModelComponent.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_HMI_MODEL_COMPONENT_H)
#define _HMI_MODEL_COMPONENT_H
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_SdsStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"

class HMIModelComponent
{
   private:
      //  Binding source instances
      //DataBindingItem<DummyDataBindingSource>m_DummyData;

      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      //virtual bool onCourierMessage(const DummyChangedUpdMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      //ON_COURIER_MESSAGE(DummyChangedUpdMsg)
      COURIER_MSG_MAP_END()

   public:
      HMIModelComponent();
      virtual ~HMIModelComponent();
      bool Init();
};


#endif // _HMI_MODEL_COMPONENT_H
