/**
 * @file <VehicleSrvClient.h>
 * @author <ECG> <INF4CV>
 * @copyright (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 * @addtogroup <AppHmi_Sds>
 */

#ifndef LANGUAGE_CLIENT_H
#define LANGUAGE_CLIENT_H

#define LANGNO  19

#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/DataModel/ListRegistry.h"
namespace App {
namespace Core {

class VehicleSrvClient : public ListImplementation,
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::VEHICLE_MAIN_FI::LanguageSyncSourceCallbackIF,
   public ::VEHICLE_MAIN_FI::SetLanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::LanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::VoiceRecgCommandCallbackIF

{
   private:

      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;

   public :
      VehicleSrvClient();

      virtual ~VehicleSrvClient();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                              const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onSetLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageError >& error);

      void onSetLanguageResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageResult >& result);

      void onLanguageSyncSourceError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceError >& /*error*/) {}
      void onLanguageSyncSourceStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                      const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceStatus >& /*status*/) {}
      void onLanguageStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                            const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageStatus >& status);
      void onLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                           const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageError >& error);
      void onVoiceRecgCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                                    const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VoiceRecgCommandStatus >& status);
      void onVoiceRecgCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                                   const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VoiceRecgCommandError >& error);
      //GuiStartupFinishedUpdMsg has to be bind in all the hall component in order to reflect the language changes at the time of bootup/system start up
      //bool onCourierMessage(const GuiStartupFinishedUpdMsg& msg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SDS_COURIER_PAYLOAD_MODEL_COMP)
      //ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()

      /* struct LanguageTable
      {
         int LangIndex;
         std::string LangString;
      };

      LanguageTable LanguageMappingTable[LANGNO] =
      {
         { 12, "en_GB" },
         { 23, "de_DE" },
         { 10, "nl_NL" },
         { 21, "fr_FR" },
         { 29, "it_IT"},
         { 46, "es_ES"},
         { 39, "pt_PT" },
         { 27, "hu_HU" },
         { 42, "ru_RU" },
         { 8, "cs_CZ" },
         { 9, "da_DK" },
         { 35, "nb_NO" },
         { 38, "pl_PL" },
         { 49, "sv_SE" },
         { 13, "en_US" },
         { 24, "el_GR" },
         { 52, "tr_TR" },
         { 47, "es_MX" },
         { 22, "fr_CA" },
      }; */
      std::string getLanguageId(int index);
      //void readLanguageOnStartUp();
};


}
}


#endif
