/**************************************************************************//**
 * \file       SdsHallTypes.h
 *
 * This file is part of the SDS HMI Application.
 *
 * \copyright  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef SdsHallTypes_h
#define SdsHallTypes_h

#include "asf/core/Types.h"
#include "ProjectBaseTypes.h"
#include "AppHmi_SdsStateMachine.h"
#include "hmi_trace_if.h"


namespace App {
namespace Core {


struct SelectableListItem
{
   ::std::string text;
   bool isSelectable;
};


typedef struct
{
   std::string FirstText;
   std::string SecondText;
} SDS_TwoTextListInfo;


enum enTalkingHeadState
{
   TALKINGHEAD_STATE_ACTIVE    		 	= 0L,
   TALKINGHEAD_STATE_LISTENING        	= 1L,
   TALKINGHEAD_STATE_IDLE    			= 2L
};


static const char* const DATA_CONTEXT_LIST_BTN_ON_OFF    								= "BtnSettings_onoff";
static const char* const DATA_CONTEXT_LIST_BTN_ON_OFF_2 								= "BtnSettings_onoff2";
static const char* const DATA_CONTEXT_LIST_BTN_SETTINGS_TEXT  							= "BtnSettingsText";
static const char* const DATA_CONTEXT_LIST_BTN_SETTINGS_VOICE_PREFERENCE  				= "BtnVoicePreference";
static const char* const DATA_CONTEXT_LIST_BTN_SETTINGS_MAIN_SPEECH_RATE  				= "BtnSettingsIncrementSpeechRate";
static const char* const DATA_CONTEXT_LIST_BTN_SETTINGS_MAIN_SLIDER     				= "BtnSettingsNaviVolume";
static const char* const DATA_CONTEXT_LIST_BTN_SETTINGS_MAIN_SLIDER2     				= "BtnSettingsVoiceVolume";
static const char* const DATA_CONTEXT_LIST_BTN_SETTINGS_BEST_MATCH_AUDIO  				= "AudioList";
static const char* const DATA_CONTEXT_LIST_BTN_FUEL_PRICES    							= "BTN_VL_FUEL";
static const char* const DATA_CONTEXT_LIST_BTN_POI    									= "BTN_VL_POI";
static const char* const DATA_CONTEXT_LIST_BTN_TAB_HL                                   = "Tab_Horizontal";
static const char* const DATA_CONTEXT_LIST_BTN_TAB_VL                                   = "Tab_Vertical";
static const char* const DATA_CONTEXT_LIST_BTN_ALL_RES    								= "BTN_SDS_ALL_RES";
static const char* const E_INT_VoiceSettingsScreen_NISSAN 								= "1";
static const char* const E_INT_VoiceSettingsScreen_RENAULT 								= "2";
}


}

#endif /* SdsHallTypes_h */
