/**************************************************************************//**
 * \file       SdsHall.cpp
 *
 * This file is part of the SDS HMI Application.
 *
 * \copyright  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "hall_std_if.h"
#include "App/Core/SdsHall.h"
#include "App/Core/SdsDefines.h"
#include "App/Core/ListHandler/ListHandler.h"
//#include "App/Core/TTFisCommander/SdsTTfisTestCommandHandler.h"
#include "App/Core/SdsAdapter/GuiUpdater.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SDS_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SDS
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SDS_"
#define ETG_I_FILE_PREFIX                 App::Core::SdsHall::
#include "trcGenProj/Header/SdsHall.cpp.trc.h"
#endif

using namespace ::App::Core;
using namespace ::CourierTunnelService::CourierMessageReceiver;
#include <iostream>
using namespace std;

namespace App {
namespace Core {

SdsHall::SdsHall()
   : HallComponentBase("", "App.Core.AppHmi_Sds", "/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Sds")
{
   ETG_I_REGISTER_FILE();

   ETG_TRACE_USR4(("SdsHall:SdsHall Constructor"));
   ////////////////////////////////////////////////////////Proxy Creation////////////////////////////////////////////////////////////////////////////////
   _spmCoreServiceProxy     = SPM_CORE_FI::SPM_CORE_FIProxy::createProxy("spmFiPort", *this);
   _sdsGuiServiceProxy		= sds_gui_fi::SdsGuiService::SdsGuiServiceProxy::createProxy("sdsGuiAppPort", *this);
   /*    ///////////////////Default Service Initializations//////////////////////////////////////////////////////////////////////////////////////////////////// */
   //StartupSync::getInstance().registerPropertyRegistrationIF(this, _spmCoreServiceProxy->getPortName());//ResetSolve
   StartupSync::getInstance().registerPropertyRegistrationIF(this, _sdsGuiServiceProxy->getPortName());
   /////Courier Message Subscriptions to Model///////////////////////////////////////////////////////////////////////////////////////////////////////////
   FocusChangedUpdMsg::Subscribe(Courier::ComponentType::Model);

   /////////////////Instantiation of Handler Members/////////////////////////////////////////////////////////////////////////////////////////////////////
   _pGuiUpdater = new (std::nothrow) GuiUpdater();
   _pHMIModelComponent = new (std::nothrow)HMIModelComponent();
   _pSdsAdapterRequestor = new (std::nothrow) SdsAdapterRequestor(_sdsGuiServiceProxy);
   _pListHandler = new (std::nothrow)ListHandler(_pGuiUpdater, _pSdsAdapterRequestor);
   //_pSdsAdapterRequestor = new(std::nothrow) SdsAdapterRequestor(::boost::shared_ptr<sds_gui_fi::SdsGuiService::SdsGuiServiceProxy> _sdsGuiServiceProxy);
   _pSdsAdapterProvider = new (std::nothrow) SdsAdapterProvider(_pGuiUpdater, _pListHandler, _pSdsAdapterRequestor);
   _pVehicleSrvClient = new (std::nothrow) VehicleSrvClient();

   //registerObservers();
   registerServiceAvailableObservers();

   //for factory reset
   DefSetServiceBase::s_Intialize("AppHmiSdsServicePort");//port name needs to be same as port name given in cmc file
   _mdefSetServiceBase = DefSetServiceBase::GetInstance();
   if (_mdefSetServiceBase != NULL)
   {
      _mdefSetServiceBase->vRegisterforUpdate(this);
   }

   (void)NavigationModeDBHandler::getInstance();
}


SdsHall::~SdsHall()
{
   ETG_TRACE_USR4(("SdsHall : Destructor"));
   DELETE_AND_PURGE(_pSdsAdapterProvider);//lint -e1740
   DELETE_AND_PURGE(_pSdsAdapterRequestor);
   //TraceCmdDataBind::clearInstance();
   DELETE_AND_PURGE(_pGuiUpdater);
   DELETE_AND_PURGE(_pListHandler);
   DELETE_AND_PURGE(_pHMIModelComponent);
   DELETE_AND_PURGE(_pVehicleSrvClient);

   DefSetServiceBase::s_Destrory(); //to destroy DefSetServiceBase instance
   if (_mdefSetServiceBase != NULL)
   {
      _mdefSetServiceBase->vUnRegisterforUpdate(this);
      //donot delete this instance as its not created by us.
      _mdefSetServiceBase = NULL;
   }
}


void SdsHall::onExpired(asf::core::Timer& /*timer*/, boost::shared_ptr<asf::core::TimerPayload> /*data*/)
{
}


/* void SdsHall::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                       const asf::core::ServiceStateChange& stateChange)
{
} */

void SdsHall::addServiceAvailableObservers(asf::core::ServiceAvailableIF* obs)
{
   if (obs)
   {
      _proxyAvailabilityObservers.push_back(obs);
   }
}


void SdsHall::registerServiceAvailableObservers()
{
   addServiceAvailableObservers(_pSdsAdapterProvider);
}


//Reset To Factory//////////
/* reqPrepareResponse: To know the response of the respective APP when Restore factory setting is pressed.
* @param[in]: None
* @param[in] :None
*/
void SdsHall::reqPrepareResponse(const PrepareResDiagMsgData& /*oPrepareResDiagMsgData*/)
{
   ETG_TRACE_USR4(("SdsHall:: reqPrepareResponse"));
   if (_mdefSetServiceBase)
   {
      _mdefSetServiceBase->sendPrepareResponse(0, this);
      ETG_TRACE_USR4(("SdsHall:: Prepared"));
   }
}


/**
 * reqExecuteResponse: To Execute the response when restore factory setting has been executed..
 * @param[in]: None
 * @param[in] :None
 */
void SdsHall::reqExecuteResponse(const ExecuteResDiagMsgData& /*oExecuteResDiagMsgData*/)
{
   ETG_TRACE_USR4(("SdsHall:: reqExecuteResponse"));
   if (_mdefSetServiceBase)
   {
      _mdefSetServiceBase->sendExecuteResponse(0, this);

      ETG_TRACE_USR4(("SdsHall:: Executed"));
   }
}


/**
 * reqExecuteResponse: To Finalize the response when restore factory setting has been executed.
 * @param[in]: None
 * @param[in] :None
 */
void SdsHall:: reqFinalizeResponse(const FinalizeResDiagMsgData& /*oFinalizeResDiagMsgData*/)
{
   ETG_TRACE_USR4(("SdsHall:: reqFinalizeResponse"));
   if (_mdefSetServiceBase)
   {
      _mdefSetServiceBase->sendFinalizeResponse(0, this);
      ETG_TRACE_USR4(("SdsHall:: Finalized"));
   }
}


bool SdsHall::onCourierMessage(const NavigationCarModeInfo& oMsg)
{
   ETG_TRACE_USR4(("SdsHall::onCourierMessage carMode :%d coachMode :%d", oMsg.GetCarMode(),  oMsg.GetCoachMode()));

   (*_carModeVisibilityStatus).mVisibleStatus = oMsg.GetCarMode();
   _carModeVisibilityStatus.MarkItemModified(ItemKey::CarModeVisibility::VisibleStatusItem);
   _carModeVisibilityStatus.SendUpdate(true);
   return true;
}


} // namespace Core
} // namespace App
