/* ***************************************************************************************
* FILE:          SdsGui.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SdsGui.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "SdsGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"

//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SDS_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SDS
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SDS_"
#define ETG_I_FILE_PREFIX                 App::Core::SdsGui::
#include "trcGenProj/Header/SdsGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////

//                                   main surface,                                      video surface,                    popup surfaces
//DEFAULT_APPSETTINGS(static_cast<int>(SURFACEID_MAIN_SURFACE_SDS), static_cast<int>(SURFACEID_NONE), static_cast<int>(SURFACEID_TOP_POPUP_SURFACE_SDS), static_cast<int>(SURFACEID_CENTER_POPUP_SURFACE_SDS))
APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_SDS),
//
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_SDS),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_SDS)

                            APPSETTINGS_END()

#include <iostream>
                            using namespace std;
using namespace ::hmi;

namespace App {
namespace Core {


SdsGui::SdsGui() : GuiComponentBase(hmi::apps::reference::appHmi_Sds, appSettings)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_SDS_APPCTRL_PROXY);
   ETG_TRACE_USR4(("SdsGui:SdsGui Constructor"));
   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_SDS, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_SDS, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_SDS, DisplayID_D1);
}


SdsGui::~SdsGui()
{
}


unsigned int SdsGui::getDefaultTraceClass()
{
   return TR_CLASS_APPHMI_SDS_MAIN;
}


void SdsGui::setupCgiInstance()
{
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


void SdsGui::preRun()
{
//   DP_vCreateDatapool();
   PersistentValuesRead();
}


void SdsGui::postRun()
{
   PersistentValuesWrite();
}


void SdsGui::PersistentValuesRead()
{
//   dp_tclhmiAppSdsPersMemVarsSds dp;
//   _mvar = dp.tGetData();
}


void SdsGui::PersistentValuesWrite()
{
//   dp_tclhmiAppSdsPersMemVarsSds dp;
//   dp.s32SetData(_mvar);
}


/**
 *sink for not processed ttfis input messages
 */
void SdsGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_FATAL(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
