/**************************************************************************//**
 * \file       SdsAdapterRequestor.h
 *
 * This file is part of the SDS HMI Application.
 *
 * \copyright  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef SdsAdapterRequestor_h
#define SdsAdapterRequestor_h

//#include "App/Core/Interfaces/ISdsAdapterRequestor.h"
#include "App/Core/SdsHallTypes.h"
#include "sds_gui_fi/SdsGuiServiceProxy.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "List/Data/ListDataProviderDistributor.h"
//#include "App/Core/Observers/LanguageSourceObserver.h"

namespace App {
namespace Core {


class SdsAdapterRequestor
   : public sds_gui_fi::SdsGuiService::PttPressCallbackIF,
/* , public ISdsAdapterRequestor */
/*,*/ public sds_gui_fi::SdsGuiService::ManualOperationCallbackIF
   , public sds_gui_fi::SdsGuiService::StopSessionCallbackIF
//, public sds_gui_fi::SdsGuiService::StartSessionContextCallbackIF
//, public sds_gui_fi::SdsGuiService::TestModeUpdateCallbackIF
//, public sds_gui_fi::SdsGuiService::SettingsCommandCallbackIF
//, public sds_gui_fi::SdsGuiService::BackPressCallbackIF
//, public sds_gui_fi::SdsGuiService::AbortSessionCallbackIF
//, public sds_gui_fi::SdsGuiService::PauseSessionCallbackIF
//, public sds_gui_fi::SdsGuiService::ResumeSessionCallbackIF
//, public sds_gui_fi::SdsGuiService::HelpCommandCallbackIF
//, public sds_gui_fi::SdsGuiService::CursorIndexForInitialFocusCallbackIF
//, public sds_gui_fi::SdsGuiService::HighPrioAppStatusCallbackIF
/* , public LanguageSourceObserver */
{
   public:
      SdsAdapterRequestor(::boost::shared_ptr<sds_gui_fi::SdsGuiService::SdsGuiServiceProxy>& sdsGuiServProxy);
      virtual ~SdsAdapterRequestor();

      ///////////////////////////////////////////Callbacks for Requests to SDS_Adapter/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      virtual void onManualOperationResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ManualOperationResponse >& response);
      virtual void onManualOperationError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ManualOperationError >& error);
      unsigned int listItemSelected(unsigned int _guiSelectedListItemIndex);
      unsigned int requestNextPage();
      unsigned int requestPrevPage();
      void sendPttShortPress();
      void sendStopSession();
      void onPttPressError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::PttPressError >& error) ;
      void onPttPressResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::PttPressResponse >& response) ;
      virtual void onStopSessionError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::StopSessionError >& error);
      virtual void onStopSessionResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::StopSessionResponse >& response);
#if 0
      void onPttPressError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::PttPressError >& error) ;
      void onPttPressResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::PttPressResponse >& response) ;

      void sendPttShortPress();

      virtual void onManualOperationResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ManualOperationResponse >& response);
      virtual void onManualOperationError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ManualOperationError >& error);

      virtual void onStartSessionContextError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::StartSessionContextError >& error) ;
      virtual void onStartSessionContextResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::StartSessionContextResponse >& response);

      virtual void onTestModeUpdateError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::TestModeUpdateError >& error);
      virtual void onTestModeUpdateResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::TestModeUpdateResponse >& response);

      virtual void onSettingsCommandError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SettingsCommandError >& error);
      virtual void onSettingsCommandResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SettingsCommandResponse >& response);

      virtual void onBackPressError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::BackPressError >& error);
      virtual void onBackPressResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::BackPressResponse >& response);

      virtual void onAbortSessionError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::AbortSessionError >& error);
      virtual void onAbortSessionResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::AbortSessionResponse >& response);

      virtual void onPauseSessionError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::PauseSessionError >& error);
      virtual void onPauseSessionResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::PauseSessionResponse >& response);

      virtual void onResumeSessionError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ResumeSessionError >& error);
      virtual void onResumeSessionResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ResumeSessionResponse >& response);

      virtual void onHelpCommandError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::HelpCommandError >& error);
      virtual void onHelpCommandResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::HelpCommandResponse >& response);

      virtual void onCursorIndexForInitialFocusError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::CursorIndexForInitialFocusError >& error);
      virtual void onCursorIndexForInitialFocusResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::CursorIndexForInitialFocusResponse >& response);

      virtual void onHighPrioAppStatusError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::HighPrioAppStatusError >& error);
      virtual void onHighPrioAppStatusUpdate(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::HighPrioAppStatusUpdate >& update);
      ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

      ////////////////////////////////////////////// Courier Message Mapping with Traces classes ///////////////////////////////////////////////////////////////////////////////////
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SDS_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SDSBackPressMsg)
      COURIER_MSG_MAP_END()
      //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

      //////////The below onCourierMessage funtions are the various action perform & model subscribed courier messages from SM ////////////////////////////////////////////////////
      bool onCourierMessage(const SDSBackPressMsg& msg);
      /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

      ///////////////////////////////////////////Requests to SDS_Adapter//////////////////////////////////////////////////////////////////////////////////////////////////////////////
      void backKeyPressed();
      unsigned int focusMoved(unsigned int _guiFocusIndex);
      unsigned int listItemSelected(unsigned int _guiSelectedListItemIndex);
      unsigned int listItemSelectedHL(unsigned int _guiSelectedListItemIndex);
      unsigned int requestNextPage();
      unsigned int requestPrevPage();
      unsigned int sendShortcutRequest(unsigned int _shortcutType);
      unsigned int sendSWCTelLongPressRequest();
      unsigned int sendTestModeSentence(std::string _textSentence);
      void sendAbortSession();
      void sendPauseSession();
      void sendResumeSession();
      void resetSessionFlag();
      void cursorIndexChanged(unsigned int cursorIndex);
      void highPrioAppStatus(bool status);
      void sendHelpCommandRequest();
      void sendSettingsCommandRequest();
      ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

   private:
      sds_gui_fi::SdsGuiService::ContextType mapGui2AdapterShortcutContext(unsigned int _guiContext);
      void onLanguageSourceChange();
#endif

   private:
      ::boost::shared_ptr<sds_gui_fi::SdsGuiService::SdsGuiServiceProxy> _sdsGuiServiceProxy;
      bool _cancelSessionRequested;
};


}
}


#endif /* SDSADAPTERREQUESTOR_H_ */
