/**************************************************************************//**
 * \file       GuiUpdater.cpp
 *
 * This file is part of the SDS HMI Application.
 *
 * \copyright  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "gui_std_if.h"

#include "util/StrUtf8.h"

#include "AppHmi_SdsStateMachine.h"
#include "AppHmi_SdsConstants.h"
#include "AppHmi_SdsStateMachineSEMLibB.h"
#include "hmi_trace_if.h"

#include "App/Core/SdsAdapter/GuiUpdater.h"
#include "App/Core/SdsDefines.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SDS_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SDS
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SDS_"
#define ETG_I_FILE_PREFIX                 App::Core::GuiUpdater::
#include "trcGenProj/Header/GuiUpdater.cpp.trc.h"
#endif
#include <iostream>
using namespace sds_gui_fi::PopUpService;
using namespace std;
namespace App {
namespace Core {

GuiUpdater::GuiUpdater()
{
}


GuiUpdater::~GuiUpdater()
{
}


void GuiUpdater::updateHeaderSpeakingIconIndex(unsigned int index)
{
   ETG_TRACE_USR4(("GuiUpdater :: updateHeaderSpeakingIconIndex %d", index));

   (*_SRStatusData).mIcon_SRStatus = (Candera::UInt16) index;
   _SRStatusData.MarkItemModified(ItemKey::SRStatus::Icon_SRStatusItem);
   _SRStatusData.SendUpdate();
}


void GuiUpdater::updateHeaderTextData(std::string headerString)
{
   ETG_TRACE_USR4(("GuiUpdater::updateHeaderTextData, _headerString = %s", headerString.c_str()));
   (*_PopUpTextData).mDynamicText = headerString.c_str();/* "INF4CV" */
   _PopUpTextData.MarkItemModified(ItemKey::PopUpText::DynamicTextItem);
   _PopUpTextData.SendUpdate();
}


/////  Clear Header ////

void GuiUpdater::ClearHeaderTextData()
{
   ETG_TRACE_USR4(("GuiUpdater::ClearHeaderTextData"));
   (*_PopUpTextData).mDynamicText = "";/* "INF4CV" */
   _PopUpTextData.MarkItemModified(ItemKey::PopUpText::DynamicTextItem);
   _PopUpTextData.SendUpdate();
}


void GuiUpdater::updatePopupTextfieldData(::std::vector< sds_gui_fi::PopUpService::TextField > processTextfieldvectorpass)
{
   ETG_TRACE_USR4(("GuiUpdater::updatePopupTextfieldData Entered"));
   if (processTextfieldvectorpass.size() == 2)
   {
      ETG_TRACE_USR4(("GuiUpdater::updatePopupTextfieldData, textfieldstring = %s", processTextfieldvectorpass.at(1).getString().c_str()));
      (*_PopUpSingleText).mSRText = processTextfieldvectorpass.at(1).getString().c_str();
   }
   else
   {
      ETG_TRACE_USR4(("GuiUpdater::updatePopupTextfieldData, textfieldstring = %s", processTextfieldvectorpass.at(0).getString().c_str()));
      (*_PopUpSingleText).mSRText = processTextfieldvectorpass.at(0).getString().c_str();
   }

   _PopUpSingleText.MarkItemModified(ItemKey::PopUpSingleText::SRTextItem);
   _PopUpSingleText.SendUpdate();
}


void GuiUpdater::updatePopupNumberfieldData(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal/* ::std::vector< sds_gui_fi::PopUpService::TextField > Numberfieldvector */)
{
   ::std::vector< sds_gui_fi::PopUpService::TextField > Numberfieldvector;
   Numberfieldvector = signal->getTextFields();
   ETG_TRACE_USR4(("GuiUpdater::updatePopupNumberfieldData, textfieldstring = %s", Numberfieldvector.at(1).getString().c_str()));

   (*_PopUpMultipleText).mSROne = Numberfieldvector.at(1).getString().c_str();
   (*_PopUpMultipleText).mSRPlus = Numberfieldvector.at(2).getString().c_str();
   (*_PopUpMultipleText).mSRStar = Numberfieldvector.at(3).getString().c_str();
   (*_PopUpMultipleText).mSRHash = Numberfieldvector.at(4).getString().c_str();
   (*_PopUpMultipleText).mSRReadNumber = Numberfieldvector.at(5).getString().c_str();
   (*_PopUpMultipleText).mSRCallNumber = Numberfieldvector.at(6).getString().c_str();
   (*_PopUpMultipleText).mSRCorrect = Numberfieldvector.at(7).getString().c_str();
   (*_PopUpMultipleText).mSRDeleteAll = Numberfieldvector.at(8).getString().c_str();
   // //////////header /////////////////////
   if (signal->getHeader() == "")
   {
      (*_MediaDeviceConnectedStatus).misEnable = 0;
   }
   else
   {
      (*_MediaDeviceConnectedStatus).misEnable = 1;
   }

   _MediaDeviceConnectedStatus.MarkItemModified(ItemKey::MediaDeviceConnectedStatus::isEnableItem);
   _MediaDeviceConnectedStatus.SendUpdate();

   _PopUpMultipleText.MarkAllItemsModified();
   _PopUpMultipleText.SendUpdate();
}


void GuiUpdater::listSliderDisplay(bool status)
{
   ETG_TRACE_USR4(("GuiUpdater::listScrollbarDisplay"));

   (*_ListSliderDisplay).mSliderVisible = status;
   ETG_TRACE_USR4(("scroll status :%d ", status));
   _ListSliderDisplay.MarkItemModified(ItemKey::ListSliderDisplay::SliderVisibleItem);
   _ListSliderDisplay.SendUpdate();
}


void GuiUpdater::NextButtonEnableStatus(bool status)
{
   ETG_TRACE_USR4(("GuiUpdater::NextButtonEnableStatus"));
   (*_NextButtonActiveStatus).mNextButtonActive = status;
   _NextButtonActiveStatus.MarkItemModified(ItemKey::NextButtonActiveStatus::NextButtonActiveItem);
   _NextButtonActiveStatus.SendUpdate();
}


void GuiUpdater::PrevButtonEnableStatus(bool status)
{
   ETG_TRACE_USR4(("GuiUpdater::PrevButtonEnableStatus"));
   (*_PrevButtonActiveStatus).mPrevButtonActive = status;
   _PrevButtonActiveStatus.MarkItemModified(ItemKey::PrevButtonActiveStatus::PrevButtonActiveItem);
   _PrevButtonActiveStatus.SendUpdate();
}


void GuiUpdater::updatePageNumber(::std::string pageNumberCount)
{
   ETG_TRACE_USR4(("GuiUpdater::updatePageNumber, pageNumberCount = %s", pageNumberCount.c_str()));
   (*_listPageNumberData).mPageNumber = pageNumberCount.c_str();
   _listPageNumberData.MarkItemModified(ItemKey::ListPageNumber::PageNumberItem);
   _listPageNumberData.SendUpdate();
}


void GuiUpdater::TimedStepMovementSlider(float index, float sliderValue)
{
   ETG_TRACE_USR4(("GuiUpdater::TimedStepMovementSlider"));
   (*_TimedStepMovementSlider).mNumOfSteps = (Candera::UInt16) index;
   (*_TimedStepMovementSlider).mCurrentValue = (Candera::UInt16) sliderValue;
   _TimedStepMovementSlider.MarkItemModified(ItemKey::TimedStepMovementSlider::NumOfStepsItem);
   _TimedStepMovementSlider.MarkItemModified(ItemKey::TimedStepMovementSlider::CurrentValueItem);
   _TimedStepMovementSlider.SendUpdate();
}


void  GuiUpdater::bargeInEnableStatus(bool status)
{
   ETG_TRACE_USR4(("GuiUpdater::bargeInEnableStatus"));
   (*_BargeInEnableStatus).mBargeInEnable = status;
   _BargeInEnableStatus.MarkItemModified(ItemKey::BargeInEnableStatus::BargeInEnableItem);
   _BargeInEnableStatus.SendUpdate();
}


std::string GuiUpdater::toString(int value)
{
   char itoa_txt[40];
   snprintf(itoa_txt, sizeof(itoa_txt), "%d", value);
   return (itoa_txt);
}


} // namespace Core
} // namespace App
