/* ***************************************************************************************
* FILE:          CGIAppViewFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactory.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "CGIAppViewFactory.h"
#include "AppHmi_SPIMessages.h"
// the views
#include "CGIAppViewController_SPI.h"


SCENE_MAPPING_BEGIN(aScenes)

//SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_ConnectSP),
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_FullScreen),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_mySPIN_AppView),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_MySPIN),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_1stDeviceConnection),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_2ndDeviceConnectConfirmation),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_AAP_FRX_Disclaimer),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_Connect_BT),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_ParkedCondition),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_SPIMessage),

                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Phone_not_connected),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_SPI_BT_Pairing),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_SPI_Retry),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SPI_Gadget),
// simple view controller from AppHmi_SPI_SimpleViewController.h have not to be added here
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   COURIER_UNUSED(viewController);
}
