/*********************************************************************************************************************************
 * @file         : SystemPowerModeClientHandler.h
 * @author       : Sundeep Parvathikar (RBEI/ECH2)
 * @addtogroup   : AppHmi_SPI
 * @brief        :
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *17.04.2019 Rev. 0.1 Sundeep Parvathikar (RBEI/ECH2)	Initial Revision to handle System Power Mode.
 *********************************************************************************************************************************/

#ifndef _SPM_CLIENT_HANDLER_H_
#define _SPM_CLIENT_HANDLER_H_

#include "SPIDefines.h"
#include "SPM_CORE_FIProxy.h"

#include "Core/DisplaySourceClientHandler/DisplaySourceClientHandler.h" //Used to call DisplaySourceClientHandler::vsetAccessoryDisplayContext() -> DisplaySourceClientHandler::vsendCurrentAppID
#include "Core/AudioSourceClientHandler/AudioSourceClientHandler.h"
#include "Core/ConnectionClientHandler/ConnectionClientHandler.h"
#define SPI_APP_ID 16
namespace App {
namespace Core {
class SystemPowerModeClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::SPM_CORE_FI::HmiStateCallbackIF
{
   private:
      static SystemPowerModeClientHandler* _SystemPowerModeClientHandler;
      SystemPowerModeClientHandler();

      /****** Proxy instance creation  ******/
      ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy> _SPMSetproxy;

      bool m_bSleepContextFlag; // To avoid sending false display context/ unborrow request on system startup.
      bool m_bStandByContextFlag; // To avoid sending false display context/ unborrow request on system startup.

   public:
      static SystemPowerModeClientHandler* getInstance();
      virtual ~SystemPowerModeClientHandler();
      bool getSleepContextFlag();

      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      COURIER_MSG_MAP_END()

      void onUnavailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);
      void onAvailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);

      /********************* Service Property registration/deregistration  *****************/
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);

      /******************** CFC_SPM_FI::HmiStateCallbackIF ********************/
      void onHmiStateError(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const boost::shared_ptr< ::SPM_CORE_FI::HmiStateError >& /*error*/);
      void onHmiStateStatus(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const boost::shared_ptr< ::SPM_CORE_FI::HmiStateStatus >& /*status*/);
};


} // namespace Core
} // namespace App

#endif /*_SPM_CLIENT_HANDLER_H_*/
