/**************************************************************************************
 * @file         : ConnectionClientHandler.cpp
 * @author       : Athira K Sreekumar
 * @addtogroup   : AppHmi_SPI
 * @brief        :
 * @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *20.04.18 Rev. 0.1 Athira K Sreekumar (RBEI/ECG2)
 * 		  			Initial Revision.
 **************************************************************************************/
/*
Date        | Version | Author               |  Description
--------------------------------------------------------------------------------------------------------------
20.04.18    0.1         Athira K Sreekumar      Initial version.
--------------------------------------------------------------------------------------------------------------
| includes
|----------------------------------------------------------------*/
#ifndef SPIDEFINES_H_
#define SPIDEFINES_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h" // For including the OSAL related files.

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "generic_msgs_if.h" //Includes Generic msg interface file
#include "midw_fi_if.h" // Interface file which includes service definitions

#include "midw_smartphoneint_fi.h"
#include "midw_smartphoneint_fiProxy.h"
#include "midw_smartphoneint_fi_types.h"
#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_SPIStateMachine.h"
#include "MOST_BTSet_FI.h"
#include "MOST_BTSet_FIProxy.h"
#include "most_BTSet_fi_types.h"
#include "MOST_Tel_FI.h"
#include "MOST_Tel_FIProxy.h"
#include "most_Tel_fi_types.h"

/***********************************************************************
* 						MACRO DEFINITIONS
***********************************************************************/
//SetPreferenceDeviceUsage
#define ENABLE_INFO 1
#define DISABLE_INFO 0

#define UNDEFINED 0
#define DEFAULT_SOURCE 255
#define LANGNO  19
#define SPEED_TRESHOLD 5

// Set Feature Restriction in Decimal
#define CARPLAY_DRIVERESTRICTED_SPEED  16   //10000

#define AAP_DONTHIDE 0
#define SPEED_STATIONARY 0
#define SPEEDLOCK_ON 1
#define SPEEDLOCK_OFF 0

// Set Feature Restriction in Decimal
#define AAP_C_UNRESTRICTED     0    //00000
#define AAP_C_DRIVERESTRICTED_SLON  27   //11011
#define AAP_C_DRIVERESTRICTED_SLOFF  25   //11001
#define AAP_C_RVCRESTRICTED    31   //11111
#define AAP_C_VHSTATIONARY    9   //01001
#define AAP_DontHide  0 //0000000000000000
#define AAP_DUMMY 2//00010

//VehicleType
#define DP_INF4CV_VEHICLETYPE_TRUCK 0
#define DP_INF4CV_VEHICLETYPE_COACH 1
#define DP_INF4CV_VEHICLETYPE_SMART 2

//Gear Status
#define GEAR_NEUTRAL 0
#define GEAR_1 1
#define GEAR_2 2
#define GEAR_3 3
#define GEAR_4 4
#define GEAR_5 5
#define GEAR_6 6
#define GEAR_LOW 7
#define GEAR_DRIVE 100
#define GEAR_PARK 101
#define GEAR_REVERSE 102
#define GEAR_INFO_UNAVAILABLE 255

/************************************************************************
* info about different active profiles (A2DP, HFP) over which the BT device is connected.
* 0th bit - A2DP
* 1st bit - HFP
* 0xFF  - When information is not available.
************************************************************************/
#define A2DP_BIT_POSITION 0
#define HFP_BIT_POSITION 1
#define UNKNOWN_INFO 0xFF


/*DipoApp*/
/*
		bool DipoAppPhoneState_Flag;
		bool DipoAppSpeechState_Flag;
		bool isPhoneState;
*/
#define DIPO_APP_PHONE_ENABLE 1
#define DIPO_APP_PHONE_DISABLE 0
#define DIPO_APP_SPEECH_ENABLE 1
#define DIPO_APP_SPEECH_DISABLE 0

/***********************************************************************
* 						ENUMS
***********************************************************************/
typedef struct
{
   tU32 tDeviceHandle;
   ::midw_smartphoneint_fi_types::T_e8_DeviceType enDeviceType;
   ::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus enUserAuthorizationStatus;
} UserAuthorizationDetails;

typedef struct
{
   tU32 tDeviceHandle;
   ::midw_smartphoneint_fi_types::T_AccessoryDisplayContext enDisplayContextInfo;
   ::midw_smartphoneint_fi_types::T_DisplayConstraint enDisplayConstraintInfo;
   ::midw_smartphoneint_fi_types::T_e8_DisplayInfo enContextResponsibility;
} SetAccessoryDisplayContextDetails;

enum ParkBreakInfo
{
   PARK_BRAKE_INFO_UNAVAILABLE,
   PARK_BRAKE_NOT_ENGAGED,
   PARK_BRAKE_ENGAGED
};


enum VehicleStateInfo
{
   PARK_MODE,
   DRIVE_MODE
};


enum DTRTileInfo
{
   DTR_NO_CONNECTION,
   DTR_MYSPIN_CONNECTED,
   DTR_ANDROIDAUTO_CONNECTED,
   DTR_CARPLAY_CONNECTED
};


enum DimmingStatusInfo
{
   DAY_MODE = 1,
   NIGHT_MODE,
   AUTO_DAY_MODE,
   AUTO_NIGHT_MODE
};


enum enPhoneAppState
{
   PhoneAppState__SPI_APP_STATE_PHONE_UNKNOWN = 0u,
   PhoneAppState__SPI_APP_STATE_PHONE_ACTIVE = 1u,
   PhoneAppState__SPI_APP_STATE_PHONE_NOTACTIVE = 2u
};


enum enSpeechAppState
{
   SpeechAppState__SPI_APP_STATE_SPEECH_UNKNOWN = 0u,
   SpeechAppState__SPI_APP_STATE_SPEECH_END = 1u,
   SpeechAppState__SPI_APP_STATE_SPEECH_RECOGNISING = 2u,
   SpeechAppState__SPI_APP_STATE_SPEECH_SPEAKING = 3u
};


enum enNavigationAppState
{
   NavigationAppState__SPI_APP_STATE_NAV_UNKNOWN = 0u,
   NavigationAppState__SPI_APP_STATE_NAV_ACTIVE = 1u,
   NavigationAppState__SPI_APP_STATE_NAV_NOTACTIVE = 2u
};


typedef enum
{
   EN_NONE = 0UL,
   EN_BT_PAIRING = 1UL,
   EN_OOB_BT_PAIRING = 2UL,
   EN_AAP_USB = 3UL,
   EN_AAP_WIRELESS = 4UL,
   EN_DIPO_USB = 5UL,
   EN_DIPO_WIRELESS = 6UL,
   EN_CARLIFE_USB = 7UL,
   EN_ML_USB = 8UL, // Dummy vlaue used till component releases it officially
   EN_ML_BT = 9UL
} BTConflictTrigger_Info;

enum DisplayContextInfo
{
   DISPLAY_CONTEXT_UNKNOWN,
   DISPLAY_CONTEXT_SPEECH_REC,
   DISPLAY_CONTEXT_PHONE,
   DISPLAY_CONTEXT_NAVIGATION,
   DISPLAY_CONTEXT_MEDIA,
   DISPLAY_CONTEXT_INFORMATIONAL,
   DISPLAY_CONTEXT_EMERGENCY,
   DISPLAY_CONTEXT_SPEAKING,
   DISPLAY_CONTEXT_TBT_NAVIGATION,
   DISPLAY_CONTEXT_SLEEP_MODE,
   DISPLAY_CONTEXT_STANDBY_MODE,
   DISPLAY_CONTEXT_SCREEN_SAVER,
   DISPLAY_CONTEXT_NATIVE,
   DISPLAY_CONTEXT_PROJECTION,
   DISPLAY_CONTEXT_USER_INPUT
};


enum en2ndDevSwitcherIndex
{
   EN_2ND_DEVICE_BT_TO_DIPO = 2,
   EN_2ND_DEVICE_BT_TO_AAP = 5,
};


#endif /*SPIDEFINES_H_*/
