/**************************************************************************************
 * @file         : DisplaySourceClientHandler.h
 * @author       : Bruce Mario Savio Netto
 * @addtogroup   : AppHmi_SPI
 * @brief        :
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *
 * 17.04.19        0.1 Bruce Netto (RBEI/ECH2)
 *                 New Client Handler to handle Display Resource Management in SPI
 **************************************************************************************/

#ifndef DISPLAYSOURCECLIENTHANDLER_H_
#define DISPLAYSOURCECLIENTHANDLER_H_

#include "SPIDefines.h"
#include "App/Core/ConnectionClientHandler/ConnectionClientHandler.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_hmi_10_if.h"

#include <ilm_client.h>
#include <ilm_control.h>
#include <algorithm>
#include <sstream>
#include <limits>

class StartupSync;

namespace App {
namespace Core {
class ConnectionClientHandler;

class DisplaySourceClientHandler: public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CurrentForegroundApplicationIdCallbackIF
   , public ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusCallbackIF
{
   private:
      static DisplaySourceClientHandler* _displaySourceClientHandler;
      ConnectionClientHandler* _connectionClientHandler;
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoProxyClient;

   public:
      DisplaySourceClientHandler(ConnectionClientHandler*);
      virtual ~DisplaySourceClientHandler();
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool m_displayFlag;//giving the target,or giving the external
      int m_appID, m_PrevAppID;
      bool m_RVCState;
      bool m_tempRVC;
      int currentAppID;
      midw_smartphoneint_fi_types::T_e8_DisplayContext m_valDisplayContext;

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      COURIER_MSG_MAP_END()

//getInstance
      static DisplaySourceClientHandler* getInstance(ConnectionClientHandler* pConnectionClientHandler)
      {
         if (NULL == _displaySourceClientHandler)
         {
            _displaySourceClientHandler = new DisplaySourceClientHandler(pConnectionClientHandler);
         }
         return _displaySourceClientHandler;
      }

//Virtual Functions
      virtual void registerProperties(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);
      virtual void deregisterProperties(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);

      void onUnavailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);
      void onAvailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);

      //CurrentForegroundApplicationIdCallbackIF
      virtual void onCurrentForegroundApplicationIdError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy >& proxy,
            const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CurrentForegroundApplicationIdError >& error);
      virtual void onCurrentForegroundApplicationIdUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy >& proxy,
            const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::CurrentForegroundApplicationIdUpdate >& update);
      //RVCSignalStatusCallbackIF
      virtual void onRVCSignalStatusError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy >& proxy,
                                          const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusError >& error);
      virtual void onRVCSignalStatusUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy >& proxy,
                                           const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusUpdate >& update);
      void vsendCurrentAppID(midw_smartphoneint_fi_types::T_e8_DisplayContext, bool);
      void vsetAccessoryDisplayContext(int);
      void vsetRVCInfo(bool);
      int getCurrentAppID();
};//class DisplaySourceClientHandler
}//namespace Core
}//namespace App
#endif /*DISPLAYSOURCECLIENTHANDLER_H_*/
//EOF
