/**************************************************************************************
 * @file         : ContextSwitchClientHandler.h
 * @author       : Sundeep Parvathikar (RBEI/ECH2)
 * @addtogroup   : AppHmi_SPI
 * @brief        : Singleton class to handle Context Switch functionalities similar to ApplicationSwitchClientComponent with added functionalities
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *14.03.19 Rev. 0.1 Sundeep Parvathikar (RBEI/ECH2)
 * 		  			Initial Revision.
 **************************************************************************************/

#ifndef _CONTEXT_SWITCH_CLIENT_HANDLER_H_
#define _CONTEXT_SWITCH_CLIENT_HANDLER_H_

#include "SPIDefines.h"
#include "AppBase/ServiceAvailableIF.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "App/Core/ConnectionClientHandler/ConnectionClientHandler.h"

using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;

#define APPLICATIONSWITCH_TYPES    ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch

namespace App {
namespace Core {
class ContextSwitchClientHandler :
   public ServiceAvailableIF
   , public ActiveRegionIdCallbackIF
   , public Sig_ActivateContextCallbackIF
   , public RequestContextSwitchCallbackIF
   , public SendContextCallbackIF
{
   private:
      ContextSwitchClientHandler();
      static ContextSwitchClientHandler* _contextSwitch;

      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchProxy;

   public:

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(SPIEntryMsg)
      ON_COURIER_MESSAGE(ViewSPIActivityId)
      COURIER_MSG_MAP_END()

      static ContextSwitchClientHandler* poGetInstance();
      virtual ~ContextSwitchClientHandler();

      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const SPIEntryMsg&);
      bool onCourierMessage(const ViewSPIActivityId&);

      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                         const ::boost::shared_ptr< ActiveRegionIdError >& error) ;

      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                          const ::boost::shared_ptr< ActiveRegionIdUpdate >& update) ;

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);
      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      virtual void onRequestContextSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchError >& error);
      virtual void onRequestContextSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchResponse >& response);

      virtual void onSendContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextError >& error);
      virtual void onSendContextResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextResponse >& response);

      void requestContextSwitchApplication(uint8  regionId,
                                           uint8  sourceAppId,
                                           APPLICATIONSWITCH_TYPES::enActivityIDs  sourceActivityId,
                                           uint8  targetAppId,
                                           APPLICATIONSWITCH_TYPES::enActivityIDs  targetActivityId);

      void requestSendContext(uint8  regionId
                              , uint8  sourceAppId
                              , APPLICATIONSWITCH_TYPES::enActivityIDs  sourceActivityId);

      APPLICATIONSWITCH_TYPES::enActivityIDs getActivityIDforCurrentView(void);
};


}//namespace Core
}//namespace App

#endif //_CONTEXT_SWITCH_CLIENT_HANDLER_H_
