/**************************************************************************************
 * @file         : AudioSourceClientHandler.h
 * @author       : Athira K Sreekumar
 * @addtogroup   : AppHmi_SPI
 * @brief        :
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *04.06.18 Rev. 0.1 Athira K Sreekumar (RBEI/ECG2)
 * 		  			      Initial Revision.
 *12.02.19 Rev. 0.2 Bruce Netto (RBEI/ECH2)
 *                  Optimizations and error fixes to the client handler file
 **************************************************************************************/

#ifndef AUDIOSOURCECLIENTHANDLER_H_
#define AUDIOSOURCECLIENTHANDLER_H_

#include "SPIDefines.h"

#include "App/Core/ConnectionClientHandler/ConnectionClientHandler.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"

#include <ilm_client.h>
#include <ilm_control.h>

#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

class StartupSync;

namespace App {
namespace Core {
class ConnectionClientHandler;

class AudioSourceClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public midw_smartphoneint_fi::DeviceAudioContextCallbackIF
   , public midw_smartphoneint_fi::AccessoryAudioContextCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateCallbackIF
//, public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::VolumeCallbackIF
{
   private:
      static AudioSourceClientHandler* _audioSourceClientHandler;
      ConnectionClientHandler* _connectionClientHandler;
      ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy> _smartphoneFIProxy;
      ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy> _audioSourceChangeProxy;
      ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy> _soundPropertiesProxy;

      uint32 m_CurrentSource;
      bool m_CurrentAudioFlag;
      ::midw_smartphoneint_fi_types::T_e8_AudioContext m_CurrentAudioContext;
      bool m_MuteState;

   public:
      AudioSourceClientHandler(ConnectionClientHandler*);
      virtual ~AudioSourceClientHandler();
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SPI_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      COURIER_MSG_MAP_END()

      //getInstance
      static AudioSourceClientHandler* getInstance(ConnectionClientHandler* pConnectionClientHandler)
      {
         if (NULL == _audioSourceClientHandler)
         {
            _audioSourceClientHandler = new AudioSourceClientHandler(pConnectionClientHandler);
         }
         return _audioSourceClientHandler;
      }

      //Virtual Functions
      virtual void registerProperties(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);
      virtual void deregisterProperties(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);

      void onUnavailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);
      void onAvailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);

      //DeviceAudioContextCallbackIF
      virtual void onDeviceAudioContextStatus(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                              const ::boost::shared_ptr<midw_smartphoneint_fi::DeviceAudioContextStatus>&);
      virtual void onDeviceAudioContextError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                             const ::boost::shared_ptr<midw_smartphoneint_fi::DeviceAudioContextError>&);

      //AccessoryAudioContextCallbackIF
      virtual void onAccessoryAudioContextResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::AccessoryAudioContextResult>& result);

      virtual void onAccessoryAudioContextError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::AccessoryAudioContextError>& error);

      //ActiveSourceCallbackIF
      virtual void onActiveSourceUpdate(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy>& /*proxy*/,
                                        const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceUpdate>& update);
      virtual void onActiveSourceError(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy>& /*proxy*/,
                                       const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceError>& /*error*/);
      //VolumeCallbackIF
      //virtual void onVolumeUpdate(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy>&,
      //                               const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::VolumeUpdate>&);
      //virtual void onVolumeError(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy>&,
      //                               const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::VolumeError>&);

      //MuteStateCallbackIF
      virtual void onMuteStateUpdate(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy>&,
                                     const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateUpdate>&);

      virtual void onMuteStateError(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy>&,
                                    const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateError>&);

      void vSetAccessoryAudioContext(bool, ::midw_smartphoneint_fi_types::T_e8_AudioContext);
      void vFindAccessoryAudioContext(bool&, ::midw_smartphoneint_fi_types::T_e8_AudioContext&);
      void vUpdateAccessoryAudioContext(bool, ::midw_smartphoneint_fi_types::T_e8_AudioContext);
      bool bIsAudioBorrowContext(::midw_smartphoneint_fi_types::T_e8_AudioContext);

      bool bIsChangeAudioSource(uint32);
      bool bIsMixedSourceActive(uint32);
      bool bIsSPITempSourceActive(uint32);

      void vSetAudioFlag(bool);
      bool bGetAudioFlag();

      void vSetAudioContext(bool, ::midw_smartphoneint_fi_types::T_e8_AudioContext);
      midw_smartphoneint_fi_types::T_e8_AudioContext tGetAudioContext();

      void vSetCurrentSource(uint32);
      uint32 tGetCurrentSource();

      void vSetMuteState(bool);
      bool bGetMuteState();

      void vInitialize();
};


} // namespace Core
} // namespace App

#endif /*AUDIOSOURCECLIENTHANDLER_H_*/
