/* ***************************************************************************************
* FILE:          CGIAppController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "AppHmi_PhoneStateMachine.h"
#include "CGIAppController.h"

#include "ProjectBaseTypes.h"
#include "Project.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "../../App/datapool/PhoneDataPoolConfig.h"
#include "../../App/Core/Telephone/ServiceTel.h"
#include "AppBase/ScreenBrokerClient/ScreenBrokerClient.h"
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
#include "../../App/Core/Intercom/IntercomClienthandler.h"
#endif
#include "hmi_trace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_PHONE_MAIN
#include "trcGenProj/Header/CGIAppController.cpp.trc.h"
#endif

using namespace std;
using namespace ::App::Core;
using namespace ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl;


/********************************************
/* NAME    : CGIAppController
/* SYSFL    : SYSFL-4698, SYSFL-4699, SYSFL-4700
****************************************************/

bool CGIAppController::onCourierMessage(const HKStatusChangedUpdMsg& msg)
{
   bool retVal = false;
   int m_Hkcode = msg.GetHKCode();
   hmibase::HardKeyStateEnum hardkeyState = msg.GetHKState();
   ServiceTel* _ServiceTel = ServiceTel::poGetInstance();

#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
   IntercomClienthandler* _IntercomClienthandler = IntercomClienthandler::poGetInstance();
#endif

   if ((g_SM_SpiSessionStatus == SPI_SESSION_INACTIVE) || (g_SM_SpiSessionStatus == SPI_SESSION_UNKNOWN))
   {
      if ((Enum_hmibase_HARDKEYSTATE_DOWN != hardkeyState) &&
            ((HARDKEYCODE_SWC_PHONE_PICKUP == m_Hkcode) || (HARDKEYCODE_HK_PHONE_ACCEPT == m_Hkcode)))
      {
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg ACCEPT HKCode: %d %d", m_Hkcode, hardkeyState));

         uint16 u16VehicleType = PhoneDataPoolConfig::getInstance()->getKDSVehicleType();

         if ((VEHICLETYPE_COACH == u16VehicleType) || (VEHICLETYPE_TRUCK == u16VehicleType))
         {
            // in case of SWC and MCP Short press, DO NOT consume the short press when internal VR to be lanuched,
            // Master will take care of launch this, Phone should not consume the Key Press

            bool bisIncomingCallPopupActive = _ServiceTel->getIncomingCallStatus();
            bool bisCallDialingInProgress = _ServiceTel->getCallDialingStatus();
            bool bisThereAnActiveCall = _ServiceTel->getOngoingCallStatus();
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
            bool bisIntercomIncomingCallPopupActive = _IntercomClienthandler->getIntercomIncomingCallStatus();
            bool bisIntercomCallDialingInProgress = _IntercomClienthandler->getIntercomCallDialingStatus();
            bool bisThereAnActiveIntercomCall = _IntercomClienthandler->getIntercomOngoingCallStatus();
            bool bisThereConfIntercomCall = _IntercomClienthandler->getIntercomConfCallStatus();
#endif
            if ((Enum_hmibase_HARDKEYSTATE_UP == hardkeyState) &&    // Short Key Press  (MCP or SCW)
                  (!bisIncomingCallPopupActive) && 					  // No incoming call
                  (!bisCallDialingInProgress) && 					  // no outgoing Call
                  (!bisThereAnActiveCall) &&							   // No Active call
                  (_ServiceTel->getBTVRStatus() != true))   // BTVR is not active
            {
               // Phone is Idle, so switch to Internal VR on Long press
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
               if ((!bisIntercomIncomingCallPopupActive) && 					 // No Intercom incoming call
                     (!bisIntercomCallDialingInProgress) && 					  // no Intercom outgoing Call
                     (!bisThereAnActiveIntercomCall) &&                      // No Active call
                     (!bisThereConfIntercomCall)) 						//No Conference call

               {
                  ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg -- Phone and intercom is IDLE, Transfer HKey code to Master to trigger Interval "));
                  retVal = CGIAppControllerProject::onCourierMessage(msg);
               }
               else
               {
                  ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg -- calls are there post courier msg to phone"));
                  POST_MSG((COURIER_MESSAGE_NEW(onHardKeyPress)(m_Hkcode, hardkeyState)));
               }
#endif
#ifndef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
               // Phone is Idle, so switch to Internal VR on Long press
               ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg -- Phone is IDLE, Transfer HKey code to Master to trigger Interval "));
               retVal = CGIAppControllerProject::onCourierMessage(msg);
#endif
            }

            else
            {
               // In other cases -post courier msg to Phone to handle the scnearios
               POST_MSG((COURIER_MESSAGE_NEW(onHardKeyPress)(m_Hkcode, hardkeyState)));
            }
         }
         else
         {
            // In Case of SMART to internal VR - Hence Phone handles BTVR request
            POST_MSG((COURIER_MESSAGE_NEW(onHardKeyPress)(m_Hkcode, hardkeyState)));
         }
      }
      else if ((Enum_hmibase_HARDKEYSTATE_DOWN != hardkeyState) &&
               ((HARDKEYCODE_SWC_PHONE_REJECT == m_Hkcode) || (HARDKEYCODE_HK_PHONE_REJECT == m_Hkcode)))
      {
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg REJECT HKCode: %d %d", m_Hkcode, hardkeyState));

         POST_MSG((COURIER_MESSAGE_NEW(onHardKeyPress)(m_Hkcode, hardkeyState)));
      }
      else if ((Enum_hmibase_HARDKEYSTATE_DOWN == hardkeyState) && (HARDKEYCODE_REMOTECONTROL_PHONE == m_Hkcode))
      {
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg  HARDKEYCODE_REMOTECONTROL_PHONE"));
         POST_MSG((COURIER_MESSAGE_NEW(onHardKeyPress)(m_Hkcode, hardkeyState)));
      }
      else if ((Enum_hmibase_HARDKEYSTATE_DOWN == hardkeyState) && (((m_Hkcode >= HARDKEYCODE_REMOTECONTROL_NUM_9) && (m_Hkcode <= HARDKEYCODE_REMOTECONTROL_NUM_0)) || (m_Hkcode == HARDKEYCODE_REMOTECONTROL_HASH) || (m_Hkcode == HARDKEYCODE_REMOTECONTROL_STAR)))//multiple conditions checked due to the values not part of the same number series.
      {
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg  HARDKEYCODE_REMOTECONTROL_DIALPAD_BUTTON: %d", m_Hkcode));
         //Checking if the DialPad Scene in
         if (m_isDialpadViewRendered == true)
         {
            ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg  HARDKEYCODE_REMOTECONTROL_DIALPAD_BUTTON Consumed in Phone"));
            POST_MSG((COURIER_MESSAGE_NEW(onHardKeyPress)(m_Hkcode, hardkeyState)));
         }
         else
         {
            ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg  HARDKEYCODE_REMOTECONTROL_DIALPAD_BUTTON Not Consumed"));
            retVal = CGIAppControllerProject::onCourierMessage(msg);
         }
      }
      else if ((Enum_hmibase_HARDKEYSTATE_DOWN != hardkeyState) && (HARDKEYCODE_HK_POWER == m_Hkcode))
      {
         bool bisIncomingCallPopupActive = _ServiceTel->getIncomingCallStatus();
         bool bisCallDialingInProgress = _ServiceTel->getCallDialingStatus();
         bool bisThereAnActiveCall = _ServiceTel->getOngoingCallStatus();
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
         bool bisIntercomIncomingCallPopupActive = _IntercomClienthandler->getIntercomIncomingCallStatus();
         bool bisIntercomCallDialingInProgress = _IntercomClienthandler->getIntercomCallDialingStatus();
         bool bisThereAnActiveIntercomCall = _IntercomClienthandler->getIntercomOngoingCallStatus();
         bool bisThereConfIntercomCall = _IntercomClienthandler->getIntercomConfCallStatus();
#endif

         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg HARDKEYCODE_HK_POWER comes to Phone only when phone is in FG"));
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg HARDKEYCODE_HK_POWER HKCode: %d %d", m_Hkcode, hardkeyState));

         if (bisIncomingCallPopupActive || bisThereAnActiveCall || bisCallDialingInProgress)
         {
            ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg - either Incoming call, outgoing call or Active Call is active."));
            ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg - HARDKEYCODE_HK_POWER consumed by the Phone. "));
            retVal = true;
         }
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
         else if ((bisIntercomIncomingCallPopupActive) ||   // No Intercom incoming call
                  (bisIntercomCallDialingInProgress) ||   // no Intercom outgoing Call
                  (bisThereAnActiveIntercomCall) &&      // No Active call
                  (bisThereConfIntercomCall)) 	  //No Conference call

         {
            ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg - either Intercom Incoming call, outgoing call or Active Call is active."));
            ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg - HARDKEYCODE_HK_POWER consumed by the Phone. "));
            retVal = true;
         }
#endif
         else
         {
            retVal = CGIAppControllerProject::onCourierMessage(msg);
            ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg  HARDKEYCODE_HK_POWER Key forwared to framework"));
         }
      }
      else
      {
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg Key forwared to framework for key forwarding HKCode: %d %d", m_Hkcode, hardkeyState));
         retVal = CGIAppControllerProject::onCourierMessage(msg);
      }
   }
   else if ((Enum_hmibase_HARDKEYSTATE_DOWN != hardkeyState) && (HARDKEYCODE_HK_POWER == m_Hkcode))
   {
      bool bisIncomingCallPopupActive = _ServiceTel->getIncomingCallStatus();
      bool bisCallDialingInProgress = _ServiceTel->getCallDialingStatus();
      bool bisThereAnActiveCall = _ServiceTel->getOngoingCallStatus();

#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      bool bisIntercomIncomingCallPopupActive = _IntercomClienthandler->getIntercomIncomingCallStatus();
      bool bisIntercomCallDialingInProgress = _IntercomClienthandler->getIntercomCallDialingStatus();
      bool bisThereAnActiveIntercomCall = _IntercomClienthandler->getIntercomOngoingCallStatus();
      bool bisThereConfIntercomCall = _IntercomClienthandler->getIntercomConfCallStatus();
#endif

      ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg HARDKEYCODE_HK_POWER comes to Phone only when phone is in FG"));
      ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg HARDKEYCODE_HK_POWER HKCode: %d %d", m_Hkcode, hardkeyState));

      if (bisIncomingCallPopupActive || bisThereAnActiveCall || bisCallDialingInProgress)
      {
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg - either Incoming call, outgoing call or Active Call is active."));
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg - HARDKEYCODE_HK_POWER consumed by the Phone. "));
         retVal = true;
      }
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      else if ((bisIntercomIncomingCallPopupActive) ||   // No Intercom incoming call
               (bisIntercomCallDialingInProgress) ||   // no Intercom outgoing Call
               (bisThereAnActiveIntercomCall) &&       // No Active call
               (bisThereConfIntercomCall)) 	//No Conference call
      {
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg - either Intercom Incoming call, outgoing call or Active Call is active."));
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg - HARDKEYCODE_HK_POWER consumed by the Phone. "));
         retVal = true;
      }
#endif
      else
      {
         retVal = CGIAppControllerProject::onCourierMessage(msg);
         ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg  HARDKEYCODE_HK_POWER Key forwared to framework"));
      }
   }
   else
   {
      retVal = CGIAppControllerProject::onCourierMessage(msg);
      ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg Key forwared to framework"));
   }
   return retVal;
}


bool CGIAppController::onCourierMessage(const RenderingCompleteMsg& msg)
{
   ETG_TRACE_USR4(("CGIAppController: RenderingCompleteMsg GetViewName:%s", msg.GetViewName().GetCString()));
   bool retVal = false;
   const Courier::ViewId View_Name = Courier::ViewId(msg.GetViewName().GetCString());
   const Courier::ViewId CALL_LIST = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList");
   const Courier::ViewId CONTACT_LIST = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts");
   const Courier::ViewId DIALPAD = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad");
   const Courier::ViewId DIALPADKEYS = Courier::ViewId("Global#Scenes#Speller#P_Layout");
   const Courier::ViewId ICONTACTS = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#I_Contacts");

   m_isDialpadViewRendered = false;
   if ((View_Name == CALL_LIST) || (View_Name == CONTACT_LIST) || (View_Name == DIALPAD) || (View_Name == ICONTACTS))
   {
      ETG_TRACE_USR4(("CGIAppController: RenderingCompleteMsg, Send context switch for ActivityID = %s", msg.GetViewName().GetCString()));
      POST_MSG((COURIER_MESSAGE_NEW(ViewPhoneActivityId)()));
   }
   if (View_Name == DIALPAD || View_Name == DIALPADKEYS)
   {
      m_isDialpadViewRendered = true;
      ETG_TRACE_USR4(("CGIAppController: RenderingCompleteMsg View Name DialPad Id Set to True"));
   }
   retVal = CGIAppControllerProject::onCourierMessage(msg);
   return retVal;
}
