/**************************************************************************************
* @file         : PhoneDataPoolConfig.h
* @author       : Supriya Seshadri
* @addtogroup   : AppHmi_Phone
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef PHONE_DATAPOOLCONFIG_H_
#define PHONE_DATAPOOLCONFIG_H_

#include "asf/core/Types.h"
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_hmi_09_if.h"
#endif

// uint8 values used in Data pool
#define DP_FIRST_NAME 0
#define DP_LAST_NAME 1

// reference : g3inf4cv_GEN\ai_projects\generated\components\datapool\dp\dpIfGlob.h
#define DP_S32_NO_ERR     0

/**
 * class PhoneDataPoolConfig
 * This class hold implementation related to Datapool elements. It provides interfaces to read/write DP elements
 */
class PhoneDataPoolConfig
{
   public:
      /**
       * Destructor of class DataPoolConfig
       * @return None
       */

      ~PhoneDataPoolConfig();
      /**
      * Singleton Class. Method to retrieve the instance of the class
      * @return Returns instance of the class
      */
      static PhoneDataPoolConfig* getInstance();
      static void deleteInstance();

      void setMessageSettings(bool bMessageStatus);
      void setDpSortOrderValue(uint8 u8PhoneSortOrderValue);
      void setDpPhoneRingToneStatus(uint8 phRingToneStatus);

      tBool getMessageSettings();
      uint8 getDpPhoneSortOrderValue();
      uint8 getDpPhoneRingToneStatus();

      void resetMessageSettings();
      void resetDpSortOrderValue();
      void resetDpPhoneRingToneStatus();

      // Vehicle related information
      uint16 getKDSVehicleType();

      bool isVRSupported() const;
      bool isWIFISupported();
      bool isBluetoothSupported();

   private:

      // Instance of the class
      static PhoneDataPoolConfig* _DpPhone;

      PhoneDataPoolConfig();
      PhoneDataPoolConfig(const PhoneDataPoolConfig&);
      PhoneDataPoolConfig& operator=(const PhoneDataPoolConfig&);

      dp_tclAppHmi_PhoneSortOrderValue _dpPhoneSortOrderValue;//_dpPhoneTextMessageStatus;
      dp_tclAppHmi_PhoneMessageSettingsDP _dpMessageSettings;
      dp_tclAppHmi_PhonePhoneRingtoneStatus _dpPhoneRingToneStatus;
};


#endif /* DATAPOOLCONFIG_H_ */
