/**************************************************************************************
* @file         : PhoneDataPoolConfig.cpp
* @author       : Supriya Seshadri
* @addtogroup   : AppHmi_Phone
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_09_if.h"
#include "dp_generic_if.h"
#endif

#include "PhoneDataPoolConfig.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_PHONE_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_PHONE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_PHONE_"
#define ETG_I_FILE_PREFIX                 PhoneDataPoolConfig::
#include "trcGenProj/Header/PhoneDataPoolConfig.cpp.trc.h"
#endif

#define DP_U8_KDSLEN_VEHICLEINFORMATION_VEHICLETYPE   2

// Instantiate the static class object
PhoneDataPoolConfig* PhoneDataPoolConfig::_DpPhone = NULL;


/**
 * Description     : Constructor of PhoneDataPoolConfig
 *
 *
 * @param[in]      : none
 * @param[in]      : None
 * @return         : void
 */
PhoneDataPoolConfig::PhoneDataPoolConfig()
{
}


PhoneDataPoolConfig::~PhoneDataPoolConfig()
{
}


/**
 * Description     : getInstance, returns the instance of the class
 *                   PhoneDataPoolConfig
 * @param[in]      : none
 * @param[in]      : none
 * @return         : PhoneDataPoolConfig*
 */
PhoneDataPoolConfig* PhoneDataPoolConfig::getInstance()
{
   if (_DpPhone == NULL)
   {
      _DpPhone = new PhoneDataPoolConfig();
   }
   return _DpPhone;
}


/**
 * Description     : Destructor of PhoneDataPoolConfig
 *
 * @param[in]      : none
 * @param[in]      : None
 * @return         : void
 */

void PhoneDataPoolConfig::deleteInstance()
{
   if (_DpPhone != NULL)
   {
      delete _DpPhone;
   }
   _DpPhone = NULL;
}


/**
 * Description     : setMessageSettings, Sets the Message Settings
 *
 * @param[in]      : MessageStatus :
* @return         : void
 */
void PhoneDataPoolConfig::setMessageSettings(bool bMessageStatus)
{
   _dpMessageSettings.vSetData(bMessageStatus);
   ETG_TRACE_USR4(("PhoneDataPoolConfig::setMessageSettings  :%d", bMessageStatus));
}


/**
 * Description     : getMessageSettings, reads the Message Settings
 *
 * @param[in]      : none
 * @param[in]      : none
 * @return         : uint8
 */
tBool PhoneDataPoolConfig::getMessageSettings()
{
   tBool bMsgSetting = static_cast<tBool>(_dpMessageSettings.tGetData());
   ETG_TRACE_USR4(("PhoneDataPoolConfig::getMessageSettings :%d", bMsgSetting));
   return bMsgSetting;
}


void PhoneDataPoolConfig::resetMessageSettings()
{
   ETG_TRACE_USR4(("PhoneDataPoolConfig::resetMessageSettings :  Reset to 1"));
   uint8 factorydefvalue = 1;
   _dpMessageSettings.vSetData(factorydefvalue);
}


void PhoneDataPoolConfig::resetDpPhoneRingToneStatus()
{
   ETG_TRACE_USR4(("PhoneDataPoolConfig::resetDpPhoneRingToneStatus  :  Reset to 1 (factory default)"));
   uint8 factorydefvalue = 1;
   _dpPhoneRingToneStatus.vSetData(factorydefvalue);
}


uint8 PhoneDataPoolConfig::getDpPhoneRingToneStatus()
{
   uint8 u8PhoneRingToneStatus = _dpPhoneRingToneStatus.tGetData();
   ETG_TRACE_USR4(("PhoneDataPoolConfig::getDpPhoneRingToneStatus :%d", u8PhoneRingToneStatus));
   return u8PhoneRingToneStatus;
}


void PhoneDataPoolConfig::setDpPhoneRingToneStatus(uint8 phRingToneStatus)
{
   ETG_TRACE_USR4(("PhoneDataPoolConfig::setDpPhoneRingToneStatus :%d", phRingToneStatus));
   _dpPhoneRingToneStatus.vSetData(phRingToneStatus);
}


void PhoneDataPoolConfig::resetDpSortOrderValue()
{
   ETG_TRACE_USR4(("PhoneDataPoolConfig::resetDpSortOrderValue  :  Reset to 0"));
   uint8 factorydefvalue = 0;
   _dpPhoneSortOrderValue.vSetData(factorydefvalue);
}


uint8 PhoneDataPoolConfig::getDpPhoneSortOrderValue()
{
   uint8 u8PhoneSortOrderValue = _dpPhoneSortOrderValue.tGetData();
   ETG_TRACE_USR4(("PhoneDataPoolConfig::getDpPhoneSortOrderValue :%d", u8PhoneSortOrderValue));
   return u8PhoneSortOrderValue;
}


void PhoneDataPoolConfig::setDpSortOrderValue(uint8 u8PhoneSortOrderValue)
{
   ETG_TRACE_USR4(("PhoneDataPoolConfig::setDpSortOrderValue :%d", u8PhoneSortOrderValue));
   _dpPhoneSortOrderValue.vSetData(u8PhoneSortOrderValue);
}


bool PhoneDataPoolConfig::isVRSupported() const
{
   uint8 VRSupported = 0xFF;
   bool isVoiceRecognitionSupported = false;
   if (DP_S32_NO_ERR ==  DP_s32GetConfigItem("SystemConfiguration1", "BTVR", &VRSupported, 1))
   {
      isVoiceRecognitionSupported = (VRSupported == 0x01) ? true : false;
      ETG_TRACE_USR4(("PhoneDataPoolConfig::isVoiceRecognitionSupported :%d", isVoiceRecognitionSupported));
   }
   else
   {
      ETG_TRACE_FATAL(("PhoneDataPoolConfig::isVRSupported, Error in Reading KDS -- default set as false"));
   }
   return isVoiceRecognitionSupported;
}


bool PhoneDataPoolConfig::isWIFISupported()
{
   uint8 WIFICompatible = 0xFF;
   bool isWifiSupported = false;
   ETG_TRACE_USR4(("PhoneDataPoolConfig::isWifiSupported"));
   if (DP_S32_NO_ERR ==  DP_s32GetConfigItem("SystemConfiguration1", "WifiFunction", &WIFICompatible, 1))
   {
      isWifiSupported = (WIFICompatible == 0x01) ? true : false;
      ETG_TRACE_USR4(("PhoneDataPoolConfig::isWifiSupported :%d", isWifiSupported));
   }
   else
   {
      ETG_TRACE_FATAL(("PhoneDataPoolConfig::isWifiSupported, Error in Reading KDS -- default set as false"));
   }
   ETG_TRACE_USR4(("PhoneDataPoolConfig::isWifiSupported Done"));
   return isWifiSupported;
}


bool PhoneDataPoolConfig::isBluetoothSupported()
{
   uint8 BTCompatible = 0xFF;
   bool isBluetoothSupported = false;
   ETG_TRACE_USR4(("PhoneDataPoolConfig::isBluetoothSupported"));
   if (DP_S32_NO_ERR ==  DP_s32GetConfigItem("SystemConfiguration1", "BluetoothFunction", &BTCompatible, 1))
   {
      isBluetoothSupported = (BTCompatible == 0x01) ? true : false;
      ETG_TRACE_USR4(("PhoneDataPoolConfig::isBluetoothSupported :%d", isBluetoothSupported));
   }
   else
   {
      ETG_TRACE_FATAL(("PhoneDataPoolConfig::isBluetoothSupported, Error in Reading KDS -- default set as false"));
   }
   ETG_TRACE_USR4(("PhoneDataPoolConfig::isBluetoothSupported Done"));
   return isBluetoothSupported;
}


/**
 * Description     : getKDSVehicleType, reads the Vehicle type information from KDS
 *
 * @param[in]      : none
 * @param[in]      : none
 * @return         : uint16
 */
uint16 PhoneDataPoolConfig::getKDSVehicleType()
{
   uint8 u8VehicleType[2] = {0};
   uint16 u16VehicleType = 0;

   if (DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "VehicleType", &u8VehicleType[0], 2))
   {
      u16VehicleType = static_cast<uint16>((u8VehicleType[0] << 8) | u8VehicleType[1]);
      ETG_TRACE_USR4(("PhoneDataPoolConfig::getKDSVehicleType, Vehicle type : %d", u16VehicleType));
   }
   else
   {
      ETG_TRACE_FATAL(("PhoneDataPoolConfig::getKDSVehicleType, Error in Reading KDS -- Setting to 0 representing Truck"));
      u16VehicleType = 0; // to confirm the default state
   }
   return u16VehicleType;
}
