/************************************************************************
*FILE: 			 Apphmi_PhoneTtfisHmiCmdHandler.h
*SW-COMPONENT:  HMI
*DESCRIPTION: 	 Defines the class btphn_tclApphmiPhoneTtfisHmiCmdHandler which
*               handles TTFis input commands (that simulates HMI user actions)
*AUTHOR:        Supriya
*COPYRIGHT:     (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*HISTORY:
*03.22.2018 Rev. 0.1 Supriya Seshadri
* 		    Initial Revision.
************************************************************************/

#ifndef APPHMI_PHONETTFISHMICMDHANDLER_HEADER
#define APPHMI_PHONETTFISHMICMDHANDLER_HEADER

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC

/* Macros to be defined for including the needed trace files */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON

/*****************************************************************
| includes
|----------------------------------------------------------------*/

/* Header files required for Tracing out log statements */
#include "etrace_if.h"

#include "osal_if.h" // For including the OSAL related files

/* For using the courier messages */
#include "AppHmi_PhoneMessages.h"

#include "BTPhoneDefines.h"
#include "PhoneBookDataTypes.h"
#include "hmi_trace_if.h"
#include "Core/SmartPhone/SmartPhoneClient.h"
#include "Core/Telephone/ServiceTel.h"

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/*****************************************************************
| class declaration (scope: global)
|----------------------------------------------------------------*/

namespace App {
namespace Core {
class Apphmi_PhoneTtfisHmiCmdHandler; // Forward declaration

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/
class Apphmi_PhoneTtfisHmiCmdHandler
{
   public:
      Apphmi_PhoneTtfisHmiCmdHandler();
      ~Apphmi_PhoneTtfisHmiCmdHandler();

      static void initialize();

      //static void traceCmd_optionKeyRespCmd();
      static void traceCmd_settingsKey();

      static void traceCmd_ChangeMessageSettings();

      static void traceCmd_ActivateBtVR();
      static void traceCmd_StartBtVRSession();

   private:

      /* Assingment Operater, will not be implemented.
      So if an attempt for the assignment is made compiler complains.
      Copy constructor will also not be implemented */
      Apphmi_PhoneTtfisHmiCmdHandler& operator= (
         const Apphmi_PhoneTtfisHmiCmdHandler& corfoCmdHandler
      );
      Apphmi_PhoneTtfisHmiCmdHandler(
         const Apphmi_PhoneTtfisHmiCmdHandler& corfoCmdHandler
      );
};


}
}


#endif // APPHMI_PHONETTFISHMICMDHANDLER_HEADER

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
