/* ***************************************************************************************
* FILE:          SpellerModel.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SpellerModel.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_SPELLER_MODEL_H)
#define _SPELLER_MODEL_H
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneMessages.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "PhoneBookDataTypes.h"
#include "AppUtils/HmiMacros.h"
#include  "AppHmi_PhoneStateMachineData.h"
#include "Common/DataModel/ListModel.h"
#include "Common/DataModel/ListRegistry.h"


using namespace Courier;

namespace App {
namespace Core {
class SpellerModel : virtual public ListImplementation
{
   private:
      SpellerModel& operator=(const SpellerModel&);
      SpellerModel(const SpellerModel&);
      static SpellerModel* m_poSpellerModel;
      /*Binding source to update the ValidCharactes in DialPad */
      DataItemContainer<ValidCharSetDataBindingSource> oValidCharset;

      /*Binding source to update the Suggesstion Text in DialPad */
      DataItemContainer<SuggesstionTextDataBindingSource> oSuggesstionText;

      /*Binding source to update the Suggesstion Text in DialPad */
      DataItemContainer<EntryTextDataBindingSource> oEntryText;

      /*Binding source to update Number of Matched Items */
      DataItemContainer<MatchedItemsDataBindingSource> oMatchedItems;

      /*Binding source to update the Match list Button */
      DataItemContainer<MatchListDataBindingSource> oMatchList;

      /*Binding source to update the Dial Button Status */
      DataItemContainer<DialButtonDataBindingSource> oDialButton;

      /*	Binding source to update the List Size */
      DataItemContainer <ListDataSizeDataBindingSource> oListDataSize;

      /*	Binding source to update the List Id */
      DataBindingItem<ListId_FlexDataBindingSource>oListID;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);

      //int m_ListId;
      //::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy > _btPhoneBookProxy;
   protected:
      SpellerModel();

   private:

      tU8 u8MatchListSize;

   public:
      static SpellerModel* poGetInstance()
      {
         if (NULL == m_poSpellerModel)
         {
            m_poSpellerModel = new SpellerModel();
         }
         return m_poSpellerModel;
      }
      ~SpellerModel();

      bool Init();

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      void OnUpdEntryText(std::string sEntrytext);

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      void OnUpdValidCharSet(Candera::String sCharset);

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      void OnUpdSuggestionText(std::string sSuggestionText);

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      void OnUpdDialButton(std::string sEditInfo);

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      void OnUpdMatchList(tU16 u8Listsize, tU8 u8WindowSize);
      std::string strGetEntryText();

      /* Updates the match list according to the values provided by PhoneBook service */
      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      void OnUpdDialMatchList(tBool bAutocompleteMatch, tCString copcAutocompleteMatchNum, tU8 u8MatchNumber, std::vector<btphn_trPhnBkMatchListEntry>& arMatchList);

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      void vSetMatchListElements(tU8 u8ListSize, std::vector<btphn_trPhnBkMatchListEntry>& arMatchList);

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      tU8 u8GetMatchListSize()
      {
         return u8MatchListSize;
      }

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      bool OnUpdClearEditField();
};


}//Namespace Core
}//Namespace App

#endif // _SPELLER_MODEL_H
