/* ***************************************************************************************
* FILE:          PhoneCallModel.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PhoneCallModel.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_PHONE_CALL_MODEL_H)
#define _PHONE_CALL_MODEL_H
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneMessages.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "BTPhoneDefines.h"
#include "TeleDefines.h"
#include "PhoneBookDataTypes.h"
#include "AppHmiPhone_Helper.h"
#include "AppUtils/HmiMacros.h"
#include  "AppHmi_PhoneStateMachineData.h"
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
#include "../HmiTranslation_TextIds.h"
#endif
using namespace Courier;

namespace App {
namespace Core {
class PhoneCallModel
{
   private:
      /*Binding source to update the MicEnable */
      DataItemContainer<MicEnableDataBindingSource> oMicEnable;
      /*Binding source to update the Incoming Call  */
      DataItemContainer<IncomingCallDataBindingSource> oIncomingCall;

      /* Data Bining source used for handling Call Status provided by the application */
      DataItemContainer<CallProgressDataBindingSource> oCallProgress;

      /* Binding source instance - Updates BTVR Icon*/
      DataBindingItem<BTVRIconSRStatusIndexDataBindingSource> oBTVRIconDataBindingSourceIndex;

      /*Binding source to update the DialPadButton */
      DataItemContainer<DialPadButtonDataBindingSource> oDialPadButton;

      /*Binding source to update the Multiparty Call */
      DataItemContainer<MultipleCallProgressDataBindingSource>oMultipleCallProgress;
      /*Binding source to update the VehicleAudioStatus */
      DataItemContainer<VehicleAudioStatusDataBindingSource>oVehicleAudioStatus;

      /* Binding source instance - Updates Icon and Device Name*/
      DataBindingItem<BTVRIconSRStatusDataBindingSource> oBTVRIconDataBindingSource;
      //DataBindingItem<BTVRDeviceNameDataBindingSource> oSIRIDeviceNameDataBindingSource;

      /*Binding source to update the Network Operator name */
      DataItemContainer<NetworkOperatorDataBindingSource>oOperatorName;
      PhoneCallModel();
      PhoneCallModel& operator=(const PhoneCallModel&);
      PhoneCallModel(const PhoneCallModel&);

   public:
      static PhoneCallModel* poPhoneCallModel;
      static PhoneCallModel* poGetInstance()
      {
         if (NULL == poPhoneCallModel)
         {
            poPhoneCallModel = new PhoneCallModel();
         }
         return poPhoneCallModel;
      }
      ~PhoneCallModel();

      void OnUpdCallStatus(tU16 CallInst, std::string CallDuration, std::string CallerID, btphn_tenPhoneCallStatus CallStatus, std::string PhoneType);
      void OnUpdIncomingCallStatus(std::string ContactName, std::string TelePhoneNo, btphn_tenPhoneIncomingCallStatus CallStatus, std::string DeviceName);
      void OnUpdMicMuteStatus(bool MuteStatus);
      void OnUpdVehicleAudioSource(bool AudioStatus);
      bool bDataUpdate(UInt8 u8CallStatus, std::string PhoneType);
      void OnUpdMultipleCallStatusResp(std::string FirstCallerID, std::string FirstCallDuration, tU8 u8FirstCallStatus,
                                       std::string FirstContactType, std::string SecondCallerID, std::string SecondCallDuration, tU8 u8SecondCallStatus,
                                       std::string SecondContactType);
      bool bMultipleCallStatusUpdate(
         Candera::String strFirstCallerID,
         Candera::String strSecondCallerID,
         Candera::String strFirstCallDuration,
         Candera::String strSecondCallDuration,
         Candera::String strFirstCallStatus,
         Candera::String strSecondCallStatus,
         Candera::String strFirstCallContactType,
         Candera::String strSecondCallContactType,
         Candera::String strCallStatusType,
         tBool bIsEnabled
      );
      void OnUpdMultipleConfCallStatus(Candera::String CallerID, Candera::String CallDuration);
      void vMultipleCallStatusInitatingUpdate
      (
         Candera::String strFirstCallerID,
         Candera::String strSecondCallerID,
         UInt8 u8FirstCallStatus,
         UInt8 u8SecondCallStatus,
         Candera::String strFirstCallContactType,
         Candera::String strSecondCallContactType,
         Candera::String strFirstCallDuration,
         Candera::String strSecondCallDuration);
      void OnUpdNetworkOperatorName(std::string strNetworkOperator);
      void OnUpdCallDuration(std::string sCallDuration);
      void OnUpdDeviceConnectionStatus(void);
      tVoid OnUpdSRIconStatus(tBool bVRIconToGUI);
      void vDeletecalldetails();
};


}//Namespace Core
}//Namespace App

#endif // _SPELLER_MODEL_H
