/* ***************************************************************************************
* FILE:          MSGModelComponent.h
* SW-COMPONENT:  AppHmi_Phone
*  DESCRIPTION:  MSGModelComponent.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_MSG_MODEL_COMPONENT_H)
#define _MSG_MODEL_COMPONENT_H
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneMessages.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "BTPhoneDefines.h"
#include "MessagingDataTypes.h"
#include "AppUtils/HmiMacros.h"
#include  "AppHmi_PhoneStateMachineData.h"
#include "PhonebookModelComponent.h"

#include "MOST_Msg_FI.h"


using namespace Courier;

namespace App {
namespace Core {
class MSGModelComponent
{
   private:
      /* For singleton implementation*/
      MSGModelComponent& operator=(const MSGModelComponent&);
      MSGModelComponent(const MSGModelComponent&);
      DataItemContainer<MsgProgressDataBindingSource> oMsgProgress;

      /*	Binding source to update the List Id
      DataBindingItem<ListId_FlexDataBindingSource>m_ListID; */

      // Incomming events ...

   protected:
      MSGModelComponent();
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
#ifdef WINDOWS_SIMULATION
      virtual bool onCourierMessage(const ReadMessageAloudReq& oMsg);
#endif


   public:
      /* for singleton implementation */
      static MSGModelComponent* _ModelInstance;
      static MSGModelComponent* poGetInstance();
      static void vDeleteInstance();
      virtual ~MSGModelComponent();

      bool Init();
      void OnUpdSendIncomingMsg(const btphn_trMsgDetailsResult& rMessageDetails);
      void OnUpdMsgAudioPlayStatus(const most_Msg_fi_types::T_e8_MsgPlaybackState& EnumPlayBackState);
      void OnUpdChangeSMSSettingsReq(bool bShowMessageStatus);

   public:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
#ifdef WINDOWS_SIMULATION
      ON_COURIER_MESSAGE(ReadMessageAloudReq)
#endif
      COURIER_MSG_MAP_END()
};


}//Namespace Core
}//Namespace App

#endif // _MSG_MODEL_COMPONENT_H
