/* ***************************************************************************************
* FILE:          MsgModelComponent.cpp
* SW-COMPONENT:  AppHmi_Phone Application
*  DESCRIPTION:  MsgModelComponent.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "util/StrUtf8.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneConstants.h"
#include "MsgModelComponent.h"
#include "AppHmiPhone_Helper.h"
#include "../PhoneBook/ServicePhonebook.h"
#include "App/datapool/PhoneDataPoolConfig.h"
#include "hmi_trace_if.h"

#ifdef WINDOWS_SIMULATION
#include <iostream>
using namespace std;
#endif

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_PHONE_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_FILE_PREFIX            App::Core::MSGModelComponent::
#include "trcGenProj/Header/MsgModelComponent.cpp.trc.h"
#endif
namespace App {
namespace Core {

MSGModelComponent* MSGModelComponent::_ModelInstance = NULL;


/**
*  MSGModelComponent::getInstance - function to get singleton instance
*  @return Singleton Instance
*/
MSGModelComponent* MSGModelComponent::poGetInstance()
{
   if (_ModelInstance == NULL)
   {
      _ModelInstance = new MSGModelComponent();
   }

   assert(_ModelInstance);
   return _ModelInstance;
}


void MSGModelComponent::vDeleteInstance()
{
   if (_ModelInstance)
   {
      delete _ModelInstance;
      _ModelInstance = 0;
   }
}


/************************************************************************
*FUNCTION: 	   MSGModelComponent
*DESCRIPTION:  Constructor
*PARAMETER: NA
*
*RETURNVALUE: 	NA
*
*HISTORY:
11/07/17 Supriya Seshadri		Initial Revision

************************************************************************/
MSGModelComponent::MSGModelComponent()
{
   ETG_TRACE_USR4(("MSGModelComponent : MSGModelComponent()"));

   uint16 u16VehicleType = VEHICLETYPE_TRUCK;
   //Read VehicleType from KDS and either enable or disable the read-out-aloud icon in the message pop-up based on the Vehicletype value
   if (PhoneDataPoolConfig::getInstance())
   {
      ETG_TRACE_USR4(("MSGModelComponent:: Retrive vehicleType information from KDS"));
      u16VehicleType = PhoneDataPoolConfig::getInstance()->getKDSVehicleType();
      ETG_TRACE_USR4(("MSGModelComponent:: getKDSVehicleType, Vehicle type : %d", u16VehicleType));
   }
   else
   {
      ETG_TRACE_USR4(("MSGModelComponent:: Error in getting PhoneDataPoolConfig instance"));
   }

   //Disable read out aloud for vehicle variant of Smart
   if (VEHICLETYPE_SMART == u16VehicleType)
   {
      ETG_TRACE_USR4(("MSGModelComponent::Disable read out aloud icon"));
      (*oMsgProgress).mIsEnableReadOutAloud = false;
   }
   else
   {
      //default to truck variant; enable read out aloud
      ETG_TRACE_USR4(("MSGModelComponent:: Enable read out aloud icon"));
      (*oMsgProgress).mIsEnableReadOutAloud = true;
   }
   oMsgProgress.MarkItemModified(ItemKey::MsgProgress::IsEnableReadOutAloudItem);
   oMsgProgress.SendUpdate(true);
}


/************************************************************************
*FUNCTION: 	   ~MSGModelComponent
*DESCRIPTION:  Destructor
*PARAMETER: NA
*
*RETURNVALUE: 	NA
*
*HISTORY:
*HISTORY:
11/07/17 Supriya Seshadri		Initial Revision
************************************************************************/
MSGModelComponent::~MSGModelComponent()
{
   ETG_TRACE_USR4(("BTMSGModelComponent : ~MSGModelComponent()"));
}


bool MSGModelComponent::Init()
{
   return true;
}


/**
 * @brief   : Incomming message for HMI data model a message component
 * @param   :
 */
bool MSGModelComponent::onCourierMessage(const Courier::StartupMsg& /*oMsg*/)
{
#ifdef WINDOWS_SIMULATION
   std::cout << "OnUpdNewDeviceInfoResult\n";
   //btphn_trMsgDetailsResult rMessageDetails;
   std::cout << "Enter" << "\n";
   int i;
   //std::cin >> i;
   btphn_trMsgDetailsResult rMessageDetails;
   rMessageDetails.rMsgDateTime.rMsgTime.copcHours = "12";
   rMessageDetails.rMsgDateTime.rMsgTime.copcMinutes = "45";
   rMessageDetails.rMsgDateTime.rMsgTime.copcSecounds = "10";
   rMessageDetails.copcShortMessage = "SHort Message";
   rMessageDetails.copcSubject = "This is the subjetc";
   rMessageDetails.copcFirstName = "SUPRIYA";
   this->OnUpdSendIncomingMsg(rMessageDetails);
#endif
   return true;
}


#ifdef WINDOWS_SIMULATION
bool MSGModelComponent::onCourierMessage(const ReadMessageAloudReq& oMsg)
{
   btphn_trMsgPlayBackAction enPlayBackAction = oMsg.GetPlayBackAction();
   btphn_trMsgPlayBackState EnumPlayBackState;

   if (enPlayBackAction == BTPHN_EN_E8PBA_PLAY)
   {
      EnumPlayBackState = BTPHN_EN_E8PBS_PLAYING;
   }

   if (enPlayBackAction == BTPHN_EN_E8PBA_PAUSE || enPlayBackAction == BTPHN_EN_E8PBA_STOP)
   {
      EnumPlayBackState = BTPHN_EN_E8PBS_STOPPED;
   }

   OnUpdMsgAudioPlayStatus(EnumPlayBackState);
   return true;
}


#endif
/*****************************************************************************
* @brief: Proprty Status Update from clienthandler for OnUpdSendIncomingMsg
*11.07.2017 : ess7kor
*Rev 0.1: Initial Version
*****************************************************************************/
void MSGModelComponent::OnUpdSendIncomingMsg(const btphn_trMsgDetailsResult& rMessageDetails)
{
   char DateTimeHours_Minutes[50];
   sprintf(DateTimeHours_Minutes, "%s : %s", rMessageDetails.rMsgDateTime.rMsgTime.copcHours.c_str(), rMessageDetails.rMsgDateTime.rMsgTime.copcMinutes.c_str());
   std::string strTimeHour = DateTimeHours_Minutes;
   most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder sortorder = T_e8_PhonBkPreferredPhoneBookSortOrder__e8PREFERRED_SORT_ORDER_FIRSTNAME;

   if (ServicePhoneBook::poGetInstance() != NULL)
   {
      sortorder = ServicePhoneBook::poGetInstance()->enGetSortOrder(); //temporary untill P_OPT scene implementation
   }
   ETG_TRACE_USR4(("MSGModelComponent : OnUpdSendIncomingMsg(), DateTimeHours_Minutes = %s ", DateTimeHours_Minutes));

   /*send Message to IAR to activate the Message Pop-up*/
   POST_MSG((COURIER_MESSAGE_NEW(IncomingMessageListResp)
             ((Candera::String)rMessageDetails.copcFirstName.c_str(),
              (Candera::String)rMessageDetails.copcPhoneNumber.c_str(),
              (Candera::String)DateTimeHours_Minutes,
              (Candera::String)rMessageDetails.copcSubject.c_str(),
              (Candera::String)rMessageDetails.copcShortMessage.c_str())));

   /*Udpate the Data Binding propertiy values for Message Pop-up*/
   std::string strContactName = AppHmiPhone_Helper::GetContactname(rMessageDetails.copcFirstName, rMessageDetails.copcLastName, sortorder);

   if (strContactName.empty() && rMessageDetails.copcPhoneNumber.empty())
   {
      (*oMsgProgress).mCallerID = BTPHN_C_CONTACT_UNKNOWN;
      ETG_TRACE_USR3(("Inside Empty (*oMsgProgress).mCallerID = %s", (*oMsgProgress).mCallerID));
   }

   else if (strContactName.compare(BTPHN_C_CONTACT_UNKNOWN) == BTPHN_C_EQUAL)
   {
      (*oMsgProgress).mCallerID = rMessageDetails.copcPhoneNumber.c_str();
      ETG_TRACE_USR3(("Inside unknown :(*oMsgProgress).mCallerID = %s", (*oMsgProgress).mCallerID));
   }
   else if (!strContactName.empty())
   {
      (*oMsgProgress).mCallerID = strContactName.c_str();

      ETG_TRACE_USR3(("inside valid : (*oMsgProgress).mCallerID = %s", (*oMsgProgress).mCallerID));
   }
   IsSMSContactActive =
      (BTPHN_C_VALUE_ZERO < rMessageDetails.copcPhoneNumber.length())
      ? BTPHN_C_VALUE_ONE :
      BTPHN_C_VALUE_ZERO;
   (*oMsgProgress).mValidContact = IsSMSContactActive;

   (*oMsgProgress).mTimeHour = ((Candera::String)strTimeHour.c_str());
   ETG_TRACE_USR4(("TimeHour : %s", ((*oMsgProgress).mTimeHour.GetCString())));

   (*oMsgProgress).mSubject = ((Candera::String)rMessageDetails.copcSubject.c_str());
   ETG_TRACE_USR4(("Subject : %s", ((*oMsgProgress).mSubject.GetCString())));

   (*oMsgProgress).mShortMessage = ((Candera::String)rMessageDetails.copcShortMessage.c_str());
   ETG_TRACE_USR4(("ShortMessage : %s", ((*oMsgProgress).mShortMessage.GetCString())));

   oMsgProgress.MarkAllItemsModified();
   oMsgProgress.SendUpdate(true);
}


/*****************************************************************************
* @brief: Proprty Status Update from clienthandler for OnUpdMsgAudioPlayStatus to
*highlight the Readaloud buttton on Message
*11.07.2017 : ess7kor
*Rev 0.1: Initial Version
*****************************************************************************/
void MSGModelComponent::OnUpdMsgAudioPlayStatus(const most_Msg_fi_types::T_e8_MsgPlaybackState& EnumPlayBackState)
{
   ETG_TRACE_USR4(("MSGModelComponent : OnUpdMsgAudioPlayStatus"));
   /*send Message to IAR to activate the Message Pop-up*/
   POST_MSG((COURIER_MESSAGE_NEW(ReadMessageAudioPlayBackstateResp)((btphn_trMsgPlayBackState)(EnumPlayBackState))));

   switch (EnumPlayBackState)
   {
      case most_Msg_fi_types::T_e8_MsgPlaybackState__e8PBS_PLAYING:
      {
         ETG_TRACE_USR4(("Button Enable at BTPHN_EN_E8PBS_PLAYING / n"));
         (*oMsgProgress).mPlayBackAction = true;
         break;
      }
      case most_Msg_fi_types::T_e8_MsgPlaybackState__e8PBS_STOPPED:
      {
         ETG_TRACE_USR4(("Button Enable at BTPHN_EN_E8PBS_STOPPED / n"));
         (*oMsgProgress).mPlayBackAction = false;
         IsReadAloudActive = BTPHN_C_VALUE_ZERO;
         break;
      }
      default:
      {
         ETG_TRACE_USR4(("Button Enable at BTPHN_EN_E8PBS_ERROR / n"));
         (*oMsgProgress).mPlayBackAction = false;
         IsReadAloudActive = BTPHN_C_VALUE_ZERO;
         break;
      }
   }
   oMsgProgress.MarkItemModified(ItemKey::MsgProgress::PlayBackActionItem);
   oMsgProgress.SendUpdate(true);
}


void MSGModelComponent::OnUpdChangeSMSSettingsReq(bool bShowMessageStatus)
{
   ETG_TRACE_USR4(("MSGModelComponent : OnUpdChangeSMSSettingsReq : bShowMessageStatus = %d", bShowMessageStatus));
   if (PhonebookModelComponent::poGetInstance() != NULL)
   {
      PhonebookModelComponent::poGetInstance()->vSetShowIncomingMessage(bShowMessageStatus);
      PhonebookModelComponent::poGetInstance()->OnUpdSettingsList();
   }
}


}
}
