/* ***************************************************************************************
* FILE:          CallHistoryModel.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CallHistoryModel.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(_CALL_HISTORY_MODEL_H)
#define _CALL_HISTORY_MODEL_H

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneMessages.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "BTPhoneDefines.h"
#include "PhoneBookDataTypes.h"
#include "AppHmiPhone_Helper.h"
#include "AppUtils/HmiMacros.h"
#include "ServiceBT.h"
#include  "AppHmi_PhoneStateMachineData.h"
#include "Common/DataModel/ListModel.h"
#include "Common/DataModel/ListRegistry.h"
#ifndef WINDOWS_SIMULATION
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif


using namespace Courier;
#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "asf/core/Types.h"
#include "utest/stubs/EnumData.h"
typedef int8 tU8;
#endif


#define INVALID_CALLHISTORYICONTYPE -1

namespace App {
namespace Core {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class CallHistoryModel :  public ListImplementation
{
   private:
      static CallHistoryModel* m_poCallHistoryModel;
      CallHistoryModel();
      CallHistoryModel& operator=(const CallHistoryModel&);
      CallHistoryModel(const CallHistoryModel&);
#else
class CallHistoryModel
{
   public:
      static CallHistoryModel* m_poCallHistoryModel;
      CallHistoryModel();
      CallHistoryModel& operator=(const CallHistoryModel&);
      CallHistoryModel(const CallHistoryModel&);
      ~CallHistoryModel();
#endif

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      /*	Binding source to update the List Id */
      DataBindingItem<ListId_FlexDataBindingSource>m_ListID;

      /*	Binding source to update the List Size */
      DataBindingItem<ListDataSizeDataBindingSource>m_ListDataSize;

      DataBindingItem<CallList_ListItemDataBindingSource>m_CallListItem;

      /*	Binding source to update the PhoneStatus */
      DataBindingItem<PhoneStatusDataBindingSource> oPhoneStatus;

      /*	Binding source to update the BTTele update */
      DataBindingItem<BTTelltalesDataBindingSource> oBTTelltale;
      DataBindingItem<RoamingDataBindingSource> oRoamingenable;

      /*Binding source to update List Status  */
      DataItemContainer<IsListNotemptyDataBindingSource> oIsListNotempty;

      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      //int m_ListId;
      //::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy > _btPhoneBookProxy;

   private:
      bool bRetVal;

      /* Used to store BTIcons Status */
      UInt8 u8BTLinkLost, u8BatteryIndicator, u8RoamingStatus, u8SignalStrength;
      bool bRoamingStatus;
   public:
      static CallHistoryModel* poGetInstance()
      {
         if (NULL == m_poCallHistoryModel)
         {
            m_poCallHistoryModel = new CallHistoryModel();
         }
         return m_poCallHistoryModel;
      }
      ~CallHistoryModel();

      bool Init();

      /*creates call list rows with valid data and updates it to GUI*/
      void OnUpdSetCallListElement(std::vector<btphn_trCallHistoryInfo>& arCallListSlice,
                                   tU16 u16CallListSize, tU16 u16StartIndex_CallList, tU16 u16lastItemIndex_CallList); //(SWFL-305, SWFL-306)
#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
   public:
#endif
      /*returns correct call info icon index*/
      tU8 GetCallInfoIcon(btphn_tenCallHistoryType enCallHistoryType);
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      /*updates battery status of phone */
      void OnUpdCellStateOfCharge(tU8 stateofcharge);

      /*/*updates signal strength of phone */
      void OnUpdCellSignalStrength(tU8 CellSignalStrength);

      /*updates network and roaming status  of phone */
      void OnUpdCellNetworkStatus(btphn_tenNetworkServiceState NetworkServicestate, bool RoamingStatus);

      /*updates call list size data binding property*/
      void OnUpdCallListSizeToModel(tU16 corfu16TotalListSize); //(SWFL-305, SWFL-306),SWFL-302

      /*updates BTteletales data binding property*/
      bool bUpdateBTTelltaleUpdate();

      void OnUpdMissedCallIndicator(tU32 u32NumOfMissedCall);

      void vClearCallListinGUI();

      /*updates the Battery Status Indicator flag*/
      void SetBatteryIndicator();
#endif
};


}//Namespace Core
}//Namespace App

#endif // _HMI_MODEL_COMPONENT_H
