/***************************************************************************
* Copyright(c) 2017-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/* ***************************************************************************************
* FILE:          AppHmi_PhoneHelper.h
*  DESCRIPTION:  Helper class to Phone application which implements common functonalities
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(_APPHMIPHONE_HELPER_H)
#define _APPHMIPHONE_HELPER_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#ifndef WINDOWS_SIMULATION
#include "osal_if.h"
#endif
#include <vector>
#include <string>
#include "AppHmi_PhoneTypes.h"
#include "BTPhoneDefines.h"
#include "../PhoneBook/ServicePhonebook.h"
#ifdef WINDOWS_SIMULATION
#include "tTypes.h"
#endif

namespace App {
namespace Core {
class AppHmiPhone_Helper
{
   private:
      AppHmiPhone_Helper();

      virtual ~AppHmiPhone_Helper();

   public:
      static std::string GetContactname(std::string sFirstName, std::string sLastName, most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder sortorder);
      static tU32 vCalculateWindowSize(int windowstart, int windowsize, int ListSize);
      static std::string ConvertCallDuration(tU8 corfu8CallDurationHr, tU8 corfu8CallDurationMin,
                                             tU8 corfu8CallDurationSec);
};


}//core
}//App
#endif
