/***************************************************************************
* Copyright(c) 2017-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/* ***************************************************************************************
* FILE:          AppHmiPhone_Helper.cpp
*  DESCRIPTION:  Helper class to wite functionalities common to all the models.
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "AppHmiPhone_Helper.h"
#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_PHONE_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_FILE_PREFIX            App::Core::AppHmiPhone_Helper::
#include "trcGenProj/Header/AppHmiPhone_Helper.cpp.trc.h"
#endif

namespace App {
namespace Core {


/************************************************************************
		*FUNCTION: 	   AppHmiPhone_Helper
		*DESCRIPTION:  Constructor
		*PARAMETER: NA
		*
		*RETURNVALUE: 	NA
		*
		*HISTORY:
		15/09/2017 Shwetha K
		Initial Revision

		************************************************************************/
AppHmiPhone_Helper::AppHmiPhone_Helper()
{
}


/************************************************************************
*FUNCTION: 	   ~AppHmiPhone_Helper
*DESCRIPTION:  Destructor
*PARAMETER: NA
*
*RETURNVALUE: 	NA
*
*HISTORY:
15/09/2017 Shwetha K
Initial Revision

************************************************************************/
AppHmiPhone_Helper::~AppHmiPhone_Helper()
{
}


/**
* This function Receives first name, last name and sort order,then based on the sort order gives the Contact name .
* @Input: first name, last name, Sort order
* @Return: gives the contact name.
*
* @param[out]- returns string
initial rev:Vidya
*/
std::string AppHmiPhone_Helper::GetContactname(std::string sFirstName, std::string sLastName, most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder  sortorder)
{
   ETG_TRACE_USR4(("AppHmiPhone_Helper : GetContactname : First name = %s", sFirstName.c_str()));
   ETG_TRACE_USR4(("AppHmiPhone_Helper : GetContactname : last name = %s", sLastName.c_str()));
   std::string sName = BTPHN_C_CONTACT_UNKNOWN;

   if ((sLastName.empty()) && (sFirstName.empty()))
   {
      sName = BTPHN_C_CONTACT_UNKNOWN;
      ETG_TRACE_USR4(("AppHmiPhone_Helper : GetContactname : Contact name = %s", sName.c_str()));
      return sName;
   }

   if (T_e8_PhonBkPreferredPhoneBookSortOrder__e8PREFERRED_SORT_ORDER_LASTNAME == sortorder)
   {
      if (!sLastName.empty() && !sFirstName.empty())
      {
         sName = sLastName + " " + sFirstName;
      }
      else if (sFirstName.empty())
      {
         sName = sLastName;
      }
      else
      {
         sName = sFirstName;
      }
   }
   else if (T_e8_PhonBkPreferredPhoneBookSortOrder__e8PREFERRED_SORT_ORDER_FIRSTNAME == sortorder)
   {
      if (!sLastName.empty() && !sFirstName.empty())
      {
         sName = sFirstName + " " + sLastName ;
      }
      else if (sFirstName.empty())
      {
         sName = sLastName;
      }
      else
      {
         sName = sFirstName;
      }
   }
   ETG_TRACE_USR4(("AppHmiPhone_Helper : GetContactname : Contact name = %s", sName.c_str()));
   return sName;
}


/**
* This function Receives windowstart, windowsize and ListSize and calculates the size of the list to be fetched from client .
* @Input: windowstart, windowsize and ListSize
* @Return: size of the list to be fetched from client.
*

*eg: if start index =0, list size = 100, windowsize = 20
*0...................19 items in list makes size of 20 window size
*hence lastItemIndex_List = 0 + 20 - 1
*i,e lastItemIndex_List = windowstart + windowsize - 1
* @param[out]- returns int
initial rev:Sai Prabha for Bug fix 277357
*/
tU32 AppHmiPhone_Helper::vCalculateWindowSize(int windowstart, int windowsize, int ListSize)
{
   ETG_TRACE_USR4(("Helper::vCalculateWindowSize startIndex= %d WindowSize =%d ", windowstart, windowsize));
   tU32 lastItemIndex_List = windowstart + windowsize - 1;
   if ((lastItemIndex_List == 0) || (lastItemIndex_List > ListSize))
   {
      ETG_TRACE_USR4(("Helper::vCalculateWindowSize lastItemIndex_List= %d", lastItemIndex_List));
      lastItemIndex_List = ListSize - 1;
   }
   ETG_TRACE_USR4(("Helper::lastItemIndex_List :%d", lastItemIndex_List));
   return lastItemIndex_List;
}


std::string AppHmiPhone_Helper::ConvertCallDuration(tU8 corfu8CallDurationHr, tU8 corfu8CallDurationMin, tU8 corfu8CallDurationSec)
{
   char acCallDuration[10];
   ETG_TRACE_USR4(("AppHmiPhone_Helper : covConvertCallDuration()"));
   ETG_TRACE_USR4(("Call Duration = %u:%u:%u",	corfu8CallDurationHr, corfu8CallDurationMin, corfu8CallDurationSec));
   if (0 == corfu8CallDurationHr)
   {
      sprintf(acCallDuration, "%02u:%02u", corfu8CallDurationMin, corfu8CallDurationSec);
   }
   else
   {
      sprintf(acCallDuration, "%02u:%02u:%02u", corfu8CallDurationHr, corfu8CallDurationMin, corfu8CallDurationSec);
   }
   ETG_TRACE_USR4(("Call Duration = %s", acCallDuration));
   std::string strCallDuration = acCallDuration;
   return strCallDuration;
}


}//Core
}//App
