/***************************************************************************
* Copyright(c) 2018-2018 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
#ifndef TELEDATATYPES_HEADER
#define TELEDATATYPES_HEADER

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/* Macros to be defined for including the needed OSAL files */
#define OSAL_S_IMPORT_INTERFACE_GENERIC

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include <vector> // For using vector data type
#include <list> // For using list data type
#include "BTPhoneDefines.h"
#include "MOST_Tel_FI.h"
#include "PhoneBookDataTypes.h"
#ifdef WINDOWS_SIMULATION
#include "tTypes.h"
#include <iostream>
#include <string>
#endif

/********************* Call Status ***************/
#define BTPHN_C_CALL_STATUS_ACTIVE "%1"//%1
#define BTPHN_C_CALL_STATUS_DIALING "Dialing"
#define BTPHN_C_DEVICE_IDLE "IDLE"
#define BTPHN_C_DEVICE_ONHOLD "%2"//%2
#define BTPHN_C_CALLER_ID_UNKNOWN "%1"//%1
#define BTPHN_C_CONTACT_TYPE_PHONE_GENRIC "AppHmi_PhoneModule#Images#Pfo_IncomingCall#Icon_PhoneType"
#define BTPHN_C_LIST_ICON_CELL "AppHmi_PhoneModule#Images#P_Call#Icon_Phonetype_Mobile"
#define BTPHN_C_LIST_ICON_HOME "AppHmi_PhoneModule#Images#P_Call#Icon_Phonetype_Private"
#define BTPHN_C_LIST_ICON_WORK "AppHmi_PhoneModule#Images#P_Call#Icon_PhoneType_Business"
#define BTPHN_C_LIST_ICON_OTHER "AppHmi_PhoneModule#Images#P_Call#Icon_Phonetype_Other"
#define BTPHN_C_LIST_ICON_GENERIC "AppHmi_PhoneModule#Images#P_Call#Icon_Phonetype"

#define BTPHN_C_FIRST_INCOMING "%1"//%1
#define BTPHN_C_SECOND_INCOMING "%2"//%2
#define BTPHN_C_ZERO_CALL_DURATION "0:00"
/********************* Call Types ***************/
#define BTPHN_C_CALL_MULTIPLE "%1"
#define BTPHN_C_CALL_CONFERENCE "%2"


#define BTPHN_C_CALL_INSTANCE_INVALID 255 // Value of invalid call instance
#define BTPHN_C_NUM_CALLS_SUPPORTED 2 // Number of calls supported at a time
#define BTPHN_C_CONTACT_NAME_MAX_SIZE 100 // Maximum size of contact name
#define BTPHN_C_PHONE_NUM_MAX_SIZE 25 // Maximum size of telephone number
#define BTPHB_C_SINGLE_CALL 1 // Only call is in progress
#define BTPHN_C_END_CALL_TIMER_DURATION 2000 // Duration in milliseconds

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/

#define BTPHN_C_DIAL_CALL_TIMER_DURATION 2000

/* Call instance indices */
#define BTPHN_C_FIRST_CALL_INDEX 0
#define BTPHN_C_SECOND_CALL_INDEX 1

/* Max length of network operator name*/
#define BTPHN_C_OPERATOR_NAME_LENGTH 20
typedef enum
{
   /* No Call Handset */
   BTPHN_EN_NO_CALL = 0UL,

   /* Active Call in Handset */
   BTPHN_EN_ACTIVE_CALL = 1UL,

   /* Hold Call in Handset */
   BTPHN_EN_HOLD_CALL = 2UL,

   /* Active and Hold Call in Handset */
   BTPHN_EN_ACTIVEANDHOLD_CALL = 4UL,

   /* Multyparty Call in Handset */
   BTPHN_EN_MULTIPARTY_CALL = 5UL
} btphn_tenPhoneCallHandsetState;

typedef enum
{
   /* Use MicrophoneUnMute */
   BTPHN_EN_MIC_UNMUTE = 0UL,

   /* MicrophoneMute */
   BTPHN_EN_MIC_MUTE = 1UL
} btphn_tenMicMuteSettings;

struct btphn_trCallStatus
{
   tBool bIsCallerIdUpdated;
   tBool bIsContactInfoReq;
   tBool bUsingVehicleAudio;
   std::string coarCallerId;
#ifdef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
   std::string strCallStatusExTelNo;
#endif
   tU8 u8CallDurationHr;
   tU8 u8CallDurationMin;
   tU8 u8CallDurationSec;
   tU16 u16CallInstance;
   btphn_tenPhoneCallStatus enCallStatus;
   btphn_tenPhoneType enPhoneType;

   btphn_trCallStatus()
      : bIsCallerIdUpdated(0),
        bIsContactInfoReq(0),
        bUsingVehicleAudio(0),
        coarCallerId(""),
#ifdef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
        strCallStatusExTelNo(""),
#endif
        u8CallDurationHr(0),
        u8CallDurationMin(0),
        u8CallDurationSec(0),
        u16CallInstance(0),
        enCallStatus(BTPHN_EN_IDLE),
        enPhoneType(BTPHN_EN_NO_TYPE)
   {}
};


struct btphn_voiceRecExtStatus
{
   tU8 u8DeviceHandle;
   most_Tel_fi_types_Extended::T_e8_TelSiriAvailabilityState enSiriAvailabilityState;
};


#endif
