/***************************************************************************
* Copyright(c) 2017-2020 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
* (c) Robert Bosch Car Multimedia GmbH
*
* Add details here
****************************************************************************/
#ifndef SERVICETEL_HEADER
#define SERVICETEL_HEADER

//Add include files here
#define GENERIC_FI_INTERFACE
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MOST_FI_S_IMPORT_INTERFACE_FI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_SERVICEINFO
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_ERRORCODES


#include "most_fi_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#include "midw_fi_if.h"
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "MOST_Tel_FI.h"
#include "MOST_Tel_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "BTPhoneDefines.h"
#include "CallHistoryModel.h"
#include "DeviceListModel.h"
#include "TeleDefines.h"
#include "PhoneCallModel.h"
#include "ServiceBT.h"
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
#include "IntercomModel.h"
#endif
using namespace ::App::Core;
using namespace ::MOST_Tel_FI;
using namespace ::most_Tel_fi_types;
using namespace ::most_Tel_fi_types_Extended;

//Forward Declarations
class DeviceListModel;
class CallHistoryModel;
class PhoneCallModel;

namespace App {
namespace Core {

class ServiceTel :
//public ListImplementation,
   public hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public MOST_Tel_FI::AcceptCallCallbackIF,
   public MOST_Tel_FI::CancelOutgoingCallCallbackIF,
   public MOST_Tel_FI::ConferenceInCallbackIF,
   public MOST_Tel_FI::HangUpCallCallbackIF,
   public MOST_Tel_FI::HoldCallCallbackIF,
   public MOST_Tel_FI::IgnoreCallCallbackIF,
   public MOST_Tel_FI::RejectCallCallbackIF,
   public MOST_Tel_FI::ResumeCallCallbackIF,
   public MOST_Tel_FI::SendDTMFCallbackIF,
   public MOST_Tel_FI::SpeedDialCallbackIF,
   public MOST_Tel_FI::SplitCallCallbackIF,
   public MOST_Tel_FI::SwapCallCallbackIF,
   public MOST_Tel_FI::TransferCallToHandsetCallbackIF,
   public MOST_Tel_FI::TransferCallToVehicleCallbackIF,
   public MOST_Tel_FI::ActiveCallinHandsetCallbackIF,
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
   public MOST_Tel_FI::CallStatusNoticeCallbackIF,
#endif
#ifdef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
   public MOST_Tel_FI::CallStatusNoticeExtendedCallbackIF,
#endif
   public MOST_Tel_FI::CellDeviceNameCallbackIF,
   public MOST_Tel_FI::CellNetworkStatusCallbackIF,
   public MOST_Tel_FI::CellSignalStrengthCallbackIF,
   public MOST_Tel_FI::CellStateofChargeCallbackIF,
   public MOST_Tel_FI::InComingCallEventCallbackIF,
   public MOST_Tel_FI::NetworkOperatorCallbackIF,
   public MOST_Tel_FI::SLCStatusCallbackIF,
   public MOST_Tel_FI::VehicleAudioCallbackIF,
   public MOST_Tel_FI::MicrophoneMuteStateCallbackIF,
   public MOST_Tel_FI::RingtoneMuteStateCallbackIF,
   public MOST_Tel_FI::HFServiceCallbackIF,
   public MOST_Tel_FI::BTDeviceVoiceRecognitionExtendedCallbackIF,
   public MOST_Tel_FI::HandsFreeEnhancedCallControlCallbackIF,
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
   public MOST_Tel_FI::QueryTelephoneNumberCallbackIF,
#endif
   public MOST_Tel_FI::DialCallbackIF,
   public MOST_Tel_FI::ActivePhoneDeviceCallbackIF,
   public MOST_Tel_FI::SetActivePhoneCallbackIF
#ifdef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
   , public MOST_Tel_FI::SetRingtoneCallbackIF,
   public MOST_Tel_FI::SystemWideRingtonesListCallbackIF,
   public MOST_Tel_FI::DeviceRingtoneListCallbackIF,
   public MOST_Tel_FI::CallOperationFailedEventCallbackIF,
   public MOST_Tel_FI::SendDTMFFailedEventCallbackIF,
   public MOST_Tel_FI::AudioTransferFailedEventCallbackIF
#endif
{
   private:
      ServiceTel();
      static ServiceTel* _poServiceTel;
   public:
      //ServiceTel(/*tclMostTelFiIf *pIfClass*/::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > _telephoneProxy);

      virtual ~ServiceTel();
      static ServiceTel* poGetInstance()
      {
         if (NULL == _poServiceTel)
         {
            _poServiceTel = new ServiceTel();
         }
         return _poServiceTel;
      }

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // ServiceAvailableIF implementation
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      /*Manual Code for CCA interface*/

      // class AcceptCallCallbackIF implementation
      virtual void onAcceptCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::AcceptCallError >& error);
      virtual void onAcceptCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::AcceptCallResult >& result);

      // class CancelOutgoingCallCallbackIF implementation
      virtual void onCancelOutgoingCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CancelOutgoingCallError >& error);
      virtual void onCancelOutgoingCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CancelOutgoingCallResult >& result);

      // class ConferenceInCallbackIF implementation
      virtual void onConferenceInError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::ConferenceInError >& error);
      virtual void onConferenceInResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::ConferenceInResult >& result);

      // class HangUpCallCallbackIF implementation
      virtual void onHangUpCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::HangUpCallError >& error);
      virtual void onHangUpCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::HangUpCallResult >& result);

      // class HoldCallCallbackIF implementation
      virtual void onHoldCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::HoldCallError >& error);
      virtual void onHoldCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::HoldCallResult >& result);

      // class IgnoreCallCallbackIF implementation
      virtual void onIgnoreCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::IgnoreCallError >& error);
      virtual void onIgnoreCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::IgnoreCallResult >& result);

      // class RejectCallCallbackIF implementation
      virtual void onRejectCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::RejectCallError >& error);
      virtual void onRejectCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::RejectCallResult >& result);

      // class ResumeCallCallbackIF implementation
      virtual void onResumeCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::ResumeCallError >& error);
      virtual void onResumeCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::ResumeCallResult >& result);

      // class SendDTMFCallbackIF implementation
      virtual void onSendDTMFError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SendDTMFError >& error);
      virtual void onSendDTMFResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SendDTMFResult >& result);

      // class SpeedDialCallbackIF implementation
      virtual void onSpeedDialError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SpeedDialError >& error);
      virtual void onSpeedDialResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SpeedDialResult >& result);

      // class SplitCallCallbackIF implementation
      virtual void onSplitCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SplitCallError >& error);
      virtual void onSplitCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SplitCallResult >& result);

      // class SwapCallCallbackIF implementation
      virtual void onSwapCallError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SwapCallError >& error);
      virtual void onSwapCallResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SwapCallResult >& result);

      // class DialCallCallbackIF implementation
      //virtual void onDialCallError(const :: boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI:: DialCallError >& error);
      //virtual void onDialCallResult(const :: boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI:: DialCallResult >& result);
      // virtual void onDialExtendedError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_Tel_FI::DialExtendedError >& error);
      //  virtual void onDialExtendedResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_Tel_FI::DialExtendedResult >& result);

      // class TransferCallToHandsetCallbackIF implementation
      virtual void onTransferCallToHandsetError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::TransferCallToHandsetError >& error);
      virtual void onTransferCallToHandsetResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::TransferCallToHandsetResult >& result);

      virtual void onTransferCallToVehicleError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< TransferCallToVehicleError >& error);
      virtual void onTransferCallToVehicleResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< TransferCallToVehicleResult >& result);

#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      virtual void onQueryTelephoneNumberError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::QueryTelephoneNumberError >& error);
      virtual void onQueryTelephoneNumberResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::QueryTelephoneNumberResult >& result);
#endif

      // class ActiveCallinHandsetCallbackIF implementation
      virtual void onActiveCallinHandsetError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::ActiveCallinHandsetError >& error);
      virtual void onActiveCallinHandsetStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::ActiveCallinHandsetStatus >& status);

      // class CallStatusNoticeCallbackIF implementation
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      virtual void onCallStatusNoticeError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CallStatusNoticeError >& error);
      virtual void onCallStatusNoticeStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CallStatusNoticeStatus >& status);
#endif

      // class CallStatusNoticeExtendedCallbackIF implementation
#ifdef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      virtual void onCallStatusNoticeExtendedError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CallStatusNoticeExtendedError >& error);
      virtual void onCallStatusNoticeExtendedStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CallStatusNoticeExtendedStatus >& status);
#endif

      // class CellDeviceNameCallbackIF implementation
      virtual void onCellDeviceNameError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellDeviceNameError >& error);
      virtual void onCellDeviceNameStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellDeviceNameStatus >& status);

      // class CellNetworkStatusCallbackIF implementation
      virtual void onCellNetworkStatusError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellNetworkStatusError >& error);
      virtual void onCellNetworkStatusStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellNetworkStatusStatus >& status);

      // class CellSignalStrengthCallbackIF implementation
      virtual void onCellSignalStrengthError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellSignalStrengthError >& error);
      virtual void onCellSignalStrengthStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellSignalStrengthStatus >& status);

      // class CellStateofChargeCallbackIF implementation
      virtual void onCellStateofChargeError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellStateofChargeError >& error);
      virtual void onCellStateofChargeStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellStateofChargeStatus >& status);

      // class InComingCallEventCallbackIF implementation
      virtual void onInComingCallEventError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::InComingCallEventError >& error);
      virtual void onInComingCallEventStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::InComingCallEventStatus >& status);

      // class NetworkOperatorCallbackIF implementation
      virtual void onNetworkOperatorError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::NetworkOperatorError >& error);
      virtual void onNetworkOperatorStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::NetworkOperatorStatus >& status);

      // class SLCStatusCallbackIF implementation
      virtual void onSLCStatusError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SLCStatusError >& error);
      virtual void onSLCStatusStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::SLCStatusStatus >& status);

      // class VehicleAudioCallbackIF implementation
      virtual void onVehicleAudioError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::VehicleAudioError >& error);
      virtual void onVehicleAudioStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::VehicleAudioStatus >& status);

      // class MicrophoneMuteStateCallbackIF implementation
      virtual void onMicrophoneMuteStateError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::MicrophoneMuteStateError >& error);
      virtual void onMicrophoneMuteStateStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::MicrophoneMuteStateStatus >& status);

      // class RingtoneMuteStateCallbackIF implementation
      virtual void onRingtoneMuteStateError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::RingtoneMuteStateError >& error);
      virtual void onRingtoneMuteStateStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::RingtoneMuteStateStatus >& status);

      // class HFServiceCallbackIF implementation
      virtual void onHFServiceError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::HFServiceError >& error);
      virtual void onHFServiceStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::HFServiceStatus >& status);

      // class BTDeviceVoiceRecognitionCallbackIF implementation
      virtual void onBTDeviceVoiceRecognitionExtendedError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::BTDeviceVoiceRecognitionExtendedError >& error);
      virtual void onBTDeviceVoiceRecognitionExtendedStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::BTDeviceVoiceRecognitionExtendedStatus >& status);

      // class HandsFreeEnhancedCallControlCallbackIF implementation
      virtual void onHandsFreeEnhancedCallControlError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::HandsFreeEnhancedCallControlError >& error);
      virtual void onHandsFreeEnhancedCallControlStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::HandsFreeEnhancedCallControlStatus >& status);
      virtual void onDialError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_Tel_FI::DialError >& error);
      virtual void onDialResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_Tel_FI::DialResult >& result);

      virtual void onActivePhoneDeviceError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ActivePhoneDeviceError >& error);
      virtual void onActivePhoneDeviceStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ActivePhoneDeviceStatus >& status);
      virtual void onSetActivePhoneError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SetActivePhoneError >& error);
      virtual void onSetActivePhoneResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SetActivePhoneResult >& result);

#ifdef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      virtual void onSetRingtoneError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SetRingtoneError >& error);
      virtual void onSetRingtoneResult(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SetRingtoneResult >& result);
      virtual void onSystemWideRingtonesListError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SystemWideRingtonesListError >& error);
      virtual void onSystemWideRingtonesListStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SystemWideRingtonesListStatus >& status);
      virtual void onDeviceRingtoneListError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DeviceRingtoneListError >& error);
      virtual void onDeviceRingtoneListStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< DeviceRingtoneListStatus >& status);
      virtual void onCallOperationFailedEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CallOperationFailedEventError >& error);
      virtual void onCallOperationFailedEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< CallOperationFailedEventStatus >& status);
      virtual void onSendDTMFFailedEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SendDTMFFailedEventError >& error);
      virtual void onSendDTMFFailedEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< SendDTMFFailedEventStatus >& status);
      virtual void onAudioTransferFailedEventError(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AudioTransferFailedEventError >& error);
      virtual void onAudioTransferFailedEventStatus(const ::boost::shared_ptr< MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< AudioTransferFailedEventStatus >& status);
#endif

      void HandleCallState(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CallStatusNoticeStatus >& status);
      void covConvertCallDuration(uint8 corfu8CallDurationHr, uint8 corfu8CallDurationMin, uint8 corfu8CallDurationSec, char acCallDuration[]);
      //btphn_trCallStatus arCallStatusInfo[BTPHN_C_NUM_CALLS_SUPPORTED];

      tVoid vSendDialCallMethodStart(std::string strTelephoneNo, btphn_tenECNRSettings enECNRStatus);
      /*call Req flag flag reset*/
      tVoid vResetCallFlag()
      {
         bCallReqFlag = FALSE;
      }
      //Method to Send Phone Service Error COurier Message to GUI
      tVoid vSendServiceError(const btphn_tenPhnServiceType& corfrServiceType, const btphn_tenServiceErrCode& corfrErrCode);

      tVoid vHandleDialError();

      //Method to trigger Method Start to Accept Incoming Call
      tVoid vAcceptCallStart(tU16 u16CallInstance);

      //Method to trigger Method Start to Ignore Incoming Call
      tVoid vIgnoreCallStart(tU16 u16CallInstance);

      static tVoid vOnDialCallTimerExpiry(tPVoid pvObject); // Callback function
      static tVoid vOnEndCallTimerExpiry(tPVoid pvObject); // Callback function
      tVoid vStopDialCallTimer();
      tVoid vStartDialCallTimer();
      tBool bGetDialTimer()
      {
         return bIsDialCallTimerRunning;
      }

      tVoid vUpdateCallStatus(const std::vector<btphn_trCallStatus>& corfarNewCallStatus);
      tBool bIsCallStatusUpdateRequired(const btphn_tenPhoneCallStatus& corfenFirstCallStatus, const	btphn_tenPhoneCallStatus& corfenSecondCallStatus);

      tVoid vHandleDeviceHandleResp(tU8 u8ConnectedDeviceHandle);
      tBool vCheckCallStatus();
      btphn_tenPhoneCallStatus CallStatusEnumMapper(most_Tel_fi_types::T_e8_TelCallStatus callStatus);

      tVoid vUpdateContactInfo(tU32 u32ContactHandle, std::string SFirstName, std::string SLastName, btphn_tenContactDetailType enContactDetailType);
      tVoid vUpdateContactInfo(std::string copcContactName, const btphn_tenPhoneType& corfenPhoneType);
      tVoid vSendDTMFStart(std::string strKeyPressed);

      tVoid vSet_BTVoiceRecognition(tBool bBTActiveReq);
      tVoid vEnableBTVRView();
      tVoid vDisableBTVRView();
      tVoid vSwitchToBTVRView();
      tVoid vDisableBTVRPopUpOnHomeButton();
      tVoid vStartBTVRSessionViaPTT();
      tVoid vSendCallStatusToBTVR(const std::vector<btphn_trCallStatus>& arCallList);
      //Method to trigger Method Start to Set Ringtone
#ifdef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      tVoid vSetRingtone(tU8 u8RingToneID);
#endif
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      void vUpdActivePhone();
#endif
   private:

      //Flag used t check if Call req is already sent to Service and waiting for ack.
      tBool bCallReqFlag;

      //Store IncomingCallInstace for later use when there is an accept or reject request from GUI
      tU8 u8IncomingCallInstance;
      tU8 u8CurrentCallInstance; // Call instance of currently active call
      tU8 u8PreviousCallInstance; //  To store Call instance of previous active call on incoming call in passive device
      tU8 u8CurrentActiveCallInstance_dtmf; // Call instance of currently active call when call status is ACTIVE
      DeviceListModel& rfoDeviceListModel;
      PhoneCallModel& rfoPhoneCallModel;
      // Set to TRUE if dial timer is running
      tBool bIsDialCallTimerRunning;
      tBool bIsEndCallTimerRunning;
      tU32 u32EndCallTimerDuration;

      OSAL_tTimerHandle hDialCallTimer; // Dial call timer
      OSAL_tTimerHandle hEndCallTimer; // End call timer

      /* Maintains status information about the active calls */
      btphn_trCallStatus arCallStatusInfo[BTPHN_C_NUM_CALLS_SUPPORTED];
      /* Maintains status information about the SiriAvailability state */
      btphn_voiceRecExtStatus BtvrExtendedStatus[MAX_HFP_CONNECTION];

      tU8 u8NumSwapRequests; // Count of swap requests handled
      tBool bIsConference; // Set to TRUE for a conference
      tBool bIsCallRejected; // Set to TRUE if incoming call is rejected
      tBool bMicrophoneState; // Stores the microphone status
      tU8 u8NumActiveCalls; // Maintains the number of active calls

      tU8 u8ChargeStatus;
      tU8 u8NetworkStrength;
      std::string strDeviceNameCurrent;
      /* Text displayed for unknown contact names or private numbers */
      std::string copcUnknownText;

      std::string m_strDeviceName;
      std::string m_strlongDataCallNum;
      // to store bt vr Session active/ inactive state
      tU8 m_u8BTVRSessionActive;

      tU8 m_u8ActiveDev;
      tU8 m_index;
      tU8 m_u8PassiveDevHandle; // To store passive dev handle on incoming call in passive device
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      tBool m_bMissedBTCall;
#endif

      tBool m_bBTVoiceActive;
      tBool m_bBTRecSupported;
      tU8 m_nActiveCall;
      ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > _most_tel_fi;
      void printIncomingCallEventStatus(const boost::shared_ptr< InComingCallEventStatus >& status);
      CallHistoryModel& rfoCallHistoryModel;

      //MCP Handling : flag created to identify is there any incoming call popup in PhoneHall
      bool bIsIncomingCallPopupActive;

      // Currently this is implemented in as a scene - CallConnecting
      // MCP Handling : flag created to identify is there any outgoing call popup in PhoneHall
      bool bIsOutgoingCallPopupActive;

      // MCP Handling : flag created to identify is there any active ongoing call popup in PhoneHall
      bool bIsOngoingCallActive;

      //flag created to identify the idle call status
      bool bIsIdlestatus;

      //Accept call requested when VR ends
      bool bIsAcceptCallRequestedWhenVREnds;

      bool _isCabinOnly;

      tVoid vProcessCallStatus();
#ifdef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      tVoid vProcessAndUpdateTelephoneNumber(std::string strTelphoneno, tU16 u16CallInstance);
#endif

      tVoid vSendMultipleCallStatus(const btphn_trCallStatus coarCallStatus[]);

      tVoid vSendCallStatus(const btphn_trCallStatus& corfrCallStatus);

      void vProcessCallMICStatus();

      //Incoming Courier Message Handled by ServiceTel
      virtual bool onCourierMessage(const IncomingCallResponseReq& oMsg);
      virtual bool onCourierMessage(const TransferVehicleAudioReq& oMsg);
      virtual bool onCourierMessage(const MicMuteStateReq& oMsg);
      virtual bool onCourierMessage(const TerminateCallReq& oMsg);
      virtual bool onCourierMessage(const CancelDialCallReq& oMsg);
      virtual bool onCourierMessage(const SwapMultipleCallReq& oMsg);
      virtual bool onCourierMessage(const NetworkOperatorReq& oMsg);
      virtual bool onCourierMessage(const BTVROnExitMsg& oMsg);
      virtual bool onCourierMessage(const BTVRSessionExitAppReqMsg& oMsg);
      virtual bool onCourierMessage(const BTVRSessionStartAppReqMsg& oMsg);
      virtual bool onCourierMessage(const BTVRSessionStopAppReqMsg& oMsg);
      virtual bool onCourierMessage(const TransferVehicleAudioReqFromCAN& oMsg); //(SWFL-8200)
      virtual bool onCourierMessage(const MicMuteStateReqFromCAN& oMsg); //(SWFL-8200)
      DECLARE_CLASS_LOGGER();

   public:
      inline tU8 u8GetActiveDev()
      {
         return m_u8ActiveDev;
      }
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      void OnUpdMissedIntercomCall();
#endif
      void vSetActivePhone(tU8 u8ActiveDev, std::string strDeviceName);
      bool bIsMultipleCallActive();

      //CRQ 1053847 Currently Disabled
      bool bGetActiveSmartVRDevice();
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(IncomingCallResponseReq)
      ON_COURIER_MESSAGE(TransferVehicleAudioReq)
      ON_COURIER_MESSAGE(MicMuteStateReq)
      ON_COURIER_MESSAGE(TerminateCallReq)
      ON_COURIER_MESSAGE(CancelDialCallReq)
      ON_COURIER_MESSAGE(SwapMultipleCallReq)
      ON_COURIER_MESSAGE(NetworkOperatorReq)
      ON_COURIER_MESSAGE(BTVROnExitMsg)
      ON_COURIER_MESSAGE(BTVRSessionExitAppReqMsg)
      ON_COURIER_MESSAGE(BTVRSessionStartAppReqMsg)
      ON_COURIER_MESSAGE(BTVRSessionStopAppReqMsg)
      ON_COURIER_MESSAGE(TransferVehicleAudioReqFromCAN) //(SWFL-8200)
      ON_COURIER_MESSAGE(MicMuteStateReqFromCAN) //(SWFL-8200)
      COURIER_MSG_MAP_END()

      // Method to retrive the incoming call Status
      bool getIncomingCallStatus()
      {
         return bIsIncomingCallPopupActive;
      }
      //Method to retrive the incoming call instance
      int getIncomingCallInstance()
      {
         return u8IncomingCallInstance;
      }

      // Method to retrive the outgoing call Status
      bool getCallDialingStatus()
      {
         return bIsOutgoingCallPopupActive;
      }

      // Method to retrive the on going call Status
      bool getOngoingCallStatus()
      {
         return bIsOngoingCallActive;
      }
      std::string getDevicenameStatus()
      {
         return strDeviceNameCurrent;
      }
      bool getMicrophoneMuteStatus()
      {
         return bMicrophoneState;
      }
      bool getBTVRStatus()
      {
         return bBTVRViewShown;
      }
      bool getIdleCallStatus()
      {
         return bIsIdlestatus;
      }
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      bool getMissedBTCallStatus()
      {
         return m_bMissedBTCall;
      }
      void setMissedBTCallStatus(bool bMissedBTCall)
      {
         m_bMissedBTCall = bMissedBTCall;
      }
#endif
};


}
}


#endif
