/* ***************************************************************************************
* FILE:          PhoneGui.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PhoneGui.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "PhoneGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "Trace/GuiInfo.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"
#include "ProjectBaseTypes.h"

//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_PHONE_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_PHONE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_PHONE_"
#define ETG_I_FILE_PREFIX                 App::Core::PhoneGui::
#include "trcGenProj/Header/PhoneGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////

//                                   main surface,                                      video surface,                    popup surfaces
//DEFAULT_APPSETTINGS(/*static_cast<int>*/(SURFACEID_MAIN_SURFACE_PHONE), /*static_cast<int>*/(SURFACEID_NONE), /*static_cast<int>*/(SURFACEID_TOP_POPUP_SURFACE_PHONE), /*static_cast<int>*/(SURFACEID_CENTER_POPUP_SURFACE_PHONE))
APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_PHONE),
//                            APPSETTINGS_ADD_MAINSURFACE(UD_SURFACEID_MAIN_SURFACE_NAVIGATION),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_PHONE),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_PHONE)
//                            APPSETTINGS_ADD_POPUPSURFACE(UD_SURFACEID_TOP_POPUP_SURFACE_NAVIGATION),
//                            APPSETTINGS_ADD_POPUPSURFACE(UD_SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION)
                            APPSETTINGS_END()
                            using namespace ::hmi;

namespace App {
namespace Core {


PhoneGui::PhoneGui() : GuiComponentBase(hmi::apps::reference::appHmi_Phone, appSettings)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_PHONE_APPCTRL_PROXY);
   SYNC_BLOCK_CONNECTION(765, PHONE_GADGET);
   SYNC_BLOCK_CONNECTION(765, PHONE_GADGET_NON_NAVI);
   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_PHONE, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_PHONE, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_PHONE, DisplayID_D1);
}


PhoneGui::~PhoneGui()
{
}


unsigned int PhoneGui::getDefaultTraceClass()
{
   return TR_CLASS_APPHMI_PHONE_MAIN;
}


void PhoneGui::setupCgiInstance()
{
   ETG_TRACE_FATAL(("PhoneGUI : setupCgiInstance()"));
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   //std::string assetFileName = SystemConfiguration::getAssetFileName();
   ETG_TRACE_FATAL(("PhoneGUI : setupCgiInstance() asset %s\n", assetFileName.c_str()));
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


void PhoneGui::preRun()
{
//   DP_vCreateDatapool();
   PersistentValuesRead();
}


void PhoneGui::postRun()
{
   PersistentValuesWrite();
}


void PhoneGui::PersistentValuesRead()
{
//   dp_tclhmiAppPhonePersMemVarsPhone dp;
//   _mvar = dp.tGetData();
}


void PhoneGui::PersistentValuesWrite()
{
//   dp_tclhmiAppPhonePersMemVarsPhone dp;
//   dp.s32SetData(_mvar);
}


/**
 *sink for not processed ttfis input messages
 */
void PhoneGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_FATAL(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
