/***************************************************************************
* Copyright(c) 2017-2020 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
 ****************************************************************************/
#include "hall_std_if.h"
#include "ServicePhonebook.h"
#include "AppHmi_PhoneTypes.h"
#include "BTPhoneDefines.h"
#include "../ClockSrvClient/ClockSrvClient.h"
#include "../Core/VehicleSrvClient/VehicleSrvClient.h"
#include "Common/VariantHandling/VariantHandling.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_PHONE_HALL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_FILE_PREFIX            App::Core::ServicePhoneBook::
#include "trcGenProj/Header/ServicePhoneBook.cpp.trc.h"
#endif


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
namespace App {
namespace Core {
ServicePhoneBook* ServicePhoneBook::_mPBKHelper = NULL;
static const Courier::ViewId		IdScene_CalllistLoading = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading");
static const Courier::Identifier	IdRotation_CalllistLoading = Courier::Identifier("AnimationWidget2DCallist");
static const Courier::ViewId		IdScene_phonebookloading = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading");
static const Courier::Identifier	IdRotation_phonebookloading = Courier::Identifier("AnimationWidget2DPhonebook");
static const tU16 LISTHANDLE_OFFSET = 16;

ServicePhoneBook::ServicePhoneBook() :
   rfoCallHistoryModel(*CallHistoryModel::poGetInstance()),
   rfoSpellerModel(*SpellerModel::poGetInstance()),
   rfoPhonebookModelComponent(*PhonebookModelComponent::poGetInstance()),
   _most_phonbk_fi(::MOST_PhonBk_FI::MOST_PhonBk_FIProxy::createProxy("btPhonBkFiPort", *this)),
   bCallListSupportStatus(false),
   mContacthandle(0),
   m_StartIndex_CallList(0),
   m_WindowSize_CallList(BTPHN_C_PHNBKLIST_WINDOW_SIZE),
   m_lastItemIndex_CallList(0),
   m_PBStartIndex(0),
   m_PBWindowSize(BTPHN_C_PHNBKLIST_WINDOW_SIZE),
   m_lastItemIndex_PBList(0),
   enPhnBkDownloadState(most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_NOT_STARTED),
   bContactInfoRequired(FALSE),
   enCallListDownloadState(most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_NOT_STARTED),
   strEditInfo(""),
   strTelephoneNumber(""),
   bLoadPersistent(false),
   bReqCallListDialInfo(FALSE),
   enCurrSortOrder(most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder__e8PREFERRED_SORT_ORDER_FIRSTNAME),
   enSortType(most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType__e8PB_LIST_SORT_FIRSTNAME),
   u32NumOfMissedCall(0),
   m_U8ViewPortStartIndex(0),
   bPhonebookContactSupport(0),
   bCurrentActiveTab(0),//Bug 711626
   KeyPressed(""),
   activeDevIndex(0),
   m_u16PBcurrentlisthandle(0)
{
   // Initialize _isCabinOnly based on the VariantType
   if (VariantHandling::getInstance() != NULL)
   {
      _isCabinOnly = (VariantHandling::getInstance()->getVariantType() == VARIANTTYPE_CC);
   }
   else
   {
      _isCabinOnly = false; // Default to false if VariantHandling is not available
   }

   //StartupSync::getInstance().registerPropertyRegistrationIF(this, "btPhonBkFiPort");
   //_applicationSwitchClientComponent = ApplicationSwitchClientComponent::poGetInstance();
   if (_most_phonbk_fi.get())
   {
      ETG_TRACE_USR4(("ServicePhoneBook _most_phonbk_fi.get is TRUE"));
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _most_phonbk_fi->getPortName());
   }

   arMatchList.clear();
   for (int i = 0; i < (BTPHN_C_CONTACT_DETAILS_MAX_NUMBER + 1); i++)
   {
      acopcContactNumbers[i] = "";
   }
}


ServicePhoneBook::~ServicePhoneBook()
{
   vDeleteAllLists();
}


void ServicePhoneBook::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4(("ServicePhoneBook registerProperties"));
}


void ServicePhoneBook::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4(("ServicePhoneBook deregisterProperties"));
}


void ServicePhoneBook::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("ServicePhoneBook onAvailable"));
   if (!_isCabinOnly)
   {
      if (proxy == _most_phonbk_fi && _most_phonbk_fi.get())
      {
         ETG_TRACE_USR4(("ServicePhoneBook registerProperties(_most_phonbk_fi)"));
         //_most_phonbk_fi->sendDevicePhoneBookFeatureSupportUpReg(*this);
         _most_phonbk_fi->sendDevicePhoneBookFeatureSupportExtendedUpReg(*this);
         _most_phonbk_fi->sendListChangeUpReg(*this);
         _most_phonbk_fi->sendDownloadStateExtendedUpReg(*this);
         _most_phonbk_fi->sendPreferredPhoneBookSortOrderUpReg(*this);
         _most_phonbk_fi->sendMissedCallIndicatorUpReg(*this);
      }
      else
      {
         if (proxy != _most_phonbk_fi)
         {
            ETG_TRACE_USR4(("ServicePhoneBook registerProperties(_most_phonbk_fi != proxy)"));
         }
      }
   }
}


void ServicePhoneBook::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("ServicePhoneBook onUnavailable"));

   if (!_isCabinOnly)
   {
      if (proxy == _most_phonbk_fi)
      {
         ETG_TRACE_USR4(("ServicePhoneBook deregisterProperties(_most_phonbk_fi)"));
         //  _most_phonbk_fi->sendDevicePhoneBookFeatureSupportRelUpRegAll();
         _most_phonbk_fi->sendDevicePhoneBookFeatureSupportExtendedRelUpRegAll();
         _most_phonbk_fi->sendListChangeRelUpRegAll();
         _most_phonbk_fi->sendDownloadStateExtendedRelUpRegAll();
         _most_phonbk_fi->sendPreferredPhoneBookSortOrderRelUpRegAll();
         _most_phonbk_fi->sendMissedCallIndicatorRelUpRegAll();
      }
   }
}


/**
* This function returns pointer to ServicePhonebook object
* @param[in] - none
*
* @param[out]- ServicePhoneBook*
*/
ServicePhoneBook* ServicePhoneBook::poGetInstance()
{
   if (NULL == _mPBKHelper)
   {
      _mPBKHelper = new ServicePhoneBook();
   }

   return _mPBKHelper;
}


/**
	 * This function gives the phone book features that are supported for connected device
	 * @param[in] - proxy  - shared pointer for client side representation of a service,
	 * @param[in] - status - gives the features that are supported
	 *                       Features that are supported/not supported : Phonebook support, Combined Call history list support, Incoming call history
	 *                       list support, outgoing call history list support , missed call history list support
	 * @param[out]- returns void
	* System Requirements : SWFL-302
	* System Requirements : (SWFL - 706, SWFL - 1944),SWFL-706
	initial rev:Shwetha K, Vidya,Bhagya
*/
void ServicePhoneBook::onDevicePhoneBookFeatureSupportExtendedStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< DevicePhoneBookFeatureSupportExtendedStatus >& status)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onDevicePhoneBookFeatureSupportExtendedStatus"));

   uint16 u16SupportedListSize = status->getODevicePhoneBookFeatureSupportList().size();

   ETG_TRACE_USR4(("ServiceBook::onDevicePhoneBookFeatureSupportExtendedStatus = %d", u16SupportedListSize));

   if (u16SupportedListSize == 0) //size is unsigned int
   {
      return;
   }

   for (uint16 i = 0 ; i < u16SupportedListSize; i++)
   {
      tU8 devicehandle = status->getODevicePhoneBookFeatureSupportList().at(i).getU8DeviceHandle();
      ETG_TRACE_USR4(("ServicePhoneBook::onDevicePhoneBookFeatureSupportExtendedStatus CCHListSupport : %d, PBListSupport : %d, ICHlistSupport : %d, MCHListSupport : %d, OCHListSupport : %d, DeviceHandle : %d",
                      status->getODevicePhoneBookFeatureSupportList().at(i).getBCCHListSupport(),
                      status->getODevicePhoneBookFeatureSupportList().at(i).getBPhoneBookSupport(),
                      status->getODevicePhoneBookFeatureSupportList().at(i).getBICHListSupport(),
                      status->getODevicePhoneBookFeatureSupportList().at(i).getBMCHListSupport(),
                      status->getODevicePhoneBookFeatureSupportList().at(i).getBOCHListSupport(),
                      devicehandle));
      if ((devicehandle == 0))
      {
         ETG_TRACE_USR4(("ServiceBook::onDevicePhoneBookFeatureSupportExtendedSte device handle DeviceHandle is  equal to zero"));
         continue;
      }

      else
      {
         ETG_TRACE_USR4(("ServiceBook::onDevicePhoneBookFeatureSupportExtendedSte device handle DeviceHandle is not equal to zero"));
         bPhonebookContactSupport = status->getODevicePhoneBookFeatureSupportList().at(i).getBPhoneBookSupport();
         tU8 Pbsupportstatus = status->getODevicePhoneBookFeatureSupportList().at(i).getBPhoneBookSupport();
         m_phonebookSupportStatus.insert(std::pair<tU8, tU8>(devicehandle, Pbsupportstatus));

         if (devicehandle == ServiceTel::poGetInstance()->u8GetActiveDev())
         {
            ETG_TRACE_USR4(("ServiceBook::onDevicePhoneBookFeatureSupportExtendedSte device handle DeviceHandle : %d", status->getODevicePhoneBookFeatureSupportList().at(i).getU8DeviceHandle()));
            rListSupport.bContactSupport = status->getODevicePhoneBookFeatureSupportList().at(i).getBPhoneBookSupport();

            tU8 u8Index = BTPHN_C_DEFAULT_VALUE_ZERO;

            rListSupport.bCallListSupport[u8Index] = status->getODevicePhoneBookFeatureSupportList().at(i).getBCCHListSupport();
            u8Index++;
            /*list support status for Incoming call list*/
            rListSupport.bCallListSupport[u8Index] = status->getODevicePhoneBookFeatureSupportList().at(i).getBICHListSupport();

            u8Index++;
            /*list support status for Outgoing call list*/
            rListSupport.bCallListSupport[u8Index] = status->getODevicePhoneBookFeatureSupportList().at(i).getBOCHListSupport();

            u8Index++;
            /*list support status for Missed call list*/
            rListSupport.bCallListSupport[u8Index] = status->getODevicePhoneBookFeatureSupportList().at(i).getBMCHListSupport();

            /* Sends the support status of PhoneBook lists */
            vUpdateListSupportStatus(devicehandle, rListSupport);
         }
      }
   }
}


void ServicePhoneBook::onDevicePhoneBookFeatureSupportExtendedError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::DevicePhoneBookFeatureSupportExtendedError >& /*error*/)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onDevicePhoneBookFeatureSupportExtendedError"));
}


/**
	 * This function gives the phone book features that are supported for connected device
	 * @param[in] - proxy  - shared pointer for client side representation of a service,
	 * @param[in] - status - gives the features that are supported
	 *                       Features that are supported/not supported : Phonebook support, Combined Call history list support, Incoming call history
	 *                       list support, outgoing call history list support , missed call history list support
	 * @param[out]- returns void
	* System Requirements : SWFL-302
	* System Requirements : (SWFL - 706, SWFL - 1944),SWFL-706
	initial rev:Shwetha K, Vidya
*/
//Void ServicePhoneBook::onDevicePhoneBookFeatureSupportStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< DevicePhoneBookFeatureSupportStatus >& status)
//{
/* ETG_TRACE_USR4(("ServicePhoneBook::onDevicePhoneBookFeatureSupportStatus CCHListSupport : %d, PBListSupport : %d, ICHlistSupport : %d, MCHListSupport : %d, OCHListSupport : %d, DeviceHandle : %d",
                  status->getBCCHListSupport(),
                  status->getBPhoneBookSupport(),
                  status->getBICHListSupport(),
                  status->getBMCHListSupport(),
                  status->getBOCHListSupport(),
                  status->getU8DeviceHandle()));*/
/*if (status->getU8DeviceHandle() == 0)
{
   return;
}*/
/* Populate the structure with the support status for the different
lists */
/* rListSupport.bContactSupport = status->getBPhoneBookSupport();
 //Bug 680928
 bPhonebookContactSupport = status->getBPhoneBookSupport();
 tU8 Pbsupportstatus = status->getBPhoneBookSupport();
 tU8 devicehandle = status->getU8DeviceHandle();
 m_phonebookSupportStatus.insert(std::pair<tU8, tU8>(devicehandle, Pbsupportstatus));

 tU8 u8Index = BTPHN_C_DEFAULT_VALUE_ZERO;*/
/*list support status for Combined call list*/
// rListSupport.bCallListSupport[u8Index] = status->getBCCHListSupport();
//u8Index++;
/*list support status for Incoming call list*/
// rListSupport.bCallListSupport[u8Index] = status->getBICHListSupport();
// u8Index++;
/*list support status for Outgoing call list*/
// rListSupport.bCallListSupport[u8Index] = status->getBOCHListSupport();
//  u8Index++;
/*list support status for Missed call list*/
// rListSupport.bCallListSupport[u8Index] = status->getBMCHListSupport();
//  if ((status->getU8DeviceHandle() != 0))
//  {
/* Sends the support status of PhoneBook lists */
//  vUpdateListSupportStatus(status->getU8DeviceHandle(), rListSupport);
// }
//}


//void ServicePhoneBook::onDevicePhoneBookFeatureSupportError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::DevicePhoneBookFeatureSupportError >& /*error*/)
//{
//}


void ServicePhoneBook::onCreatePhoneBookListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::CreatePhoneBookListError >& /*error*/)
{
}


/**
* Whenever we want a Phonebook list to be created, Phonebook create calllist method start with type of the list to be created.
* This function Handles response from PhoneBook service which provides the list handle of the newly created Phonebook list.
* Stores list handle and list size of newly created Phonebook list
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - result - gives the Phonebook list handle and list total size
*
* @param[out]- returns void
* System Requirements : (SWFL - 706, SWFL - 1944)
initial rev:Vidya
*/
void ServicePhoneBook::onCreatePhoneBookListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::CreatePhoneBookListResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onCreatePhoneBookListResult list handle :%d", result->getU16ListHandle()));
   if (result->getU16ListHandle() == 0)
   {
      return;
   }
   /*stores the list handle and list length of the phonebook for displaying the phonebook list*/
   rContactListData.u16ListHandle = result->getU16ListHandle();
   rContactListData.u16TotalListSize = result->getU16ListLength();
   ETG_TRACE_USR4(("ServicePhoneBook::onCreatePhoneBookListResult : rContactListData.u16ListHandle = %d", rContactListData.u16ListHandle));
   ETG_TRACE_USR4(("ServicePhoneBook::onCreatePhoneBookListResult : rContactListData.u16TotalListSize = %d", rContactListData.u16TotalListSize));
}


/**
* This function  Handles property update from PhoneBook service when the call history or phone book list is updated.
* It updates the new calllist size and requests for new set of call history list data
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - status - gives changes in list(phone book/call history) when item is added/removed or changed
*
* @param[out]- returns void
initial rev:Shwetha K, Vidya
*/
void ServicePhoneBook::onListChangeStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ListChangeStatus >& status)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onListChangeStatus"));
   /*if call list handle matches the already created list handle then set total list size*/
   if ((status->getE8ListType() == T_e8_PhonBkListType__e8CALLHISTORY_LIST) &&
         (status->getU16ListHandle() == rCallListData.u16ListHandle))
   {
      rCallListData.u16TotalListSize = status->getU16ListLength();
      ETG_TRACE_USR4(("ServicePhoneBook::onListChangeStatus : rCallListData.u16ListHandle = %d", rCallListData.u16ListHandle));
      ETG_TRACE_USR4(("ServicePhoneBook::onListChangeStatus : rCallListData.u16TotalListSize = %d", rCallListData.u16TotalListSize));
      /* Requests to fetch and populate call list data*/
      vRequestCallListData();
   }

   if ((status->getE8ListType() == T_e8_PhonBkListType__e8PHONEBOOK_LIST) &&
         (status->getU16ListHandle() == rContactListData.u16ListHandle))
   {
      rContactListData.u16TotalListSize = status->getU16ListLength();
      rContactListData.u16ListHandle = status->getU16ListHandle();
      ETG_TRACE_USR4(("ServicePhoneBook::onListChangeStatus : rContactListData.u16ListHandle = %d", rContactListData.u16ListHandle));
      ETG_TRACE_USR4(("ServicePhoneBook::onListChangeStatus : rContactListData.u16TotalListSize = %d", rContactListData.u16TotalListSize));
      /* Requests to fetch and populate contact list data*/
      //vUpdateContactListData();//will be used in future

      m_u16PBcurrentlisthandle =  ServiceTel::poGetInstance()->u8GetActiveDev() * LISTHANDLE_OFFSET + enSortType;//Bug 880046
      ETG_TRACE_USR4(("ServicePhoneBook::onListChangeStatus : m_u16PBcurrentlisthandle = %d", m_u16PBcurrentlisthandle));
      if (m_u16PBcurrentlisthandle == rContactListData.u16ListHandle)
      {
         ETG_TRACE_USR4(("ServicePhoneBook::onListChangeStatus : vRequestContactListData called"));
         vRequestContactListData();
      }
      else
      {
         ETG_TRACE_USR4(("ServicePhoneBook::onListChangeStatus - currentlisthandle is not equal to  ContactListhandle"));
      }
   }
}


void ServicePhoneBook::onListChangeError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::ListChangeError >& /*error*/)
{
}


/**
* his function  Handles property update from PhoneBook service when there us change in number of miss calls for the connected device.
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - status - gives status of nubmber of missed calls for the connected device
*
* @param[out]- returns void
initial rev:Shwetha K
*/
void ServicePhoneBook::onMissedCallIndicatorStatus(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< MissedCallIndicatorStatus >& status)
{
   ETG_TRACE_USR2(("ServicePhoneBook::onMissedCallIndicatorStatus : %d", status->getU32NumMissedCalls()));
   u32NumOfMissedCall = status->getU32NumMissedCalls();
   rfoCallHistoryModel.OnUpdMissedCallIndicator(u32NumOfMissedCall);
}


/**
* his function  Handles error in property update from PhoneBook service when there us change in number of miss calls for the connected device.
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - status - gives status of nubmber of missed calls for the connected device
*
* @param[out]- returns void
initial rev:Shwetha K
*/
void ServicePhoneBook::onMissedCallIndicatorError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::MissedCallIndicatorError >& /*error*/)
{
   ETG_TRACE_USR2(("ServicePhoneBook::onMissedCallIndicatorError "));
   //update 0 as number of miss calls as default value
   rfoCallHistoryModel.OnUpdMissedCallIndicator(0);
}


/**
* When a call list(of type: CCH/MCL/ICH/OCH) is already created and we want to delete it and create a different call list,
* Release call list method start has to be sent before creating new call list of different type.
* Release call list result is response from PhoneBook service specifying the list handle whose resources were released.
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - result - gives list handle whose resources were released
*
* @param[out]- returns void
initial rev:Shwetha K
*/
void ServicePhoneBook::onReleaseCallHistoryListResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< ReleaseCallHistoryListResult >& result)
{
   ETG_TRACE_USR2(("ReleaseCallHistoryListResult :: ListHandle : %d", result->getU16ListHandle()));
}


void ServicePhoneBook::onReleaseCallHistoryListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< ::MOST_PhonBk_FI::ReleaseCallHistoryListError >& /*error*/)
{
}


void ServicePhoneBook::onRequestSliceCallHistoryListExtendedError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestSliceCallHistoryListExtendedError >& /*error*/)
{
}


/**
* This function Receives the requested slice of entries from Call History List.
* Slice starts with window list start and includes in sequencial order the number of items specified by window size
* It fills arCallListSlice vector of type btphn_trCallHistoryInfo with details of each list entry which are caller name,caller number,date,call count
* @param[in] - proxy  - shared pointer for client side representation of a service
* @param[in] - result - gives the call history slice information : First name, last name, phone number, call type(missed,outgoing or incoming),
*						call count, call date and time.
*
* @param[out]- returns void
* System Requirements : (SWFL-305, SWFL-306)
* initial rev:Shwetha K
* 26.08.2019 Rev 0.2, Palani K, Bugfix: 579778
*/
void ServicePhoneBook::onRequestSliceCallHistoryListExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< RequestSliceCallHistoryListExtendedResult >& result)
{
   bool flag = false;
   ETG_TRACE_USR4(("ServicePhoneBook::onRequestSliceCallHistoryListExtendedResult"));
   if (NULL == result)
   {
      ETG_TRACE_USR4(("ERROR : NULL POINTER ACCESS"));
      return;
   }
   tU16 u16Size = result->getOCallHistoryListSliceResultExtended().size();
   for (uint8 i = 0; i < u16Size; i++)
   {
      if (result->getOCallHistoryListSliceResultExtended().at(i).getU32ContactHandle() == 0)
      {
         flag = true;
      }
      else
      {
         flag = false;
      }
   }
   if (flag == true)
   {
      return;
   }

   if (u16Size != m_WindowSize_CallList)
   {
      ETG_TRACE_USR4(("ServicePhoneBook::u16Size != m_WindowSize_CallList "));
      m_lastItemIndex_CallList = m_StartIndex_CallList + u16Size - 1;
   }
   ETG_TRACE_USR4(("onRequestSliceCallHistoryListExtendedResult::u16Size= %d, m_StartIndex_CallList=%d m_lastItemIndex_CallList =%d"
                   "m_WindowSize_CallList=%d ", u16Size, m_StartIndex_CallList, m_lastItemIndex_CallList, m_WindowSize_CallList));

   btphn_trCallHistoryInfo rCallListEntry;
   /*vector to store Call List Slice Extended info*/
   std::vector<btphn_trCallHistoryInfo> arCallListSlice;
   arCallListSlice.clear();
   /*extract each row of call history slice information and store it in arCallListSlice array*/
   for (uint8 i = 0; i < u16Size; i++)
   {
      rCallListEntry.copcFirstName = result->getOCallHistoryListSliceResultExtended().at(i).getSFirstName().c_str();
      rCallListEntry.copcLastName = result->getOCallHistoryListSliceResultExtended().at(i).getSLastName().c_str();
      rCallListEntry.copcPhoneNumber = result->getOCallHistoryListSliceResultExtended().at(i).getSPhoneNumber().c_str();
      rCallListEntry.enCallHistoryType = (btphn_tenCallHistoryType)(result->getOCallHistoryListSliceResultExtended().at(i).getE8CallHistoryType());
      rCallListEntry.u8CallCount = result->getOCallHistoryListSliceResultExtended().at(i).getU8CallCount();
      //rCallListEntry.u8CallCount = 562;
      /*append day, month, year information to a single string and store it in CallHistorydate */
      const T_PhonBkCallDateTime& oDateTime = result->getOCallHistoryListSliceResultExtended().at(i).getOCallDateTime();
      rCallListEntry.CallHistorydate = "";
      /*rCallListEntry.CallHistorydate.append(oDateTime.getOCallDate().getSCldrDay());
      rCallListEntry.CallHistorydate.append(".");
      rCallListEntry.CallHistorydate.append(oDateTime.getOCallDate().getSCldrMonth());
      rCallListEntry.CallHistorydate.append(".");
      rCallListEntry.CallHistorydate.append(oDateTime.getOCallDate().getSCldrYear());*/

      /* Get the formatted date string from clock module based on the current set date format */
      if (ClockSrvClient::getInstance() != NULL)
      {
         rCallListEntry.CallHistorydate = ClockSrvClient::getInstance()->evaluateDateFormat(oDateTime.getOCallDate().getSCldrDay(), oDateTime.getOCallDate().getSCldrMonth(), oDateTime.getOCallDate().getSCldrYear());
      }
      ETG_TRACE_USR4(("row[%d]:First name=%s ", i, rCallListEntry.copcFirstName.c_str()));
      ETG_TRACE_USR4(("Last name = %s\t", rCallListEntry.copcLastName.c_str()));
      ETG_TRACE_USR4(("Phone number = %s\t", rCallListEntry.copcPhoneNumber.c_str()));
      ETG_TRACE_USR4(("Call type = %d", rCallListEntry.enCallHistoryType));
      ETG_TRACE_USR4(("Call Date = %s", rCallListEntry.CallHistorydate.c_str()));
      ETG_TRACE_USR4(("Call Count = %d", result->getOCallHistoryListSliceResultExtended().at(i).getU8CallCount()));
      arCallListSlice.push_back(rCallListEntry);
   }
   /*update call history list elements to model*/
   rfoCallHistoryModel.OnUpdSetCallListElement(arCallListSlice, rCallListData.u16TotalListSize,
         m_StartIndex_CallList, m_lastItemIndex_CallList);

   covSendCallList(rCallListData.u16TotalListSize);
}


void ServicePhoneBook::onRequestPhoneBookListSliceExtendedError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedError >& /*error*/)
{
   ETG_TRACE_USR4(("ERROR : ServicePhoneBook::onRequestPhoneBookListSliceExtendedError"));
}


/**
* This function Receives the requested slice of entries from Phonebook List.
* Slice starts with window list start and includes in sequencial order the number of items specified by window size
* It fills arContactListSlice vector of type btphn_trContactInfo with details of each list entry which are u8PhoneNumberCount,u32ContactHandle,szFirstName,szLastName
* @param[in] - proxy  - shared pointer for client side representation of a service
* @param[in] - result - gives the call history slice information : First name, last name, phone number, call type(missed,outgoing or incoming),
*						call count, call date and time.
*
* @param[out]- returns void
* System Requirements : (SWFL - 706, SWFL - 1944)
initial rev:Vidya
*/
void ServicePhoneBook::onRequestPhoneBookListSliceExtendedResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onRequestPhoneBookListSliceExtendedResult"));
   bool flag = false;

   tU16 u16resultlistHandle = result->getU16ListHandle();
   tU32 u8ListSize = result->getOPhoneBookListSliceResultExtended().size();

   ETG_TRACE_USR4(("ServicePhoneBook::onRequestPhoneBookListSliceExtendedResult:list handle of current device is %d", m_u16PBcurrentlisthandle));
   ETG_TRACE_USR4(("ServicePhoneBook::onRequestPhoneBookListSliceExtendedResult:list handle of result is %d", u16resultlistHandle));
   ETG_TRACE_USR4(("ServicePhoneBook::onRequestPhoneBookListSliceExtendedResult:u8ListSize = %d,  m_PBWindowSize = %d", u8ListSize, m_PBWindowSize));

   if (u8ListSize != m_PBWindowSize)
   {
      ETG_TRACE_USR4(("ServicePhoneBook::(u8ListSize != m_PBWindowSize) "));
      m_lastItemIndex_PBList = m_PBStartIndex + u8ListSize - 1;
   }
   /*if ((m_lastItemIndex_PBList == 0))
   {
   	m_lastItemIndex_PBList = u8ListSize - 1;
   }*/
   ETG_TRACE_USR4(("ServicePhoneBook::m_lastItemIndex_PBList =%d", m_lastItemIndex_PBList));
   /*extract each row of Phonebook slice information and store it in arContactListSlice array*/
   if (u16resultlistHandle != m_u16PBcurrentlisthandle) //Bug 880046
   {
      ETG_TRACE_USR4(("ServicePhoneBook::onRequestPhoneBookListSliceExtendedResult: u16resultlistHandle not equal to m_u16PBcurrentlisthandle   "));
      return;
   }
   for (uint8 i = 0; i < u8ListSize; i++)
   {
      if (result->getOPhoneBookListSliceResultExtended().at(i).getU32ContactHandle() == 0)
      {
         flag = true;
      }
      else
      {
         flag = false;
      }
   }
   if (flag == true)
   {
      return;
   }
   // uint8 u8ListIterator = 0;

   /*vector to store Phonebook List Slice Extended info*/
   std::vector<btphn_trContactInfo> arContactListSlice;
   std::string indexName;
   arContactListSlice.clear();
   most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder sortorder = enGetSortOrder();
   /*extract each row of Phonebook slice information and store it in arContactListSlice array*/
   for (uint8 u8ListIterator = 0; u8ListIterator < u8ListSize; u8ListIterator++)
   {
      btphn_trContactInfo rContactListEntry;
      //memset(&rContactListEntry, '\0', sizeof(btphn_trContactInfo));
      rContactListEntry.u32ContactHandle = result->getOPhoneBookListSliceResultExtended().at(u8ListIterator).getU32ContactHandle();
      rContactListEntry.szFirstName = result->getOPhoneBookListSliceResultExtended().at(u8ListIterator).getSFirstName().c_str();
      rContactListEntry.szLastName = result->getOPhoneBookListSliceResultExtended().at(u8ListIterator).getSLastName().c_str();
      rContactListEntry.u8PhoneNumberCount = result->getOPhoneBookListSliceResultExtended().at(u8ListIterator).getU8PhoneNumberCount();

      ETG_TRACE_USR4(("Row[%d] Contact handle : %d\t", u8ListIterator, rContactListEntry.u32ContactHandle));
      ETG_TRACE_USR4(("First name : %s\t", rContactListEntry.szFirstName.c_str()));
      ETG_TRACE_USR4(("Last name : %s", rContactListEntry.szLastName.c_str()));
      ETG_TRACE_USR4(("PhoneNumberCount : %d", rContactListEntry.u8PhoneNumberCount));

      arContactListSlice.push_back(rContactListEntry);

      indexName = AppHmiPhone_Helper::GetContactname(rContactListEntry.szFirstName, rContactListEntry.szLastName, sortorder);

      // Buffer size: 5, offset: 3
      if (u8ListIterator <= 8)
      {
         ETG_TRACE_USR4(("ZoomBubbleCounter : %d", u8ListIterator));
         if (indexName.at(0) < 0xC0)	//Single Byte Character
         {
            ETG_TRACE_USR4(("Single Byte Character : %s", std::string(1, indexName.at(0)).c_str()));
            updatecharInBubble(std::string(1, indexName.at(0)));
         }
         else	//MultiByte Character
         {
            ETG_TRACE_USR4(("MultiByte Character Length: %d", u32GetCharacterByteLength(indexName.at(0))));
            std::string multiByteChar = std::string(indexName.substr(0, u32GetCharacterByteLength(indexName.at(0))));
            ETG_TRACE_USR4(("MultiByte Character : %s", multiByteChar.c_str()));
            updatecharInBubble(multiByteChar);
         }
      }
   }
   /*update Phonebook list elements to model*/
   rfoPhonebookModelComponent.OnUpdContactListSlice(arContactListSlice, m_PBStartIndex, m_lastItemIndex_PBList, rContactListData.u16TotalListSize, bLoadPersistent, m_U8ViewPortStartIndex);
   // Since we reset it here, when we get the actual list data request from List Wisget, we proceed with the Start index.
   bLoadPersistent = FALSE;

   // Below function call trigger event to mark the completion of contact list load via Sending SM trigger
   covSendContactList(rContactListData.u16TotalListSize);
}


/**
* Whenever we want a call list to be created, call create calllist method start with type of the list to be created(i.e Combined/missed/outgoing/incoming call list).
* This function Handles response from PhoneBook service which provides the list handle of the newly created call history list.
* Stores list handle and list size of newly created callHistory list
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - result - gives the call history list handle and list total size
*
* @param[out]- returns void
* System Requirements : (SWFL-305, SWFL-306)
initial rev:Shwetha K
*/
void ServicePhoneBook::onCreateCallHistoryListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::CreateCallHistoryListResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onCreateCallHistoryListResult"));
   if (result->getU16ListHandle() == 0)
   {
      return;
   }
   rCallListData.u16ListHandle = result->getU16ListHandle();
   rCallListData.u16TotalListSize = result->getU16ListLength();
   ETG_TRACE_USR4(("ServicePhoneBook::onCreateCallHistoryListResult : rCallListData.u16ListHandle = %d", rCallListData.u16ListHandle));
   ETG_TRACE_USR4(("ServicePhoneBook::onCreateCallHistoryListResult : rCallListData.u16TotalListSize = %d", rCallListData.u16TotalListSize));
   /* Requests to fetch and populate call list data*/
   vRequestCallListData();
}


void ServicePhoneBook::onCreateCallHistoryListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::CreateCallHistoryListError >& /*error*/)
{
}


/*void ServicePhoneBook::onGetContactDetailsError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::GetContactDetailsError >& error)
{
}*/


/**
* Whenever we want the detailed contact list of a particular contact to be created, call the GetContactDetails method start with the type of the list to be created like contact handle, start index, list size.
* This function Handles response from PhoneBook service which provides the detailed contact list of a selected contact.
* Stores detailed contact list of a selected contact.
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - result - gives the detailed contact list.
*
* @param[out]- returns void
* System Requirements : (SWFL- 1946)
initial rev:Vidya
*/
/*void ServicePhoneBook::onGetContactDetailsResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::GetContactDetailsResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsResult"));
   if (result->getOContactDetails().getU32FirstNameTag() == 0)
   {
      return;
   }
   //Allocating memory for 7 contact numbers + Preferred number
   tU8 u8ContactNumIndex = BTPHN_C_DEFAULT_VALUE_ZERO;
   tU8 ContactDetailType[BTPHN_C_CONTACT_DETAILS_MAX_NUMBER + 1];

    //Populating the contact numbers - Cell, Home, Work and Other
   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetails().getSCellNumber1();
   ContactDetailType[u8ContactNumIndex] = BTPHN_EN_CELL_NUMBER_1;
   ETG_TRACE_USR4(("Cell Number 1 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetails().getSCellNumber2();
   ContactDetailType[u8ContactNumIndex] = BTPHN_EN_CELL_NUMBER_2;
   ETG_TRACE_USR4(("Cell Number 2 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetails().getSHomeNumber1();
   ContactDetailType[u8ContactNumIndex] = BTPHN_EN_HOME_NUMBER_1;
   ETG_TRACE_USR4(("Home Number 1 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetails().getSHomeNumber2();
   ContactDetailType[u8ContactNumIndex] = BTPHN_EN_HOME_NUMBER_2;
   ETG_TRACE_USR4(("Home Number 2 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetails().getSWorkNumber1();
   ContactDetailType[u8ContactNumIndex] = BTPHN_EN_WORK_NUMBER_1;
   ETG_TRACE_USR4(("Work Number 1 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetails().getSWorkNumber2();
   ContactDetailType[u8ContactNumIndex] = BTPHN_EN_WORK_NUMBER_2;
   ETG_TRACE_USR4(("Work Number 2 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetails().getSOtherNumber();
   ContactDetailType[u8ContactNumIndex] = BTPHN_EN_OTHER_NUMBER;
   ETG_TRACE_USR4(("Other Number : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetails().getSPreferredNumber();
   ContactDetailType[u8ContactNumIndex] = BTPHN_EN_PREFERRED_NUMBER;
   ETG_TRACE_USR4(("Preferred Number : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));

   std::string copcFirstName = result->getOContactDetails().getSFirstName();
   std::string copcLastName = result->getOContactDetails().getSLastName();

   ETG_TRACE_USR4(("First name : %s", copcFirstName.c_str()));
   ETG_TRACE_USR4(("Last name : %s", copcLastName.c_str()));

   if (TRUE == bContactInfoRequired)
   {
      ETG_TRACE_USR4(("Processing - Contact type of preferred number"));
      // This branch is entered when the phone type of the preferred number
      has to be determined and the call screen has to be updated
      bContactInfoRequired = FALSE;
      covUpdatePrefNumType(copcFirstName, copcLastName, acopcContactNumbers);
   }
   else
   {
      vCreateContactDetailsList(copcFirstName, copcLastName,
                                acopcContactNumbers);
   }
}*/


void ServicePhoneBook::onGetContactDetailsExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactDetailsExtendedError >& error)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedError"));
}


void ServicePhoneBook::onGetContactDetailsExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactDetailsExtendedResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult"));
   tU8 u8ContactNumIndex = BTPHN_C_DEFAULT_VALUE_ZERO;
   tU8 ContactDetailType[BTPHN_C_CONTACT_DETAILS_MAX_NUMBER + 1];

   /* Populating the contact numbers - Cell, Home, Work and Other */
   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber1().getSNumber();
   ContactDetailType[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber1().getE8Type();
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult Phone Number 1 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult ContactDetailType Phone Number 1 : %d", ContactDetailType[u8ContactNumIndex]));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber2().getSNumber();
   ContactDetailType[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber2().getE8Type();
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult Phone Number 2 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult ContactDetailType Phone Number 2 : %d", ContactDetailType[u8ContactNumIndex]));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber3().getSNumber();
   ContactDetailType[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber3().getE8Type();
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult Phone Number 3 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult ContactDetailType Phone Number 3 : %d", ContactDetailType[u8ContactNumIndex]));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber4().getSNumber();
   ContactDetailType[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber4().getE8Type();
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult Phone Number 4 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult ContactDetailType Phone Number 4 : %d", ContactDetailType[u8ContactNumIndex]));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber5().getSNumber();
   ContactDetailType[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber5().getE8Type();
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult Phone Number 5 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult ContactDetailType Phone Number 5 : %d", ContactDetailType[u8ContactNumIndex]));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber6().getSNumber();
   ContactDetailType[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber6().getE8Type();
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult Phone Number 6 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult ContactDetailType Phone Number 6 : %d", ContactDetailType[u8ContactNumIndex]));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber7().getSNumber();
   ContactDetailType[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber7().getE8Type();
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult Phone Number 7 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult ContactDetailType Phone Number 7 : %d", ContactDetailType[u8ContactNumIndex]));
   u8ContactNumIndex++;

   acopcContactNumbers[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber8().getSNumber();
   ContactDetailType[u8ContactNumIndex] = result->getOContactDetailsExtended().getOPhoneNumber8().getE8Type();
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult Phone Number 8 : %s", acopcContactNumbers[u8ContactNumIndex].c_str()));
   ETG_TRACE_USR4(("ServicePhoneBook::onGetContactDetailsExtendedResult ContactDetailType Phone Number 8 : %d", ContactDetailType[u8ContactNumIndex]));
   u8ContactNumIndex++;

   std::string copcFirstName = result->getOContactDetailsExtended().getSFirstName();
   std::string copcLastName = result->getOContactDetailsExtended().getSLastName();

   ETG_TRACE_USR4(("First name : %s", copcFirstName.c_str()));
   ETG_TRACE_USR4(("Last name : %s", copcLastName.c_str()));

   if (TRUE == bContactInfoRequired)
   {
      ETG_TRACE_USR4(("Processing - Contact type of preferred number"));
      /* This branch is entered when the phone type of the preferred number
      has to be determined and the call screen has to be updated */
      bContactInfoRequired = FALSE;
      covUpdatePrefNumType(copcFirstName, copcLastName, acopcContactNumbers);
   }
   else
   {
      vCreateContactDetailsList(copcFirstName, copcLastName,
                                acopcContactNumbers, ContactDetailType);
   }
}


/********************************************************************************
*Function responsible for extracting the contact details-> Contact numbers, contact number type, Preffered number for selected contact
* Calls GUI method OnUpdGetContactDetails with these details for list display
* @param[in] - copcFirstName  - First name of the contact
			 - copcLastName - Last name for contact
			 - acopcContactNumbers - array of all contact numbers for selected contact
*
* @param[out]- returns void
* System Requirements : (SWFL- 1946)
*initial rev:Shwetha K
*06/02/2018
***********************************************************************************/
tVoid ServicePhoneBook::vCreateContactDetailsList(std::string copcFirstName, std::string  copcLastName, std::string  acopcContactNumbers[], tU8 ContactDetailType[])
{
   ETG_TRACE_USR4(("ServicePhoneBook : vCreateContactDetailsList()\t"));

   std::vector<btphn_trContactCallDetail> arDetailedContactNum;
   tU8 u8ContactNumIndex = BTPHN_C_DEFAULT_VALUE_ZERO;
   tU8 u8ContactNumTypeIndex = BTPHN_C_DEFAULT_VALUE_ZERO;

   /* Extracting the primary contact number which is stored as the last
   number in the list of contact numbers */
   std::string copcPrimaryNumber =	acopcContactNumbers[BTPHN_C_CONTACT_DETAILS_MAX_NUMBER].c_str();

   /* Iterating through the contact numbers to find the first non-zero
   contact number entry */
   for (; u8ContactNumIndex < BTPHN_C_CONTACT_DETAILS_MAX_NUMBER;
         u8ContactNumIndex++
       )
   {
      if (BTPHN_C_EQUAL != acopcContactNumbers[u8ContactNumIndex].compare(""))
      {
         break;
      }
      else
      {
         if (1 == (u8ContactNumIndex % BTPHN_C_CONTACTTYPE_MAX_NUMBER))
         {
            u8ContactNumTypeIndex++;
         }
      }
   }

   btphn_trContactCallDetail rContactInfo;
   arDetailedContactNum.clear();
   if (BTPHN_C_CONTACT_DETAILS_MAX_NUMBER > u8ContactNumIndex)
   {
      /* Populating the remaining contact details list entries */
      for (u8ContactNumIndex;
            u8ContactNumIndex < BTPHN_C_CONTACT_DETAILS_MAX_NUMBER;
            u8ContactNumIndex++
          )
      {
         /* Populating the contact number if not an empty string */
         if (BTPHN_C_EQUAL != acopcContactNumbers[u8ContactNumIndex].compare(""))
         {
            /* Assigning the primary icon image if the contact number
            is the primary number */
            ETG_TRACE_USR4(("vCreateContactDetailsList() :copcPrimaryNumber = %s ", copcPrimaryNumber.c_str()));
            ETG_TRACE_USR4(("vCreateContactDetailsList() :acopcContactNumbers[%d] =%s ", u8ContactNumIndex, acopcContactNumbers[u8ContactNumIndex].c_str()));
            int nRetVal = copcPrimaryNumber.compare(acopcContactNumbers[u8ContactNumIndex]);

            bool bPrimaryNumIcon = (BTPHN_C_EQUAL == nRetVal) ? true : false;

            /* Invoking method to populate the contact number details */
            rContactInfo.szContactNumber = acopcContactNumbers[u8ContactNumIndex].c_str();
            rContactInfo.u8ContactNumType = ContactDetailType[u8ContactNumIndex];
            rContactInfo.bPrefferedNum = bPrimaryNumIcon;
            ETG_TRACE_USR4(("vCreateContactDetailsList() :rContactInfo.szContactNumber = %s ", rContactInfo.szContactNumber.c_str()));
            ETG_TRACE_USR4(("vCreateContactDetailsList() :rContactInfo.bPrefferedNum  = %d", rContactInfo.bPrefferedNum));
            ETG_TRACE_USR4(("vCreateContactDetailsList() :rContactInfo.u8ContactNumType   = %d", rContactInfo.u8ContactNumType));
            arDetailedContactNum.push_back(rContactInfo);
         }
         if (1 == (u8ContactNumIndex % BTPHN_C_CONTACTTYPE_MAX_NUMBER))
         {
            u8ContactNumTypeIndex++;
            ETG_TRACE_USR4(("vCreateContactDetailsList() :u8ContactNumTypeIndex = %d ", u8ContactNumTypeIndex));
         }
      }
   }
   else
   {
      ETG_TRACE_USR4(("vCreateContactDetailsList() : invalid index\t"));
   }
   /* Sends the contact details of a particular contact to HMI */
   rfoPhonebookModelComponent.OnUpdGetContactDetails(copcFirstName, copcLastName, arDetailedContactNum);
}


/************************************************************************
*FUNCTION: 		 covUpdatePrefNumType
*DESCRIPTION: 	 Receives the contact information namely the contact name and
*					 contact numbers. Determines what is the phone type of the
*					 preferred number and invokes method to send the contact name
*					 and phone type information of the ongoing call to HMI Model.
*PARAMETER:
*					 copcFirstName:   (->I)
*					    Contact's first name
*					 copcLastName:   (->I)
*					    Contact's last name
* 				    acopcContactNumbers:   (I)
* 					    Array of contact numbers
*
*RETURNVALUE: 	tVoid
*
*HISTORY:
*15.01.2018 ess7kor
*Rev 0.1 Initial Revision.
************************************************************************/
tVoid ServicePhoneBook::covUpdatePrefNumType(std::string copcFirstName, std::string copcLastName, std::string acopcContactNumbers[])
{
   ETG_TRACE_USR4(("ServicePhoneBook : covUpdatePrefNumType()\t"));

   tU8 u8ContactNumIndex = BTPHN_C_DEFAULT_VALUE_ZERO;
   tU8 u8ContactNumTypeIndex = BTPHN_C_DEFAULT_VALUE_ZERO;

   /* Extracting the primary contact number which is stored as the last
   number in the list of contact numbers */
   std::string copcPrimaryNumber = acopcContactNumbers[BTPHN_C_CONTACT_DETAILS_MAX_NUMBER].c_str();

   /* Iterating through the contact numbers to find the phone number which
   matches the primary number */
   for (; u8ContactNumIndex < BTPHN_C_CONTACT_DETAILS_MAX_NUMBER; u8ContactNumIndex++)
   {
      if (BTPHN_C_EQUAL == copcPrimaryNumber.compare(acopcContactNumbers[u8ContactNumIndex]))
      {
         break;
      }
      else
      {
         if (1 == (u8ContactNumIndex % BTPHN_C_CONTACTTYPE_MAX_NUMBER))
         {
            u8ContactNumTypeIndex++;
         }
      }
   }

   /* Determining the phone type of the preferred number */
   btphn_tenPhoneType enPhoneType = static_cast<btphn_tenPhoneType>(
                                       (BTPHN_C_CONTACT_DETAILS_MAX_NUMBER > u8ContactNumIndex) ?
                                       u8ContactNumTypeIndex : BTPHN_EN_GENERIC);

   most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder sortorder = T_e8_PhonBkPreferredPhoneBookSortOrder__e8PREFERRED_SORT_ORDER_FIRSTNAME;

   if (ServicePhoneBook::poGetInstance() != NULL)
   {
      sortorder = ServicePhoneBook::poGetInstance()->enGetSortOrder();
   }
   /* Invoking method to provide the contact full name */
   std::string strContactName = AppHmiPhone_Helper::GetContactname(copcFirstName, copcLastName, sortorder);

   /* Sending the contact name and phone type to HMI Model for the ongoing call */
   if (NULL != ServiceTel::poGetInstance())
   {
      ServiceTel::poGetInstance()->vUpdateContactInfo(strContactName, enPhoneType);
   }
}


void ServicePhoneBook::onSearchPhoneBookError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::SearchPhoneBookError >& /*error*/)
{
}


/************************************************************************
*FUNCTION:		onSearchPhoneBookResult
*DESCRIPTION:	Handles response from PhoneBook service which provides the
*					contact details (namely the first and last name, contact handle
*					and contact detail type) corresponding to a contact number
*PARAMETER:
*               poMessage:   (->I)
*                  Message object
*
*RETURNVALUE:	tVoid
*
*HISTORY:
*01.11.2018 ess7kor
*Rev 0.1 Initial Revision
************************************************************************/
void ServicePhoneBook::onSearchPhoneBookResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::SearchPhoneBookResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook : onSearchPhoneBookResult()"));
   ETG_TRACE_USR3(("Contact handle : %d\t", result->getU32ContactHandle()));
   ETG_TRACE_USR3(("First name : %s\t", result->getSFirstName().c_str()));
   ETG_TRACE_USR3(("Last name : %s\t", result->getSLastName().c_str()));
   ETG_TRACE_USR3(("Contact detail type : %d\t", (tU8)result->getE8ContactDetailType()));

   btphn_tenContactDetailType enContactDetailType = static_cast <btphn_tenContactDetailType>(result->getE8ContactDetailType());

   if (BTPHN_EN_PREFERRED_NUMBER == enContactDetailType)
   {
      bContactInfoRequired = TRUE;
      if (NULL != _most_phonbk_fi && _most_phonbk_fi.get())
      {
         _most_phonbk_fi->sendGetContactDetailsExtendedStart(*this, result->getU32ContactHandle());
      }
      else
      {
         ETG_TRACE_ERR(("ServicePhoneBook::onSearchPhoneBookResult _most_phonbk_fi() NULL Pointer"));
      }
   }

   else
   {
      /* Sending the contact details (corresponding to a contact number) for updating HMI */
      if (NULL != ServiceTel::poGetInstance())
      {
         std::string strFirstName = result->getSFirstName().c_str();
         std::string strLastName = result->getSLastName().c_str();
         tU32 u32ContactHandle = result->getU32ContactHandle();

         ServiceTel::poGetInstance()->vUpdateContactInfo(u32ContactHandle, strFirstName, strLastName, enContactDetailType);
      }
   }
}


void ServicePhoneBook::onAutocompletePhoneNumberEntryError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::AutocompletePhoneNumberEntryError >& /* error*/)
{
}


/*************************************************************************
* This function handles response from PhoneBook service which provides the
* matched phone number (autocomplete) and matched phone entries.
* It fills the arMatchList with the matched entries if found
* @param[in] - proxy  - shared pointer for client side representation of a service
* @param[in] - result - AutocompleteMatch -> true if match is found, false otherwise
*					AutocompleteMatchPhoneNumber-> matched number
					NumberOfMatches -> number of matched found user input number
*
* @param[out]- returns void
* System Requirements : (SWFL-278, SWFL-279, SWFL-285, SWFL-292, SWFL-1953, SWFL-1961, SWFL-270, SWFL-283, SWFL-299)
initial rev:Shwetha K
**************************************************************************/
void ServicePhoneBook::onAutocompletePhoneNumberEntryResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::AutocompletePhoneNumberEntryResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook : onAutocompletePhoneNumberEntryResult()"));

   /* Set to TRUE if matched entries are found. Else set to FALSE */
   tBool bAutocompleteMatch = result->getBAutocompleteMatch();

   /* Extracting the autocompleted matched phone number */
   tCString copcAutocompleteMatchNum =	result->getSAutocompleteMatchPhoneNumber().c_str();
   //If no match is found then remove the suggestion text from the text box //FOR BUG FIX
   if (!bAutocompleteMatch)
   {
      copcAutocompleteMatchNum = 	strEditInfo.c_str();
   }

   /* Extracting the count of the number of matched entries found */
   tU8 u8MatchNumber = result->getU8NumberOfMatches();

   ETG_TRACE_USR4(("Autocomplete match found = %d\t Number of matches = %d", bAutocompleteMatch, u8MatchNumber));
   ETG_TRACE_USR4(("Autocomplete match number = %s", copcAutocompleteMatchNum));

   btphn_trPhnBkMatchListEntry rMatchListEntry;
   //memset(&rMatchListEntry, '\0', sizeof(btphn_trPhnBkMatchListEntry));
   arMatchList.clear();
   /* Iterating through the match list given by PhoneBook service and storing this information in the MatchList array */
   for (tU8 u8Index = BTPHN_C_DEFAULT_VALUE_ZERO; u8Index < u8MatchNumber; u8Index++)
   {
      /* Populating MatchList information */
      rMatchListEntry.copcFirstName = result->getOAutocompleteMultipleMatchList().at(u8Index).getSFirstName().c_str();
      rMatchListEntry.copcLastName = result->getOAutocompleteMultipleMatchList().at(u8Index).getSLastName().c_str();
      rMatchListEntry.copcPhoneNumber = result->getOAutocompleteMultipleMatchList().at(u8Index).getSPhoneNumber().c_str();
      ETG_TRACE_USR4(("First name = %s\t", rMatchListEntry.copcFirstName.c_str()));
      ETG_TRACE_USR4(("Last name = %s\t", rMatchListEntry.copcLastName.c_str()));
      ETG_TRACE_USR4(("Phone number = %s\t", rMatchListEntry.copcPhoneNumber.c_str()));

      arMatchList.push_back(rMatchListEntry);
   }
   /* Sending the Matched list to model for updating HMI */
   //OnUpdEntryText(strEditInfo);
   rfoSpellerModel.OnUpdDialMatchList(bAutocompleteMatch, copcAutocompleteMatchNum, u8MatchNumber, arMatchList);
}


void ServicePhoneBook::onRequestSliceCallHistoryListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::RequestSliceCallHistoryListError >& /*error*/)
{
}


/**
* This function Receives the requested slice of entries from Call History List.
* Slice starts with window list start and includes in sequencial order the number of items specified by window size(in this case 1 as we have requested for 1 item)
* It extracts phone number from the slice and calls vSendDialCallMethodStart to place a call to the number obtained
* @param[in] - proxy  - shared pointer for client side representation of a service
* @param[in] - result - gives the call history slice information : First name, last name, phone number, call type(missed,outgoing or incoming),
*						call count, call date and time.
*
* @param[out]- returns void
initial rev:Shwetha K
*/
void ServicePhoneBook::onRequestSliceCallHistoryListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::RequestSliceCallHistoryListResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onRequestSliceCallHistoryListResult()"));
   /*flag to check if call must be placed to the number */
   if (bReqCallListDialInfo == TRUE)
   {
      bReqCallListDialInfo = FALSE;

      if (NULL == result)
      {
         ETG_TRACE_USR4(("ERROR : NULL POINTER ACCESS"));
      }
      tU16 u16Size = result->getOCallHistoryListSliceResult().size();
      ETG_TRACE_USR4(("onRequestSliceCallHistoryListResult::List Size: %d", u16Size));
      if (u16Size != 1 ||
            (TRUE == result->getOCallHistoryListSliceResult().empty()))
      {
         ETG_TRACE_FATAL(("onRequestSliceCallHistoryListResult::List Size is not 1 or empty"));
         return;
      }
      /*Extracts number from the slice requested*/
      std::string strPhoneNumber = result->getOCallHistoryListSliceResult().at(0).getSPhoneNumber().c_str();

      ServiceTel* poServiceTel = ServiceTel::poGetInstance();
      if (poServiceTel)
      {
         ETG_TRACE_USR4(("onRequestSliceCallHistoryListResult:Calling number: %s", strPhoneNumber.c_str()));
         poServiceTel->vSendDialCallMethodStart(strPhoneNumber, BTPHN_EN_ECNR_NOCHANGE);
      }
   }
}


void ServicePhoneBook::onReleasePhoneBookListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ReleasePhoneBookListError >& /*error*/)
{
}


/**
* When a phonebook list is already created and we want to delete it and create a different phonebook list,
* Release phonebook list method start has to be sent before creating new phonebook list of different type.
* Release phonebook list result is response from PhoneBook service specifying the list handle whose resources were released.
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - result - gives list handle whose resources were released
*
* @param[out]- returns void
initial rev:Vidya
*/
void ServicePhoneBook::onReleasePhoneBookListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ReleasePhoneBookListResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onReleasePhoneBookListResult"));
   ETG_TRACE_USR4(("Contact handle : %d\t", result->getU16ListHandle()));
}


void ServicePhoneBook::onRequestPhoneBookListSliceError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestPhoneBookListSliceError >& /*error*/)
{
}


/**
* This function Receives the requested slice of entries from phonebook List.
* Slice starts with window list start and includes in sequencial order the number of items specified by window size (here 1 as we have requested for 1 item)
* It extracts contact handle of the received slice and calls vsendGetContactDetailsStart function to place a call for the contact handle
* @param[in] - proxy  - shared pointer for client side representation of a service
* @param[in] - result - gives the Contact list slice information : contact handle, contact name, phone number count
*
* @param[out]- returns void
initial rev:Shwetha K
*/
void ServicePhoneBook::onRequestPhoneBookListSliceResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestPhoneBookListSliceResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onRequestPhoneBookListSliceResult()"));
   if (NULL == result)
   {
      ETG_TRACE_USR4(("ERROR : NULL POINTER ACCESS"));
   }
   tU16 u16Size = result->getOPhoneBookListSliceResult().size();
   ETG_TRACE_USR4(("onRequestPhoneBookListSliceResult::List Size: %d", u16Size));
   if (u16Size != 1 ||
         (TRUE == result->getOPhoneBookListSliceResult().empty()))
   {
      ETG_TRACE_FATAL(("onRequestSliceCallHistoryListResult::List Size is not 1 or empty"));
      return;
   }

   mContacthandle = result->getOPhoneBookListSliceResult().at(0).getU32ContactHandle();
   ETG_TRACE_USR4(("onRequestPhoneBookListSliceResult: mContacthandle= %d", mContacthandle));
   vsendGetContactDetailsStart();
}


void ServicePhoneBook::onSearchKeyboardPhoneBookListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::SearchKeyboardPhoneBookListError >& error)
{
}


void ServicePhoneBook::onSearchKeyboardPhoneBookListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::SearchKeyboardPhoneBookListResult >& result)
{
}


void ServicePhoneBook::onClearMissedCallIndicatorError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ClearMissedCallIndicatorError >& /*error*/)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onClearMissedCallIndicatorError"));
}


void ServicePhoneBook::onClearMissedCallIndicatorResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ClearMissedCallIndicatorResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onClearMissedCallIndicatorResult"));
}


void ServicePhoneBook::onGetDeviceCallHistorySupportError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::GetDeviceCallHistorySupportError >& /*error*/)
{
}


/**
 * This function updates the date and time stamp information for current connected device
*
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - result - gives the call history list support status and datetime support info
*
* @param[out]- returns void
initial rev:Shwetha K
*/
void ServicePhoneBook::onGetDeviceCallHistorySupportResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::GetDeviceCallHistorySupportResult >& result)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onGetDeviceCallHistorySupportResult"));
   if (result->getU8DeviceHandle() == 0)
   {
      return;
   }
   if (result->getU8DeviceHandle() == ServiceTel::poGetInstance()->u8GetActiveDev())
   {
      rListSupport.bTimestampSupport = result->getBCallHistoryDateTimeSupport();
   }
}


void ServicePhoneBook::onDownloadStateExtendedError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::DownloadStateExtendedError >& error)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedError"));
   if (error->hasSystemErrorCode() == true)
   {
      ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedError:SYSTEM Error code"));
      VehicleSrvClient::poGetInstance()->updatePhonebookDownloadError(PHONEMW_SNA);//Gen Can Imp for roaming error code
      VehicleSrvClient::poGetInstance()->updateCallHistorySyncError(PHONEMW_SNA);//Gen Can Imp for roaming error code
   }
   else if (error->hasCcaErrorCode() == true)
   {
      ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedError:CCA Error code"));
      VehicleSrvClient::poGetInstance()->updatePhonebookDownloadError(CAN_ERROR);//Gen Can Imp for roaming error code
      VehicleSrvClient::poGetInstance()->updateCallHistorySyncError(CAN_ERROR);//Gen Can Imp for roaming error code
   }
   else
   {
      ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedError:Unknown Error"));
      VehicleSrvClient::poGetInstance()->updatePhonebookDownloadError(PHONEMW_SNA);//Gen Can Imp for roaming error code
      VehicleSrvClient::poGetInstance()->updateCallHistorySyncError(PHONEMW_SNA);//Gen Can Imp for roaming error code
   }
}


/**
* This function receives the download status for all the lists supported by the connected device. This is called whenever there is change in list download state
*It stores the Call history list download state if its changed into enCallListDownloadState and posts CallListDownloadStateResp courier message to controller
* @param[in] - proxy  - shared pointer for client side representation of a service,
* @param[in] - status - gives the list download state info
*
* @param[out]- returns void
* System Requirements : SWFL-1943, (SWFL-1945, SWFL-1972, SWFL-1973)
initial rev:Shwetha K
*/
void ServicePhoneBook::onDownloadStateExtendedStatus(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::DownloadStateExtendedStatus >& status)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus"));
   ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::size =  %d", status->getODownloadStateExtendedStream().size()));
   if (status->getODownloadStateExtendedStream().size() == 0)
   {
      if (VehicleSrvClient::poGetInstance() != NULL)
      {
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::GEN CAN Update for Call History Download Status"));
         VehicleSrvClient::poGetInstance()->updateCallHistorySyncStatus(PHONEMW_SNA); //CAN Imp
      }
      return;
   }
   if (status->getODownloadStateExtendedStream().size() != 0)
   {
      ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus:download size not 0"));
      if (status->getODownloadStateExtendedStream().size() == 1)
      {
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus:Set active device Index to 0"));
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::enCallListDownloadState = %d", status->getODownloadStateExtendedStream().at(0).getE8RecentCallListDownloadState()));
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::enPhnBkDownloadState = %d", status->getODownloadStateExtendedStream().at(0).getE8PhoneBookDownloadState()));

         activeDevIndex = 0;
      }
      else
      {
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus:Set active device Index to 1"));
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::enCallListDownloadState = %d", status->getODownloadStateExtendedStream().at(1).getE8RecentCallListDownloadState()));
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::enPhnBkDownloadState = %d", status->getODownloadStateExtendedStream().at(1).getE8PhoneBookDownloadState()));

         activeDevIndex = 1;
      }
      /*check if the status is received for current connected device*/
      ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::call list support = %d", rListSupport.bCallListSupport[activeDevIndex]));
      ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::PB support = %d", rListSupport.bContactSupport));

      if (CALLHISTORY_NOT_STARTED == status->getODownloadStateExtendedStream().at(activeDevIndex).getE8RecentCallListDownloadState())
      {
         if (VehicleSrvClient::poGetInstance() != NULL)
         {
            ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::GEN CAN Update for Call History Download Status is 0"));
            VehicleSrvClient::poGetInstance()->updateCallHistorySyncStatus(enCallListDownloadState); //CAN Imp
         }
      }

      if (PBDS_NOT_STARTED == status->getODownloadStateExtendedStream().at(activeDevIndex).getE8PhoneBookDownloadState())
      {
         if (VehicleSrvClient::poGetInstance() != NULL)
         {
            ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::GEN CAN Update for Phone Book Download Status is 0"));
            VehicleSrvClient::poGetInstance()->updatePhonebookDownloadSync(enPhnBkDownloadState); //CAN Imp
         }
      }

      if (enCallListDownloadState != status->getODownloadStateExtendedStream().at(activeDevIndex).getE8RecentCallListDownloadState())
      {
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::CallList_Loading"));
         /*store call history list download status to enum variable*/
         enCallListDownloadState = (status->getODownloadStateExtendedStream().at(activeDevIndex).getE8RecentCallListDownloadState());
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::CallList_Loading enCallListDownloadState = %d", enCallListDownloadState));
         /*send courier message CallListDownloadStateResp to controller indicating the state change*/
         POST_MSG((COURIER_MESSAGE_NEW(CallListDownloadStateResp)((btphn_tenCallListDownloadState)(enCallListDownloadState))));
         if (VehicleSrvClient::poGetInstance() != NULL)
         {
            ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::GEN CAN Update for Call History Download Status"));
            VehicleSrvClient::poGetInstance()->updateCallHistorySyncStatus(enCallListDownloadState); //CAN Imp
         }
      }

      if (enPhnBkDownloadState != status->getODownloadStateExtendedStream().at(activeDevIndex).getE8PhoneBookDownloadState())
      {
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::ContactList_Loading"));
         enPhnBkDownloadState = status->getODownloadStateExtendedStream().at(activeDevIndex).getE8PhoneBookDownloadState();
         if (VehicleSrvClient::poGetInstance() != NULL)
         {
            ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::GEN CAN Update for Phone Book Download Status"));
            VehicleSrvClient::poGetInstance()->updatePhonebookDownloadSync(enPhnBkDownloadState); //CAN Imp
         }
         ETG_TRACE_USR4(("ServicePhoneBook::onDownloadStateExtendedStatus::ContactList_Loading enPhnBkDownloadState = %d", enPhnBkDownloadState));
         POST_MSG((COURIER_MESSAGE_NEW(PhnBkDownloadStateResp)((btphn_tenPhnBkDownloadState)(enPhnBkDownloadState))));
         if (((most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_COMPLETE == enPhnBkDownloadState) || (most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_ERROR == enPhnBkDownloadState)) &&
               (NULL != ServiceTel::poGetInstance()))
         {
            //check if a calling sequnce is initiated
            tBool bIsSearchPhoneBookReq = ServiceTel::poGetInstance()->vCheckCallStatus();
            //if TRUE perform a SearchPhoneBookaction to update the Data in Calling Screen
            if (bIsSearchPhoneBookReq)
            {
               ETG_TRACE_USR4(("PhoneBook Download Completed.SearchPhoneBook Required Now."));
               _most_phonbk_fi->sendSearchPhoneBookStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev(), strTelephoneNumber, "");
            }
         }
      }
   }
}


void ServicePhoneBook::onPreferredPhoneBookSortOrderError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::PreferredPhoneBookSortOrderError >& error)
{
   ETG_TRACE_USR2(("ServiceBT::onPreferredPhoneBookSortOrderError"));

   if (error->hasCcaErrorCode() || error->hasSystemErrorCode())
   {
      ETG_TRACE_USR4(("ServiceBT::onPreferredPhoneBookSortOrderError Encountered error in Change in Sort order. Hence set sort order to First Name (default)"));
      vSetSortOrder(most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder__e8PREFERRED_SORT_ORDER_FIRSTNAME);
   }
}


void ServicePhoneBook::onPreferredPhoneBookSortOrderStatus(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::PreferredPhoneBookSortOrderStatus >& status)
{
   ETG_TRACE_USR4(("ServicePhoneBook::onPreferredPhoneBookSortOrderStatus"));
   ETG_TRACE_USR2(("onPreferredPhoneBookSortOrderStatus : %d", ETG_CENUM(btphn_tenPreferredPhnBkSortOrder, (btphn_tenPreferredPhnBkSortOrder)status->getE8PreferredPhoneBookSortOrder())));
   enSortType =
      (most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder__e8PREFERRED_SORT_ORDER_FIRSTNAME == status->getE8PreferredPhoneBookSortOrder()) ? most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType__e8PB_LIST_SORT_FIRSTNAME : most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType__e8PB_LIST_SORT_LASTNAME;
   if (ServiceTel::poGetInstance()->u8GetActiveDev() != 0)
   {
      if (BTPHN_C_LIST_HANDLE_INVALID != rContactListData.u16ListHandle)
      {
         if (status->getE8PreferredPhoneBookSortOrder() != enCurrSortOrder)
         {
            /* Delete the existing contact list data when there is a change
            in phonebook sort type */
            vDeleteContactList();
         }
      }
      /* Else if is not used here because if the contact list is deleted in
      the above if condition or if the contact list has not yet been
      created after phone connection, the below if branch has to be
      executed. */
      if (BTPHN_C_LIST_HANDLE_INVALID == rContactListData.u16ListHandle)
      {
         /* If contact list is supported and if the contact list is not
         already created, then send a request to create contact list */
         if ((TRUE == rListSupport.bContactSupport) &&
               (BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <=
                ServiceTel::poGetInstance()->u8GetActiveDev())
            )
         {
            _most_phonbk_fi->sendCreatePhoneBookListStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev(), enSortType);
         }
      }
      if ((status->getE8PreferredPhoneBookSortOrder() != enCurrSortOrder))
      {
         ETG_TRACE_USR4(("Display the call list again based on the new sort type set"));
         ///rCallListData.poWindowListHandler->vRequestForlistDataOnEntry(); ///should call suitable callist function
         // vRequestCallListData(); // function identified for above comment, Need testing .
      }
   }
   vSetSortOrder(status->getE8PreferredPhoneBookSortOrder());
   rfoPhonebookModelComponent.OnUpdSettingsList();
}


/**
* This courier message is called by controller for call list request
* @param[in] - oMsg -  courier message received
*
* @param[out]- returns true if message is consumed else false
* System Requirements : (SWFL-305, SWFL-306),SWFL-302
initial rev:Shwetha K
v 0.1 initial rev : Sai Prabha
*/
bool ServicePhoneBook::onCourierMessage(const CallListReq& oMsg)
{
   ETG_TRACE_USR3(("ServicePhoneBook : bOnCallListReq(), Received CallListReq"));
   bCurrentActiveTab = BTPHN_EN_CALLHISTORY_LIST;
   ETG_TRACE_USR3(("ServicePhoneBook : bOnCallListReq(),PBsupport status : %d", bPhonebookContactSupport));
   //Bug 680928
   std::map<tU8, tU8>::iterator it = ServicePhoneBook::poGetInstance()->m_phonebookSupportStatus.find(ServiceTel::poGetInstance()->u8GetActiveDev());
   ServicePhoneBook::poGetInstance()->bPhonebookContactSupport = it->second;

   if (NULL != ServiceBT::poGetInstance() && (!_isCabinOnly))
   {
      rfoCallHistoryModel.vClearCallListinGUI();
      if ((BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= ServiceTel::poGetInstance()->u8GetActiveDev()))
      {
         if (FALSE == bPhonebookContactSupport)
         {
            covSendCallList(0);
         }
         else
         {
            /*Connected device name is updated even before call list screen is created in some cases.
            To avoid data loss, update device name when call list is loaded*/
            if (NULL != DeviceListModel::poGetInstance())
            {
               DeviceListModel::poGetInstance()->OnUpdConnectedDeviceName(ServiceBT::poGetInstance()->szGetConnectedBTDeviceName());
            }

            /* Clearing missed call indicator, when call list view is displayed */
            if (NULL != _most_phonbk_fi)
            {
               _most_phonbk_fi->sendClearMissedCallIndicatorStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev());
            }

            ETG_TRACE_USR4(("rCallListData.u16ListHandle:%d", rCallListData.u16ListHandle));
            ETG_TRACE_USR4(("rCallListData.u16TotalListSize:%d", rCallListData.u16TotalListSize));

            if (BTPHN_C_LIST_HANDLE_INVALID != rCallListData.u16ListHandle)
            {
               if (0 == rCallListData.u16TotalListSize)
               {
                  ETG_TRACE_USR3(("CallListReq() listsize is =0"));
                  if ((most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_COMPLETE == enCallListDownloadState) ||
                        (most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_ERROR == enCallListDownloadState))
                  {
                     ETG_TRACE_USR4(("ServicePhoneBook :CallListReq :No entries in contact list"));
                     covSendCallList(0);
                  }
               }
               else
               {
                  ETG_TRACE_USR4(("ServicePhoneBook :CallListReq : Requesting call list to middleware"));
                  vRequestCallListData();
               }
            }
            // Required incase of active phones hfp is disconnected,we request for the current active phones list creation
            else if (BTPHN_C_LIST_HANDLE_INVALID == rCallListData.u16ListHandle)
            {
               ETG_TRACE_USR3(("Req for create calllist for current active phone"));
               ETG_TRACE_USR3(("ServicePhoneBook::onCourierMessage->u8GetActiveDev():%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
               _most_phonbk_fi->sendCreateCallHistoryListStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev(), (::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType)BTPHN_EN_CCH, (::most_PhonBk_fi_types::T_e8_PhonBkCallHistorySortType)rCallListData.enSortType);
            }
         }
      }
   }
   return TRUE;
}


/**
* This courier message is called by controller for ContactListReq request
* @param[in] - oMsg -  courier message received
*
* @param[out]- returns true if message is consumed else false
* System Requirements : (SWFL - 706, SWFL - 1944),SWFL-706
initial rev:Vidya
v 0.1 initial rev : Sai Prabha
*/
bool ServicePhoneBook::onCourierMessage(const ContactListReq& oMsg)
{
   ETG_TRACE_USR3(("ServicePhoneBook : ContactListReq()"));
   bCurrentActiveTab = BTPHN_EN_PHONEBOOK_LIST;
   ETG_TRACE_USR3(("ServicePhoneBook : bOnContactListReq(),PBsupport status : %d", bPhonebookContactSupport));
   ETG_TRACE_USR3(("ContactListReq- enCurrSortOrder :%d", enCurrSortOrder));
   m_u16PBcurrentlisthandle =  ServiceTel::poGetInstance()->u8GetActiveDev() * LISTHANDLE_OFFSET + enSortType;//Bug 880046
   if (!_isCabinOnly)
   {
      // retrive persistancy info from courier msg
      if (TRUE == oMsg.GetIsPersistencyRequired())
      {
         bLoadPersistent = TRUE;
         ETG_TRACE_USR4(("ServicePhoneBook : ContactListReq : bLoadPersistent is TRUE."));
      }
      else
      {
         bLoadPersistent = FALSE;
         ETG_TRACE_USR4(("ServicePhoneBook : ContactListReq : bLoadPersistent is FALSE."));
         rfoPhonebookModelComponent.vClearContactList();
      }

      if ((BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= ServiceTel::poGetInstance()->u8GetActiveDev()))
      {
         ETG_TRACE_USR3(("ContactListReq() 2<=activeDH is true:%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
         //Bug 680928
         if (FALSE == bPhonebookContactSupport)
         {
            covSendContactList(0);
         }
         else
         {
            ETG_TRACE_USR4(("ServicePhoneBook::onCreatePhoneBookListResult : rContactListData.u16ListHandle = %d", rContactListData.u16ListHandle));
            ETG_TRACE_USR4(("ServicePhoneBook::onCreatePhoneBookListResult : rContactListData.u16TotalListSize = %d", rContactListData.u16TotalListSize));
            if (rContactListData.u16ListHandle != BTPHN_C_LIST_HANDLE_INVALID)
            {
               if (0 == rContactListData.u16TotalListSize)
               {
                  ETG_TRACE_USR3(("ContactListReq() listsize is =0"));
                  /* If request for contact list is received from HMI before completion
                  of first time phonebook download, then no action is taken.
                  If phonebook download completes and there is no entry in the contact
                  list or if phonebook download error occurs, then empty list is sent
                  to HMI */

                  if ((most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_NOT_STARTED == enPhnBkDownloadState) ||
                        (most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_CONTACT_INFO == enPhnBkDownloadState)) // To be cross verified with the functionality
                  {
                     ETG_TRACE_USR4(("most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_COMPLETE,enPhnBkDownloadState:%d,%d", most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_COMPLETE, enPhnBkDownloadState));
                     POST_MSG((COURIER_MESSAGE_NEW(PhnBkDownloadStateResp)((btphn_tenPhnBkDownloadState)(enPhnBkDownloadState))));
                  }
                  else if ((most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_COMPLETE == enPhnBkDownloadState) ||
                           (most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_ERROR == enPhnBkDownloadState))
                  {
                     ETG_TRACE_USR4(("ServicePhoneBook :ContactListReq :No entries in contact list"));
                     covSendContactList(0);
                  }
               }
               else
               {
                  ETG_TRACE_USR3(("entering in the vReqContact"));
                  ETG_TRACE_USR4(("ServicePhoneBook :ContactListReq : Requesting Contact list to middleware"));
                  //Bug 880046
                  ETG_TRACE_USR4(("ServicePhoneBook::ContactListReq : m_u16PBcurrentlisthandle = %d", m_u16PBcurrentlisthandle));
                  if (m_u16PBcurrentlisthandle == rContactListData.u16ListHandle)
                  {
                     ETG_TRACE_USR4(("ServicePhoneBook::ContactListReq : vRequestContactListData called"));
                     vRequestContactListData();
                  }
                  else
                  {
                     ETG_TRACE_USR4(("ServicePhoneBook::ContactListReq - currentlisthandle is not equal to  ContactListhandle"));
                  }
               }
            }
            // Required incase of active phones hfp is disconnected,we request for the current active phones list creation
            else if ((rContactListData.u16ListHandle == BTPHN_C_LIST_HANDLE_INVALID) && (TRUE == rListSupport.bContactSupport))
            {
               ETG_TRACE_USR3(("Req for createPhonebook for current active phone"));
               ETG_TRACE_USR3(("ServicePhoneBook::onCourierMessage->u8GetActiveDev():%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
               _most_phonbk_fi->sendCreatePhoneBookListStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev(), enSortType);
            }
            else if (FALSE == rListSupport.bContactSupport)
            {
               /* If phonebook was downloaded previously but presently PBDL failure
               has occured, then empty contact list is sent to HMI */
               ETG_TRACE_USR4(("ServicePhoneBook :ContactListReq :Contact list is not supported"));

               covSendContactList(0);
            }
            else
            {
               // This block is never hit as in case of contactlist we have will valid handle, Hence execution will go to first if condition
               //TODO:Vidya :will be implemented once SearchKeyboardPhoneBookList is implemented
               const ContactListReq* copoContactListReq =
                  Courier::message_cast<const ContactListReq*>(&oMsg);
               if (NULL != copoContactListReq)
               {
                  tBool bIsPersistent =
                     copoContactListReq->GetIsPersistencyRequired();
                  if (bIsPersistent)
                  {
                     bLoadPersistent = TRUE;
                  }
                  else
                  {
                     bLoadPersistent = FALSE;
                  }
                  ETG_TRACE_USR4(("ServicePhoneBook :ContactListReq :bIsPersistent is %d bLoadPersistent is %d", bIsPersistent, bLoadPersistent));
               }
            }
         }
      }
   }
   return true;
}


/**
* This courier message is called by controller for ContactDetailsReq request
* @param[in] - oMsg -  courier message received
*
* @param[out]- returns true if message is consumed else false
* System Requirements : (SWFL- 1946)
initial rev:Vidya
*/
bool ServicePhoneBook::onCourierMessage(const ContactDetailsReq& oMsg)
{
   if (!_isCabinOnly)
   {
      ETG_TRACE_USR3(("ServicePhoneBook : bOnContactDetailsReq()"));
      std::vector<btphn_trContactInfo> arContactInfo;
      const ContactDetailsReq* copoContactDetailsReq =
         Courier::message_cast<const ContactDetailsReq*>(&oMsg);
      if (NULL != copoContactDetailsReq)
      {
         tU32 u8ContactListIndex = copoContactDetailsReq->GetContactListIndex();
         ETG_TRACE_USR3(("Contact list index : %d", u8ContactListIndex));

         if (u8ContactListIndex < arContactInfo.size())
         {
            vsendGetContactDetailsStart();
         }
      }
      else
      {
         ETG_TRACE_ERR(("ServicePhoneBook : ContactDetailsReq(), copoContactDetailsReq NULL Pointer"));
      }
   }
   return true;
}


/**
* This courier message is called whenever there is change in list or when a screen with list is loaded. it calls getListDataProvider function
* @param[in] - oMsg - ListdateProvider request courier message received
*
* @param[out]- returns true if message is consumed else false
initial rev:Shwetha K
*/
bool ServicePhoneBook::onCourierMessage(const ListDateProviderReqMsg& oMsg)
{
   if (!_isCabinOnly)
   {
      ETG_TRACE_USR4(("ServicePhoneBook : ListDateProviderReqMsg GetListId::%d", oMsg.GetListId()));
      /*updateList function is base class function which is responsible to invoking getListDataProvider method */

      switch (oMsg.GetListId())
      {
         case LISTID_CALLLIST:
            ETG_TRACE_USR4(("ServicePhoneBook : ListDateProviderReqMsg LISTID_CALLLIST"));
            /* Clearing missed call indicator, when call list view is displayed */
            if (NULL != _most_phonbk_fi)
            {
               _most_phonbk_fi->sendClearMissedCallIndicatorStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev());
            }
            /*store start index and window size as received from widget*/
            m_StartIndex_CallList = oMsg.GetStartIndex();
            m_WindowSize_CallList = oMsg.GetWindowElementSize();
            /*request for slice call list data*/
            vSendSliceCallHistoryExtendedStart(m_StartIndex_CallList, m_WindowSize_CallList);
            break;
         case LISTID_PHONECONTACTS:
            ETG_TRACE_USR4(("ServicePhoneBook : getListDataProvider LISTID_PHONECONTACTS"));
            m_PBWindowSize = oMsg.GetWindowElementSize();
            /*store start index and window size as received from widget*/
            if (TRUE == bLoadPersistent)
            {
               //m_PBStartIndex = m_U8ViewPortStartIndex;
               if (m_U8ViewPortStartIndex <= 10)
               {
                  m_PBStartIndex = 0;
               }
               else
               {
                  m_PBStartIndex = m_U8ViewPortStartIndex - 10;
               }

               ETG_TRACE_USR4(("ServicePhoneBook : getListDataProvider m_U8ViewPortStartIndex : %d m_PBStartIndex : %d", m_U8ViewPortStartIndex, m_PBStartIndex));
               m_PBWindowSize = m_PBWindowSize + m_U8ViewPortStartIndex - 	m_PBStartIndex;

               ETG_TRACE_USR4(("ServicePhoneBook : getListDataProvider new calculate m_PBWindowSize  : %d", m_PBWindowSize));
               vSendRequestPhoneBookListSliceExtendedStart(m_PBStartIndex, m_PBWindowSize);
            }
            else
            {
               m_PBStartIndex = oMsg.GetStartIndex();
               /*request for slice Phonebook list data*/
               vSendRequestPhoneBookListSliceExtendedStart(m_PBStartIndex, m_PBWindowSize);
            }
            break;
         case LISTID_PSETTING:
            ETG_TRACE_USR4(("ServicePhoneBook : getListDataProvider LISTID_PSETTING"));
            rfoPhonebookModelComponent.OnUpdSettingsList();
            break;
         case LISTID_SORTORDER:
            ETG_TRACE_USR4(("ServicePhoneBook : getListDataProvider LISTID_SORTORDER"));
            rfoPhonebookModelComponent.OnUpdSortOrder();
            break;
         default:
            ETG_TRACE_USR4(("default case for ServicePhoneBook::ListDateProviderReqMsg function "));
      }
   }
   return true;
}


/**
* This function is responsible for updating the zoom bubble when user scrolls the contact list
* @param[in] - firstchar - Character to update zoom bubble
* System Requirements : SWFL-1760
* initial rev:Varun
*/
void ServicePhoneBook::updatecharInBubble(std::string  firstchar)
{
   ETG_TRACE_USR4(("updatecharInBubble firstchar = %s", firstchar.c_str()));
   (*quickScrollSearch).mScrollSearchChar = firstchar.c_str();
   quickScrollSearch.MarkAllItemsModified();
   quickScrollSearch.SendUpdate(true);
}


/**
* This function is to get Number of Bytes taken a Character
* @param[in] - firstchar - Character to update zoom bubble
* Bug : 884735
* initial rev:Sravani K
*/
tU32 ServicePhoneBook::u32GetCharacterByteLength(tU8 u8StartByte)
{
   ETG_TRACE_USR4(("u32GetCharacterByteLength "));
   if (u8StartByte < 0xC0)	//standard ascii
   {
      return SINGLEBYTECHAR;
   }
   if (u8StartByte < 0xE0)	// 2  byte MultiByteChar
   {
      return TWOBYTECHAR;
   }
   if (u8StartByte < 0xF0)	// 3 byte MultiByteChar
   {
      return THREEBYTECHAR;
   }
   if (u8StartByte < 0xF8)	// 4 byte MultiByteChar
   {
      return FOURBYTECHAR;
   }
   if (u8StartByte < 0xFC)	// fifth bit is set, not supported unicode range
   {
      return FIVEBYTECHAR;
   }
   return SIXBYTECHAR;	// sixth bit is set, not supported unicode range
}


/**This courier message is received from widget when scrolling is started
* @param[in] - oMsg -  courier message received
*
* @param[out]- returns true if message is consumed else false
* System Requirements : (SWFL- 1760)
initial rev:Varun
**/
bool ServicePhoneBook::onCourierMessage(const ListChangedUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("onCourierMessage. . ListChangedUpdMsg"));
   if (oMsg.GetListId() == LISTID_PHONECONTACTS)
   {
      ETG_TRACE_USR4(("onCourierMessage ListChangedUpdMsg binding"));
      (*quickScrollSearch).mScrollVisible = 1;
      quickScrollSearch.MarkAllItemsModified();
      quickScrollSearch.SendUpdate(true);
   }
   return true;
}


/**
* This courier message is received from widget when scrolling is stopped
* @param[in] - oMsg -  courier message received
*
* @param[out]- returns true if message is consumed else false
* System Requirements : (SWFL- 1760)
initial rev:Varun
**/
bool ServicePhoneBook::onCourierMessage(const ListMovementFinishedUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("onCourierMessage. . ListMovementFinishedUpdMsg"));
   if (oMsg.GetListId() == LISTID_PHONECONTACTS)
   {
      ETG_TRACE_USR4(("onCourierMessage ListMovementFinishedUpdMsg binding"));
      (*quickScrollSearch).mScrollVisible = 0;
      quickScrollSearch.MarkAllItemsModified();
      quickScrollSearch.SendUpdate(true);
   }
   return true;
}


/**
* This function is responsible for updating the list supportrd status ans calling method start to create call list
* @param[in] - corfu8DeviceHandle - device handle of the device whose list support status information is provided
- corfrListSupport -	List support status. TRUE, if the list is supported. FALSE, otherwise
*
* @param[out]- returns tSharedPtrDataProvider -> shared data pointer of listimplementation
* System Requirements : (SWFL-305, SWFL-306), SWFL-302,(SWFL - 706, SWFL - 1944),SWFL-706
initial rev:Shwetha K
v 0.1 initial rev: Sai Prabha
*/
void ServicePhoneBook::vUpdateListSupportStatus(tRCU8 corfu8DeviceHandle, const btphn_trPhnBkListSupport& corfrListSupport)
{
   ETG_TRACE_USR4(("ServicePhoneBook : vUpdateListSupportStatus"));
   ETG_TRACE_USR4(("Device handle : %d", corfu8DeviceHandle));
   bCallListSupportStatus = PBCL_SUPPORTED;

   /* Update the support status of the lists if there is a match in the
   device handle */
   if ((corfu8DeviceHandle == ServiceTel::poGetInstance()->u8GetActiveDev()))//&&
      // (BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= corfu8DeviceHandle))
   {
      rContactListData.u16ListHandle = BTPHN_C_LIST_HANDLE_INVALID ;
      rCallListData.u16ListHandle = BTPHN_C_LIST_HANDLE_INVALID;
      ETG_TRACE_USR4(("ServicePhoneBook : vUpdateListSupportStatus Device Handle matched to %d", ServiceTel::poGetInstance()->u8GetActiveDev()));
      rListSupport = corfrListSupport;

      if (DP_FIRST_NAME == PhoneDataPoolConfig::getInstance()->getDpPhoneSortOrderValue())
      {
         enSortType = most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType__e8PB_LIST_SORT_FIRSTNAME;
      }
      else
      {
         enSortType = most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType__e8PB_LIST_SORT_LASTNAME;
      }

      if (NULL != _most_phonbk_fi)
      {
         ETG_TRACE_USR4(("ServicePhoneBook vUpdateListSupportStatus:rContactListData.u16ListHandle = %d", rContactListData.u16ListHandle));
         ETG_TRACE_USR4(("ServicePhoneBook vUpdateListSupportStatus:rCallListData.u16ListHandle = %d", rCallListData.u16ListHandle));
         ETG_TRACE_USR4(("ServicePhoneBook vUpdateListSupportStatus:enSortType = %d", enSortType));
         if ((BTPHN_C_LIST_HANDLE_INVALID == rContactListData.u16ListHandle)
               &&
               ((most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType__e8PB_LIST_SORT_FIRSTNAME == enSortType)
                ||
                (most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType__e8PB_LIST_SORT_LASTNAME == enSortType)))

         {
            ETG_TRACE_USR4(("ServicePhoneBook : vUpdateListSupportStatus ::sendCreatePhoneBookListStart "));
            _most_phonbk_fi->sendCreatePhoneBookListStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev(), enSortType);
         }
         /* Request to create combined call history list, if supported */
         if (BTPHN_C_LIST_HANDLE_INVALID == rCallListData.u16ListHandle || rCallListData.u16ListHandle == 0)
         {
            if (TRUE == rListSupport.bCallListSupport[BTPHN_EN_CCH])
            {
               ETG_TRACE_USR4(("CCH list is supported"));
               rCallListData.enSortType = BTPHN_EN_CH_SORT_DATETIME;// default sort type is by date
               ETG_TRACE_USR4(("Call history list sort type : %d", rCallListData.enSortType));
               /*call method start to create combined call call history list*/
               _most_phonbk_fi->sendCreateCallHistoryListStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev(), (::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType)BTPHN_EN_CCH, (::most_PhonBk_fi_types::T_e8_PhonBkCallHistorySortType)rCallListData.enSortType);
            }
            else
            {
               bCallListSupportStatus = PBCL_NOT_SUPPORTED;
               ETG_TRACE_USR4(("CallListSupportStatus is %d", bCallListSupportStatus));
               /* Sending empty call list to HMI if CCH list is not supported */
               covSendCallList(0); //where 0 corresponds to list size
            }
         }
         /* If CCH list was previously supported and if later CCH list is not
         supported, then the CCH list will be deleted by FC_PhoneBook.
         Hence CCH list data maintained in HMI is also cleared */
         else if ((BTPHN_C_LIST_HANDLE_INVALID != rCallListData.u16ListHandle) &&
                  (FALSE == rListSupport.bCallListSupport[BTPHN_EN_CCH]))
         {
            ETG_TRACE_USR4(("CallListSupportStatus is else if ((BTPHN_C_LIST_HANDLE_INVALID != rCallListData.u16ListHandle) &&"));
            vDeleteCallList();
         }
      }
   }
}


/**
* This function request service to provide one slice of entries from Call History List.
* @param[in] - startIndex - start index of the list required
- WindowSize -	window size of the slice
*
* @param[out]- returns void
initial rev:Shwetha K
*/
void ServicePhoneBook::vSendSliceCallHistoryExtendedStart(int startIndex, int WindowSize)
{
   ETG_TRACE_USR4(("vSendSliceCallHistoryExtendedStart startIndex =%d , WindowSize =%d", startIndex, WindowSize));
   m_lastItemIndex_CallList = AppHmiPhone_Helper::vCalculateWindowSize(startIndex, WindowSize, rCallListData.u16TotalListSize);
   ETG_TRACE_USR4(("vSendSliceCallHistoryExtendedStart startIndex =%d ,m_lastItemIndex_CallList =%d", startIndex, m_lastItemIndex_CallList));
   if (BTPHN_C_LIST_HANDLE_INVALID != rCallListData.u16ListHandle)
   {
      if (NULL != _most_phonbk_fi)
      {
         _most_phonbk_fi->sendRequestSliceCallHistoryListExtendedStart(*this, rCallListData.u16ListHandle, startIndex, WindowSize);
      }
   }
}


/**
* This function request service to provide one slice of entries from Phonebook list.
* @param[in] - startIndex - start index of the list required
- WindowSize -	window size of the slice
*
* @param[out]- returns void
initial rev:Vidya
*/
void ServicePhoneBook::vSendRequestPhoneBookListSliceExtendedStart(int startIndex, int WindowSize)
{
   m_lastItemIndex_PBList = AppHmiPhone_Helper::vCalculateWindowSize(startIndex, WindowSize, rContactListData.u16TotalListSize);
   if (BTPHN_C_LIST_HANDLE_INVALID != rContactListData.u16ListHandle)
   {
      ETG_TRACE_USR4(("ServicePhoneBook::vSendRequestPhoneBookListSliceExtendedStart startIndex= %d WindowSize =%d ", startIndex, WindowSize));
      if (NULL != _most_phonbk_fi)
      {
         _most_phonbk_fi->sendRequestPhoneBookListSliceExtendedStart(*this, rContactListData.u16ListHandle, startIndex, WindowSize);
      }
   }
}


/**
* This function request service to provide detailed contact list of selected contact.
* @param[out]- returns void
* System Requirements : (SWFL- 1946)
initial rev:Vidya
*/
void ServicePhoneBook::vsendGetContactDetailsStart()
{
   ETG_TRACE_USR4(("ServicePhoneBook::vsendGetContactDetailsStart -> contact handle = %d", mContacthandle));
   if (NULL != _most_phonbk_fi)
   {
      _most_phonbk_fi->sendGetContactDetailsExtendedStart(*this, mContacthandle);
   }
}


/**
* This function requests for  Call history list data
* @param[in] - void
*
* @param[out]- returns void
* System Requirements : (SWFL-305, SWFL-306)
initial rev:Shwetha K
v 0.1 initial rev : Sai Prabha
*/
void ServicePhoneBook::vRequestCallListData()
{
   ETG_TRACE_USR4(("ServicePhoneBook::vRequestCallListData"));
   /*when total list size is 0 and if the download status is not started or there is error in download or if download is complete then display No list item */
   if (rCallListData.u16ListHandle != BTPHN_C_LIST_HANDLE_INVALID)
   {
      ETG_TRACE_USR4(("ServicePhoneBook::vRequestCallListData():download state is: %d", enCallListDownloadState));

      if ((0 == rCallListData.u16TotalListSize)
            && ((most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_COMPLETE == enCallListDownloadState) ||
                (most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_ERROR == enCallListDownloadState)))
      {
         ETG_TRACE_USR4(("No entries in call history list"));
         covSendCallList(rCallListData.u16TotalListSize);// Total list size
         return;
      }
      else if ((most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_COMPLETE == enCallListDownloadState) ||
               ((most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_IN_PROCESS == enCallListDownloadState) &&
                (BTPHN_C_PHNBKLIST_WINDOW_SIZE <= rCallListData.u16TotalListSize)))
      {
         if (BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= ServiceTel::poGetInstance()->u8GetActiveDev())
         {
            /* Fetching the timestamp support information for
            call history list */
            if (NULL != _most_phonbk_fi)
            {
               ETG_TRACE_USR4(("ServicePhoneBook::vRequestCallListData:Req to start sendGetDeviceCallHistorySupportStart"));
               _most_phonbk_fi->sendGetDeviceCallHistorySupportStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev());
            }
         }
      }
   }

   /*request for slice call list
    If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided
   in the slice will be less than the WindowSize calling parameter */
   m_StartIndex_CallList = BTPHN_C_VALUE_ZERO;
   vSendSliceCallHistoryExtendedStart(m_StartIndex_CallList, m_WindowSize_CallList);
}


/**
* This function requests for  PhoneBook list data
* @param[in] - void
*
* @param[out]- returns void
* System Requirements : (SWFL - 706, SWFL - 1944)
initial rev:Sai Prabha
*/
void ServicePhoneBook::vRequestContactListData()
{
   ETG_TRACE_USR4(("ServicePhoneBook::vRequestContactListData"));
   ETG_TRACE_USR4(("ServicePhoneBook::vRequestContactListData():download state is: %d", enPhnBkDownloadState));
   if (false == rListSupport.bContactSupport || rContactListData.u16TotalListSize == 0)
   {
      ETG_TRACE_USR4(("Contact list is not supported"));
      m_PBStartIndex = BTPHN_C_VALUE_ZERO;
      covSendContactList(0);
      return;
   }
   if (bLoadPersistent == false)
   {
      m_PBStartIndex = BTPHN_C_VALUE_ZERO;
   }
   if ((0 == rContactListData.u16TotalListSize) &&
         ((most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_COMPLETE == enPhnBkDownloadState) ||
          (most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_ERROR == enPhnBkDownloadState)))

   {
      ETG_TRACE_USR4(("vRequestContactListData::No entries in Contact list"));
      m_PBStartIndex = BTPHN_C_VALUE_ZERO;
      covSendContactList(rContactListData.u16TotalListSize);// Total list size
      return;
   }
   else
   {
      if (0 != rContactListData.u16TotalListSize)

      {
         ETG_TRACE_USR4(("Request to start method RequestPhoneBookListSliceExtendedStart - Requesting with existing start index m_PBStartIndex: %d m_PBWindowSize : %d", m_PBStartIndex, m_PBWindowSize));

         // as the list size is not empty, request it with existing start index
         // as request is place at end of the function removing it from this scope
         vSendRequestPhoneBookListSliceExtendedStart(m_PBStartIndex, m_PBWindowSize);
      }
   }
}


/**
* This function updates Call list size as received to model and controller
* @param[in] - corfu16TotalListSize - list size to be updated to GUI
*
* @param[out]- returns void
* System Requirements : (SWFL-305, SWFL-306),SWFL-302
initial rev:Shwetha K
*/
void ServicePhoneBook::covSendCallList(tU16 corfu16TotalListSize)
{
   ETG_TRACE_USR4(("ServicePhoneBook : covSendCallList"));
   ETG_TRACE_USR4(("Total list size : %d", corfu16TotalListSize));

   POST_MSG((COURIER_MESSAGE_NEW(CallListWindowResp)(corfu16TotalListSize, BTPHN_C_PHNBKLIST_WINDOW_SIZE)));
   rfoCallHistoryModel.OnUpdCallListSizeToModel(corfu16TotalListSize);
}


/**
* This function updates Phonebook list size as received to model and controller
* @param[in] - corfu16TotalListSize - list size to be updated to GUI
*
* @param[out]- returns void
* System Requirements : (SWFL - 706, SWFL - 1944), SWFL-706
initial rev:Vidya
*/
void ServicePhoneBook::covSendContactList(tU16 corfu16TotalListSize)
{
   ETG_TRACE_USR4(("ServicePhoneBook : covSendContactDetails"));
   ETG_TRACE_USR4(("Total list size : %d", corfu16TotalListSize));

   POST_MSG((COURIER_MESSAGE_NEW(ContactListWindowResp)(corfu16TotalListSize, BTPHN_C_PHNBKLIST_WINDOW_SIZE)));
   rfoPhonebookModelComponent.OnUpdContactListSizeToModel(corfu16TotalListSize);
}


/************************************************************************
*FUNCTION: 		 vDeleteAllLists
*DESCRIPTION: 	 Deletes all the lists maintained by ServicePhoneBook namely
*					 Call history list, Match list and Contacts list
*
*PARAMETER:     None
*RETURNVALUE: 	 tVoid
*
*HISTORY:
*
*Rev 0.1 Initial Revision.
************************************************************************/

tVoid ServicePhoneBook::vDeleteAllLists()
{
   ETG_TRACE_USR4(("ServicePhoneBook : vDeleteAllLists()"));

   /* Setting the list support status to FALSE when the device is
   disconnected */
   rListSupport.bContactSupport = FALSE;
   memset(rListSupport.bCallListSupport, 0, BTPHN_C_CALL_LIST_COUNT);
   rListSupport.bTimestampSupport = FALSE;
   arMatchList.clear();
   /* Deleting the contact list and call list */
   vDeleteContactList();
   vDeleteCallList();
}


/******************************************************
* This function clears call history list.
* @param[in] - void
*
* @param[out]- returns void
* System Requirements : SWFL-302
initial rev:Shwetha K
************************************************************/
void ServicePhoneBook::vDeleteCallList()
{
   ETG_TRACE_USR4(("ServicePhoneBook : vDeleteCallList()"));
   rCallListData.u16TotalListSize = BTPHN_C_DEFAULT_VALUE_ZERO;
   m_lastItemIndex_CallList = BTPHN_C_DEFAULT_VALUE_ZERO;
   if (rCallListData.u16ListHandle != BTPHN_C_LIST_HANDLE_INVALID)
   {
      ETG_TRACE_USR4(("ServicePhoneBook : vDeleteCallList(): sending release list for list handle %d", rCallListData.u16ListHandle));
      /*request for releasing the current call history list*/
      if (NULL != _most_phonbk_fi)
      {
         _most_phonbk_fi->sendReleaseCallHistoryListStart(*this, rCallListData.u16ListHandle);
      }
   }
   rCallListData.u16ListHandle = BTPHN_C_LIST_HANDLE_INVALID;
   bContactInfoRequired = FALSE;
   vSetCallListDownloadState(most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_NOT_STARTED);

   //Logic to display No Entries in CallList
   POST_MSG((COURIER_MESSAGE_NEW(CallListWindowResp)(0, BTPHN_C_PHNBKLIST_WINDOW_SIZE))); //Bug 680928
}


/**
* This function clears call history list.
* @param[in] - void
*
* @param[out]- returns void
* System Requirements : SWFL-706
initial rev:Vidya
*/
void ServicePhoneBook::vDeleteContactList()
{
   m_PBStartIndex = BTPHN_C_VALUE_ZERO;
   rContactListData.u16TotalListSize = BTPHN_C_DEFAULT_VALUE_ZERO;
   m_lastItemIndex_PBList = BTPHN_C_DEFAULT_VALUE_ZERO;
   if (rContactListData.u16ListHandle != BTPHN_C_LIST_HANDLE_INVALID)
   {
      /*request for releasing the current call history list*/
      if (NULL != _most_phonbk_fi)
      {
         _most_phonbk_fi->sendReleasePhoneBookListStart(*this, rContactListData.u16ListHandle);
      }
   }
   rContactListData.u16ListHandle = BTPHN_C_LIST_HANDLE_INVALID;
   //arContactListSlice.clear();
   enPhnBkDownloadState = most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended__e8PBDS_NOT_STARTED;
   POST_MSG((COURIER_MESSAGE_NEW(ContactListWindowResp)(0, BTPHN_C_PHNBKLIST_WINDOW_SIZE)));//Bug 680928
}


/**
* This function sets enCallListDownload state.
* @param[in] - void
*
* @param[out]- returns void
initial rev:Shwetha K
*/
void ServicePhoneBook::vSetCallListDownloadState(most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended CallListDownloadState)
{
   ETG_TRACE_USR2(("ServicePhoneBook:  vSetCallListDownloadState, setting callList download state to = %d\n", CallListDownloadState));
   enCallListDownloadState = CallListDownloadState;
}


/**
* This function returns CallListDownload state for the connected device
* @param[in] - void
*
* @param[out]- returns void
initial rev:Shwetha K
*/
most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended ServicePhoneBook::enGetCallListDownloadState()
{
   ETG_TRACE_USR2(("ServicePhoneBook:  vSetConnectedDeviceHandle, callList download state = %d\n", enCallListDownloadState));
   return enCallListDownloadState;
}


/**************************************************************************
* This courier message is called when list item is pressed.
* This function extracts the list id, list row value and list col value from which the button reaction  message is triggered.
* It calls list specific implementation for each list from which button reacton is posted
* @param[in] - oMsg -  courier message received
*
* @param[out]- returns true if message is consumed else false
initial rev:Vidya
**************************************************************************/
bool ServicePhoneBook::onCourierMessage(const ButtonReactionMsg& oMsg)
{
   bool retVal = false;
   //Based on the Sender parameter of the ButtonReactionMsg we can determine if the button is part of list item inside a FlexListWidget2D.
   //For those buttons we can obtain ListId, HdlRow, HdlCol and Flags which were associated to that ListItem.
   if (!_isCabinOnly)
   {
      ListProviderEventInfo info;
      //If any new list id should be handled here, then add it in if condition below.
      ETG_TRACE_USR4(("ServicePhoneBook :: ButtonReactionMsg"));
      if (oMsg.GetEnReaction() == enRelease)
      {
         //ListProviderEventInfo::GetItemIdentifierInfo(oMsg.GetSender(), info);
         ETG_TRACE_USR4(("ServicePhoneBook :: ButtonReactionMsg:enRelease"));
         //ETG_TRACE_USR4(("BTSettingListHandler:ButtonReactionMsg Listid : %d, HdlRow : %d, hdlCol : %d", listId, hdlRow, hdlCol));
         if (ListProviderEventInfo::GetItemIdentifierInfo(oMsg.GetSender(), info))
         {
            unsigned int listId = info.getListId();
            tU32 hdlRow = info.getHdlRow();     // normally the index
            tU32 hdlCol = info.getHdlCol();

            if ((listId != 0u) && (oMsg.GetEnReaction() == enRelease))
            {
               unsigned int ddListId;
               Candera::DropdownChangeType ddChange;
               //clicking expandable items should toggle their associated sublists which have the id stored inside hdlCol
               if ((info.getFlags() & ListDataProviderBuilder::ListItem::Expandable) == ListDataProviderBuilder::ListItem::Expandable)
               {
                  ETG_TRACE_USR4(("ServicePhoneBook :: if expandable"));
                  //ddListId = static_cast<unsigned int>(hdlCol);
                  ddListId = LISTID_SORTORDER;
                  ddChange = Candera::DropdownChangeToggle;
               }
               //clicking non expandable items should close their parent list (assuming that it is a dropdown list)
               else
               {
                  ETG_TRACE_USR4(("ServicePhoneBook :: else expandable"));
                  //ddListId = listId;
                  ddListId = LISTID_SORTORDER;
                  ddChange = Candera::DropdownChangeClose;
               }

               DropdownChangeMsg* ddToggleMsg = COURIER_MESSAGE_NEW(DropdownChangeMsg)(ddChange, ddListId);
               if (ddToggleMsg != NULL)
               {
                  ETG_TRACE_USR4(("ServicePhoneBook :: post DropdownChangeMsg "));
                  ddToggleMsg->Post();
               }
            }

            // the list id for generic access
            // if more than 1 active element in one list row, e.g. Button in a button line
            ETG_TRACE_USR4(("ServicePhoneBook:ButtonReactionMsg Listid : %d, HdlRow : %d, hdlCol : %d", listId, hdlRow, hdlCol));
            //Send update to GUI that list item is released
            //ETG_TRACE_USR4(("Posting on enRelease"));
            switch (listId)
            {
               case LISTID_PHONECONTACTS:
               {
                  POST_MSG((COURIER_MESSAGE_NEW(ButtonListItemUpdMsg)(listId, hdlRow, hdlCol, oMsg.GetEnReaction())));
                  vGetContacthandle(hdlRow);
                  IsContactListPersistent = BTPHN_C_VALUE_ONE;
                  /* viewport start index to show the list such that the item that was selected is shown in the
                  second position of the view port when we go to contact screen*/
                  /* below code is commented as a part of Bug 864070. When first contact in the list is selected and navigate to contact details and switch back to the list the contact item selected should always be at top.
                     if (hdlRow == 0)
                     {
                        m_U8ViewPortStartIndex = 0;
                     }
                     else
                     {
                        m_U8ViewPortStartIndex = hdlRow - 1;
                     }*/
                  m_U8ViewPortStartIndex = hdlRow; // fix for  864070
                  ETG_TRACE_USR4(("ServicePhoneBook:ButtonReactionMsg m_U8ViewPortStartIndex is %d", m_U8ViewPortStartIndex));
                  retVal = true;
                  break;
               }
               case LISTID_DIALPADMATCHLIST:
               {
                  ETG_TRACE_USR4(("ServiceBT : on ButtonReactionMsg(): LISTID_DIALPADMATCHLIST"));
                  vMatchListItemInfo(hdlRow);
                  retVal = true;
                  break;
               }
               case LISTID_CALLLIST:
               {
                  ETG_TRACE_USR4(("ServiceBT : on ButtonReactionMsg(): LISTID_CALLLIST"));
                  vCallListItemInfo(hdlRow);
                  retVal = true;
                  break;
               }
               case LISTID_PSETTING:
               {
                  uint16 u16VehicleType = VEHICLETYPE_TRUCK;
                  //Read VehicleType from KDS and register for the MSG services based on the Vehicletype value
                  if (PhoneDataPoolConfig::getInstance())
                  {
                     ETG_TRACE_FATAL(("ServiceMsg:: Retrive vehicleType information from KDS"));
                     u16VehicleType = PhoneDataPoolConfig::getInstance()->getKDSVehicleType();
                     ETG_TRACE_FATAL(("ServiceMsg:: getKDSVehicleType, Vehicle type : %d", u16VehicleType));
                  }
                  else
                  {
                     ETG_TRACE_FATAL(("ServiceMsg:: Error in getting PhoneDataPoolConfig instance"));
                  }
                  // MSG services are available only when vehicle variant is other than Smart
                  if (VEHICLETYPE_SMART != u16VehicleType)
                  {
                     ETG_TRACE_USR4(("ServicePhoneBook : on ButtonReactionMsg(): LISTID_PSETTING coach"));
                     vSettingListInfoCoach(hdlRow);
                     retVal = true;
                     break;
                  }
                  else
                  {
                     ETG_TRACE_USR4(("ServicePhoneBook : on ButtonReactionMsg(): LISTID_PSETTING"));
                     vSettingListInfoSmart(hdlRow);
                     retVal = true;
                     break;
                  }
               }
               case LISTID_SORTORDER:
               {
                  ETG_TRACE_USR4(("ServiceBT : on ButtonReactionMsg(): LISTID_SORTORDER"));
                  POST_MSG((COURIER_MESSAGE_NEW(ButtonListItemUpdMsg)(listId, hdlRow, hdlCol, oMsg.GetEnReaction())));
                  vSortOrderList(hdlRow);
                  retVal = true;
                  break;
               }
               default:
                  ETG_TRACE_USR4(("inside default"));
            }
         }
      }
   }
   return retVal;
}


/**************************************************************************
* This function uses the row value from Button reaction message and makes uses in calling the method start for detailed contact list
* @param[in]  -  rowvalue
*
* @param[out]- returns void
* System Requirements : (SWFL- 1946)
initial rev:Vidya
**************************************************************************/

void ServicePhoneBook::vGetContacthandle(tU32 rowvalue)
{
   ETG_TRACE_USR4(("ServicePhoneBook :: vGetContacthandle  rowvalue= %d", rowvalue));
   if (m_PBStartIndex > rowvalue > m_lastItemIndex_PBList)
   {
      ETG_TRACE_ERR(("Invalid Match List index = %d, m_PBStartIndex =%d  m_lastItemIndex_PBList=%d",
                     rowvalue, m_PBStartIndex, m_lastItemIndex_PBList));
      return;
   }
   /*call method start to receive slice of 1 with the requested row value*/
   _most_phonbk_fi->sendRequestPhoneBookListSliceStart(*this, rContactListData.u16ListHandle, rowvalue, 1);
}


/**************************************************************************
* This function uses the row value from Button reaction message and calls method start to place call to the number in the row
* @param[in]   rowvalue in the list
listId-> list id of the list( dialpad match list)
*
* @param[out]- returns void
initial rev:Shwetha K
**************************************************************************/
tVoid ServicePhoneBook::vMatchListItemInfo(tU8 hdlRow)
{
   if (hdlRow >= rfoSpellerModel.u8GetMatchListSize())
   {
      ETG_TRACE_ERR(("Invalid Match List index = %d", hdlRow));
      return;
   }
   if (NULL != ServiceTel::poGetInstance())
   {
      if ((BTPHN_C_EQUAL != arMatchList[hdlRow].copcPhoneNumber.compare("")) &&
            (FALSE == ServiceTel::poGetInstance()->bGetDialTimer()))
      {
         ETG_TRACE_ERR(("Calling number = %s", arMatchList[hdlRow].copcPhoneNumber.c_str()));
         /* Sending the phone number to telservice for placing a call */
         ServiceTel::poGetInstance()->vSendDialCallMethodStart(arMatchList[hdlRow].copcPhoneNumber, BTPHN_EN_ECNR_NOCHANGE);
      }
   }
}


/**************************************************************************
* This function uses the row value from Button reaction message and calls method start to place call to the number in the row
* @param[in]   rowvalue in the list
listId-> list id of the list( call list)
*
* @param[out]- returns void
* System Requirements : (SWFL-305, SWFL-306)
initial rev:Shwetha K
**************************************************************************/
tVoid ServicePhoneBook::vCallListItemInfo(tU8 hdlRow)
{
   if (m_StartIndex_CallList > hdlRow > m_lastItemIndex_CallList)
   {
      ETG_TRACE_ERR(("Invalid Match List index = %d, m_StartIndex_CallList =%d  m_lastItemIndex_CallList=%d",
                     hdlRow, m_StartIndex_CallList, m_lastItemIndex_CallList));
      return;
   }
   if (NULL != ServiceTel::poGetInstance())
   {
      if (FALSE == ServiceTel::poGetInstance()->bGetDialTimer())
      {
         bReqCallListDialInfo = TRUE;
         _most_phonbk_fi->sendRequestSliceCallHistoryListStart(*this, rCallListData.u16ListHandle, hdlRow, 1);
      }
   }
}


/**************************************************************************
* This function uses the row value from Button reaction message and calls method start to place call to the number in the row
* @param[in]   rowvalue in the list
listId-> list id of the list( call list)
*
* @param[out]- returns void
initial rev:Shwetha K
**************************************************************************/
tVoid ServicePhoneBook::vSettingListInfoCoach(tU8 hdlRow)
{
   if (hdlRow >= 3)
   {
      ETG_TRACE_ERR(("Invalid Setting List index = %d", hdlRow));
      return;
   }

   else if (hdlRow == 0)
   {
      if (NULL != ServiceMsg::poGetInstance())
      {
         // list update trigger in MSGModelComponent::OnUpdChangeSMSSettingsReq method call
         ServiceMsg::poGetInstance()->vOnChangeSMSSettings();
      }
   }
   else if (hdlRow == 1)
   {
      tU8 u8RingToneID = rfoPhonebookModelComponent.u8GetUsePhoneRingtone();// data model is always updated with latest from BT
      ETG_TRACE_USR4(("vSettingListInfo : previous settings RingToneID: %d", u8RingToneID));

      if (BTPHN_C_CHECKED == u8RingToneID)
      {
         u8RingToneID = BTPHN_C_VALUE_TWO;
      }
      else
      {
         u8RingToneID = BTPHN_C_VALUE_ONE;
      }
      if (NULL != ServiceBT::poGetInstance())
      {
         ETG_TRACE_USR4(("vSettingListInfo : requesting for change in ringtone from HMI -  RingToneID: %d", u8RingToneID));
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
         ServiceBT::poGetInstance()->vSetChangeRingtone(u8RingToneID);
#else
         ServiceTel::poGetInstance()->vSetRingtone(u8RingToneID);
#endif
      }

      // updating the settings list
      ListRegistry::s_getInstance().updateList(LISTID_PSETTING);
   }
   else if (hdlRow == 2)
   {
      ETG_TRACE_USR4(("vSettingListInfoCoach : requesting for change sort order from HMI "));
      // settings list updated on selection made in dropdown
      rfoPhonebookModelComponent.OnUpdSortOrder();
   }
}


/**************************************************************************
* This function uses the row value from Button reaction message and calls method start to place call to the number in the row
* @param[in]   rowvalue in the list
listId-> list id of the list( call list)
*
* @param[out]- returns void
initial rev:Shwetha K
**************************************************************************/
tVoid ServicePhoneBook::vSettingListInfoSmart(tU8 hdlRow)
{
   if (hdlRow >= 2)
   {
      ETG_TRACE_ERR(("vSettingListInfoSmart:Invalid Setting List index = %d", hdlRow));
      return;
   }
   else if (hdlRow == 0)
   {
      tU8 u8RingToneID = rfoPhonebookModelComponent.u8GetUsePhoneRingtone();// data model is always updated with latest from BT
      ETG_TRACE_USR4(("vSettingListInfoSmart : previous settings RingToneID: %d", u8RingToneID));

      if (BTPHN_C_CHECKED == u8RingToneID)
      {
         u8RingToneID = BTPHN_C_VALUE_TWO;
      }
      else
      {
         u8RingToneID = BTPHN_C_VALUE_ONE;
      }
      if (NULL != ServiceBT::poGetInstance())
      {
         ETG_TRACE_USR4(("vSettingListInfoSmart : requesting for change in ringtone from HMI -  RingToneID: %d", u8RingToneID));
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
         ServiceBT::poGetInstance()->vSetChangeRingtone(u8RingToneID);
#else
         ServiceTel::poGetInstance()->vSetRingtone(u8RingToneID);
#endif
      }

      // updating the settings list
      ListRegistry::s_getInstance().updateList(LISTID_PSETTING);
   }
   else if (hdlRow == 1)
   {
      ETG_TRACE_USR4(("vSettingListInfoSmart : requesting for change sort order from HMI "));
      // settings list updated on selection made in dropdown
      rfoPhonebookModelComponent.OnUpdSortOrder();
   }
}


/**************************************************************************
* This function uses the row value from Button reaction message and calls method start to place call to the number in the row
* @param[in]   rowvalue in the list
listId-> list id of the list( call list)
*
* @param[out]- returns void
initial rev:Shwetha K
**************************************************************************/
tVoid ServicePhoneBook::vSortOrderList(tU8 hdlRow)
{
   if (hdlRow >= 2)
   {
      ETG_TRACE_ERR(("Invalid Sort List index = %d", hdlRow));
      return;
   }

   else if (hdlRow == 0)
   {
      ETG_TRACE_USR4(("Sort order set to first name"));
      OnSortPhonebook(BTPHN_EN_PREFERRED_SORT_ORDER_FIRSTNAME);
      PhonebookModelComponent::poGetInstance()->vSetSortOrder(BTPHN_C_SORT_FIRST_NAME, false);
   }
   else if (hdlRow == 1)
   {
      ETG_TRACE_USR4(("Sort order set to last name"));
      OnSortPhonebook(BTPHN_EN_PREFERRED_SORT_ORDER_LASTNAME);
      PhonebookModelComponent::poGetInstance()->vSetSortOrder(BTPHN_C_SORT_LAST_NAME, true);
   }

   // updating HMI if there is an error in setting sort, we will set the value to default on middleware error resp
   PhonebookModelComponent::poGetInstance()->OnUpdSettingsList();
}


bool ServicePhoneBook::onCourierBindingItemChange_PhoneDialPadInputTextItem(const Courier::Request& request)
{
   oDialPadInputText.SetValue(request.ItemKey(), request.GetItemValue());
   oDialPadInputText.MarkItemModified(ItemKey::EntryText::TextItem);
   oDialPadInputText.SendUpdate(true);
   SECURE_FEATSTD_STRING_ACCESS_BEGIN((*oDialPadInputText).mText);
   std::string sDTMFNumber = (*oDialPadInputText).mText.GetCString();// locks the access of GetCString within this scope
   ETG_TRACE_USR4(("String is: %s", sDTMFNumber.c_str()));
   SECURE_FEATSTD_STRING_ACCESS_END()

   if ((BTPHN_C_VALUE_ONE == IsDTMFActive) &&	(BTPHN_C_VALUE_HUNDRED > KeyPressed.length()))
   {
      if (NULL != ServiceTel::poGetInstance())
      {
         ServiceTel::poGetInstance()->vSendDTMFStart(sDTMFNumber);
      }
   }
   return true;
}


void ServicePhoneBook::onRemoteControlKeyPress(std::string inputStr)
{
   ETG_TRACE_USR4(("ServicePhoneBook : onRemoteControlDialPadKeyPress( %s ) ", inputStr.c_str()));
   (*oDialPadInputText).mText = inputStr.c_str();
   oDialPadInputText.SendUpdate(true);
}


bool ServicePhoneBook::onCourierMessage(const hmibase::widget::editfield::EditFieldUpdMsg& oMsg)
{
   if (oMsg.GetViewId() == :: Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad"))
   {
      KeyPressed = oMsg.GetText().GetCString();//getcstring returns char*

      if ((BTPHN_C_VALUE_ZERO == IsDTMFActive) && (BTPHN_C_VALUE_HUNDRED > KeyPressed.length()))
      {
         vSendAutoCompletePhoneNumber(KeyPressed);
      }
      //updateSpellerEditField(KeyPressed);
      ETG_TRACE_USR4(("mText :%s", oMsg.GetText().GetCString()));
      if ((BTPHN_C_VALUE_ZERO == strcmp(KeyPressed.c_str(), BTPHN_C_BT_NULL)))
      {
         arMatchList.clear();
         rfoSpellerModel.vSetMatchListElements(0, arMatchList);
      }
      return true ;
   }
   else
   {
      return false;
   }
}


/************************************************************************
*FUNCTION: ServicePhoneBook::onCourierMessage(SpellerKeyPressed)
*DESCRIPTION : Invoked when cobSpellerKeyPressed message updated by Speller
*			  Widget.Updating Pressed key
*PARAMETER :
*corfoMsg : (I)
* 					Courier message from the Message Router
*RETURNVALUE : Bool
*HISTORY :
* System Requirements : (SWFL-278, SWFL-279, SWFL-285, SWFL-292, SWFL-1953, SWFL-1961, SWFL-270, SWFL-283, SWFL-299)
*05.01.18 Rev. 0.1 Shwetha K
* 		  Initial Revision.
************************************************************************/
bool ServicePhoneBook::onCourierMessage(const SpellerKeyPressed& oMsg)
{
   ETG_TRACE_USR4(("ServicePhoneBook : onCourierMessage(SpellerKeyPressed)"));
   //Bool bRetValue = FALSE;
   /* Getting keystatus */
   std::string  KeyPressed = oMsg.GetKeyChar().GetCString();//getcstring returns char*

   bool bRetVal = false;
   strEditInfo = rfoSpellerModel.strGetEntryText();
   ETG_TRACE_USR4(("Entered value is strEditString: %s", strEditInfo.c_str()));
   if ((KeyPressed != BTPHN_C_SPELLER_DELETE_STRING) &&
         (KeyPressed != BTPHN_C_SPELLER_DELETE_ALL_STRING) &&
         (BTPHN_C_VALUE_HUNDRED > strEditInfo.length()))
   {
      strEditInfo = strEditInfo + KeyPressed;
   }
   else if ((strcmp(strEditInfo.c_str(), BTPHN_C_BT_NULL) != BTPHN_C_VALUE_ZERO) && (KeyPressed == BTPHN_C_SPELLER_DELETE_STRING))
   {
      strEditInfo = strEditInfo.substr(BTPHN_C_VALUE_ZERO, strEditInfo.length() - BTPHN_C_VALUE_ONE);
   }
   else if ((BTPHN_C_VALUE_ZERO != strcmp(strEditInfo.c_str(), BTPHN_C_BT_NULL)) && (KeyPressed == BTPHN_C_SPELLER_DELETE_ALL_STRING))
   {
      strEditInfo = BTPHN_C_BT_NULL;
   }
   //Added below loop to clear the match list when dialpad input field is cleared(Dialpad New PSD CRQ)
   if ((BTPHN_C_VALUE_ZERO == strcmp(strEditInfo.c_str(), BTPHN_C_BT_NULL)))
   {
      arMatchList.clear();
      rfoSpellerModel.vSetMatchListElements(0, arMatchList);
   }
   rfoSpellerModel.OnUpdEntryText(strEditInfo);

   /*uncomment IsDTMFActive when call feature is implemeted */
   if ((BTPHN_C_VALUE_ONE == IsDTMFActive) &&	(BTPHN_C_VALUE_HUNDRED > strEditInfo.length()))
   {
      /* Valid Char Set Updated to enable the digits of Dialpad in DTMF Mode */
      rfoSpellerModel.OnUpdValidCharSet((Candera::String)BTPHN_C_SPELLER_VALID_CHAR_SET_NO_DELETE);

      if (NULL != ServiceTel::poGetInstance())
      {
         ServiceTel::poGetInstance()->vSendDTMFStart(KeyPressed);
      }
   }
   else
   {
      rfoSpellerModel.OnUpdValidCharSet((Candera::String)BTPHN_C_SPELLER_VALID_CHAR_SET_ALL);
      vSendAutoCompletePhoneNumber(strEditInfo);
   }
   /*Updating the Bindable Property of Dial Call Button*/
   rfoSpellerModel.OnUpdDialButton(strEditInfo);
   return false;
}


/************************************************************************
*FUNCTION: ServicePhoneBook::vSendAutoCompletePhoneNumber
*DESCRIPTION : Invoked when a key is pressed from dialpad, and we request service to provide a match for the entered number
*PARAMETER :
szInputNumber -> entered string number
*RETURNVALUE : Bool
*HISTORY :
* System Requirements : (SWFL-278, SWFL-279, SWFL-285, SWFL-292, SWFL-1953, SWFL-1961, SWFL-270, SWFL-283, SWFL-299)
*05.01.18 Rev. 0.1 Shwetha K
* 		  Initial Revision.
************************************************************************/
void ServicePhoneBook::vSendAutoCompletePhoneNumber(std::string szInputNumber)
{
   ETG_TRACE_USR4(("vSendAutoCompletePhoneNumber:Number entered in Dial pad = %s", szInputNumber.c_str()));

   if (BTPHN_C_EQUAL != szInputNumber.compare(""))
   {
      if (NULL != _most_phonbk_fi)
      {
         /* Sending the number entered in Dial pad to Phonebook service
         to obtain the autocomplete and match contact list */
         _most_phonbk_fi->sendAutocompletePhoneNumberEntryStart(*this, szInputNumber);
      }
      else
      {
         ETG_TRACE_ERR(("ServicePhoneBook : vSendAutoCompletePhoneNumber() error "));
      }
   }
   else
   {
      /* Sending an empty match list when the input string is null */
      rfoSpellerModel.OnUpdMatchList(0, BTPHN_C_MATCHLIST_WINDOW_SIZE);
   }
}


/************************************************************************
*FUNCTION: ServicePhoneBook::onCourierMessage(DialCall_ModelReq)
*DESCRIPTION : Invoked when Call is requested from dial pad to the entered number
*PARAMETER :
*corfoMsg : (I)
* 					Courier message from the Message Router
*RETURNVALUE : Bool
*HISTORY :
*05.01.18 Rev. 0.1 Shwetha K
* 		  Initial Revision.
************************************************************************/
bool ServicePhoneBook::onCourierMessage(const DialCall_ModelReq& oMsg)
{
   if (!_isCabinOnly)
   {
      ETG_TRACE_USR4(("ServicePhoneBook : onCourierMessage(DialCall_ModelReq) "));
      std::string strDial = KeyPressed.c_str();
      if (NULL != ServiceTel::poGetInstance())
      {
         if ((BTPHN_C_VALUE_ZERO != strcmp(strDial.c_str(), BTPHN_C_BT_NULL)) && ((FALSE == ServiceTel::poGetInstance()->bGetDialTimer())))
         {
            ETG_TRACE_USR4(("Dialing Number is : %s", strDial.c_str()));

            ServiceTel::poGetInstance()->vSendDialCallMethodStart(strDial, BTPHN_EN_ECNR_NOCHANGE);
         }
         else
         {
            IsDialed = BTPHN_C_VALUE_ZERO;
         }
      }
   }
   return true;
}


/************************************************************************
*FUNCTION: ServicePhoneBook::onCourierMessage(ClearEditFieldRequestReq)
*DESCRIPTION : Invoked when BT is disconnected
*PARAMETER :
*corfoMsg : (I)
* 					Courier message from the Message Router
*RETURNVALUE : Bool
*HISTORY :
*05.01.18 Rev. 0.1 Shwetha K
* 		  Initial Revision.
************************************************************************/
bool ServicePhoneBook::onCourierMessage(const ClearEditFieldRequestReq& oMsg)
{
   if (!_isCabinOnly)
   {
      ETG_TRACE_USR4(("ServicePhoneBook : onCourierMessage(ClearEditFieldRequestReq) "));
      bool bRetVal = rfoSpellerModel.OnUpdClearEditField();
      (*oDialPadInputText).mText = "";
      oDialPadInputText.MarkAllItemsModified();
      oDialPadInputText.SendUpdate(true);

      //the list is updated with size zero to clear the match list when we move to Homescren scene from dialpad or
      //when there is a disconnection of the phone Bug:280285
      arMatchList.clear();
      rfoSpellerModel.vSetMatchListElements(0, arMatchList);
      if (bRetVal == true)
      {
         ETG_TRACE_USR4(("ClearEditFieldRequestReq update successfull"));
      }
      else
      {
         ETG_TRACE_ERR(("ClearEditFieldRequestReq update Failed"));
      }
      return bRetVal;
   }
}


bool ServicePhoneBook::onCourierMessage(const ResetSortOrderReq& oMsg)
{
   ETG_TRACE_USR4(("ServicePhoneBook : onCourierMessage(ResetSortOrderReq) "));
   OnSortPhonebook(oMsg.GetSortOrder());
   return true;
}


//bool ServicePhoneBook::onCourierMessage(const WaitPopUpReqMsg& oMsg)
//{
//	ETG_TRACE_USR3(("ServicePhoneBook::onCourierMessage(WaitPopUpReqMsg)"));
//	ETG_TRACE_USR3(("ServicePhoneBook::onCourierMessage(WaitPopUpReqMsg) %d oMsg.GetWait", oMsg.GetWait()));
//
//	_applicationSwitchClientComponent->requestShowHideWaitScene(oMsg.GetWait());
//
//}
bool ServicePhoneBook::onCourierMessage(const ResetListDataReq& oMsg)
{
   if (!_isCabinOnly)
   {
      ETG_TRACE_USR4(("ServicePhoneBook : onCourierMessage(ResetListDataReq):%d ", oMsg.GetListID()));
      tU8 ListID = oMsg.GetListID();
      if (ListID == BTPHN_C_LIST_ID_CALL_LIST)
      {
         ETG_TRACE_USR4(("onCourierMessage(ResetListDataReq) :clearing calllist in gui "));
         rfoCallHistoryModel.vClearCallListinGUI();
      }
      else if (ListID == BTPHN_C_LIST_ID_CONTACT_LIST)
      {
         ETG_TRACE_USR4(("onCourierMessage(ResetListDataReq) :clearing contactlist in gui "));
         rfoPhonebookModelComponent.vClearContactList();
      }
   }
   return true;
}


/************************************************************************
*FUNCTION:		vGetContactInfo
*DESCRIPTION:	Requests PhoneBook service to provide the contact details (namely
*					first and last name, contact handle and contact detail type)
*					corresponding to the input telephone number
*PARAMETER:

*               copcTelephoneNumber:   (->I)
*                  Contact number whose contact details has to be fetched
*
*RETURNVALUE:	tVoid
*
*HISTORY:
*01.11.2018 ess7kor
*Rev 0.1 Initial Revision
************************************************************************/
tBool ServicePhoneBook::vGetContactInfo(std::string strTelphoneno)
{
   ETG_TRACE_USR4(("ServicePhoneBook::vGetContactInfo"));
   strTelephoneNumber = strTelphoneno.c_str();
   if (_most_phonbk_fi && _most_phonbk_fi.get() && (NULL != ServiceBT::poGetInstance()))
   {
      _most_phonbk_fi->sendSearchPhoneBookStart(*this, ServiceTel::poGetInstance()->u8GetActiveDev(), strTelphoneno, "");
      return TRUE;
   }
   return FALSE;
}


/************************************************************************
*FUNCTION:		vDialCallMethodStart
*DESCRIPTION:	This function is responsible extracting the row value from a contact selected and
				places call to the number selected
*PARAMETER:		hdlRow : row value as obtained from gui
*
*RETURNVALUE:	tVoid
*

************************************************************************/
void ServicePhoneBook::vDialCallMethodStart(tU8 hdlRow)
{
   ETG_TRACE_USR4(("ServicePhoneBook::vDialCallMethodStart"));
   ETG_TRACE_ERR(("Calling number = %s", ContactNumbersList[hdlRow]));//680019
   ServiceTel::poGetInstance()->vSendDialCallMethodStart(ContactNumbersList[hdlRow], BTPHN_EN_ECNR_NOCHANGE);//680019
}


void ServicePhoneBook::OnSortPhonebook(tU8 Sortorder)
{
   ETG_TRACE_USR3(("Preferred PhoneBook sort order : %d", Sortorder));
   /* Sends a request to PhoneBook service to set the preferred
   phonebook sort order */
   _most_phonbk_fi->sendPreferredPhoneBookSortOrderPureSet((T_e8_PhonBkPreferredPhoneBookSortOrder)Sortorder);
}


/************************************************************************
*FUNCTION:		AnimationWidgetIndMsg
*DESCRIPTION:	This is a courier message to rotate the busy animation widget in the clockwise direction
*PARAMETER:		oMsg : oMsg value as obtained from courier message
* Bug:269262
*RETURNVALUE:	tVoid
*

************************************************************************/

bool ServicePhoneBook::onCourierMessage(const AnimationWidgetIndMsg& oMsg)
{
   //tBool Retval;
   ETG_TRACE_USR4(("ServicePhoneBook::AnimationWidgetIndMsg"));

   if (IdScene_CalllistLoading == oMsg.GetView())
   {
      if (IdRotation_CalllistLoading == oMsg.GetSender())
      {
         rfoPhonebookModelComponent.OnUpdChannel1_CalllistLoading();
         POST_MSG((COURIER_MESSAGE_NEW(AnimationWidgetReqMsg)(Courier::AnimationAction::Start, IdScene_CalllistLoading, IdRotation_CalllistLoading)));
         return true;
      }
      else
      {
         ETG_TRACE_USR4(("ServicePhoneBook::AnimationWidgetIndMsg calllist Widget not matching"));
      }
   }
   else  if (IdScene_phonebookloading == oMsg.GetView())
   {
      if (IdRotation_phonebookloading == oMsg.GetSender())
      {
         rfoPhonebookModelComponent.OnUpdChannel1_PhonebookLoading();
         POST_MSG((COURIER_MESSAGE_NEW(AnimationWidgetReqMsg)(Courier::AnimationAction::Start, IdScene_phonebookloading, IdRotation_phonebookloading)));
         //	return true;
      }
      else
      {
         ETG_TRACE_USR4(("ServicePhoneBook::AnimationWidgetIndMsg Phonebook Widget not matching"));
      }
   }
   else
   {
      ETG_TRACE_USR4(("ServicePhoneBook::AnimationWidgetIndMsg View not matching"));
   }
   return false;
}


/************************************************************************
*FUNCTION:		vSetSortOrder
*DESCRIPTION:	This function is used update the sort order set in middleware
*PARAMETER:		Sort order enumeration
* Bug:269262
*RETURNVALUE:	tVoid
*

************************************************************************/
void ServicePhoneBook::vSetSortOrder(most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder enSortOrder)
{
   ETG_TRACE_USR4(("ServicePhoneBook::vSetSortOrder Update from Middleware on Sort Order"));
   enCurrSortOrder = enSortOrder;
   if (most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder__e8PREFERRED_SORT_ORDER_FIRSTNAME == enCurrSortOrder)
   {
      // set false as second argument if the sort order is based on last name.
      rfoPhonebookModelComponent.vSetSortOrder(BTPHN_C_SORT_FIRST_NAME, false);
      ETG_TRACE_USR4(("ServicePhoneBook::vSetSortOrder  - sort based on First name"));
   }
   else
   {
      // set true as second argument if the sort order is based on last name.
      rfoPhonebookModelComponent.vSetSortOrder(BTPHN_C_SORT_LAST_NAME, true);
      ETG_TRACE_USR4(("ServicePhoneBook::vSetSortOrder  - sort based on Last name"));
   }
}


/******************************************************
 * This function clears call history list on toggle.
 * @param[in] - void
 *
 * @param[out]- returns void
 ************************************************************/
void ServicePhoneBook::vDeleteCallListOnToggle()
{
   if (!_isCabinOnly)
   {
      ETG_TRACE_USR4(("ServicePhoneBook : vDeleteCallListOnToggle()"));
      rCallListData.u16TotalListSize = BTPHN_C_DEFAULT_VALUE_ZERO;
      m_lastItemIndex_CallList = BTPHN_C_DEFAULT_VALUE_ZERO;
      if (rCallListData.u16ListHandle != BTPHN_C_LIST_HANDLE_INVALID)
      {
         ETG_TRACE_USR4(("ServicePhoneBook : vDeleteCallList(): sending release list for list handle %d", rCallListData.u16ListHandle));
         /*request for releasing the current call history list*/
         if (NULL != _most_phonbk_fi)
         {
            _most_phonbk_fi->sendReleaseCallHistoryListStart(*this, rCallListData.u16ListHandle);
         }
      }
      rCallListData.u16ListHandle = BTPHN_C_LIST_HANDLE_INVALID;
      bContactInfoRequired = FALSE;
      //Logic to display No Entries in CallList
      POST_MSG((COURIER_MESSAGE_NEW(CallListWindowResp)(0, BTPHN_C_PHNBKLIST_WINDOW_SIZE))); //Bug 680928
   }
}


/**
 * This function clears contact list on toggle.
 * @param[in] - void
 *
 * @param[out]- returns void
 */
void ServicePhoneBook::vDeleteContactListOnToggle()
{
   if (!_isCabinOnly)
   {
      ETG_TRACE_USR4(("ServicePhoneBook : vDeleteContactListOnToggle()"));
      m_PBStartIndex = BTPHN_C_VALUE_ZERO;
      rContactListData.u16TotalListSize = BTPHN_C_DEFAULT_VALUE_ZERO;
      m_lastItemIndex_PBList = BTPHN_C_DEFAULT_VALUE_ZERO;
      if (rContactListData.u16ListHandle != BTPHN_C_LIST_HANDLE_INVALID)
      {
         /*request for releasing the current call history list*/
         if (NULL != _most_phonbk_fi)
         {
            _most_phonbk_fi->sendReleasePhoneBookListStart(*this, rContactListData.u16ListHandle);
         }
      }
      rContactListData.u16ListHandle = BTPHN_C_LIST_HANDLE_INVALID;
      POST_MSG((COURIER_MESSAGE_NEW(ContactListWindowResp)(0, BTPHN_C_PHNBKLIST_WINDOW_SIZE)));//Bug 680928
   }
}


}
}
