/***************************************************************************
* Copyright(c) 2017-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
#ifndef PHONEBOOKDATATYPES_HEADER
#define PHONEBOOKDATATYPES_HEADER

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/* Macros to be defined for including the needed OSAL files */
#define OSAL_S_IMPORT_INTERFACE_GENERIC

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include <vector> // For using vector data type
#include <list> // For using list data type
#include "BTPhoneDefines.h"
#ifdef WINDOWS_SIMULATION
#include "tTypes.h"
#include <iostream>
#include <string>
#endif

#ifndef WINDOWS_SIMULATION
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/* The maximum number of contact numbers that can be stored for a
	particular contact */
#define BTPHN_C_CONTACT_DETAILS_MAX_NUMBER 7

/* Count of the different type of call lists - Combined, missed, incoming,
	outgoing */
#define BTPHN_C_CALL_LIST_COUNT 4

/* Caller Id is displayed as unknown if telephone number/ contact name
   does not exist */
#define BTPHN_C_CONTACT_UNKNOWN "unknown"
#define BTPHN_C_CONTACT_UNKNOWN_CN "未知号码" // JIRA ticket JAC-6857

/* A maximum of two contact numbers can be displayed for each contact type -
	mobile/home/work/other */
#define BTPHN_C_CONTACTTYPE_MAX_NUMBER 2

/* Date string will be set to 0000-00-00 and
   Time string will be set to 99-99-99 for unknown callDateTime details */
#define BTPHN_C_CALLHISTORY_INVALID_YEAR "0000"
#define BTPHN_C_CALLHISTORY_INVALID_MONTH "00"
#define BTPHN_C_CALLHISTORY_INVALID_DAY "00"
#define BTPHN_C_CALLHISTORY_INVALID_TIME "99"
#define BTPHN_C_CONTACTDETAILSLIST_WINDOW_SIZE 10
#define BTPHN_C_PHNBKLIST_WINDOW_SIZE 25
/* Match list window size*/
#define BTPHN_C_MATCHLIST_WINDOW_SIZE 30

/*Maximum number of call list that can be displayed*/
#define BTPHN_C_CALL_LIST_MAX_NUMBER_SIZE 60

/*List id for ResetListDataReq*/
#define BTPHN_C_LIST_ID_CONTACT_LIST 3
#define BTPHN_C_LIST_ID_CALL_LIST 2
/*****************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------*/


/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/
#define PBCL_SUPPORTED 1
#define PBCL_NOT_SUPPORTED 0
#define BTPHN_C_VALUE_TWO	2
#define BTPHN_C_VALUE_HUNDRED 100
#define BTPHN_C_BT_NULL ""
#define BTPHN_C_BT_SPACE "  "

/********************* Button Actions ***************/
#define BTPHN_C_BUTTON_ENABLED 1
#define BTPHN_C_BUTTON_DISABLED 0
/*for speller config*/
#define BTPHN_C_SPELLER_DELETE_STRING "0x232B"
#define BTPHN_C_SPELLER_DELETE_ALL_STRING "0x2327"
#define BTPHN_C_SPELLER_VALID_CHAR_SET_ALL "123456789*0#©"
#define BTPHN_C_SPELLER_VALID_CHAR_SET_NO_DELETE "123456789*0#"
#define BTPHN_C_SPELLER_VALID_CHAR_SET_DELETE "©"

typedef enum
{
   /* Combined call history list */
   BTPHN_EN_CCH = 0UL,

   /* Missed call history list or missed call */
   BTPHN_EN_MCH = 1UL,

   /* Incoming call history list or incoming call */
   BTPHN_EN_ICH = 2UL,

   /* Outgoing call history call or outgoing call */
   BTPHN_EN_OCH = 3UL
} btphn_tenCallHistoryType;

typedef enum
{
   /* Sort by Datetime  */
   BTPHN_EN_CH_SORT_DATETIME = 0UL,

   /* Sort by LastName->FirstName->Datetime */
   BTPHN_EN_CH_SORT_LASTNAME = 1UL,

   /* Sort by FirstName->LastName->Datetime */
   BTPHN_EN_CH_SORT_FIRSTNAME = 2UL
} btphn_tenCallHistorySortType;

typedef enum
{
   /* Phone Book list */
   BTPHN_EN_PHONEBOOK_LIST = 0UL,

   /* Call History List */
   BTPHN_EN_CALLHISTORY_LIST = 1UL
} btphn_tenListType;

typedef enum
{
   /* The complete contents of the list has changed */
   BTPHN_EN_LCH_CONTENT_CHANGED = 0UL,

   /* Items have been added to the list */
   BTPHN_EN_LCH_ITEMS_ADDED = 1UL,

   /* Items have been removed from the list */
   BTPHN_EN_LCH_ITEMS_REMOVED = 2UL,

   /* Items have changed in the list */
   BTPHN_EN_LCH_ITEMS_CHANGED = 3UL
} btphn_tenListChangeType;

/* Enum for the different types of contact details that can be stored for a
	particular contact */
typedef enum
{
   BTPHN_EN_NONE = 0UL,
   BTPHN_EN_PREFERRED_NUMBER = 1UL,
   BTPHN_EN_CELL_NUMBER_1 = 2UL,
   BTPHN_EN_CELL_NUMBER_2 = 3UL,
   BTPHN_EN_HOME_NUMBER_1 = 4UL,
   BTPHN_EN_HOME_NUMBER_2 = 5UL,
   BTPHN_EN_WORK_NUMBER_1 = 6UL,
   BTPHN_EN_WORK_NUMBER_2 = 7UL,
   BTPHN_EN_OTHER_NUMBER = 8UL,
   BTPHN_EN_EMAIL_ADDRESS_1 = 9UL,
   BTPHN_EN_EMAIL_ADDRESS_2 = 10UL,
   BTPHN_EN_EMAIL_ADDRESS_3 = 11UL,
   BTPHN_EN_HOME_ADDRESS = 12UL,
   BTPHN_EN_WORK_ADDRESS = 13UL,
   BTPHN_EN_OTHER_ADDRESS = 14UL
} btphn_tenContactDetailType;

/* Enum for the different phone types to be displayed in HMI */
typedef enum
{
   BTPHN_EN_NO_TYPE = -1,
   BTPHN_EN_CELL = 0,
   BTPHN_EN_HOME = 1,
   BTPHN_EN_WORK = 2,
   BTPHN_EN_OTHER = 3,
   BTPHN_EN_GENERIC = 4
} btphn_tenPhoneType;

typedef enum
{
   /* List of all contact details */
   BTPHN_EN_CDF_NONE = 0UL,

   /* List of all contact addresses */
   BTPHN_EN_CDF_ADDRESS = 1UL,

   /* List of all contact telephone numbers */
   BTPHN_EN_CDF_TELEPHONE = 2UL,

   /* List of all contact email addresses */
   BTPHN_EN_CDF_EMAIL = 3UL,

   /* List of all contact notes */
   BTPHN_EN_CDF_NOTE = 4UL
} btphn_tenContactDetailFilter;

typedef enum
{
   /* Sort contacts by: Invalid */
   BTPHN_EN_PB_LIST_SORT_INVALID = -1,

   /* Sort contacts by: LastName->FirstName */
   BTPHN_EN_PB_LIST_SORT_LASTNAME = 0UL,

   /* Sort contacts by: FirstName->LastName */
   BTPHN_EN_PB_LIST_SORT_FIRSTNAME = 1UL,

   /* Sort contacts by: Contacts with Addresses -> LastName -> FirstName */
   BTPHN_EN_PB_LIST_SORT_ADDRESS_LASTNAME = 2UL,

   /* Sort contacts by: Contacts with Addresses -> FirstName -> LastName */
   BTPHN_EN_PB_LIST_SORT_ADDRESS_FIRSTNAME = 3UL,

   /* Sort contacts by: Contacts with phone number -> LastName -> FirstName */
   BTPHN_EN_PB_LIST_SORT_NUMBER_LASTNAME = 4UL,

   /* Sort contacts by: Contacts with phone number -> FirstName -> LastName */
   BTPHN_EN_PB_LIST_SORT_NUMBER_FIRSTNAME = 5UL,

   /* 	Sort contacts by: Contacts with email -> LastName -> FirstName */
   BTPHN_EN_PB_LIST_SORT_EMAIL_LASTNAME = 6UL,

   /* Sort contacts by: Contacts with email -> FirstName -> LastName */
   BTPHN_EN_PB_LIST_SORT_EMAIL_FIRSTNAME = 7UL,

   /* Sort contacts by: Category -> LastName -> Firstname */
   BTPHN_EN_PB_LIST_SORT_CATEGORY_LASTNAME = 8UL,

   /* Sort contacts by: Category -> Firstname -> Lastname */
   BTPHN_EN_PB_LIST_SORT_CATEGORY_FIRSTNAME = 9UL
} btphn_tenPhoneBookSortType;


typedef enum
{
   /* Date format - dd.mm.yyyy */
   BTPHN_EN_DF_DD_MM_YYYY = 1UL,

   /* Date format - mm.dd.yyyy */
   BTPHN_EN_DF_MM_DD_YYYY = 2UL,

   /* Date format - yyyy.mm.dd */
   BTPHN_EN_DF_YYYY_MM_DD = 3UL,

   /* Date format - dd-mm-yyyy */
   BTPHN_EN_DF_DD_MM_YYYY_DASH = 4UL,

   /* Date format - dd/mm/yyyy */
   BTPHN_EN_DF_DD_MM_YYYY_LINE = 5UL,

   /* Date format - yyyy.dd.mm */
   BTPHN_EN_DF_YYYY_DD_MM = 6UL,

   /* Date format - d.m.yyyy */
   BTPHN_EN_DF_D_M_YYYY = 7UL,

   /* Date format - yyyy-mm-dd */
   BTPHN_EN_DF_YYYY_MM_DD_DASH = 8UL,

   /* Date format - yyyy(year)m(month)d(day) chinese characters */
   BTPHN_EN_DF_YYYY_M_D_CHAR = 9UL,
} btphn_tenDateFormat;

///* Structure that maintains call's year, month and date information */
//typedef struct
//{
//	std::string copcCldrYear;
//	std::string copcCldrMonth;
//	std::string copcCldrDay;
//} btphn_trPhoneBookCallDate;

/* Structure that maintains call's hours and minutes information */
typedef struct
{
   std::string copcHours;
   std::string copcMinutes;
} btphn_trPhoneBookCallTime;

/* Structure that maintains call history information */
typedef struct
{
   tU8 u8CallCount;
   std::string copcFirstName;
   std::string copcLastName;
   std::string copcPhoneNumber;
   btphn_tenCallHistoryType enCallHistoryType;
   std::string CallHistorydate;
   //btphn_trPhoneBookCallDate rCallDate;
   btphn_trPhoneBookCallTime rCallTime;
} btphn_trCallHistoryInfo;
typedef struct
{
   // bool bQuickDial;
   int u8PhoneNumberCount;
   int u32ContactHandle;
   std::string szFirstName;
   std::string szLastName;
} btphn_trContactInfo;
/* Structure that maintains contact list and the call lists support status */
typedef struct btphn_trPhnBkListSupport
{
   tBool bContactSupport;
   tBool bCallListSupport[BTPHN_C_CALL_LIST_COUNT];
   tBool bTimestampSupport;
   btphn_trPhnBkListSupport()
      : bContactSupport(FALSE), bTimestampSupport(FALSE)
   {
      memset(bCallListSupport, 0, BTPHN_C_CALL_LIST_COUNT);
   };
} btphn_trPhnBkListSupport;


typedef struct
{
   std::string copcPhoneNumber;
   std::string copcFirstName;
   std::string copcLastName;
} btphn_trPhnBkMatchListEntry;

typedef struct
{
   std::string copcLetter;
   tBool bIsAvailable;
   tU32 u32StartIndex;
   tU32 u32EndIndex;
} btphn_trPhnBkSearchKeyboard;
typedef struct
{
   std::string szContactNumber;
   tU8 u8ContactNumType;
   tBool bPrefferedNum;
} btphn_trContactCallDetail;

typedef struct btphn_trContactListData
{
   /* Contact list handle */
   tU16 u16ListHandle;

   /* Total size of the contact list */
   tU16 u16TotalListSize;

   /* Phonebook sort type */
   btphn_tenPhoneBookSortType enSortType;

   btphn_trContactListData()
      : u16ListHandle(BTPHN_C_LIST_HANDLE_INVALID),
        u16TotalListSize(0),
        enSortType(BTPHN_EN_PB_LIST_SORT_INVALID)

   {}
} btphn_trContactListData;

typedef struct btphn_trCallListData
{
   /* CCH list handle */
   tU16 u16ListHandle;

   /* Total size of the call list */
   tU16 u16TotalListSize;

   /* Call history list sort type */
   btphn_tenCallHistorySortType enSortType;

   tBool bIsActiveDevice;

   btphn_trCallListData()
      : u16ListHandle(BTPHN_C_LIST_HANDLE_INVALID),
        u16TotalListSize(0),
        enSortType(BTPHN_EN_CH_SORT_DATETIME),
        bIsActiveDevice(false)
   {}
} btphn_trCallListData;

/* Icon names corresponding to the type of contact number shown in
contact details Highlighted */
#define BTPHN_C_LIST_ICON_CELL_HIGHLIGHTED \
										"AppHmi_PhoneModule#Images#P_MultipleCall#Icon_PhoneType_Mobile_active_1"
#define BTPHN_C_LIST_ICON_HOME_HIGHLIGHTED \
										"AppHmi_PhoneModule#Images#P_MultipleCall#Icon_PhoneType_Private_active_1"
#define BTPHN_C_LIST_ICON_WORK_HIGHLIGHTED \
										"AppHmi_PhoneModule#Images#P_MultipleCall#Icon_PhoneType_Business_active_1"
#define BTPHN_C_LIST_ICON_OTHER_HIGHLIGHTED \
										"AppHmi_PhoneModule#Images#P_MultipleCall#Icon_PhoneType_Other_active_1"
#define BTPHN_C_LIST_ICON_GENERIC_HIGHLIGHTED \
										"AppHmi_PhoneModule#Images#P_MultipleCall#Icon_PhoneType_active_1"

#define BTPHN_C_CONTACT_LIST_SINGLE_NUMBER "%1"
#define BTPHN_C_CONTACT_LIST_MULTIPLE_NUMBERS "%2"
#define BTPHN_C_CONTACT_NUMBER_TEXT_SIZE 12
#define BTPHN_C_CALL_DURATION_TEXT_LENGTH 5
#define BTPHN_C_CALL_DATE_TEXT_LENGTH 20
#define SINGLEBYTECHAR 1
#define TWOBYTECHAR 2
#define THREEBYTECHAR 3
#define FOURBYTECHAR 4
#define FIVEBYTECHAR 5
#define SIXBYTECHAR 6
#endif // PHONEBOOKDATATYPES_HEADER

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
