/***************************************************************************
* Copyright(c) 2017-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
#ifndef INTERCOMDATATYPES_HEADER
#define INTERCOMDATATYPES_HEADER

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/* Macros to be defined for including the needed OSAL files */
#define OSAL_S_IMPORT_INTERFACE_GENERIC

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include <vector> // For using vector data type
#include <list> // For using list data type
#define PICK_UP 0
#define ONHOOKUP_NOTRINGING 4
#define ONHOOKUP_RINGING 12
#define PHONENUMBER_RESTROOM 1
#define PHONENUMBER_KITCHEN 2
#define PHONENUMBER_UPPERDECK 3
#define MAX_SIZE 3
#define MIN_SIZE 0
#define CMC_INDEX 0
#define CC_INDEX 1
#define INDEX_PHONENUMBER_RESTROOM 0
#define INDEX_PHONENUMBER_KITCHEN 1
#define INDEX_PHONENUMBER_UPPERDECK 2

typedef struct
{
   Candera::String strCallerId;
   tU16 u16Contacttype;
   Candera::String strCallStatus;
} IntercomContactinfo;

typedef struct
{
   bool isEnabled;
   bool isActive;
   bool isVisible;
   float x;
   float y;
} IntercomGadgetContactinfo;

typedef struct
{
   tU16 u16CurrentPhoneStatus;
   tU16 u16Contacttype;
} IntercomPhonestatus;

typedef enum
{
   EN_INTERCOM_NO_PHONE_CONNECTED = 0,
   EN_INTERCOM_CONTACT_LIST,
   EN_INTERCOM_FUNCTION_NOT_AVAILABLE,
   EN_INTERCOM_NOT_SUPPORTED,
} en_IntercomCabinTileIndex;
typedef enum
{
   INTERCOM_BG_ENABLED = 0,
   INTERCOM_BG_DISABLED,
} en_IntercomCabinTileBGIndex;
typedef enum
{
   EN_RESTCABIN_NORMAL  = 1,
   EN_KITCHEN_NORMAL,
   EN_UPPERDECK_NORMAL,
   EN_RESTCABIN_ACTIVE,
   EN_KITCHEN_ACTIVE,
   EN_UPPERDECK_ACTIVE,
   EN_RESTCABIN_DISABLE,
   EN_KITCHEN_DISABLE,
   EN_UPPERDECK_DISABLE,
} en_IntercomContactIconIndex;

typedef enum
{
   EN_PHONENUMBER_RESTROOM = 1,
   EN_PHONENUMBER_KITCHEN = 2,
   EN_PHONENUMBER_UPPERDECK = 3,
} en_IntercomContactType;

#endif
