#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                :
* COMPONENT Name      :
* DESCRIPTION         :
* AUTHOR              :
* Revision History    : 0.1
* Date 23.08.2017     : Initial version
****************************************************************************/
#include "IntercomClienthandler.h"
#include "IntercomDataTypes.h"
#include "PluginConstants.h"
#include "hmi_trace_if.h"
#include <string>
#include "hall_std_if.h"
#include "Core/Microphone/MicClientHandler.h"
#include "ServiceTel.h"
#include "ServiceBT.h"
#include "ProjectBaseTypes.h"
#include "Common/VariantHandling/VariantHandling.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_PHONE_HALL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_PHONE
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_PHONE_"
#define ETG_I_FILE_PREFIX App::Core::IntercomClienthandler::
#include "trcGenProj/Header/IntercomClienthandler.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::IntercomAudioService;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
namespace App {
namespace Core {

IntercomClienthandler* IntercomClienthandler::_IntercomInstance = NULL;

/************************************************
Function 	: Constructor
Parameters 	:
Description : This function is called when list request is called
SYSFL/SWFL : CRQ-createProxy
************************************************/
IntercomClienthandler::IntercomClienthandler():
   rfoIntercomModel(*IntercomModel::poGetInstance()),
   _IntercomAudioServiceProxy(bosch::cm::ai::IntercomAudioService::IntercomAudioServiceProxy::createProxy("IntercomAudioPort", *this)),
   _hmiInfoServiceProxy(bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy::createProxy("hmiinfoservicePort", *this)),
   _SPMSetproxy(::SPM_CORE_FI::SPM_CORE_FIProxy::createProxy("spmFiPort", *this)),
   strcallerId(""),
   strMissedCallerID(""),
   u16Contacttype(0),
   m_u8IntercomActiveCallCount(0),
   bIsIntercomServiceAvailable(false),
   bIsIntercomIncomingCallPopupActive(false),
   bIsIntercomOutgoingCallPopupActive(false),
   bIsIntercomOngoingCallActive(false),
   bRestroomstatus(false),
   bKitchenstatus(false),
   bUpperDeckstatus(false),
   m_bEventInterComConfigErrorStatus(false),
   m_bEventNanoMessageErrorStatus(false),
   m_bEventRTPErrorStatus(false),
   m_bIsCMAavailable(false),
   m_bIsCMAavailablefirsttimeflag(true),
   m_bIntercomIncomingSignal(false),
   m_audioallocationstatus(false),
   m_uint8StartupIntercomAvailable(0),
   m_bIsIntercomConfCallActive(false),
   m_u8SystemGroup(0),
   m_u8SystemStatus(0),
   m_u8SystemCategory(0),
   m_u8NanoMsgStatus(SYSTEM_STATUS_NONE),
   m_bMissedIntercomCall(false)

{
   ETG_TRACE_USR4(("IntercomClienthandler Constructor is called"));
   //arContactinfo[3] = false;
   arPhoneStatus[0].u16CurrentPhoneStatus = ONHOOKUP_NOTRINGING;
   arPhoneStatus[0].u16Contacttype = 0XFF;
   arPhoneStatus[1].u16CurrentPhoneStatus = ONHOOKUP_NOTRINGING;
   arPhoneStatus[1].u16Contacttype = 0XFF;
   arPhoneStatus[2].u16CurrentPhoneStatus = ONHOOKUP_NOTRINGING;
   arPhoneStatus[2].u16Contacttype = 0XFF;
   if ((_IntercomAudioServiceProxy != NULL) && (_IntercomAudioServiceProxy.get()))
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _IntercomAudioServiceProxy->getPortName());
      ETG_TRACE_USR4(("IntercomClienthandler Constructor after creating proxy"));
   }
   if ((_hmiInfoServiceProxy != NULL) && (_hmiInfoServiceProxy.get()))
   {
      ETG_TRACE_USR4(("IntercomClienthandler Constructor before creating Hmiinfoservice proxy"));
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _hmiInfoServiceProxy->getPortName());
      ETG_TRACE_USR4(("IntercomClienthandler Constructor after creating Hmiinfoservice proxy"));
   }
   if ((_SPMSetproxy != NULL) && (_SPMSetproxy.get()))
   {
      ETG_TRACE_USR4(("IntercomClienthandler::IntercomClienthandler StartupSync _SPMSetproxy"));
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _SPMSetproxy->getPortName());
   }
   if (VariantHandling::getInstance() != NULL)
   {
      _isCabinOnly = (VariantHandling::getInstance()->getVariantType() == VARIANTTYPE_CC);
   }
   else
   {
      _isCabinOnly = false; // Default to false if VariantHandling is not available
   }
}


/************************************************
Function 	: destructor
Parameters 	:
Description :
SYSFL/SWFL :
************************************************/
IntercomClienthandler::~IntercomClienthandler()
{
   bIsIntercomServiceAvailable = false;
}


/************************************************
Function 	: poGetInstance function
Parameters 	:
Description : This function is called when list request is called
SYSFL/SWFL :
************************************************/
IntercomClienthandler* IntercomClienthandler::poGetInstance()
{
   ETG_TRACE_FATAL(("IntercomClienthandler poGetInstance"));
   if (_IntercomInstance == NULL)
   {
      _IntercomInstance = new IntercomClienthandler();
   }
   return _IntercomInstance;
}


void IntercomClienthandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("IntercomClienthandler register property is called"));
   _IntercomAudioServiceProxy->sendIncomingCallRegister(*this);
   _IntercomAudioServiceProxy->sendCancelCallRegister(*this);
   _IntercomAudioServiceProxy->sendActiveCallStatusRegister(*this);
   _IntercomAudioServiceProxy->sendIntercomServiceAvailabilityRegister(*this);
   _IntercomAudioServiceProxy->sendRspPhoneStatusRegister(*this);
   _IntercomAudioServiceProxy->sendEventPhoneStatusChangedRegister(*this);
   _IntercomAudioServiceProxy->sendEventNanoMessageErrorStatusRegister(*this);
   _IntercomAudioServiceProxy->sendEventRTPErrorStatusRegister(*this);
   _IntercomAudioServiceProxy->sendEventInterComConfigErrorRegister(*this);
   _IntercomAudioServiceProxy->sendEventAudioAllocationStatusRegister(*this);
   _IntercomAudioServiceProxy->sendRspIntercomAvailableRegister(*this);
   _IntercomAudioServiceProxy->sendEventIntercomAvailableRegister(*this);
   if (_hmiInfoServiceProxy && _hmiInfoServiceProxy == proxy)
   {
      _hmiInfoServiceProxy->sendCabinsSystemsInfoRegister(*this);
      _hmiInfoServiceProxy->sendCabinsSourceRestorationInfoRegister(*this);
      ETG_TRACE_USR4(("IntercomClienthandler::Hmiinfoservice Register proxy"));
   }
   if (_SPMSetproxy && _SPMSetproxy == proxy)
   {
      _SPMSetproxy->sendHmiStateUpReg(*this);
      ETG_TRACE_USR4(("IntercomClienthandler::SPM HMI State Proxy On Register"));
   }
}


void IntercomClienthandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("IntercomClienthandler deregister property is called"));
   _IntercomAudioServiceProxy->sendIncomingCallDeregisterAll();
   _IntercomAudioServiceProxy->sendCancelCallDeregisterAll();
   _IntercomAudioServiceProxy->sendActiveCallStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendIntercomServiceAvailabilityDeregisterAll();
   _IntercomAudioServiceProxy->sendRspPhoneStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendEventPhoneStatusChangedDeregisterAll();
   _IntercomAudioServiceProxy->sendEventNanoMessageErrorStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendEventRTPErrorStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendEventInterComConfigErrorDeregisterAll();
   _IntercomAudioServiceProxy->sendEventAudioAllocationStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendRspIntercomAvailableDeregisterAll();
   _IntercomAudioServiceProxy->sendEventIntercomAvailableDeregisterAll();
   if (_hmiInfoServiceProxy && _hmiInfoServiceProxy == proxy)
   {
      _hmiInfoServiceProxy->sendCabinsSystemsInfoDeregisterAll();
      _hmiInfoServiceProxy->sendCabinsSourceRestorationInfoDeregisterAll();
      ETG_TRACE_USR4(("IntercomClienthandler::Hmiinfoservice Deregister proxy"));
   }
   if ((proxy == _SPMSetproxy) && (_SPMSetproxy.get()))
   {
      _SPMSetproxy->sendHmiStateRelUpRegAll();
      ETG_TRACE_USR4(("IntercomClienthandler::SPM HMI State Proxy Deregister"));
   }
}


void IntercomClienthandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_FATAL(("IntercomClienthandler::onUnavailable()"));
   _IntercomAudioServiceProxy->sendIncomingCallDeregisterAll();
   _IntercomAudioServiceProxy->sendCancelCallDeregisterAll();
   _IntercomAudioServiceProxy->sendActiveCallStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendIntercomServiceAvailabilityDeregisterAll();
   _IntercomAudioServiceProxy->sendRspPhoneStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendEventPhoneStatusChangedDeregisterAll();
   _IntercomAudioServiceProxy->sendEventNanoMessageErrorStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendEventRTPErrorStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendEventInterComConfigErrorDeregisterAll();
   _IntercomAudioServiceProxy->sendEventAudioAllocationStatusDeregisterAll();
   _IntercomAudioServiceProxy->sendRspIntercomAvailableDeregisterAll();
   _IntercomAudioServiceProxy->sendEventIntercomAvailableDeregisterAll();
   if (_hmiInfoServiceProxy && _hmiInfoServiceProxy == proxy)
   {
      _hmiInfoServiceProxy->sendCabinsSystemsInfoDeregisterAll();
      _hmiInfoServiceProxy->sendCabinsSourceRestorationInfoDeregisterAll();
      ETG_TRACE_USR4(("IntercomClienthandler::Hmiinfoservice Unavailable proxy"));
   }
   if ((proxy == _SPMSetproxy) && (_SPMSetproxy.get()))
   {
      _SPMSetproxy->sendHmiStateRelUpRegAll();
      ETG_TRACE_USR4(("IntercomClienthandler::SPM HMI State Proxy on Unavailable"));
   }
}


void IntercomClienthandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_FATAL(("IntercomClienthandler::onAvailable()"));
   _IntercomAudioServiceProxy->sendIncomingCallRegister(*this);
   _IntercomAudioServiceProxy->sendCancelCallRegister(*this);
   _IntercomAudioServiceProxy->sendActiveCallStatusRegister(*this);
   _IntercomAudioServiceProxy->sendIntercomServiceAvailabilityRegister(*this);
   _IntercomAudioServiceProxy->sendRspPhoneStatusRegister(*this);
   _IntercomAudioServiceProxy->sendEventPhoneStatusChangedRegister(*this);
   _IntercomAudioServiceProxy->sendEventNanoMessageErrorStatusRegister(*this);
   _IntercomAudioServiceProxy->sendEventRTPErrorStatusRegister(*this);
   _IntercomAudioServiceProxy->sendEventInterComConfigErrorRegister(*this);
   _IntercomAudioServiceProxy->sendEventAudioAllocationStatusRegister(*this);
   _IntercomAudioServiceProxy->sendRspIntercomAvailableRegister(*this);
   _IntercomAudioServiceProxy->sendEventIntercomAvailableRegister(*this);
   if (_hmiInfoServiceProxy && _hmiInfoServiceProxy == proxy)
   {
      _hmiInfoServiceProxy->sendCabinsSystemsInfoRegister(*this);
      _hmiInfoServiceProxy->sendCabinsSourceRestorationInfoRegister(*this);
      ETG_TRACE_USR4(("IntercomClienthandler::Hmiinfoservice Available proxy"));
   }
   if (proxy && (proxy == _SPMSetproxy) && (_SPMSetproxy.get()))
   {
      _SPMSetproxy->sendHmiStateUpReg(*this);
      ETG_TRACE_USR4(("IntercomClienthandler::SPM HMI State Proxy On Available"));
   }
}


void IntercomClienthandler::onCallActionError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CallActionError >& error)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onCallActionError()"));
}


void IntercomClienthandler::onCallActionResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CallActionResponse >& response)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onCallActionResponse()"));
}


void IntercomClienthandler::onIncomingCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IncomingCallError >& error)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onIncomingCallError()"));
}


void IntercomClienthandler::onIncomingCallSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IncomingCallSignal >& signal)
{
   if (_IntercomAudioServiceProxy != NULL)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onIncomingCallSignal()"));
      ETG_TRACE_USR3(("IntercomClienthandler::onIncomingCallSignal() Caller ID = %d", signal->getPhoneNo()));
      strcallerId = getCallerId(signal->getPhoneNo());
      strMissedCallerID = getCallerId(signal->getPhoneNo());
      u16Contacttype = signal->getPhoneNo();
      m_bIntercomIncomingSignal = true;
      //POST_MSG((COURIER_MESSAGE_NEW(IntercomIncomingCallResp)()));
      //rfoIntercomModel.OnUpdIncomingCallStatus(strcallerId, u16Contacttype);
      //bIsIntercomIncomingCallPopupActive = true;
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
   }
}


void IntercomClienthandler::vCheckAudioAllocationinIncomingCall()
{
   ETG_TRACE_USR3(("IntercomClienthandler::vCheckAudioAllocationinIncomingCall"));
   if ((m_audioallocationstatus == true) && (true == m_bIntercomIncomingSignal) && (MicClientHandler::poGetInstance()->getMicStatus() == false))
   {
      ETG_TRACE_USR3(("IntercomClienthandler::vCheckAudioAllocationinIncomingCall MIC is Not Active"));
      POST_MSG((COURIER_MESSAGE_NEW(IntercomIncomingCallResp)()));
      rfoIntercomModel.OnUpdIncomingCallStatus(strcallerId, u16Contacttype);
      bIsIntercomIncomingCallPopupActive = true;
      m_bIntercomIncomingSignal = false;
   }
   else if ((m_audioallocationstatus == false) && (true == m_bIntercomIncomingSignal) && (MicClientHandler::poGetInstance()->getMicStatus() == true))
   {
      ETG_TRACE_USR3(("IntercomClienthandler::vCheckAudioAllocationinIncomingCall MIC is Active"));
      vCheckIncomingCallMICActive();
   }
   else if ((m_audioallocationstatus == false) && (true == m_bIntercomIncomingSignal) && ((true == ServiceTel::poGetInstance()->getIncomingCallStatus()) || (true == ServiceTel::poGetInstance()->getCallDialingStatus()) || (true == ServiceTel::poGetInstance()->getOngoingCallStatus())))
   {
      ETG_TRACE_USR3(("IntercomClienthandler::vCheckAudioAllocationinIncomingCall BT Call is active"));
      m_bIntercomIncomingSignal = false;
      //OnUpdDisconnectCall(); //Disconnects the Intercom Call
      // POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(ShowPriorityCall_BT_Req)()));
      m_bMissedIntercomCall = true;
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::vCheckAudioAllocationinIncomingCall else MIC not Active and Audio Not allocated"));
      m_bIntercomIncomingSignal = false;
      //OnUpdDisconnectCall(); //since audio is not allocated should we send this signal to MW?
      //Else do we need to send reject call to MW
   }
}


void IntercomClienthandler::vCheckIncomingCallMICActive()
{
   if (bIsIntercomIncomingCallPopupActive == false) //MIC is ON first and We receieve Incoming Call next
   {
      ETG_TRACE_USR3(("IntercomClienthandler::vCheckIncomingCallMICActive bIsIntercomIncomingCallPopupActive is false"));
      m_bIntercomIncomingSignal = false;
      //OnUpdDisconnectCall(); //Disconnects the Intercom Call
      //POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(MICIntercomCallResp)()));//send courier message to show mic anounment pop up
      if (MicClientHandler::poGetInstance()->getEnMicStatus() == enMIC_BTCall)
      {
         ETG_TRACE_USR3(("IntercomClienthandler::vCheckIncomingCallMICActive Bt call is missed before intercom missed call"));
         MicClientHandler::poGetInstance()->vSetMicStatus(enMIC_BTCall_Intercom);
      }
      else
      {
         ETG_TRACE_USR3(("IntercomClienthandler::vCheckIncomingCallMICActive intercom call is missed "));
         MicClientHandler::poGetInstance()->vSetMicStatus(enMIC_IntercomCall);
      }
   }
   else //Incoming Call comes first then MIC is ON
   {
      ETG_TRACE_USR3(("IntercomClienthandler::vCheckIncomingCallMICActive bIsIntercomIncomingCallPopupActive is true"));
      OnUpdDisconnectCall();
      //Else do we need to send reject call to MW
   }
}


void IntercomClienthandler::onOutgoingCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< OutgoingCallError >& error)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onOutgoingCallError()"));
}


void IntercomClienthandler::onOutgoingCallResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< OutgoingCallResponse >& response)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onOutgoingCallResponse()"));
}


void IntercomClienthandler::onCancelCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CancelCallError >& error)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallError()"));
}


void IntercomClienthandler::onCancelCallSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CancelCallSignal >& signal)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal()"));
   ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() m_bIsIntercomConfCallActive = %d", m_bIsIntercomConfCallActive));
   if (true == bIsIntercomIncomingCallPopupActive)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() Single call"));
      OnUpdDisconnectCall();
      OnUpdMissedBTCall();
   }
   /* else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() m_u8IntercomActiveCallCount = %d",m_u8IntercomActiveCallCount));
      if ((m_u8IntercomActiveCallCount > 1) && (MicClientHandler::poGetInstance()->getMicStatus() == false))
      {
         ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() Conference call"));
         OnUpdConferenceCall();
      }
      else if ((1 == m_u8IntercomActiveCallCount) && (MicClientHandler::poGetInstance()->getMicStatus() == false))
      {
         ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() Active call"));
         //TODO:find the contact and switch to active call
         //in arphonestatus array add one more variable and store contact type along with callstatus in the eventphonestatuschangedsignal property
         //in vcheckactivecallcount function when the call is active store the active contact name and use here to verify ad update for active call
         for (int i = 0; i < 3 ; i++)
         {
            if (PICK_UP == arPhoneStatus[i].u16CurrentPhoneStatus)
            {
               ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() Active call = %d", arPhoneStatus[i].u16CurrentPhoneStatus));
               POST_MSG((COURIER_MESSAGE_NEW(AcceptOutgoingIntercomCall)()));
               tU16 u16Contacttype = arPhoneStatus[i].u16Contacttype;
               Candera::String strcallerId = getCallerId(u16Contacttype);
               rfoIntercomModel.OnUpdCallProgressStatus(strcallerId, u16Contacttype);
               break;
            }
         }
      }
      else
      {
   	   ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() else"));
      }
   } */
   if ((MicClientHandler::poGetInstance()->getMicStatus() == true))
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() MIC is active pop up shown"));
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(MICIntercomCallResp)()));
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onCancelCallSignal() MIC is not active no pop up shown"));
   }
}


void IntercomClienthandler::onActiveCallStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< ActiveCallStatusError >& error)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onActiveCallStatusError()"));
}


void IntercomClienthandler::onActiveCallStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< ActiveCallStatusSignal >& signal)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onActiveCallStatusSignal()"));
   /*  if (_IntercomAudioServiceProxy != NULL)
    {
       IsIntercomCallActive = true;
       POST_MSG((COURIER_MESSAGE_NEW(AcceptOutgoingIntercomCall)()));
       bIsIntercomOutgoingCallPopupActive = false;
       bIsIntercomOngoingCallActive = true;
    }
    else
    {
       ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
    } */
}


void IntercomClienthandler::onIntercomServiceAvailabilityError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IntercomServiceAvailabilityError >& error)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onIntercomServiceAvailabilityError()"));
}


void IntercomClienthandler::onIntercomServiceAvailabilitySignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IntercomServiceAvailabilitySignal >& signal)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onIntercomServiceAvailabilitySignal()"));
   bIsIntercomServiceAvailable = true;
//Post the BT on/off status to ApplicationSwitchClientHandler to enable/disable Phone AppFlyIn.
//   POST_MSG((COURIER_MESSAGE_NEW(BtOnOffStatusAppFlyInReq)(true)));
//  PhoneGadgetModel::poGetInstance()->SetIntercomStatus(true);
   ValidateIntercomStatus();
   if (_IntercomAudioServiceProxy != NULL)
   {
      ETG_TRACE_USR4(("onIntercomServiceAvailabilitySignal sending Intercom sendGetAvailabilityRequest"));
      _IntercomAudioServiceProxy->sendGetAvailabilityRequest(*this);
   }
}


void IntercomClienthandler::onRspPhoneStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspPhoneStatusError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onRspPhoneStatusError()"));
}


void IntercomClienthandler::onRspPhoneStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspPhoneStatusSignal >& signal)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onRspPhoneStatusSignal()"));
   if (_IntercomAudioServiceProxy != NULL)
   {
      uint8_t u8Restroomstatus = signal->getRestRoomPhoneStatus();
      uint8_t u8Kitchenstatus = signal->getKitchenPhoneStatus();
      uint8_t u8UpperDeckstatus = signal->getUpperDeckPhoneStatus();
      ETG_TRACE_USR4(("IntercomClienthandler : onRspPhoneStatusSignal() u8Restroomstatus = %d", u8Restroomstatus));
      ETG_TRACE_USR4(("IntercomClienthandler : onRspPhoneStatusSignal() u8Kitchenstatus = %d", u8Kitchenstatus));
      ETG_TRACE_USR4(("IntercomClienthandler : onRspPhoneStatusSignal() u8UpperDeckstatus = %d", u8UpperDeckstatus));

      bRestroomstatus = CheckConnection((!checkStBit(u8Restroomstatus, 0)), (!checkStBit(u8Restroomstatus, 1)));
      bKitchenstatus = CheckConnection((!checkStBit(u8Kitchenstatus, 0)), (!checkStBit(u8Kitchenstatus, 1)));
      bUpperDeckstatus = CheckConnection((!checkStBit(u8UpperDeckstatus, 0)), (!checkStBit(u8UpperDeckstatus, 1)));

      ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Restroom"));
      arPhoneStatus[0].u16CurrentPhoneStatus = signal->getRestRoomPhoneStatus();
      arPhoneStatus[0].u16Contacttype = PHONENUMBER_RESTROOM;

      ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Kitchen"));
      arPhoneStatus[1].u16CurrentPhoneStatus = signal->getKitchenPhoneStatus();
      arPhoneStatus[1].u16Contacttype = PHONENUMBER_KITCHEN;

      ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Upper deck"));
      arPhoneStatus[2].u16CurrentPhoneStatus = signal->getUpperDeckPhoneStatus();
      arPhoneStatus[2].u16Contacttype = PHONENUMBER_UPPERDECK;
      vCheckActiveCallCount(arPhoneStatus);

      OnUpdIcontactLists();
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
   }
}


void IntercomClienthandler::onEventPhoneStatusChangedError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventPhoneStatusChangedError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedError()"));
}


void IntercomClienthandler::onEventPhoneStatusChangedSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventPhoneStatusChangedSignal >& signal)
{
   if (_IntercomAudioServiceProxy != NULL)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() getPhoneNumber = %d", signal->getPhoneNumber()));
      ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() getPhoneStatus = %d", signal->getPhoneStatus()));
      tU16 u16PhoneStatus = signal->getPhoneStatus();
      tU16 u16Phonenumber = signal->getPhoneNumber();
      bool bPhoneconnectstatus = CheckConnection((!checkStBit(u16PhoneStatus, 0)), (!checkStBit(u16PhoneStatus, 1)));
      // bool bActiveCallstatus = (!checkStBit(u8PhoneStatus, 2));//on hook = 1 , pick up = 0
      if (u16Phonenumber == 1)
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Restroom"));
         bRestroomstatus = bPhoneconnectstatus;
         arPhoneStatus[0].u16CurrentPhoneStatus = signal->getPhoneStatus();
         arPhoneStatus[0].u16Contacttype = u16Phonenumber;
         vCheckActiveCallCount(arPhoneStatus);
      }
      else if (u16Phonenumber == 2)
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Kitchen"));
         bKitchenstatus = bPhoneconnectstatus;
         arPhoneStatus[1].u16CurrentPhoneStatus = signal->getPhoneStatus();
         arPhoneStatus[1].u16Contacttype = u16Phonenumber;
         vCheckActiveCallCount(arPhoneStatus);
      }
      else if (u16Phonenumber == 3)
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Upper deck"));
         bUpperDeckstatus = bPhoneconnectstatus;
         arPhoneStatus[2].u16CurrentPhoneStatus = signal->getPhoneStatus();
         arPhoneStatus[2].u16Contacttype = u16Phonenumber;
         vCheckActiveCallCount(arPhoneStatus);
      }
      else
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Invalid"));
      }
      OnUpdIcontactLists();
      ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() m_u8IntercomActiveCallCount =%d", m_u8IntercomActiveCallCount));
      if ((u16Contacttype == u16Phonenumber) && (bIsIntercomOutgoingCallPopupActive == true))
      {
         if ((PICK_UP == u16PhoneStatus) && (m_u8IntercomActiveCallCount == 1))
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Accept outgoing call"));
            IsIntercomCallActive = true;
            POST_MSG((COURIER_MESSAGE_NEW(AcceptOutgoingIntercomCall)()));
            bIsIntercomOutgoingCallPopupActive = false;
            bIsIntercomOngoingCallActive = true;
         }
         else if ((PICK_UP == u16PhoneStatus) && (m_u8IntercomActiveCallCount > 1))
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() outgoing call to  Conference call"));
            IsIntercomCallActive = true;
            OnUpdConferenceCall();
            bIsIntercomOutgoingCallPopupActive = false;
            bIsIntercomOngoingCallActive = false;
         }
         else if ((ONHOOKUP_NOTRINGING == u16PhoneStatus))
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Outgoing call is terminated"));
            OnUpdDisconnectCall();
            OnUpdMissedBTCall();
         }
         else
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() invalid phone status"));
         }
      }
      else if (true == bIsIntercomOngoingCallActive)
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Active call is terminated"));
         if ((PICK_UP == u16PhoneStatus) && (m_u8IntercomActiveCallCount > 1))
         {
            //Active call going on and the receivers of other intercom phones are picked condition

            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Active call to  Conference call"));
            IsIntercomCallActive = true;
            OnUpdConferenceCall();
            bIsIntercomOutgoingCallPopupActive = false;
            bIsIntercomOngoingCallActive = false;
         }
         else if ((u16Contacttype == u16Phonenumber) && (ONHOOKUP_NOTRINGING == u16PhoneStatus) && (m_u8IntercomActiveCallCount == 0))
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Active single call is terminated"));
            OnUpdDisconnectCall();
            OnUpdMissedBTCall();
         }
         else
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Active call - Invalis status"));
         }
      }
      else if ((true == m_bIsIntercomConfCallActive))  // m_bIsIntercomConfCallActive will say if the conference call is active and driver is in the call
      {
         //conference call -- update the conference call list
         if ((PICK_UP == u16PhoneStatus) && (m_u8IntercomActiveCallCount > 1))
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal()  Conference call"));
            IsIntercomCallActive = true;
            OnUpdConferenceCall();
            bIsIntercomOutgoingCallPopupActive = false;
            bIsIntercomOngoingCallActive = false;
         }
         else if ((ONHOOKUP_NOTRINGING == u16PhoneStatus) && (m_u8IntercomActiveCallCount > 0))
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() Outgoing call is terminated"));
            // OnUpdConferenceCall();
            OnUpdCancelCall();
         }
         else if ((ONHOOKUP_RINGING == u16PhoneStatus) && (m_u8IntercomActiveCallCount > 0))
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() ringing "));
            OnUpdConferenceCallList();
         }
         else
         {
            ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() invalid phone status"));
         }
      }
      else
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal()u16Contacttype = %d", u16Contacttype));
         ETG_TRACE_USR4(("IntercomClienthandler : onEventPhoneStatusChangedSignal() bIsIntercomOutgoingCallPopupActive = %d", bIsIntercomOutgoingCallPopupActive));
      }
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
   }
}


void IntercomClienthandler::OnUpdCancelCall()
{
   ETG_TRACE_USR3(("IntercomClienthandler::OnUpdCancelCall"));
   if (m_u8IntercomActiveCallCount == 1)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdCancelCall m_u8IntercomActiveCallCount == 1"));
      for (int i = 0; i < 3 ; i++)
      {
         if (PICK_UP == arPhoneStatus[i].u16CurrentPhoneStatus)
         {
            ETG_TRACE_USR3(("IntercomClienthandler::OnUpdCancelCall() Active call = %d", arPhoneStatus[i].u16CurrentPhoneStatus));
            POST_MSG((COURIER_MESSAGE_NEW(AcceptOutgoingIntercomCall)()));
            u16Contacttype = arPhoneStatus[i].u16Contacttype;
            Candera::String strcallerId = getCallerId(u16Contacttype);
            m_bIsIntercomConfCallActive = false;
            bIsIntercomOngoingCallActive = true;
            rfoIntercomModel.OnUpdCallProgressStatus(strcallerId, u16Contacttype);
            break;
         }
      }
   }
   else if (m_u8IntercomActiveCallCount > 1)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdCancelCall m_u8IntercomActiveCallCount > 1"));
      OnUpdConferenceCall();
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdCancelCall else"));
   }
}


void IntercomClienthandler::vCheckActiveCallCount(IntercomPhonestatus arPhoneStatus[3])
{
   ETG_TRACE_USR3(("IntercomClienthandler::vCheckActiveCallCount before for = %d", m_u8IntercomActiveCallCount));
   m_u8IntercomActiveCallCount = 0;
   for (int index = 0; index < 3 ; index++)
   {
      if ((arPhoneStatus[index].u16CurrentPhoneStatus == PICK_UP))
      {
         m_u8IntercomActiveCallCount++;
      }
   }
   ETG_TRACE_USR3(("IntercomClienthandler::vCheckActiveCallCount after for = %d", m_u8IntercomActiveCallCount));
}


void IntercomClienthandler::onGetPhoneStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetPhoneStatusError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onGetPhoneStatusError()"));
}


void IntercomClienthandler::onGetPhoneStatusResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetPhoneStatusResponse >& response)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onGetPhoneStatusResponse()"));
}


void IntercomClienthandler::onEventInterComConfigErrorError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventInterComConfigErrorError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onEventInterComConfigErrorError()"));
}


void IntercomClienthandler::onEventInterComConfigErrorSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventInterComConfigErrorSignal >& signal)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onEventInterComConfigErrorSignal()"));
   if (_IntercomAudioServiceProxy != NULL)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : onEventInterComConfigErrorSignal() %d", signal->getErrorCodes()));
      if (ERRORCODE_ZERO == signal->getErrorCodes())
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventInterComConfigErrorSignal(): No error"));
         m_bEventInterComConfigErrorStatus = false;
         ValidateIntercomStatus();
      }
      else if ((signal->getErrorCodes() > ERRORCODE_ZERO) && (ERRORCODE_SEVEN >= signal->getErrorCodes()))
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventInterComConfigErrorSignal() : Intercomconfig error"));
         m_bEventInterComConfigErrorStatus = true;
         ValidateIntercomStatus();
      }
      else
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventInterComConfigErrorSignal(): out of range "));
      }
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
   }
}


void IntercomClienthandler::onEventNanoMessageErrorStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventNanoMessageErrorStatusError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onEventNanoMessageErrorStatusError()"));
}


void IntercomClienthandler::onEventNanoMessageErrorStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventNanoMessageErrorStatusSignal >& signal)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onEventNanoMessageErrorStatusSignal()"));
   if (_IntercomAudioServiceProxy != NULL)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : onEventNanoMessageErrorStatusSignal() %d", signal->getErrorCodes()));
      if (ERRORCODE_ZERO == signal->getErrorCodes())
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventNanoMessageErrorStatusSignal(): No error"));
         //m_bEventNanoMessageErrorStatus = false;
      }
      else if ((signal->getErrorCodes() > ERRORCODE_ZERO) && (ERRORCODE_FIVE >= signal->getErrorCodes()))
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventNanoMessageErrorStatusSignal() : Intercomconfig error"));
         //m_bEventNanoMessageErrorStatus = true;
         //ValidateIntercomStatus();
      }
      else
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventNanoMessageErrorStatusSignal(): out of range "));
      }
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
   }
}


void IntercomClienthandler::onEventRTPErrorStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventRTPErrorStatusError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onEventRTPErrorStatusError()"));
}


void IntercomClienthandler::onEventRTPErrorStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventRTPErrorStatusSignal >& signal)
{
   ETG_TRACE_USR4(("IntercomClienthandler : onEventRTPErrorStatusSignal()"));
   if (_IntercomAudioServiceProxy != NULL)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : onEventRTPErrorStatusSignal() %d", signal->getErrorCodes()));
      if (ERRORCODE_ZERO == signal->getErrorCodes())
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventRTPErrorStatusSignal(): No error"));
         m_bEventRTPErrorStatus = false;
         ValidateIntercomStatus();
      }
      else if ((signal->getErrorCodes() > ERRORCODE_ZERO) && (ERRORCODE_TWENTY >= signal->getErrorCodes()))
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventRTPErrorStatusSignal() : Intercomconfig error"));
         m_bEventRTPErrorStatus = true;
         ValidateIntercomStatus();
         POST_MSG((COURIER_MESSAGE_NEW(IntercomRTPStreamFailureResp)()));
      }
      else
      {
         ETG_TRACE_USR4(("IntercomClienthandler : onEventRTPErrorStatusSignal(): out of range "));
      }
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
   }
}


void IntercomClienthandler::OnUpdIcontactLists()
{
   ETG_TRACE_USR4(("IntercomClienthandler : OnUpdIcontactLists()"));
   int index = 0;
   int Callstatusindex = 0;
   bool bInophoneconnected = false;
   if (bRestroomstatus == true)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdIcontactLists()  - Restroom"));
      arContactinfo[index].strCallerId = Candera::String(TextId_0x1712); //"Rest Cabin";//
      arContactinfo[index].u16Contacttype = 1;
      Callstatusindex = 0;
      arContactinfo[index].strCallStatus =  getCallStatus(Callstatusindex);
      index++;
   }
   if (bKitchenstatus == true)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdIcontactLists() - kitchen"));
      arContactinfo[index].strCallerId = Candera::String(TextId_0x14B2); //"Kitchen" ;//
      arContactinfo[index].u16Contacttype = 2;
      Callstatusindex = 1;
      arContactinfo[index].strCallStatus =  getCallStatus(Callstatusindex);
      index++;
   }
   if (bUpperDeckstatus == true)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdIcontactLists() - upperdeck"));
      arContactinfo[index].strCallerId = Candera::String(TextId_0x14B4);//"Upper Deck";//
      arContactinfo[index].u16Contacttype = 3;
      Callstatusindex = 2;
      arContactinfo[index].strCallStatus = getCallStatus(Callstatusindex);
      index++;
   }
   if ((false == bRestroomstatus) && (false == bKitchenstatus) && (false == bUpperDeckstatus))
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdIcontactLists() - No phone connected"));
      bInophoneconnected = true;
   }
   rfoIntercomModel.OnUpdIntercomNoPhoneConnected(bInophoneconnected);
   rfoIntercomModel.OnUpdIntercomContactList(arContactinfo, index); //to model*/
   if (_isCabinOnly)
   {
      OnUpdIGadgetContactLists();
   }
}


void IntercomClienthandler::OnUpdIGadgetContactLists()
{
   ETG_TRACE_USR4(("IntercomClienthandler : OnUpdIGadgetContactLists()"));
   IntercomGadgetContactinfo arGadgetContactinfo[MAX_SIZE];
   float node_available_position = -1.0f ;
   float node_not_available_postion = 0.0f;

   arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].isVisible = bRestroomstatus;
   arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].x = bRestroomstatus ? node_available_position : node_not_available_postion;
   arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].y = bRestroomstatus ? node_available_position : node_not_available_postion;

   arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].isVisible = bKitchenstatus;
   arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].x = bKitchenstatus ? node_available_position : node_not_available_postion;
   arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].y = bKitchenstatus ? node_available_position : node_not_available_postion;

   arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].isVisible = bUpperDeckstatus;
   arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].x = bUpperDeckstatus ? node_available_position : node_not_available_postion;
   arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].y = bUpperDeckstatus ? node_available_position : node_not_available_postion;

   if ((false == IsIntercomCallActive) || (false == bIsIntercomOutgoingCallPopupActive) || (false == bIsIntercomOngoingCallActive) || (false == m_bIsIntercomConfCallActive))
   {
      arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].isEnabled = true;
      arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].isActive = false;
      arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].isEnabled = true;
      arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].isActive = false;
      arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].isEnabled = true;
      arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].isActive = false;
   }

   if ((true == IsIntercomCallActive) || (true == bIsIntercomOutgoingCallPopupActive) || (true == bIsIntercomOngoingCallActive) || (true == m_bIsIntercomConfCallActive))
   {
      if ((PICK_UP == arPhoneStatus[INDEX_PHONENUMBER_RESTROOM].u16CurrentPhoneStatus) || (ONHOOKUP_RINGING == arPhoneStatus[INDEX_PHONENUMBER_RESTROOM].u16CurrentPhoneStatus))
      {
         arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].isEnabled = true;
         arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].isActive = true;
      }
      if (ONHOOKUP_NOTRINGING == arPhoneStatus[INDEX_PHONENUMBER_RESTROOM].u16CurrentPhoneStatus)
      {
         arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].isEnabled = false;
         arGadgetContactinfo[INDEX_PHONENUMBER_RESTROOM].isActive = false;
      }

      if ((PICK_UP == arPhoneStatus[INDEX_PHONENUMBER_KITCHEN].u16CurrentPhoneStatus) || (ONHOOKUP_RINGING == arPhoneStatus[INDEX_PHONENUMBER_KITCHEN].u16CurrentPhoneStatus))
      {
         arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].isEnabled = true;
         arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].isActive = true;
      }
      if (ONHOOKUP_NOTRINGING == arPhoneStatus[INDEX_PHONENUMBER_KITCHEN].u16CurrentPhoneStatus)
      {
         arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].isEnabled = false;
         arGadgetContactinfo[INDEX_PHONENUMBER_KITCHEN].isActive = false;
      }

      if ((PICK_UP == arPhoneStatus[INDEX_PHONENUMBER_UPPERDECK].u16CurrentPhoneStatus) || (ONHOOKUP_RINGING == arPhoneStatus[INDEX_PHONENUMBER_UPPERDECK].u16CurrentPhoneStatus))
      {
         arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].isEnabled = true;
         arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].isActive = true;
      }
      if (ONHOOKUP_NOTRINGING == arPhoneStatus[INDEX_PHONENUMBER_UPPERDECK].u16CurrentPhoneStatus)
      {
         arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].isEnabled = false;
         arGadgetContactinfo[INDEX_PHONENUMBER_UPPERDECK].isActive = false;
      }
   }

   rfoIntercomModel.onUpdIntercomGadgetTileInfo();
   rfoIntercomModel.OnUpdIntercomGadgetList(arGadgetContactinfo);
}


Candera::String IntercomClienthandler::getCallerId(tU32 u32callerId)
{
   Candera::String strcallerid;
   ETG_TRACE_USR3(("IntercomClienthandler::getCallerId() Caller ID = %d", u32callerId));
   switch (u32callerId)
   {
      case 0:
         strcallerid = "Mic1";
         break;
      case 1:
         strcallerid = Candera::String(TextId_0x1712);
         break;
      case 2:
         strcallerid = Candera::String(TextId_0x14B2);
         break;
      case 3:
         strcallerid = Candera::String(TextId_0x14B4);
         break;
      default:
         break;
   }
   return strcallerid;
}


Candera::String IntercomClienthandler::getCallStatus(int Callstatusindex)
{
   ETG_TRACE_USR3(("IntercomClienthandler::getCallStatus"));
   Candera::String strcallerid;
   if (PICK_UP == arPhoneStatus[Callstatusindex].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::getCallStatus, PICK_UP"));
      strcallerid = Candera::String(TextId_0x1716);
   }
   else if (ONHOOKUP_NOTRINGING == arPhoneStatus[Callstatusindex].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::getCallStatus ONHOOKUP_NOTRINGING"));
      strcallerid = Candera::String(TextId_0x1713);
   }
   else if (ONHOOKUP_RINGING == arPhoneStatus[Callstatusindex].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::getCallStatus ONHOOKUP_RINGING"));
      strcallerid = Candera::String(TextId_0x1717);
   }
   return strcallerid;
}


bool IntercomClienthandler::checkStBit(unsigned char byte, int index)
{
   ETG_TRACE_USR3(("IntercomClienthandler::checkStBit"));
   return ((byte & (1 << index)) != 0);
}


bool IntercomClienthandler::CheckConnection(bool bEnable, bool bConnection)
{
   ETG_TRACE_USR3(("IntercomClienthandler::CheckConnection"));
   return (bEnable && bConnection);
}


void IntercomClienthandler::onEventAudioAllocationStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy,
      const ::boost::shared_ptr< EventAudioAllocationStatusError >& error)
{
   ETG_TRACE_USR3(("IntercomClienthandler::onEventAudioAllocationStatusError"));
}


void IntercomClienthandler::onEventAudioAllocationStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy,
      const ::boost::shared_ptr< EventAudioAllocationStatusSignal >& signal)
{
   if (_IntercomAudioServiceProxy != NULL)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onEventAudioAllocationStatusSignal Status %d", signal->getAllocationStatus()));
      m_audioallocationstatus = signal->getAllocationStatus();
      vCheckAudioAllocationinIncomingCall();
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onEventAudioAllocationStatusSignal _IntercomAudioServiceProxy Null pointer"));
   }
}


void IntercomClienthandler::OnUpdMissedBTCall()
{
   ETG_TRACE_USR3(("IntercomClienthandler::OnUpdMissedBTCall"));
   if (true == ServiceTel::poGetInstance()->getMissedBTCallStatus())
   {
      ServiceTel::poGetInstance()->setMissedBTCallStatus(false);
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(ShowPriorityCall_Intercom_Req)()));
   }
}


void IntercomClienthandler::OnUpdTerminateCall()
{
   ETG_TRACE_USR3(("IntercomClienthandler::OnUpdTerminateCall"));

   if ((true == IsIntercomCallActive) || (true == bIsIntercomIncomingCallPopupActive) || (true == bIsIntercomOutgoingCallPopupActive) || (true == bIsIntercomOngoingCallActive))
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdTerminateCall - Incoming/Active/outgoing call"));
      OnUpdDisconnectCall();
      m_bIntercomIncomingSignal = false;
      _IntercomAudioServiceProxy->sendCallActionRequest(*this, INTERCOMCALL_RESPONSE_REJECT);
   }

   if (true == m_bIsIntercomConfCallActive)
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdTerminateCall  conference call"));
      OnUpdDisconnectConfCall();
      _IntercomAudioServiceProxy->sendCallActionRequest(*this, INTERCOMCALL_RESPONSE_REJECT);
   }
   OnUpdMissedBTCall();
}


bool IntercomClienthandler::onCourierMessage(const TerminateIConfCall& oMsg)
{
   ETG_TRACE_USR3(("IntercomClienthandler::TerminateIConfCall"));
   _IntercomAudioServiceProxy->sendCallActionRequest(*this, INTERCOMCALL_RESPONSE_REJECT);
   //Check with Monojit.. need to send disconnect to MW or not
   OnUpdDisconnectConfCall();
   OnUpdMissedBTCall();
   return true;
}


/************************************************
Function 	: onRspIntercomAvailableError
Parameters 	:
Description : This provides the physical intercom
*             connection error response
SYSFL/SWFL  :
Author      : Bruce Netto 10/12/2020
************************************************/
void IntercomClienthandler::onRspIntercomAvailableError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy,
      const ::boost::shared_ptr< RspIntercomAvailableError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onRspIntercomAvailableError"));
}


/************************************************
Function 	: onRspIntercomAvailableSignal
Parameters 	:
Description : This provides physical intercom
*             connection status during startup
SYSFL/SWFL  :
Author      : Bruce Netto 10/12/2020
************************************************/
void IntercomClienthandler::onRspIntercomAvailableSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy,
      const ::boost::shared_ptr< RspIntercomAvailableSignal >& signal)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onRspIntercomAvailableSignal"));
   if (_IntercomAudioServiceProxy != NULL)
   {
      //Provides the physical connection status of Intercom on Startup
      //0 - Intercom Unavailable , 1 - Intercom Available
      m_uint8StartupIntercomAvailable = signal->getAvailable();
      ValidateIntercomStatus();
      ETG_TRACE_USR4(("IntercomClienthandler::onRspIntercomAvailableSignal m_uint8StartupIntercomAvailable %d", signal->getAvailable()));
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onRspIntercomAvailableSignal _IntercomAudioServiceProxy Null pointer"));
   }
}


/************************************************
Function 	: onEventIntercomAvailableError
Parameters 	:
Description : This provides the physical intercom
*             connection error response
SYSFL/SWFL  :
Author      : Bruce Netto 10/12/2020
************************************************/
void IntercomClienthandler::onEventIntercomAvailableError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy,
      const ::boost::shared_ptr< EventIntercomAvailableError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onEventIntercomAvailableError"));
}


/************************************************
Function 	: onEventIntercomAvailableSignal
Parameters 	:
Description : This provides physical intercom
*             connection status once start up is complete
SYSFL/SWFL  :
Author      : Bruce Netto 10/12/2020
************************************************/
void IntercomClienthandler::onEventIntercomAvailableSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy,
      const ::boost::shared_ptr< EventIntercomAvailableSignal >& signal)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onEventIntercomAvailableSignal"));
   if (_IntercomAudioServiceProxy != NULL)
   {
      //Provides the physical connection status of Intercom after startup is completed
      //0 - Intercom Unavailable , 1 - Intercom Available
      m_uint8StartupIntercomAvailable = signal->getAvailable();
      ValidateIntercomStatus();
      ETG_TRACE_USR4(("IntercomClienthandler::onEventIntercomAvailableSignal m_uint8StartupIntercomAvailable %d", signal->getAvailable()));
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::onEventIntercomAvailableSignal _IntercomAudioServiceProxy Null pointer"));
   }
}


/************************************************
Function 	: onGetAvailabilityError
Parameters 	:
Description : This provides the error response whether
*             getavailability send request was not reached
SYSFL/SWFL  :
Author      : Bruce Netto 10/12/2020
************************************************/
void IntercomClienthandler::onGetAvailabilityError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy,
      const ::boost::shared_ptr< GetAvailabilityError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onGetAvailabilityError"));
}


/************************************************
Function 	: onGetAvailabilityResponse
Parameters 	:
Description : This provides the response whether
*             getavailability send request was received
*             in lower layer
SYSFL/SWFL  :
Author      : Bruce Netto 10/12/2020
************************************************/
void IntercomClienthandler::onGetAvailabilityResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy,
      const ::boost::shared_ptr< GetAvailabilityResponse >& response)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onGetAvailabilityResponse"));
}


bool IntercomClienthandler::onCourierMessage(const IntercomCallResponseReq& oMsg)
{
   ETG_TRACE_USR4(("IntercomClienthandler :: onCourierMessage : IntercomCallResponseReq CallActionStatus= %d",
                   ETG_CENUM(IntercomCallResponse, (IntercomCallResponse)oMsg.GetCallActionStatus())));
   //Extract the Call Status recieved in the COurier Message
   IntercomCallResponse enIntercomIncomingCallResponse = oMsg.GetCallActionStatus();
   ETG_TRACE_USR3(("IntercomClienthandler::m_u8IntercomActiveCallCount = %d", m_u8IntercomActiveCallCount));
   if (_IntercomAudioServiceProxy != NULL)
   {
      if (INTERCOMCALL_RESPONSE_ACCEPT == enIntercomIncomingCallResponse)
      {
         ETG_TRACE_USR3(("IntercomClienthandler::INTERCOMCALL_RESPONSE_ACCEPT"));
         if (m_u8IntercomActiveCallCount == 1)
         {
            ETG_TRACE_USR3(("IntercomClienthandler::INTERCOMCALL_RESPONSE_ACCEPT m_u8IntercomActiveCallCount = 1"));
            _IntercomAudioServiceProxy->sendCallActionRequest(*this, INTERCOMCALL_RESPONSE_ACCEPT);
            rfoIntercomModel.OnUpdCallProgressStatus(strcallerId, u16Contacttype);
            IsIntercomCallActive = true;
            bIsIntercomIncomingCallPopupActive = false;
            bIsIntercomOngoingCallActive = true;
            m_bIntercomIncomingSignal = false;
            POST_MSG((COURIER_MESSAGE_NEW(OnIntercomIncomingCallRespMsg)()));
         }
         else if (m_u8IntercomActiveCallCount > 1)
         {
            // conference call
            ETG_TRACE_USR3(("IntercomClienthandler::INTERCOMCALL_RESPONSE_ACCEPT -- Conference m_u8IntercomActiveCallCount >1"));
            _IntercomAudioServiceProxy->sendCallActionRequest(*this, INTERCOMCALL_RESPONSE_ACCEPT);
            OnUpdConferenceCall();
            IsIntercomCallActive = true;
            bIsIntercomIncomingCallPopupActive = false;
            bIsIntercomOngoingCallActive = false;
            m_bIntercomIncomingSignal = false;
            POST_MSG((COURIER_MESSAGE_NEW(OnIntercomIncomingConfCallRespMsg)()));
         }
         else
         {
            ETG_TRACE_USR3(("IntercomClienthandler::INTERCOMCALL_RESPONSE_ACCEPT -- Invalid"));
         }
      }
      else if (INTERCOMCALL_RESPONSE_REJECT == enIntercomIncomingCallResponse)
      {
         ETG_TRACE_USR3(("IntercomClienthandler::INTERCOMCALL_RESPONSE_REJECT"));
         _IntercomAudioServiceProxy->sendCallActionRequest(*this, INTERCOMCALL_RESPONSE_REJECT);
         OnUpdDisconnectCall();
         OnUpdMissedBTCall();
      }
      else if (INTERCOMCALL_RESPONSE_CONF_REJECT == enIntercomIncomingCallResponse)
      {
         ETG_TRACE_USR3(("IntercomClienthandler::INTERCOMCALL_RESPONSE_CONF_REJECT"));
         _IntercomAudioServiceProxy->sendCallActionRequest(*this, INTERCOMCALL_RESPONSE_REJECT);
         OnUpdDisconnectConfCall();
         OnUpdMissedBTCall();
      }
      else
      {
         ETG_TRACE_USR3(("IntercomClienthandler::Invalid response"));
      }
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
   }

   return true;
}


void IntercomClienthandler::OnUpdDisconnectCall()
{
   ETG_TRACE_USR4(("IntercomClienthandler : OnUpdDisconnectCall()"));
   IsIntercomCallActive = false;
   bIsIntercomIncomingCallPopupActive = false;
   bIsIntercomOutgoingCallPopupActive = false;
   bIsIntercomOngoingCallActive = false;
   m_bIntercomIncomingSignal = false;
   POST_MSG((COURIER_MESSAGE_NEW(IntercomCallEndStatus)()));
   POST_MSG((COURIER_MESSAGE_NEW(OnIntercomCallEndRespMsg)()));
}


void IntercomClienthandler::OnUpdDisconnectConfCall()
{
   ETG_TRACE_USR4(("IntercomClienthandler : OnUpdDisconnectCall()"));
   IsIntercomCallActive = false;
   bIsIntercomIncomingCallPopupActive = false;
   bIsIntercomOutgoingCallPopupActive = false;
   bIsIntercomOngoingCallActive = false;
   m_bIntercomIncomingSignal = false;
   m_bIsIntercomConfCallActive = false;
   POST_MSG((COURIER_MESSAGE_NEW(IntercomCallEndStatus)()));
   POST_MSG((COURIER_MESSAGE_NEW(OnIntercomConfCallEndRespMsg)()));
}


bool IntercomClienthandler::getIntercomServiceAvailability()
{
   return bIsIntercomServiceAvailable;
}


bool IntercomClienthandler::onCourierMessage(const IContactsReq& oMsg)
{
   ETG_TRACE_USR4(("IntercomClienthandler : IContactsReq()"));
   if (_IntercomAudioServiceProxy != NULL)
   {
      _IntercomAudioServiceProxy->sendGetPhoneStatusRequest(*this);
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
   }
   return true;
}


bool IntercomClienthandler::onCourierMessage(const IntercomGadgetUpdateMsg& oMsg)
{
   ETG_TRACE_USR4(("IntercomModel::IntercomGadgetUpdateMsg"));
   if ((_isCabinOnly) && (_IntercomAudioServiceProxy != NULL))
   {
      ETG_TRACE_USR3(("IntercomClienthandler::sendGetPhoneStatusRequest"));
      _IntercomAudioServiceProxy->sendGetPhoneStatusRequest(*this);
   }

   return true;
}


bool IntercomClienthandler::onCourierMessage(const ButtonReactionMsg& oMsg)
{
   bool bRetVal = false;
   ETG_TRACE_USR4(("IntercomClienthandler : ButtonReactionMsg()"));
   const Courier::Identifier senderInfo = oMsg.GetSender();
   const Courier::ViewId sceneName = oMsg.GetView();
   const Courier::ViewId GADGET_CABIN = Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_CABIN");
   const Courier::Identifier  IdBtnRestRoom = Courier::Identifier("Layer_Intercom_RestCabin/ButtonWidget2D");
   const Courier::Identifier  IdBtnKitchen = Courier::Identifier("Layer_Intercom_Kitchen/ButtonWidget2D");
   const Courier::Identifier  IdBtnUperDeck = Courier::Identifier("Layer_Intercom_UpperDeck/ButtonWidget2D");
   tU8 rowValue ;
   if ((oMsg.GetEnReaction() == enRelease) && (true == _isCabinOnly) && (sceneName == GADGET_CABIN))
   {
      ETG_TRACE_USR4(("IntercomClienthandler : ButtonReactionMsg - enRelease"));
      if (senderInfo == IdBtnRestRoom)
      {
         rowValue = INDEX_PHONENUMBER_RESTROOM;
      }
      if (senderInfo == IdBtnKitchen)
      {
         rowValue = INDEX_PHONENUMBER_KITCHEN;
      }
      if (senderInfo == IdBtnUperDeck)
      {
         rowValue = INDEX_PHONENUMBER_UPPERDECK;
      }
      OnUpdIContactsCall(rowValue);
      bRetVal = true;
   }
   return bRetVal;
}


void IntercomClienthandler::OnUpdIContactsCall(tU8 hdlRow)
{
   ETG_TRACE_USR4(("IntercomClienthandler : OnUpdIContactsCall hdlrow = %d", hdlRow));
   if ((MicClientHandler::poGetInstance()->getMicStatus() == false)) //MIC CHECK Outgoing Call
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall MIC is not Active"));
      strcallerId = arContactinfo[hdlRow].strCallerId;
      u16Contacttype = arContactinfo[hdlRow].u16Contacttype;
      if (_IntercomAudioServiceProxy != NULL)
      {
         if (true == IsIntercomCallActive)
         {
            ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall IsIntercomCallActive == true "));
            if ((m_u8IntercomActiveCallCount > 0) && (false == BIsCheckCallStatus(u16Contacttype)))
            {
               ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall BIsCheckCallStatus false"));
               _IntercomAudioServiceProxy->sendOutgoingCallRequest(*this, u16Contacttype);
               OnUpdConferenceCall();
            }
            else
            {
               ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall BIsCheckCallStatus true"));
            }
         }
         else
         {
            ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall IsIntercomCallActive == false "));
            if (false == BIsCheckCallStatus(u16Contacttype))
            {
               ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall BIsCheckCallStatus == false "));
               _IntercomAudioServiceProxy->sendOutgoingCallRequest(*this, u16Contacttype);
               rfoIntercomModel.OnUpdCallProgressStatus(strcallerId, u16Contacttype);
               bIsIntercomOutgoingCallPopupActive = true;
               POST_MSG((COURIER_MESSAGE_NEW(SwitchToICallConnecting)()));
            }
            else
            {
               ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall BIsCheckCallStatus == true "));
               if (m_u8IntercomActiveCallCount == 1)
               {
                  //Single Active call
                  ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall m_u8IntercomActiveCallCount == 1"));
                  _IntercomAudioServiceProxy->sendOutgoingCallRequest(*this, u16Contacttype);
                  bIsIntercomOutgoingCallPopupActive = false;
                  bIsIntercomOngoingCallActive = true;
                  IsIntercomCallActive = true;
                  rfoIntercomModel.OnUpdCallProgressStatus(strcallerId, u16Contacttype);
                  POST_MSG((COURIER_MESSAGE_NEW(AcceptOutgoingIntercomCall)()));
               }
               else
               {
                  //Conference call
                  ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall m_u8IntercomActiveCallCount != 1"));
                  _IntercomAudioServiceProxy->sendOutgoingCallRequest(*this, u16Contacttype);
                  OnUpdConferenceCall();
               }
            }
         }
      }
      else
      {
         ETG_TRACE_USR3(("IntercomClienthandler::_IntercomAudioServiceProxy Null pointer"));
      }
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIContactsCall Mic is Active"));
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(MICIntercomCallResp)()));
   }
}


bool IntercomClienthandler::BIsCheckCallStatus(tU16 u16Contacttype)
{
   // bool bRetVal = false;
   ETG_TRACE_USR3(("IntercomClienthandler::BIsCheckCallStatus"));
   ETG_TRACE_USR3(("IntercomClienthandler::BIsCheckCallStatus u16Contacttype = %d", u16Contacttype));
   bool bCallstatus = false;

   if ((u16Contacttype == 1) && (PICK_UP == arPhoneStatus[0].u16CurrentPhoneStatus))
   {
      ETG_TRACE_USR4(("IntercomClienthandler : BIsCheckCallStatus() Restroom"));
      bCallstatus = true;
   }
   else if ((u16Contacttype == 2) && (PICK_UP == arPhoneStatus[1].u16CurrentPhoneStatus))
   {
      ETG_TRACE_USR4(("IntercomClienthandler : BIsCheckCallStatus() Kitchen"));
      bCallstatus = true;
   }
   else if ((u16Contacttype == 3) && (PICK_UP == arPhoneStatus[2].u16CurrentPhoneStatus))
   {
      ETG_TRACE_USR4(("IntercomClienthandler : BIsCheckCallStatus() Upper deck"));
      bCallstatus = true;
   }
   else
   {
      ETG_TRACE_USR4(("IntercomClienthandler : BIsCheckCallStatus() Invalid"));
   }

   /*  if ((true == IsIntercomCallActive) && (false == bCallstatus))
    {
       ETG_TRACE_USR4(("IntercomClienthandler : BIsCheckCallStatus() selected contact call is not active"));
       bRetVal = false;
    }
    else
    {
       ETG_TRACE_USR4(("IntercomClienthandler : BIsCheckCallStatus() selected contact call is active"));
       bRetVal = true;
    } */

   return bCallstatus;
}


void IntercomClienthandler::OnUpdConferenceCall()
{
   ETG_TRACE_USR4(("IntercomClienthandler : OnUpdIConferenceCall "));
   if ((MicClientHandler::poGetInstance()->getMicStatus() == false)) //MIC CHECK Outgoing Call
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIConferenceCall MIC is not Active"));
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(SwitchToIConferenceCall)()));
      OnUpdConferenceCallList();
      m_bIsIntercomConfCallActive = true;
   }
   else
   {
      ETG_TRACE_USR3(("IntercomClienthandler::OnUpdIConferenceCall Mic is Active"));
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(MICIntercomCallResp)()));
   }
}


void IntercomClienthandler::OnUpdConferenceCallList()
{
   ETG_TRACE_USR3(("IntercomClienthandler::OnUpdConferenceCallList "));
   int index = 0;
   ETG_TRACE_USR3(("IntercomClienthandler::OnUpdConferenceCallList Driver is in Call"));
   if (PICK_UP == arPhoneStatus[0].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList()  - Restroom PICK_UP"));
      arConfCalllist[index].strCallerId = Candera::String(TextId_0x1712); //"Rest Cabin";//
      arConfCalllist[index].u16Contacttype = 1;
      arConfCalllist[index].strCallStatus = Candera::String(TextId_0x1716); //active call status
      index++;
   }
   else if (ONHOOKUP_RINGING == arPhoneStatus[0].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList()  - Restroom - ONHOOKUP_RINGING"));
      arConfCalllist[index].strCallerId = Candera::String(TextId_0x1712); //"Rest Cabin";//
      arConfCalllist[index].u16Contacttype = 1;
      arConfCalllist[index].strCallStatus = Candera::String(TextId_0x1717); //ringing call status
      index++;
   }
   else
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList()  - Invalid callstatus for Rest Cabin"));
   }
   if (PICK_UP == arPhoneStatus[1].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList() - kitchen - PICK_UP"));
      arConfCalllist[index].strCallerId = Candera::String(TextId_0x14B2); //"Kitchen" ;//
      arConfCalllist[index].u16Contacttype = 2;
      arConfCalllist[index].strCallStatus = Candera::String(TextId_0x1716); //active call status
      index++;
   }
   else if (ONHOOKUP_RINGING == arPhoneStatus[1].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList()  - Kitchen - ONHOOKUP_RINGING "));
      arConfCalllist[index].strCallerId = Candera::String(TextId_0x14B2); //"Rest Cabin";//
      arConfCalllist[index].u16Contacttype = 2;
      arConfCalllist[index].strCallStatus = Candera::String(TextId_0x1717); //active call status
      index++;
   }
   else
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList()  - Invalid callstatus Kitchen"));
   }
   if (PICK_UP == arPhoneStatus[2].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList() - upperdeck - PICK_UP"));
      arConfCalllist[index].strCallerId = Candera::String(TextId_0x14B4);//"Upper Deck";//
      arConfCalllist[index].u16Contacttype = 3;
      arConfCalllist[index].strCallStatus = Candera::String(TextId_0x1716); //active call status
      index++;
   }
   else if (ONHOOKUP_RINGING == arPhoneStatus[2].u16CurrentPhoneStatus)
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList()  - Upperdeck - ONHOOKUP_RINGING"));
      arConfCalllist[index].strCallerId = Candera::String(TextId_0x14B4); //"Upperdeck";//
      arConfCalllist[index].u16Contacttype = 3;
      arConfCalllist[index].strCallStatus = Candera::String(TextId_0x1717); //active call status
      index++;
   }
   else
   {
      ETG_TRACE_USR4(("IntercomClienthandler : OnUpdConferenceCallList()  - Invalid callstatus Upperdeck"));
   }

   rfoIntercomModel.OnUpdIntercomConferenceCallListStatus(arConfCalllist, index);
}


//Removed Pluginendstaion update as it is depreciated from avdec plugin

void IntercomClienthandler::ValidateIntercomStatus()
{
   ETG_TRACE_USR4(("IntercomClienthandler::ValidateIntercomStatus"));
   ETG_TRACE_USR4(("IntercomClienthandler::onCourierMessage:ValidateIntercomStatus bIsIntercomServiceAvailable=%d", bIsIntercomServiceAvailable));
   ETG_TRACE_USR4(("IntercomClienthandler::onCourierMessage:ValidateIntercomStatus m_bIsCMAavailable=%d", m_bIsCMAavailable));
   ETG_TRACE_USR4(("IntercomClienthandler::onCourierMessage:ValidateIntercomStatus m_bEventInterComConfigErrorStatus=%d", m_bEventInterComConfigErrorStatus));
   ETG_TRACE_USR4(("IntercomClienthandler::onCourierMessage:ValidateIntercomStatus m_bEventNanoMessageErrorStatus=%d", m_bEventNanoMessageErrorStatus));
   ETG_TRACE_USR4(("IntercomClienthandler::onCourierMessage:ValidateIntercomStatus m_bEventRTPErrorStatus=%d", m_bEventRTPErrorStatus));
   ETG_TRACE_USR4(("IntercomClienthandler::onCourierMessage:ValidateIntercomStatus m_uint8StartupIntercomAvailable=%d", m_uint8StartupIntercomAvailable));
   bool bAppFlyinStatus = false;
   if ((false == bIsIntercomServiceAvailable)
         || (false == m_bIsCMAavailable)//Master CMA Error Check
         || (true == m_bEventInterComConfigErrorStatus) //Config Error Check
         || (false == m_bEventNanoMessageErrorStatus)// Master Nano Plugin Check
         || (true == m_bEventRTPErrorStatus) //RTP Error Check
         || (0 == m_uint8StartupIntercomAvailable)//Physical Intercom Connection Check
         /*  || (false == ErrorHandler::poGetInstance()->getCockpitModeState())//CockpitStatuscheck
           || (true == ErrorHandler::poGetInstance()->getNanoMsgError())//Nano LCM Error Check
           || (true == ErrorHandler::poGetInstance()->getAvdeccdError())*/)//Avdeccd LCM Error Check)
   {
      ETG_TRACE_USR4(("IntercomClienthandler::ValidateIntercomStatus:Intercom Tile and Appflyin unavailable"));
      PhoneGadgetModel::poGetInstance()->SetIntercomStatus(false);
      //Temporary only for error handling.Later the courier message has to be changed by writing new courier message
      OnUpdTerminateCall();
      if (ServiceBT::poGetInstance()->GetBluetoothOnOffStatus() == true)
      {
         bAppFlyinStatus = true;
         ETG_TRACE_USR4(("IntercomClienthandler::ValidateIntercomStatus bAppFlyinStatus = %d", bAppFlyinStatus));
      }
      else
      {
         bAppFlyinStatus = false;
         ETG_TRACE_USR4(("IntercomClienthandler::ValidateIntercomStatus bAppFlyinStatus = %d", bAppFlyinStatus));
      }

      POST_MSG((COURIER_MESSAGE_NEW(PhoneGadgetRequestMsg)(12)));
   }
   else
   {
      ETG_TRACE_USR4(("IntercomClienthandler::ValidateIntercomStatus:Intercom Tile available"));
      PhoneGadgetModel::poGetInstance()->SetIntercomStatus(true);
      bAppFlyinStatus = true;
      ETG_TRACE_USR4(("IntercomClienthandler::ValidateIntercomStatus bAppFlyinStatus = %d", bAppFlyinStatus));
   }
   if (_isCabinOnly)
   {
      rfoIntercomModel.onUpdIntercomGadgetTileInfo();
   }
//Post the BT on/off status to ApplicationSwitchClientHandler to enable/disable Phone AppFlyIn.
   POST_MSG((COURIER_MESSAGE_NEW(BtOnOffStatusAppFlyInReq)(bAppFlyinStatus)));
}


/************************************************
Function 	: onCabinsSourceRestorationInfoError
Parameters 	:
Description : This error of the SystemInfo
*             if not delivered to HMI is sent from this interface
SYSFL/SWFL  :
Author      : Bruce Netto 09/09/2021
************************************************/
void IntercomClienthandler::onCabinsSourceRestorationInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< CabinsSourceRestorationInfoError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSourceRestorationInfoError"));
}


/************************************************
Function 	: onCabinsSourceRestorationInfoUpdate
Parameters 	:
Description : This error of the Restoration Info
*             if not delivered to HMI is sent from this interface
SYSFL/SWFL  :
Author      : Bruce Netto 09/09/2021
************************************************/
void IntercomClienthandler::onCabinsSourceRestorationInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< CabinsSourceRestorationInfoUpdate >& update)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSourceRestorationInfoUpdate"));
}


/************************************************
Function 	: onCabinsSystemsInfoError
Parameters 	:
Description : This error of the SystemInfo
*             if not delivered to HMI is sent from this interface
SYSFL/SWFL  :
Author      : Bruce Netto 06/09/2021
************************************************/
void IntercomClienthandler::onCabinsSystemsInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< CabinsSystemsInfoError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoError"));
}


/************************************************
Function 	: onCabinsSystemsInfoUpdate
Parameters 	:
Description : This status is received from HMI_Master
*             if there is a status change in the
*             sub systems like CM-A, PNM, CM-G etc
SYSFL/SWFL  :
Author      : Bruce Netto 06/09/2021
************************************************/
void IntercomClienthandler::onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< CabinsSystemsInfoUpdate >& update)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate"));
   std::vector<SystemInfo>subSystemsInfo = update->getCabinsSystemsInfo();
   if (!subSystemsInfo.empty())
   {
      ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate Subsystem Info is available"));
      std::vector<SystemInfo>::const_iterator iter = subSystemsInfo.begin();
      while (iter != subSystemsInfo.end())
      {
         //  ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate Iter Position: %d",iter));
         m_u8SystemGroup = iter->getSystemGroup();
         m_u8SystemStatus = iter->getSystemStatus();
         m_u8SystemCategory = iter->getSystemCategory();
         m_u8NanoMsgStatus = iter->getNanoMsgStatus();
         ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Group: %d/ Status: %d/ Category: %d/ NanoMessage: %d", m_u8SystemGroup, m_u8SystemStatus, m_u8SystemCategory, m_u8NanoMsgStatus));
         if (SYSTEM_CATEGORY_CMA == m_u8SystemCategory)
         {
            ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A"));
            if (SYSTEM_STATUS_DISCONNECTED == m_u8SystemStatus)
            {
               //Avdeccd and Nano Error Situation for CMA
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A Disconnected: Reason: %d", m_u8SystemStatus));
               //Setting relevant Error handling variables to False
               m_bIsCMAavailable = false;
            }
            else if (SYSTEM_STATUS_CONNECTED == m_u8SystemStatus)
            {
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A Connected: Reason: %d", m_u8SystemStatus));
               //Setting relevant Error handling variables to True
               m_bIsCMAavailable = true;
            }
            else if (SYSTEM_STATUS_INACTIVE_DISCONNECTED == m_u8SystemStatus)
            {
               //Protected Mode or Safe Mode Scenario for CMA
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A SafeMode: Reason: %d", m_u8SystemStatus));
               //Setting relevant Error handling variables to True
               m_bIsCMAavailable = false;
            }
            else if (SYSTEM_STATUS_HOURLOGIC_DISCONNECTED == m_u8SystemStatus)
            {
               //HOURLOGIC Mode for CMA
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A Hourlogic mode: Reason: %d", m_u8SystemStatus));
               //Setting relevant Error handling variables to True
               m_bIsCMAavailable = true;
            }
            else if (SYSTEM_STATUS_NONE == m_u8SystemStatus)
            {
               //USEROFF Mode for CMA for the bug fix 2016320
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A None: Reason: %d", m_u8SystemStatus));
               //Setting relevant Error handling variables to True
               m_bIsCMAavailable = true;
            }
            else
            {
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A SafeMode else check: Reason: %d", m_u8SystemStatus));
            }
            if ((SYSTEM_STATUS_DISCONNECTED == m_u8NanoMsgStatus) || (SYSTEM_STATUS_UNAVAILABLE == m_u8NanoMsgStatus))
            {
               //NanoMessage failure in CMA
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A NanoMessage : Reason: %d", m_u8SystemStatus));
               //Setting relevant Error handling variables to False
               m_bEventNanoMessageErrorStatus = false;
            }
            else if (SYSTEM_STATUS_CONNECTED == m_u8NanoMsgStatus)
            {
               //NanoMessage connection in CMA
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A NanoMessage : Reason: %d", m_u8NanoMsgStatus));
               //Setting relevant Error handling variables to True
               m_bEventNanoMessageErrorStatus = true;
            }

            else
            {
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-A NanoMessage else check: Reason: %d", m_u8NanoMsgStatus));
            }
            ValidateIntercomStatus();
         }
         else if (SYSTEM_CATEGORY_CMC == m_u8SystemCategory)
         {
            ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-C"));
            if (SYSTEM_STATUS_INACTIVE_DISCONNECTED == m_u8SystemStatus)
            {
               //Protected Mode or Safe Mode Scenario for CMC
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-C SafeMode: Reason: %d", m_u8SystemStatus));
            }
            else
            {
               ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category CM-C Other: Reason: %d", m_u8SystemStatus));
            }
         }
         else
         {
            ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate SubSystem Category Other"));
         }
         iter++;
      }
   }
   else
   {
      ETG_TRACE_USR4(("IntercomClienthandler::onCabinsSystemsInfoUpdate Subsystem Info is empty"));
   }
}


/************************************************
Function 	: onHmiStateError
Parameters 	:
Description : This error of the SPM HMI State Interface
SYSFL/SWFL  :
Author      : Bruce Netto 16/09/2021
************************************************/
void IntercomClienthandler::onHmiStateError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy,
      const boost::shared_ptr< ::SPM_CORE_FI::HmiStateError >& error)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onHmiStateError"));
}


/************************************************
Function 	: onHmiStateStatus
Parameters 	:
Description : This interface provides CMC
*             Systems current power State
SYSFL/SWFL  :
Author      : Bruce Netto 16/09/2021
************************************************/
void IntercomClienthandler::onHmiStateStatus(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& proxy,
      const boost::shared_ptr< ::SPM_CORE_FI::HmiStateStatus >& status)
{
   ETG_TRACE_USR4(("IntercomClienthandler::onHmiStateStatus()"));
   switch (status->getHmiState())
   {
      case ::spm_core_fi_types::T_SPM_e32_HMI_STATE__SPM_U32_HMISTATE_INACTIVE :
      {
         ETG_TRACE_USR4(("IntercomClienthandler::onHmiStateStatus() HMISTATE_INACTIVE/ Protected OFF/ Safe Mode"));
         //Intercom and BT Call Deactivation Logic
         OnUpdTerminateCall();
         break;
      }
      case ::spm_core_fi_types::T_SPM_e32_HMI_STATE__SPM_U32_HMISTATE_SHOW_HMI :
      {
         ETG_TRACE_USR4(("IntercomClienthandler::onHmiStateStatus() HMISTATE_SHOW_HMI/ HMI ON"));
         break;
      }
      default :
      {
         ETG_TRACE_USR4(("IntercomClienthandler::onHmiStateStatus() HMISTATE_OTHER %d", status->getHmiState()));
         break;
      }
   };
}


}
}


#endif
