/**************************************************************************************
* @file         : ClockSrvClient.h
* @author       : Palani K
* @addtogroup   : Phone
* @brief        : To support time and date related features for Phone module
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CLOCKSRVCLIENT_H_
#define CLOCKSRVCLIENT_H_

#include "clock_main_fiProxy.h"
#include "ClockSrvClient_Defines.h"
#include "AppBase/ServiceAvailableIF.h"

using namespace ::clock_main_fi;

namespace App {
namespace Core {

/* class ClockSrvClient*/
class ClockSrvClient :
   public hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public clock_main_fi::NewDateFormatCallbackIF
{
   public :

      virtual ~ClockSrvClient();
      static ClockSrvClient* getInstance()
      {
         if (NULL == ClockSrvClientObj)
         {
            ClockSrvClientObj = new ClockSrvClient();
         }
         return ClockSrvClientObj;
      }

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // ServiceAvailableIF implementation
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onNewDateFormatError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/, const ::boost::shared_ptr< clock_main_fi::NewDateFormatError >& /*error*/);
      void onNewDateFormatStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy, const ::boost::shared_ptr< clock_main_fi::NewDateFormatStatus >& status);

      std::string evaluateDateFormat(std::string day, std::string month, std::string year = "");

   private :

      ClockSrvClient();
      static ClockSrvClient* ClockSrvClientObj;
      //ClockSrvClient(::boost::shared_ptr< ::Clock_main_fiProxy > clockProxy);

      //Instance of clock_main_fi proxy
      ::boost::shared_ptr< ::clock_main_fi::Clock_main_fiProxy > _ClockProxy;

      uint8 m_u8DateFormat; /* To store date format  */
};


}
}


#endif /* CLOCKSRVCLIENT_H_ */
