/* ***************************************************************************************
* FILE:          BTPhoneDefines.h.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BTPhoneDefines.h.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BTPhoneDefines_h
#define BTPhoneDefines_h
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_PhoneTypes.h"
#include "MOST_BTSet_FI.h"
#include "HmiTranslation_TextIds.h"


#ifndef WINDOWS_SIMULATION
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif
#else
// unittest scope
#define tU8 unsigned int
#define NULL 0
#define ETG_TRACE_USR1(a)
#define ETG_TRACE_USR2(a)
#define ETG_TRACE_USR3(a)
#define ETG_TRACE_USR4(a)
#endif // End of Unittest Macro

#define BTPHN_C_DEVICEHANDLE_ZERO 0
#define BTPHN_C_EQUAL 0
#define BTPHN_C_DEFAULT_VALUE_ZERO 0 // Default assigned during initialization
#define BTPHN_C_CONNECTED_DEVICE_INDEX 0  // In the device list, the connected device will always be the first element
#define BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX 2 // Device handle of the paired devices starts from two */
#define BTPHN_C_DEFAULT_DEVICE_LIST_SIZE 10
#define BTPHN_C_DEFAULT_MATCH_LIST_SIZE 30
#define BTPHN_C_HEXA_ONE 0x01
#define BTPHN_C_HEXA_TWO 0x02
#define BTPHN_C_HEXA_THREE 0x03
#define BTPHN_C_HEXA_FOUR 0x04
#define BTPHN_C_HEXA_FIVE 0x05
#define BTPHN_C_HEXA_SIX 0x06
#define BTPHN_C_HEXA_SEVEN 0x07
#define BTPHN_C_HEXA_EIGHT 0x08
#define BTPHN_C_HEXA_0X00E 0x0E
#define BTPHN_C_HEXA_0X00F 0x0F
#define BTPHN_C_MAX_PAIRED_DEVICE 10
#define BTPHN_C_HEXA_ZERO 0x00
#define BTPHN_C_HEXA_0X01F 0x1F
#define BTPHN_C_CONNECT_TIMER_DURATION 1500 // Duration in milliseconds 
#define BTPHN_C_DEVICE_CONNECTION_TIMER_DURATION 35000  // Max-Waiting time for getting Service Response while connection.
#define BTPHN_C_CONTACT_UNKNOWN "unknown"
#define BTPHN_C_EMPTY_STRING " "
#define BTPHN_M_UNUSED(a)              (tVoid) a
#define BTPHN_C_CHECKED 1
#define BTPHN_C_UNCHECKED 0
#define BTPHN_C_CHECKEDDISABLE 3
#define BTPHN_C_UNCHECKEDDISABLE 2
#define MAX_HFP_CONNECTION 2
#define BT_SUPPORTED_MESSAGE_TYPE 3
#define BTPHN_C_VALUE_THREE 3		//modified by Nikhil  
#define     MAX_SPEED           800 //Driver distraction: Set max value for vehicle speed
#define     SNA_VALUE 65535
#define BTPHN_C_HFP_INDEX_ZERO 0
#define BTPHN_C_HFP_INDEX_ONE 1
/*Defined for general number usage in the code*/
#define BTPHN_VALUE_ZERO 0
#define BTPHN_VALUE_ONE 1
#define BTPHN_VALUE_TWO 2
#define BTPHN_VALUE_THREE 3
#define BTPHN_VALUE_FOUR 4
#define BTPHN_VALUE_FIVE 5
#define BTPHN_VALUE_SIX 6
#define BTPHN_VALUE_SEVEN 7
#define BTPHN_VALUE_EIGHT 8
#define BTPHN_VALUE_NINE 9
#define BTPHN_VALUE_TEN 10
/*Defines for Media Long Data Types*/
#define LONGDATATYPE_CALLNAME 8
#define LONGDATATYPE_CALLNUM 9
#define LONGDATATYPE_PHONENAME 10
#define LONGDATATYPE_PHONENETWORK 11

/* Define KDS values for vehicle variants */
#define VEHICLETYPE_TRUCK 0
#define VEHICLETYPE_COACH 1
#define VEHICLETYPE_SMART 2

/*Defined for Gen CAN Phone BT Link STatus*/
static const tU8  BT_LINK_STATUS_OFF =  0;
static const tU8  BT_STATUS_NOT_CONNECTED = 1;
static const tU8  BT_STATUS_SEARCHING = 2;
static const tU8  BT_STATUS_CONNECTED = 3;

/*Defined for Gen CAN Phone BT STatus for CAN*/
static const tU8  BT_STATUS_OFF = 0;
static const tU8  BT_STATUS_ON = 1;
static const tU8  BT_STATUS_ERROR = 2;
static const tU8  BT_STATUS_SNA = 3;

/*Defined for Gen CAN Phone Power Command for CAN*/
static const tU8  PHONE_POWERCMD_ON = 1;
static const tU8  PHONE_POWERCMD_OFF = 2;
static const tU8  PHONE_POWERCMD_DONTCARE = 3;

/*Defined for Gen CAN Smart VR for CAN*/
static const tU8  PHONE_SMARTVR_START = 1;
static const tU8  PHONE_SMARTVR_STOP = 2;
static const tU8  PHONE_SMARTVR_DONTCARE = 3;

static const tU8  CALLHISTORY_NOT_STARTED = 0;

/*Defined for Gen CAN Phone BT Link STatus*/
static const tU8  PBDS_NOT_STARTED =  0;
static const tU8  PBDS_INPROGRESS =  1;
static const tU8  PBDS_LOADING = 2;
static const tU8  PBDS_COMPLETED = 3;

/*Defined for ActiveSource Type*/
static const tU8  ACTIVE_SOURCE_PHONE =  0;
static const tU8  ACTIVE_SOURCE_INTERCOM =  1;

/*Defined for Gen CAN Phone Available KDS*/
static const bool KDS_PHONE_AVAILABLE = true;
static const bool KDS_SMARTVR_AVAILABLE = true;

/* Define Homescreen text node size of devicename/no phone connected/bluetooth off as to dynamically change the node size */
#define DEVNAME_TEXTNODE_NORMAL_MAXSIZE_X 180.0F
#define DEVNAME_TEXTNODE_NORMAL_MAXSIZE_Y -1.0F
#define DEVNAME_TEXTNODE_EXTENDED_MAXSIZE_X 250.0F
#define DEVNAME_TEXTNODE_EXTENDED_MAXSIZE_Y -1.0F

/* Define textID conversion macros */
#define TEXTID_UNAVAILABLE 0xFFFFFFFF
#define textID TEXTID_UNAVAILABLE
#define LANGUAGE_STRING(text_id, text) ((text_id==TEXTID_UNAVAILABLE) ? text : Candera::String(text_id))

#define SRSTATUS_SPEAK "AppHmi_PhoneModule#Images#SR_SIRI_Main#Icon_SRStatus_Speak"
#define SRSTATUS_LISTEN "AppHmi_PhoneModule#Images#SR_SIRI_Main#Icon_SRStatus_Listen"
#ifdef WINDOWS_SIMULATION
#include "tTypes.h"
#include <string>
#endif

#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
const int PHONEONE = 1;
const int PHONETWO = 2;
const int INTERCOM = 3;
const int ERRORCODE_ZERO = 0;
const int ERRORCODE_FIVE = 5 ;
const int ERRORCODE_TWENTY = 20;
const int ERRORCODE_SEVEN = 7;
#endif


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
typedef struct
{
   tU8 u8DeviceHandle;
   std::string szDeviceName;
   // Commenting out the below two lines since these are used only in windows simulation and windows simulation has become absolute now.
   // tBool bDeviceConnectedStatus;
   // tBool bOSDStatus;
   most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus e8HFPStatus;
   most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus e8AVPPreviousStatus;
   most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus e8AVPStatus;
} btphn_trBTPairedDeviceInfo;

typedef enum
{
   BTPHN_EN_DEVICE_LIST_UPDATED = 0, // Device info in device list is updated
   BTPHN_EN_DEVICE_LIST_CREATED = 1, // Device list is created
   BTPHN_EN_DEVICE_LIST_MODIFIED = 2, // Device list is modified
   BTPHN_EN_DEVICE_LIST_INVALID = 255 // Invalid device list status
} btphn_tenDeviceListStatus;


enum enBool
{
   _False = 0,
   _True = 1
};


enum phoneupdate
{
   SmartPhone_RingTone = 0,
   PhoneMessage
};


typedef enum
{
   EN_PHONE_CONTEXT_UNKNOWN = 0, // Phone context status of unknown
   EN_PHONE_CONTEXT_FG = 1, // Phone context status of foreground
   EN_PHONE_CONTEXT_BG = 2 // Phone context status of background
} en_phoneContextStatus;

typedef struct
{
   tU8 u8DeviceHandle;
   btphn_tenBTMajorDeviceClass enMajorDeviceClass;
   tBool bHandsFreeSupport;
   tBool bAudioStreamingSupport;
} btphn_trBTDeviceSupportInfo;

#define BTPHN_C_LIST_HANDLE_INVALID 0xFFFF // Invalid list handle
typedef enum
{
   /* Use default/Previous ECNR settings */
   BTPHN_EN_ECNR_NOCHANGE = 0UL,

   /* ECNR Settings: When human is at the remote end */
   BTPHN_EN_ECNR_VOICE = 1UL,

   /* ECNR Settings: When server-based voice recognition is at the remote end */
   BTPHN_EN_ECNR_SERVER = 2UL
} btphn_tenECNRSettings;

class DeviceListInformation
{
   public:
      DeviceListInformation():
         m_sDeviceAddress(""),
         m_u8DeviceHandle(0),
         m_sDeviceName(""),
         m_bDeviceConnectedStatus(false),
         m_bOutgoingSourceDeviceStatus(false),
         m_e8DeviceConnectionStatus(::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
         m_u8DeviceFavoriteIndex(0),
         m_biAPoverBTSupport(false),
         m_bHFPStatus(::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
         m_bAVPStatus(::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT)/*,
		 m_sDeviceBtAddress("")*/
      {}
      ~DeviceListInformation() {}
   private:
      std::string m_sDeviceAddress;
      tU8 m_u8DeviceHandle;
      std::string m_sDeviceName;
      tBool m_bDeviceConnectedStatus;
      tBool m_bOutgoingSourceDeviceStatus;
      ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus m_e8DeviceConnectionStatus;
      tU8 m_u8DeviceFavoriteIndex;
      tBool m_biAPoverBTSupport;
      most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus m_bHFPStatus;
      most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus m_bAVPStatus;
      //std::string m_sDeviceBtAddress;
      //T_BTProfileFavoriteIndex m_oDeviceProfileFavoriteIndex;
      //T_e8_BTUsagePreference m_e8DeviceUsagePreference;
      //T_BTSetDateTimeStamp m_oDevicePairedDateTimeStamp;
      //T_BTSetDateTimeStamp m_oDateTimeStamp;
      //T_BTSetDeviceIdentification m_oDeviceInfo;
      //T_e8_BTSetDeviceDisconnectedReason m_e8DeviceDisconnectedReason;
      //T_BTServiceType m_oDeviceProfileStatus;
      //T_BTProfileDisconnectedReason m_oDeviceProfileDisconnectedReason;
      //T_BTSetSupportedProfiles m_oDeviceSupportedProfiles;
      //T_e8_BTSetDeviceDisconnectedReason m_e8DeviceDisconnectedReason;
      //T_BTServiceType m_oDeviceProfileStatus;
      //T_BTProfileDisconnectedReason m_oDeviceProfileDisconnectedReason;
      //T_BTSetSupportedProfiles m_oDeviceSupportedProfiles;
   public:
      inline void SetDeviceAddress(std::string sDeviceAddr)
      {
         m_sDeviceAddress = sDeviceAddr;
      }
      inline std::string GetDeviceAddress()
      {
         return m_sDeviceAddress;
      }

      inline void SetDeviceHandle(tU8 u8DeviceHandle)
      {
         m_u8DeviceHandle = u8DeviceHandle;
      }
      inline tU8 GetDeviceHandle()
      {
         return m_u8DeviceHandle;
      }

      inline void SetDeviceName(std::string sDeviceName)
      {
         m_sDeviceName = sDeviceName;
      }
      inline std::string GetDeviceName()
      {
         return m_sDeviceName;
      }

      inline void SetDeviceConnectedStatus(tBool bDeviceConnectedStatus)
      {
         m_bDeviceConnectedStatus = bDeviceConnectedStatus;
      }
      inline tBool GetDeviceConnectedStatus()
      {
         return m_bDeviceConnectedStatus;
      }

      inline void SetOSDStatus(tBool bOutgoingSourceDeviceStatus)
      {
         m_bOutgoingSourceDeviceStatus = bOutgoingSourceDeviceStatus;
      }
      inline tBool GetOSDStatus()
      {
         return m_bOutgoingSourceDeviceStatus;
      }

      inline void SetHFPStatus(most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus bHFPStatus)
      {
         m_bHFPStatus = bHFPStatus;
      }
      inline most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus GetHFPStatus()
      {
         return m_bHFPStatus;
      }

      inline void SetAVPStatus(most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus bAVPStatus)
      {
         m_bAVPStatus = bAVPStatus;
      }
      inline most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus GetAVPStatus()
      {
         return m_bAVPStatus;
      }

      inline void SetConnectingStatus(::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus e8DeviceConnectionStatus)
      {
         m_e8DeviceConnectionStatus = e8DeviceConnectionStatus;
      }
      inline ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus GetConnectingStatus()
      {
         return m_e8DeviceConnectionStatus;
      }

      /*inline void SetDeviceBtAddress(std::string sDeviceBtAddress)
       {
          m_sDeviceBtAddress = sDeviceBtAddress;
       }
       inline std::string GetDeviceBtAddress()
       {
          return m_sDeviceBtAddress;
       }*/

      /*inline void SetDeviceDisconnectedReason(T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason)
      {
      	m_e8DeviceDisconnectedReason = e8DeviceDisconnectedReason;
      }*/
      /*inline void SetDeviceProfileStatus(T_BTServiceType m_oDeviceProfileStatus)
      {
      	m_oDeviceProfileStatus = oDeviceProfileStatus;
      }*/
};


#endif // End of Unittest Macro

/********************* Sorting Text ***************/
#define BTPHN_C_SORT_FIRST_NAME "First Name"
#define BTPHN_C_SORT_LAST_NAME "Last Name"
#endif
