/* ***************************************************************************************
* FILE:          CGIAppController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "AppHmi_NavigationStateMachine.h"
#include "CGIAppController.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CGIAppController.cpp.trc.h"
#endif

/********************************************
/* NAME    : CGIAppController
/* SYSFL    : SYSFL-4698, SYSFL-4699, SYSFL-4700
****************************************************/

bool CGIAppController::onCourierMessage(const HKStatusChangedUpdMsg& msg)
{
   bool retVal = false;
   int m_Hkcode = msg.GetHKCode();
   if ((hmibase::HARDKEYSTATE_UP == msg.GetHKState())
         && ((HARDKEYCODE_HK_NAV == m_Hkcode) || (HARDKEYCODE_REMOTECONTROL_NAVI == m_Hkcode)))
   {
      POST_MSG((COURIER_MESSAGE_NEW(HKStateUpdMsg)()));
      retVal = true;
   }
   else
   {
      retVal = CGIAppControllerProject::onCourierMessage(msg);
   }
   return retVal;
}


bool CGIAppController::onCourierMessage(const RenderingCompleteMsg& oMsg)
{
   bool isMsgConsumed = false;
   std::string currentRenderedView = oMsg.GetViewName().GetCString();

   ETG_TRACE_USR4(("CGIAppController::RenderingCompleteMsg(%s)", currentRenderedView.c_str()));

   if ((0 == currentRenderedView.compare("AppHmi_NavigationModule#NavigationScenes#N_Map"))
         || (0 == currentRenderedView.compare("AppHmi_NavigationModule#NavigationScenes#N_Map_Move"))
         || (0 == currentRenderedView.compare("AppHmi_NavigationModule#NavigationScenes#N_Map_ActiveRG"))
         || (0 == currentRenderedView.compare("AppHmi_NavigationModule#NavigationScenes#N_MapScale")))
   {
      POST_MSG((COURIER_MESSAGE_NEW(SendContextReqMsg)(CONTEXT_SWITCH_FROM_N_MAP)));
   }
   else if ((0 == currentRenderedView.compare("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput"))
            || (0 == currentRenderedView.compare("AppHmi_NavigationModule#NavigationScenes#N_SpellerEdit")))
   {
      if (EXT_bIsSpeedLockActive)
      {
         POST_MSG((COURIER_MESSAGE_NEW(DisplaySpeedLockPopuponSpellerReqMsg)()));
      }
   }

   isMsgConsumed = CGIAppControllerProject::onCourierMessage(oMsg);
   return isMsgConsumed;
}
