/* ***************************************************************************************
* FILE:          TrafficListHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TrafficListHandler.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_TRAFFIC_LIST_HANDLER_H)
#define _TRAFFIC_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "List/Data/ListDataProviderDistributor.h"
#include "ListRegistry.h"
#include "Candera/System/MemoryManagement/SharedPointer.h"
#include "NavMiddleware.h"
#include "../Common/Util/HMIModelDefines.h"
#include "../Common/Util/NavMiddlewareUtils.h"
#include "../Common/Util/StaticListHandlerBase.h"
#include "../Common/Util/HMIModelIncludes.h"
#include "../Destination/SpellerHandler.h"


class TrafficListHandler : public HMIModelBase, public ListImplementation
{
   public:

      TrafficListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~TrafficListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::TRAFFICMESSAGE_INFO_LIST_CHANGED, onPropertyUpdateTrafficmessageInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::TRAFFICMESSAGE_LIST_INVALIDATE, onPropertyUpdateTrafficmessageListInvalidate)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::TRAFFICMESSAGE_INFO_DETAILS_CHANGED, onPropertyUpdateTrafficmessageDetailsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_TRAFFICIMPACT_ALTERNATIVE_CHANGED, onPropertyUpdateTrafficImpactAlternativeChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::TRAFFICMESSAGE_XURGENT_CHANGED, onPropertyUpdateTrafficmessageXUrgentChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateGuidanceStateChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyUpdateTrafficmessageInfoChanged();
      bool onPropertyUpdateTrafficmessageListInvalidate();
      bool onPropertyUpdateTrafficmessageDetailsChanged();
      void onPropertyUpdateTrafficmessageXUrgentChanged();
      void onPropertyUpdateGuidanceStateChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(AcceptTrafficAlternativeReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(RejectTrafficAlternativeReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(StartTrafficDetourTimerReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(TrafficDetourTimerExpiredReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ReleaseXUrgentTrafficMessageReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      void requestTrafficMessageDetail(unsigned int index);
      bool updateTrafficDetailData(const std::vector<navmiddleware::TrafficMessageListInfo>&, int);
      bool onPropertyUpdateGuidanceTrafficEventsDetected();
      bool onPropertyUpdateTrafficImpactAlternativeChanged();
      void updateTrafficDetourPopupDetails(const navmiddleware::TrafficImpactRouteAlternativeInfos& trafficImpactRouteAlternativeInfos);
      bool onCourierMessage(const AcceptTrafficAlternativeReqMsg& oMsg);
      bool onCourierMessage(const RejectTrafficAlternativeReqMsg& oMsg);
      bool onCourierMessage(const StartTrafficDetourTimerReqMsg& oMsg);
      bool onCourierMessage(const TrafficDetourTimerExpiredReqMsg& oMsg);
      bool onCourierMessage(const ReleaseXUrgentTrafficMessageReqMsg& oMsg);

   private:
      Util::Timer _trafficDetourTimer;
      unsigned int _startIndex;
      unsigned int _windowElementSize;
      unsigned int _listID;
      unsigned int _xUrgentTrafficMsgId;
      bool _isTrafficDetourDisplayed;
      tSharedPtrDataProvider getTMCListDataProvider(unsigned int startIndex, unsigned int windowElementSize);
      DataBindingItem<TrafficMessagesDataBindingSource>_trafficMessages;
      DataBindingItem<TrafficDetourDetailsDataBindingSource>_trafficDetourDetails;
      DataBindingItem<XUrgentTrafficMessageDataBindingSource> _xUrgentTrafficMessage;
};


#endif
