/**************************************************************************************
* @file         : VehicleSettingsHelper.h
* @author       : Preethi Alagappan
* @addtogroup   : AppHmi_Navigation
* @brief        : Helper class for vehicle parameter list handler
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef VECHILE_SETTINGS_HELPER_H
#define VECHILE_SETTINGS_HELPER_H

#include <math.h>
#include "hmi_trace_if.h"
#include "InfoTypes.h"       // For definition of enum DistanceUnitSystem
#include "RouteSettings.h"   // For definition of class VehicleProfile
#include "NaviSettingsUtil.h"
#include "VehicleSettingsMetaData.h"
#include "VehicleDimensionsConverter.h"

using namespace navmiddleware::settings;

#define MAX_HMI_DIMENSION_VALUE_PRECISION 2

#define UINT(x) static_cast<unsigned int>(x)	// Macro for type-casting to unsigned integer

// Macros for rounding off floating numbers based on required precision
#define ROUNDF(x)          (roundf(x))
#define ROUNDF_1DECIMAL(x) (roundf((x) * 10) / 10)
#define ROUNDF_2DECIMAL(x) (roundf((x) * 100) / 100)

class VehicleSettingsHelper
{
   public:
      static unsigned int resetDimensionsToBound(VehicleSettingsListItemValue settingsItemIndex, unsigned int vehicleDimension, navmiddleware::DistanceUnitSystem distanceUnitSystem);
      static void convertVehicleProfileUnits(VehicleProfile& vehicleProfile, navmiddleware::DistanceUnitSystem distanceUnitSystem);
      static Candera::String convertHmiDimensionToString(VehicleSettingsListItemValue settingsItemIndex, float dimensionValue, navmiddleware::DistanceUnitSystem distanceUnitSystem);
      static unsigned int convertDimensionToPresCtrlUnit(VehicleSettingsListItemValue settingsItemIndex, float dimensionValue, navmiddleware::DistanceUnitSystem distanceUnitSystem);
      static float convertDimensionToHmiUnit(VehicleSettingsListItemValue settingsItemIndex, unsigned int dimensionValue, navmiddleware::DistanceUnitSystem distanceUnitSystem);
      static std::string convertVehicleRestrictionsDimensionToString(VehicleRestrictionsPriorityType vehicleRestrictionsType, unsigned int vehicleRestrictionValue, navmiddleware::DistanceUnitSystem distanceUnitSystem, bool isRestrictionValueInMetric);

   private:
      static void convertVehicleProfileUnitsToMetric(VehicleProfile& vehicleProfile, navmiddleware::DistanceUnitSystem distanceUnitSystem);
      static void convertVehicleProfileUnitsToImperial(VehicleProfile& vehicleProfile, navmiddleware::DistanceUnitSystem distanceUnitSystem);
      static Candera::String convertHmiMetricDimensionToString(VehicleSettingsListItemValue settingsItemIndex, float dimensionValue);
      static Candera::String convertHmiImperialDimensionToString(VehicleSettingsListItemValue settingsItemIndex, float dimensionValue);
      static unsigned int convertDimensionToPresCtrlMetricUnit(VehicleSettingsListItemValue settingsItemIndex, float dimensionValue);
      static unsigned int convertDimensionToPresCtrlImperialUnit(VehicleSettingsListItemValue settingsItemIndex, float dimensionValue, bool isBritishImperial = false);
      static float convertDimensionToHmiMetricUnit(VehicleSettingsListItemValue settingsItemIndex, unsigned int dimensionValue);
      static float convertDimensionToHmiImperialUnit(VehicleSettingsListItemValue settingsItemIndex, unsigned int dimensionValue, bool isBritishImperial = false);

      static inline unsigned int roundToNearestStepValue(unsigned int value, unsigned int step);   // Rounds off integer numbers to the nearest multiple of step value
      static inline float roundToNearestStepValue(float value, float step);
      static inline bool isMultipleOfStepValue(float value, float step);
};


#endif	// VECHILE_SETTINGS_HELPER_H
