/**************************************************************************************
* @file         : VehicleParameterListHandler.h
* @author       : ECG-Prieethi Narayanaswamy
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ROUTE_SETTINGS_LIST_HANDLER_H
#define ROUTE_SETTINGS_LIST_HANDLER_H

#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "VehicleSettingsHelper.h"

#ifdef HALL_TO_MDW_COM

using namespace navmiddleware::settings;

class VehicleParameterListHandler : public HMIModelBase, public ListImplementation
{
   public:
      VehicleParameterListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~VehicleParameterListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from infostore
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_CALCULATION_STOPPED, onPropertyUpdateRouteCalculationStopped)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateGuidanceStateChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(CheckIsVehicleSettingsChangedReqMsg)
      ON_COURIER_MESSAGE(ChangeActiveProfileReqMsg)
      ON_COURIER_MESSAGE(SaveVehicleProfileSettingsReqMsg)
      ON_COURIER_MESSAGE(ResetVehicleProfileSettingsReqMsg)
      ON_COURIER_MESSAGE(ResetVehicleProfileInfoReqMsg)
      ON_COURIER_MESSAGE(UpdateStartupVehicleProfileReqMsg)
      ON_COURIER_MESSAGE(UpdateDeletePopupTextReqMsg)
      ON_COURIER_MESSAGE(ResetAllNaviSettingsReqMsg)
      ON_COURIER_MESSAGE(CheckVehicleParameterStatusMsg)
      ON_COURIER_MESSAGE(UpdateVehicleProfilePopupStatusReqMsg)
      ON_COURIER_MESSAGE(AcceptCarModeWarningReqMsg)
      ON_COURIER_MESSAGE(DeclineCarModeWarningReqMsg)
      ON_COURIER_MESSAGE(UpdateContextonBackgroundReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const CheckIsVehicleSettingsChangedReqMsg& oMsg);
      bool onCourierMessage(const ChangeActiveProfileReqMsg& oMsg);
      bool onCourierMessage(const SaveVehicleProfileSettingsReqMsg& oMsg);
      bool onCourierMessage(const ResetVehicleProfileSettingsReqMsg& oMsg);
      bool onCourierMessage(const ResetVehicleProfileInfoReqMsg& oMsg);
      bool onCourierMessage(const UpdateStartupVehicleProfileReqMsg& oMsg);
      bool onCourierMessage(const UpdateDeletePopupTextReqMsg& oMsg);
      bool onCourierMessage(const ResetAllNaviSettingsReqMsg& oMsg);
      bool onCourierMessage(const CheckVehicleParameterStatusMsg& oMsg);
      bool onCourierMessage(const UpdateVehicleProfilePopupStatusReqMsg& oMsg);
      bool onCourierMessage(const AcceptCarModeWarningReqMsg& oMsg);
      bool onCourierMessage(const DeclineCarModeWarningReqMsg& oMsg);
      bool onCourierMessage(const UpdateContextonBackgroundReqMsg& oMsg);

      void onPropertyUpdateRouteCalculationStopped();
      void onPropertyUpdateGuidanceStateChanged();
      void updateUnitSystem();
      void getCurrentVehicleProfile();   // Reads vehicle data from navmiddleware
      void setStaticVehicleParameter(bool isEnabled);
      void restoreCoachProfileValue();  //  Weight and Load per Axle value to be retained for Coach profile.

   private:
      unsigned int _listId;
      bool _isCoach;
      bool _isStaticList;        // Settings values cannot be changed for Default and Car profile
      bool _isVehicleProfileChangedDuringActiveRG;
      unsigned int _profileId;   // Profile selected by the user
      unsigned int _currentVehicleProfileId; // Coach or car profile selected by user for guidance
      navmiddleware::settings::ActiveVehicleProfileType _previousActiveProfileId;
      float _previousVehicleProfile[MAX_SIZE_VEHICLE_SETTINGS];
      float _currentVehicleProfile[MAX_SIZE_VEHICLE_SETTINGS];
      navmiddleware::settings::CargoType _cargoType[MAX_SIZE_HAZARDOUS_DROP_DOWN_LIST];
      navmiddleware::DistanceUnitSystem _distanceUnitSystem;

      const VehicleSettingsMetaData* vehicleSettingsMetaData;

      typedef ListItemBase<VehicleSettingsListItemValue> VehicleSettingsListItem;
      std::vector<VehicleSettingsListItem> _VehicleSettingsList;
      DataBindingItem<TwoLinePopuptextDataBindingSource> _PopupText;
      DataBindingItem<MultiLinePopupTextDataBindingSource> _multiLinePopupText;
      DataBindingItem<VehicleProfileInfoDataBindingSource> _vehicleProfileInfo;
      DataBindingItem<SwitchVehicleParameterindexDataBindingSource> _switchIndexData;     // DataBinding used to switch the static Vehicle Parameter for CAR and COACH
      Candera::String currentProfileText;

      bool hasVehicleSettingsChanged();
      void changeActiveProfile();

      // List related functions
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      void buildDropDownListItem(ListDataProviderBuilder& listBuilder, const VehicleSettingsListItem& listItem, const int& listItemPosition);
      void buildSliderListItem(ListDataProviderBuilder& listBuilder, const VehicleSettingsListItem& listItem, const int& listItemPosition);
      Candera::String vehicleProfileTextUpdations(VehicleSettingsListItemValue listValue, unsigned int currentVehicleProfileValue, bool isCoach);
      void processComboBox(Courier::UInt32 hdl, Courier::UInt32 subHdl);
      unsigned int getGoodsTypeHmiIndex();

      void updateCurrentVehicleProfile();   // Writes vehicle data to navmiddleware

      FEATSTD_MAKE_CLASS_UNCOPYABLE(VehicleParameterListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // ROUTE_SETTINGS_LIST_HANDLER_H
