/**************************************************************************************
* @file         : VehicleDimensionsConverter.cpp
* @author       : Preethi Alagappan
* @addtogroup   : AppHmi_Navigation
* @brief        : Helper class for converting vehicle dimensions to different units
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "VehicleDimensionsConverter.h"

float VehicleDimensionsConverter::metersToMillimeters(float dimensionsInMeters)
{
   float dimensionsInMillimeters = dimensionsInMeters * 1000;
   return dimensionsInMillimeters;
}


float VehicleDimensionsConverter::millimetersToMeters(float dimensionsInMillimeters)
{
   float dimensionsInMeters = dimensionsInMillimeters / 1000;
   return dimensionsInMeters;
}


float VehicleDimensionsConverter::millimetersToInches(float dimensionsInMillimeters)
{
   float dimensionsInInches = dimensionsInMillimeters / 25.4F;
   return dimensionsInInches;
}


float VehicleDimensionsConverter::centimetersToMeters(float dimensionsInCentimeters)
{
   float dimensionInMeters = dimensionsInCentimeters / 100;
   return dimensionInMeters;
}


float VehicleDimensionsConverter::millimetersToYards(float dimensionsInMillimeters)
{
   float dimensionInYards = dimensionsInMillimeters / 914;
   return dimensionInYards;
}


float VehicleDimensionsConverter::inchesToMillimeters(float dimensionsInInches)
{
   float dimensionsInMillimeters = dimensionsInInches * 25.4F;
   return dimensionsInMillimeters;
}


float VehicleDimensionsConverter::inchesToYards(float dimensionsInInches)
{
   float dimensionsInYards = dimensionsInInches / 36;
   return dimensionsInYards;
}


float VehicleDimensionsConverter::yardsToInches(float dimensionsInYards)
{
   float dimensionsInInches = dimensionsInYards * 36;
   return dimensionsInInches;
}


float VehicleDimensionsConverter::inchesToMeters(float dimensionsInInches)
{
   float dimensionInMeters = dimensionsInInches / 39.37F;
   return dimensionInMeters;
}


float VehicleDimensionsConverter::tonnesToKilograms(float dimensionsInTonnes)
{
   float dimensionsInKilograms = dimensionsInTonnes * 1000;
   return dimensionsInKilograms;
}


float VehicleDimensionsConverter::tonnesToPounds(float dimensionsInTonnes)
{
   float dimensionsInPounds = dimensionsInTonnes * 2204.6226218488F;
   return dimensionsInPounds;
}


float VehicleDimensionsConverter::kilogramsToTonnes(float dimensionsInKilograms)
{
   float dimensionsInTonnes = dimensionsInKilograms / 1000;
   return dimensionsInTonnes;
}


float VehicleDimensionsConverter::kilogramsToPounds(float dimensionsInKilograms)
{
   float dimensionsInPounds = dimensionsInKilograms * 2.2046226218F;
   return dimensionsInPounds;
}


float VehicleDimensionsConverter::poundsToKilograms(float dimensionsInPounds)
{
   float dimensionsInKilograms = dimensionsInPounds * 0.45359237F;
   return dimensionsInKilograms;
}


float VehicleDimensionsConverter::poundsToTonnes(float dimensionsInPounds)
{
   float dimensionsInTonnes = dimensionsInPounds * 0.0004535924F;
   return dimensionsInTonnes;
}


float VehicleDimensionsConverter::kmphToMph(float dimensionsInKmph)
{
   float dimensionsInMph = dimensionsInKmph / 1.609;
   return dimensionsInMph;
}


float VehicleDimensionsConverter::mphToKmph(float dimensionsInMph)
{
   float dimensionsInKmph = dimensionsInMph * 1.609;
   return dimensionsInKmph;
}
