/**************************************************************************************
* @file         : TrafficIconsSettingsListHandler.h
* @author       : ECG-Ramesh Kesavan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef TRAFFIC_ICONS_SETTINGS_LIST_HANDLER_H
#define TRAFFIC_ICONS_SETTINGS_LIST_HANDLER_H

#include "AppHmi_NavigationStateMachine.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#ifdef HALL_TO_MDW_COM

class TrafficIconsSettingsListHandler : public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      TrafficIconsSettingsListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~TrafficIconsSettingsListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from Infostore
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::TRAFFICMESSAGE_ICONFILTER_LIST_CHANGED, onPropertyTrafficIconInfoAvailable);
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyTrafficIconInfoAvailable();

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ApplyTrafficIconsSettingsReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ApplyTrafficIconsSettingsReqMsg& oMsg);

   private:

      tSharedPtrDataProvider getTrafficIconSelectionList();
      IsButtonToggleEnabled getTrafficIconListElementState(navmiddleware::settings::TrafficIconSelectionCriteria trafficIconSelectionCriteria) const;

      void toggleTafficIconSelection(navmiddleware::settings::TrafficIconSelectionCriteria selectedcriteria);
      void updateTrafficIconSettingsList();

      unsigned int _startIndex;
      unsigned int _windowElementSize;
      FEATSTD_MAKE_CLASS_UNCOPYABLE(TrafficIconsSettingsListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // TRAFFIC_ICONS_SETTINGS_LIST_HANDLER_H
