/**************************************************************************************
* @file         : StreamedMapPOISettingListHandler.cpp
* @author       : ECG-NAveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include  <vector>
#include "StreamedMapPOISettingListHandler.h"
#include "MapSettingsOthersUtil.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/StreamedMapPOISettingListHandler.cpp.trc.h"
#endif

#ifdef  HALL_TO_MDW_COM
static const Candera::UInt8 MAX_LIST_SIZE = 8;

StreamedMapPOISettingListHandler::StreamedMapPOISettingListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : NavMiddlewarePropertyUpdateConsumer(navMiddleware)
{
   // configuring static list item

   for (int itr = 0; itr < MAX_LIST_SIZE; itr++)
   {
      _streamMapPOICheckBoxValue[itr] = BUTTON_TOGGLE_ENABLED_FALSE;
   }
}


StreamedMapPOISettingListHandler::~StreamedMapPOISettingListHandler()
{
}


void StreamedMapPOISettingListHandler::initialize()
{
   _streamMapPOIItemList.reserve(MAX_LIST_SIZE);
   _streamMapPOIItemList.push_back(StreamMapPOIListItem(LANGUAGE_STRING(TextId_0x0B6D, "Airport"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_POI_AIRPORT));
   _streamMapPOIItemList.push_back(StreamMapPOIListItem(LANGUAGE_STRING(TextId_0x0B6E, "Bank"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_POI_BANK));
   _streamMapPOIItemList.push_back(StreamMapPOIListItem(LANGUAGE_STRING(TextId_0x0B6F, "Hospital"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_POI_HOSPITAL));
   _streamMapPOIItemList.push_back(StreamMapPOIListItem(LANGUAGE_STRING(TextId_0x0B6B, "Hotels"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_POI_HOTEL));
   _streamMapPOIItemList.push_back(StreamMapPOIListItem(LANGUAGE_STRING(TextId_0x0B68, "Parking"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_POI_PARKING));
   _streamMapPOIItemList.push_back(StreamMapPOIListItem(LANGUAGE_STRING(TextId_0x0B6A, "Restaurant"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_POI_RESTAURANT));
   _streamMapPOIItemList.push_back(StreamMapPOIListItem(LANGUAGE_STRING(TextId_0x1491, "Shopping"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_POI_SHOPPING));
   _streamMapPOIItemList.push_back(StreamMapPOIListItem(LANGUAGE_STRING(TextId_0x1492, "Transport"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_POI_TRANSPORT));
}


void StreamedMapPOISettingListHandler::deinitialize()
{
}


tSharedPtrDataProvider StreamedMapPOISettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("StreamedMapPOISettingListHandler::getListDataProvider(List ID %d)", oMsg.GetListId()));

   DataItemContext  listItemName = "Layer_Checkbox";
   Candera::UInt32 listID = oMsg.GetListId();
   ListDataProviderBuilder listBuilder(listID);
   Candera::UInt8 checkBoxIdx = 0;

   for (std::vector<StreamMapPOIListItem>::iterator itemNumber = _streamMapPOIItemList.begin(); ((itemNumber < _streamMapPOIItemList.end()) && (checkBoxIdx < MAX_LIST_SIZE)); ++itemNumber, ++checkBoxIdx)
   {
      if (itemNumber->_listButtonType == LIST_BUTTON_TYPE_TOGGLE)
      {
         listBuilder.AddItem(
            itemNumber->_order,
            0UL,  //    - unused
            listItemName)  //0 - Name(Id) of the button
         .AddData(itemNumber->_text)
         .AddData(_streamMapPOICheckBoxValue[checkBoxIdx])
         .AddData(itemNumber->_isVisible);
      }
   }

   return listBuilder.CreateDataProvider();
}


bool StreamedMapPOISettingListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   navmiddleware::settings::MapTextFilterSettings mapTextFilterSettings = _navMiddleware.getMapTextFilterSettings();
   ETG_TRACE_USR4(("StreamedMapPOISettingListHandler::handleButtonListItemUpdMsg(%d)", oMsg.GetHdl()));

   bool listUpdateNeeded = true;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowID = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();

   if ((LIST_ID_STEAM_MAP_SUBOPTIONS == listId) && (enRelease == reaction))
   {
      switch (rowID)
      {
         case STREAMED_MAP_POI_AIRPORT:
         {
            _streamMapPOICheckBoxValue[STREAMED_MAP_POI_AIRPORT] = toggleCheckbox(_streamMapPOICheckBoxValue[STREAMED_MAP_POI_AIRPORT]);
            //Middleware calls to update the POI setting should be updated
            break;
         }
         case STREAMED_MAP_POI_BANK:
         {
            _streamMapPOICheckBoxValue[STREAMED_MAP_POI_BANK] = toggleCheckbox(_streamMapPOICheckBoxValue[STREAMED_MAP_POI_BANK]);
            //Middleware calls to update the POI setting should be updated
            break;
         }
         case STREAMED_MAP_POI_HOSPITAL: // Road _Names
         {
            _streamMapPOICheckBoxValue[STREAMED_MAP_POI_HOSPITAL] = toggleCheckbox(_streamMapPOICheckBoxValue[STREAMED_MAP_POI_HOSPITAL]);
            //Middleware calls to update the POI setting should be updated
            break;
         }
         case STREAMED_MAP_POI_HOTEL: // Road _Names
         {
            _streamMapPOICheckBoxValue[STREAMED_MAP_POI_HOTEL] = toggleCheckbox(_streamMapPOICheckBoxValue[STREAMED_MAP_POI_HOTEL]);
            //Middleware calls to update the POI setting should be updated
            break;
         }
         case STREAMED_MAP_POI_PARKING:
         {
            _streamMapPOICheckBoxValue[STREAMED_MAP_POI_PARKING] = toggleCheckbox(_streamMapPOICheckBoxValue[STREAMED_MAP_POI_PARKING]);
            //Middleware calls to update the POI setting should be updated
            break;
         }
         case STREAMED_MAP_POI_RESTAURANT:
         {
            _streamMapPOICheckBoxValue[STREAMED_MAP_POI_RESTAURANT] = toggleCheckbox(_streamMapPOICheckBoxValue[STREAMED_MAP_POI_RESTAURANT]);
            //Middleware calls to update the POI setting should be updated
            break;
         }
         case STREAMED_MAP_POI_SHOPPING: // Road _Names
         {
            _streamMapPOICheckBoxValue[STREAMED_MAP_POI_SHOPPING] = toggleCheckbox(_streamMapPOICheckBoxValue[STREAMED_MAP_POI_SHOPPING]);
            //Middleware calls to update the POI setting should be updated
            break;
         }
         case STREAMED_MAP_POI_TRANSPORT: // Road _Names
         {
            _streamMapPOICheckBoxValue[STREAMED_MAP_POI_TRANSPORT] = toggleCheckbox(_streamMapPOICheckBoxValue[STREAMED_MAP_POI_TRANSPORT]);
            //Middleware calls to update the POI setting should be updated
            break;
         }
         default:
         {
            listUpdateNeeded = false;
            break;
         }
      }
   }

   if (listUpdateNeeded)
   {
      //Middleware calls to update the POI setting should be updated
   }

   return listUpdateNeeded;
}


#endif // HALL_TO_MDW_COM
