/**************************************************************************************
* @file         : StreamedMapIconSettingListHandler.cpp
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include  <vector>
#include "StreamedMapIconSettingListHandler.h"
#include "MapSettingsOthersUtil.h"
#include "NaviSettingsUtil.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/StreamedMapIconSettingListHandler.cpp.trc.h"
#endif

#ifdef  HALL_TO_MDW_COM

static const int MAX_LIST_OTHERS_SIZE = 12;

StreamedMapIconSettingListHandler::StreamedMapIconSettingListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : NavMiddlewarePropertyUpdateConsumer(navMiddleware)
{
}


StreamedMapIconSettingListHandler::~StreamedMapIconSettingListHandler()
{
}


void StreamedMapIconSettingListHandler::initialize()
{
   Candera::UInt8 MAX_LIST_SIZE = 3;
   _streamMapDisplayItemList.reserve(MAX_LIST_SIZE);
   _streamMapDisplayItemList.push_back(StreamMapDisplayListItem(LANGUAGE_STRING(TextId_0x13F5, "Place names"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_OPTION_PLACE_NAMES));
   _streamMapDisplayItemList.push_back(StreamMapDisplayListItem(LANGUAGE_STRING(TextId_0x13F6, "Facility names"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_OPTION_FACILITY_NAMES));
   _streamMapDisplayItemList.push_back(StreamMapDisplayListItem(LANGUAGE_STRING(TextId_0x13F7, "Road names"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, STREAMED_MAP_OPTION_ROAD_NAMES));
}


void StreamedMapIconSettingListHandler::deinitialize()
{
}


tSharedPtrDataProvider StreamedMapIconSettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("StreamedMapIconSettingListHandler::getListDataProvider(List ID %d)", oMsg.GetListId()));
   DataItemContext  listItemName = "Layer_Checkbox";
   Candera::UInt32 listID = oMsg.GetListId();
   ListDataProviderBuilder listBuilder(listID);

   for (std::vector<StreamMapDisplayListItem>::iterator itemNumber = _streamMapDisplayItemList.begin(); itemNumber < _streamMapDisplayItemList.end(); ++itemNumber)
   {
      if (itemNumber->_listButtonType == LIST_BUTTON_TYPE_TOGGLE)
      {
         listBuilder.AddItem(
            itemNumber->_order,
            0UL,  //    - unused
            listItemName)  //0 - Name(Id) of the button
         .AddData(itemNumber->_text)
         .AddData(BUTTON_TOGGLE_ENABLED_FALSE)
         .AddData(itemNumber->_isVisible);
      }
   }

   return listBuilder.CreateDataProvider();
}


bool StreamedMapIconSettingListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   navmiddleware::settings::MapTextFilterSettings mapTextFilterSettings = _navMiddleware.getMapTextFilterSettings();
   ETG_TRACE_USR4(("StreamedMapIconSettingListHandler::handleButtonListItemUpdMsg(%d)", oMsg.GetHdl()));

   bool listUpdateNeeded = true;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowID = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();

   if ((LIST_ID_STEAM_MAP_SUBOPTIONS == listId) && (enRelease == reaction))
   {
      switch (rowID)
      {
         case STREAMED_MAP_OPTION_PLACE_NAMES:
         {
            //TO DO: Middleware calls to update the settings of  Streamed Map Icon should be updated
            break;
         }
         case STREAMED_MAP_OPTION_FACILITY_NAMES:
         {
            //TO DO: Middleware calls to update the settings of  Streamed Map Icon should be updated
            break;
         }
         case STREAMED_MAP_OPTION_ROAD_NAMES: // Road _Names
         {
            //TO DO: Middleware calls to update the settings of  Streamed Map Icon should be updated
            break;
         }
         case STREAMED_MAP_OPTION_INTERSECTION_NAMES:
         {
            //TO DO: Middleware calls to update the settings of  Streamed Map Icon should be updated
            break;
         }
         default:
         {
            listUpdateNeeded = false;
            break;
         }
      }
   }

   if (listUpdateNeeded)
   {
      //TO DO: Middleware calls to update the settings of  Streamed Map Icon should be updated
   }

   return listUpdateNeeded;
}


#endif // HALL_TO_MDW_COM
