/**************************************************************************************
* @file         : SettingsTrackingDotsDisplayedOnMapListHandler.cppStored Address
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include<vector>
#include "SettingsTrackingDotsDisplayedOnMapListHandler.h"
#include "MapSettingsOthersUtil.h"
#include "NaviSettingsUtil.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SettingsTrackingDotsDisplayedOnMapListHandler.cpp.trc.h"
#endif

#if defined (HALL_TO_MDW_COM)


static const char* const DATA_CONTEXT_COMBOBOX_LIST_ITEMS_4 = "ComboBox_ListItem4";
static const char* const DATA_CONTEXT_ROUTE_SETTINGS_TOGGLE_OPTION = "Layer_Checkbox";
static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_ListButton";

SettingsTrackingDotsDisplayedListHandler::SettingsTrackingDotsDisplayedListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : HMIModelBase(navMiddleware, infoStore)
{
}


unsigned int SettingsTrackingDotsDisplayedListHandler::getTrackingDotsDistanceValue(navmiddleware::NavMiddleware& navMiddleware)
{
   unsigned int retValue = MAP_TRACKING_DOT_DISTANCE_FIFTY_METER;
   switch (navMiddleware.getMapTrackingDotsSettings().getMapTrackingDotDistance())
   {
      case navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_FIFTY_METER:
      {
         retValue = MAP_TRACKING_DOT_DISTANCE_FIFTY_METER;
      }
      break;
      case navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_HUNDRED_METER:
      {
         retValue = MAP_TRACKING_DOT_DISTANCE_HUNDRED_METER;
      }
      break;
      case navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_TWO_HUNDRED_METER:
      {
         retValue = MAP_TRACKING_DOT_DISTANCE_TWO_HUNDRED_METER;
      }
      break;
      case navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_FIVE_HUNDRED_METER:
      {
         retValue = MAP_TRACKING_DOT_DISTANCE_FIVE_HUNDRED_METER;
      }
      break;
      default:
      {
         retValue = MAP_TRACKING_DOT_DISTANCE_TWO_HUNDRED_METER;
      }
      break;
   }
   ETG_TRACE_USR4(("SettingsTrackingDotsDisplayedListHandler::getTrackingDotsDistanceValue(%d)", retValue));

   return retValue;
}


SettingsTrackingDotsDisplayedListHandler::~SettingsTrackingDotsDisplayedListHandler()
{
}


void SettingsTrackingDotsDisplayedListHandler::initialize()
{
   unsigned int currentTrackingDotDistance = 0;
   Candera::String currentTrackingDotDistanceStr = "";
   InfoStoreBase::DistanceUnitSystem distanceUnit = _infoStore.getDistanceUnitSystem();
   currentTrackingDotDistance = static_cast<unsigned int>(getTrackingDotsDistanceValue(_navMiddleware));
   currentTrackingDotDistanceStr = TrackingDotsDistance[currentTrackingDotDistance][distanceUnit];
   _settingsTrackingDotsDisplayedList.reserve(3);
   _settingsTrackingDotsDisplayedList.push_back(SettingsTrackingDotsDisplayedListItem(LANGUAGE_STRING(TextId_0x140A, "Show tracking dots on map"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_SHOW_TRACKING_DOTS_ON_MAP, getTrackingDotsOnMap));
   _settingsTrackingDotsDisplayedList.push_back(SettingsTrackingDotsDisplayedListItem(LANGUAGE_STRING(TextId_0x140B, "Distance between tracking dots"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_DROPDOWN, SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_DIST_BTW_TRACKING_DOTS, currentTrackingDotDistanceStr, LIST_ID_DROPDOWN_TRACKING_DOT_DISTANCE));
   _settingsTrackingDotsDisplayedList.push_back(SettingsTrackingDotsDisplayedListItem(LANGUAGE_STRING(TextId_0x1452, "Delete tracking dots"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_DELETE_TRACK_TO_CURRENT_LOCATION));
}


void SettingsTrackingDotsDisplayedListHandler::deinitialize()
{
}


bool SettingsTrackingDotsDisplayedListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   bool listUpdateNeeded = false;
   bool isMsgConsumed = false;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();

   if (enRelease == reaction)
   {
      if (LIST_ID_MAP_SETTINGS_OTHERS == listId)
      {
         switch (rowIdx)
         {
            case SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_SHOW_TRACKING_DOTS_ON_MAP:
            {
               ETG_TRACE_USR4(("SettingsTrackingDotsDisplayedListHandler::handleButtonListItemUpdMsg(ButtonListItemUpdMsg), List Id : %d, Row Id : %d", listId, rowIdx));

               //Show Tracking Dots On Map
               navmiddleware::settings::MapTrackingDotsSettings mapTrackingDotSettings = _navMiddleware.getMapTrackingDotsSettings();
               mapTrackingDotSettings.getTrackingDotDisplayState() ? mapTrackingDotSettings.setTrackingDotDisplayState(false) : mapTrackingDotSettings.setTrackingDotDisplayState(true);
               _navMiddleware.updateMapTrackingDotsSettings(mapTrackingDotSettings);
               listUpdateNeeded = true;
               isMsgConsumed = true;
            }
            break;
            case SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_DIST_BTW_TRACKING_DOTS:
            {
               processComboBox(oMsg.GetHdl(), oMsg.GetSubHdl());
               isMsgConsumed = true;
            }
            break;
            default:
               break;
         }
      }
   }
   if (listUpdateNeeded)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
   }

   return isMsgConsumed;
}


void SettingsTrackingDotsDisplayedListHandler::processComboBox(Courier::UInt32 hdl, Courier::UInt32 subHdl)
{
   ETG_TRACE_USR4(("MapSettingsOthersListHandler::processComboBox: Hdl: %d, SubHdl: %d", hdl, subHdl));
   subHdl = subHdl - 1; //subtracting 1 as the dropdown item values start with the index of 0

   changeTrackingDotsDisatance(subHdl);
   ::hmibase::widget::combobox::ComboBoxReqMsg* cbToggleMsg = COURIER_MESSAGE_NEW(::hmibase::widget::combobox::ComboBoxReqMsg)(0, ::hmibase::widget::combobox::enComboBoxAction::Close); //ComboBoxAction enComboBoxAction::Enum::ComboBoxClose:
   if (cbToggleMsg != NULL)
   {
      cbToggleMsg->Post();
   }
   ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
}


bool SettingsTrackingDotsDisplayedListHandler::changeTrackingDotsDisatance(Candera::UInt32 selectedRowId)
{
   ETG_TRACE_USR4(("SettingsTrackingDotsDisplayedListHandler::changeTrackingDotsDisatance(), Row Id : %d", selectedRowId));
   navmiddleware::settings::MapTrackingDotsSettings::MapTrackingDotsDistance mapTrackingDots = navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_FIFTY_METER;
   SettingsTrackingDotsDisplayedListItem& settingsTrackingDotsListElement = _settingsTrackingDotsDisplayedList.at(SETTINGS_TRACKING_DOTS_DISPLAYED_LIST_ITEM_DIST_BTW_TRACKING_DOTS);
   bool isListUpdated = true;
   switch (selectedRowId)
   {
      case MAP_TRACKING_DOT_DISTANCE_FIFTY_METER:
      {
         mapTrackingDots = navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_FIFTY_METER;
         break;
      }
      case MAP_TRACKING_DOT_DISTANCE_HUNDRED_METER:
      {
         mapTrackingDots = navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_HUNDRED_METER;;
         break;
      }
      case MAP_TRACKING_DOT_DISTANCE_TWO_HUNDRED_METER:
      {
         mapTrackingDots = navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_TWO_HUNDRED_METER;
         break;
      }
      case MAP_TRACKING_DOT_DISTANCE_FIVE_HUNDRED_METER:
      {
         mapTrackingDots = navmiddleware::settings::MapTrackingDotsSettings::MAP_TRACKING_DOT_DISTANCE_FIVE_HUNDRED_METER;
         break;
      }
      default:
      {
         isListUpdated = false;
         break;
      }
   }

   if (true == isListUpdated)
   {
      navmiddleware::settings::MapTrackingDotsSettings mapTrackingDotSettings = _navMiddleware.getMapTrackingDotsSettings();
      mapTrackingDotSettings.setMapTrackingDotDistance(mapTrackingDots);
      _navMiddleware.updateMapTrackingDotsSettings(mapTrackingDotSettings);
   }

   return isListUpdated;
}


tSharedPtrDataProvider SettingsTrackingDotsDisplayedListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("SettingsTrackingDotsDisplayedListHandler:getListDataProvider: %d", oMsg.GetListId()));
   tSharedPtrDataProvider dataProvider;
   if (LIST_ID_MAP_SETTINGS_OTHERS == oMsg.GetListId())
   {
      unsigned int currentTrackingDotDistance = 0;
      Candera::String currentTrackingDotDistanceStr = "";
      bool trackingDotType[MAX_SIZE_TRACKING_DOTS_TEXT_ID] = {false};
      bool isCheckboxEnabled = false;
      InfoStoreBase::DistanceUnitSystem distanceUnit = _infoStore.getDistanceUnitSystem();
      currentTrackingDotDistance = static_cast<unsigned int>(getTrackingDotsDistanceValue(_navMiddleware));
      currentTrackingDotDistanceStr = TrackingDotsDistance[currentTrackingDotDistance][distanceUnit];

      trackingDotType[currentTrackingDotDistance] = true;
      isCheckboxEnabled = getTrackingDotsOnMap(_navMiddleware);

      ListDataProviderBuilder listBuilder(LIST_ID_MAP_SETTINGS_OTHERS);

      listBuilder.AddItem(0, 0, DATA_CONTEXT_ROUTE_SETTINGS_TOGGLE_OPTION)
      .AddData(TrackingDotSettingsListItemText[0])
      .AddData(isCheckboxEnabled);
      listBuilder.AddItem(1, 0, DATA_CONTEXT_COMBOBOX_LIST_ITEMS_4)
      .AddData(TrackingDotSettingsListItemText[1])
      .AddId(1, 1).AddData(TrackingDotsDistance[0][distanceUnit]).AddData(trackingDotType[0])
      .AddId(1, 2).AddData(TrackingDotsDistance[1][distanceUnit]).AddData(trackingDotType[1])
      .AddId(1, 3).AddData(TrackingDotsDistance[2][distanceUnit]).AddData(trackingDotType[2])
      .AddId(1, 4).AddData(TrackingDotsDistance[3][distanceUnit]).AddData(trackingDotType[3])
      .AddData(currentTrackingDotDistanceStr);
      listBuilder.AddItem(2, 0, DATA_CONTEXT_TEXT_LIST_ITEM)
      .AddData(TrackingDotSettingsListItemText[2]);

      dataProvider = listBuilder.CreateDataProvider();
   }

   return dataProvider;
}


#endif // HALL_TO_MDW_COM
