/**************************************************************************************
* @file         : SettingsMapScrollingInfoListHandler.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef SETTINGS_MAP_MAPSCROLLING_INFO_LIST_HANDLER
#define SETTINGS_MAP_MAPSCROLLING_INFO_LIST_HANDLER

#include "Common/Util/HMIModelIncludes.h"
#if defined(HALL_TO_MDW_COM)

class SettingsMapScrollingInfoListHandler : public HMIModelBase
{
   public:
      SettingsMapScrollingInfoListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~SettingsMapScrollingInfoListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      bool handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg);

   private:
      enum SettingsMapScrollingInfoListItemValue
      {
         SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_FAVOURITES_ICON,
         SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_TMC_TRAFFIC_ICONS,
         SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_DESTINATION_OR_WAYPOINT_ICONS,
         SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_LATITUDE_LONGTITUDE_ICON,
      };
      typedef ListItemBase<SettingsMapScrollingInfoListItemValue> SettingsMapScrollingInfoListItem;

      bool getListItemStatus(SettingsMapScrollingInfoListItemValue listItemValue) const;
      std::vector<SettingsMapScrollingInfoListItem> _settingsMapScrollingInfoList;
      FEATSTD_MAKE_CLASS_UNCOPYABLE(SettingsMapScrollingInfoListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // SETTINGS_MAP_MAPSCROLLING_INFO_LIST_HANDLER
