/**************************************************************************************
* @file         : SettingsMapScrollingInfoListHandler.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include <vector>
#include "Common/DataModel/ListRegistry.h"
#include "SettingsMapScrollingInfoListHandler.h"
#include "MapSettingsOthersUtil.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SettingsMapScrollingInfoListHandler.cpp.trc.h"
#endif

#if defined (HALL_TO_MDW_COM)

SettingsMapScrollingInfoListHandler::SettingsMapScrollingInfoListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : HMIModelBase(navMiddleware, infoStore)
{
}


SettingsMapScrollingInfoListHandler::~SettingsMapScrollingInfoListHandler()
{
}


void SettingsMapScrollingInfoListHandler::initialize()
{
   _settingsMapScrollingInfoList.reserve(5);
   _settingsMapScrollingInfoList.push_back(SettingsMapScrollingInfoListItem(LANGUAGE_STRING(TextId_0x1406, "Favourites icons"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_FAVOURITES_ICON, getAdressBookIcon));
   _settingsMapScrollingInfoList.push_back(SettingsMapScrollingInfoListItem(LANGUAGE_STRING(TextId_0x1430, "Traffic icons"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_TMC_TRAFFIC_ICONS, getTmcTrafficIcon));
   _settingsMapScrollingInfoList.push_back(SettingsMapScrollingInfoListItem(LANGUAGE_STRING(TextId_0x1407, "Destination/waypoint icons"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_TOGGLE, SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_DESTINATION_OR_WAYPOINT_ICONS, getDestWayPointIcon));
}


void SettingsMapScrollingInfoListHandler::deinitialize()
{
}


bool SettingsMapScrollingInfoListHandler::handleButtonListItemUpdMsg(const ButtonListItemUpdMsg& oMsg)
{
   bool bIsMsgConsumed = false;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowID = (unsigned int)oMsg.GetHdl();
   const enReaction  reaction = oMsg.GetReaction();

   if ((LIST_ID_MAP_SETTINGS_OTHERS == listId) && (enRelease == reaction))
   {
      ETG_TRACE_USR4(("SettingsMapScrollingInfoListHandler::handleButtonListItemUpdMsg(ButtonListItemUpdMsg), List Id : %d, Row Id : %d", listId, rowID));
      bool listUpdateNeeded = false;
      navmiddleware::settings::MapDetailTriggerSettings mapDetailTriggerSettings = _navMiddleware.getMapDetailTriggerSettings();

      switch (rowID)
      {
         case SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_FAVOURITES_ICON: // Address Book Icons
         {
            mapDetailTriggerSettings.isAddressBookIconsEnabled() ? mapDetailTriggerSettings.setAddressBookIcons(false) : mapDetailTriggerSettings.setAddressBookIcons(true);
            listUpdateNeeded = true;
            break;
         }
         case SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_TMC_TRAFFIC_ICONS: // TMC Traffic Icons
         {
            mapDetailTriggerSettings.isTMCTrafficIconsEnabled() ? mapDetailTriggerSettings.setTMCTrafficIcons(false) : mapDetailTriggerSettings.setTMCTrafficIcons(true);
            listUpdateNeeded = true;
            break;
         }
         case SETTINGS_MAP_SCROLLING_INFO_LIST_ITEM_DESTINATION_OR_WAYPOINT_ICONS: // Destination/Waypoint Icons
         {
            mapDetailTriggerSettings.isDestinationWaypointIconsEnabled() ? mapDetailTriggerSettings.setDestinationWaypointIcons(false) : mapDetailTriggerSettings.setDestinationWaypointIcons(true);
            listUpdateNeeded = true;
            break;
         }
         default:
         {
            break;
         }
      }
      if (true == listUpdateNeeded)
      {
         _navMiddleware.updateMapDetailTriggerSettings(mapDetailTriggerSettings);
         ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_OTHERS);
      }
      bIsMsgConsumed = true;
   }

   return bIsMsgConsumed;
}


tSharedPtrDataProvider SettingsMapScrollingInfoListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("SettingsMapScrollingInfoListHandler::getListDataProvider()"));
   DataItemContext  listItemName = "Layer_Checkbox";
   Candera::UInt32 listID = oMsg.GetListId();
   ListDataProviderBuilder listBuilder(listID);
   for (std::vector<SettingsMapScrollingInfoListItem>::iterator itemNumber = _settingsMapScrollingInfoList.begin(); itemNumber != _settingsMapScrollingInfoList.end(); ++itemNumber)
   {
      if (itemNumber->_listButtonType == LIST_BUTTON_TYPE_TOGGLE)
      {
         listBuilder.AddItem(
            itemNumber->_order,
            0UL,  //    - unused
            listItemName)  //0 - Name(Id) of the button
         .AddData(itemNumber->_text)
         .AddData(itemNumber->getButtonToggleState(_navMiddleware))
         .AddData(itemNumber->_isVisible);
      }
   }
   return listBuilder.CreateDataProvider();
}


#endif // HALL_TO_MDW_COM
